# CPpackage

## 简介

CPpackage是超品集团内部使用的Python包，核心功能集中在MySQL数据库增删改查功能以及部分数据清洗的能力。

## 安装

```bash
pip install cppackage
```

## 使用方法

```python
# 导入包
from CPpackage.db.config import set_db_config
from CPpackage.db.sql_model import sel_data, del_data , incremental_update, get_table_columns,add_columns,check_and_sync_columns,update_datas

# 配置数据库连接（也可通过环境变量CPPACKAGE_DB_*配置）
set_db_config(host='your_host', user='your_user', password='your_password', database='your_database', port=3306)

# 更新过程会先经过check_and_sync_columns函数完成表格校验
check_and_sync_columns(df, table_name, database, max_new=5)
# 更新数据函数，在完成数据库信息配置后，df为pd.dataframe格式的数据
update_datas(df, table_name, database)

```

## 项目结构

```
CPpackage/
├── CPpackage/       # 主包
│   ├── core/        # 核心功能
│   ├── utils/       # 工具函数
│   └── db/          # 数据库功能与配置（sql_model拆解于此）
├── manage.py        # 管理脚本
├── LICENSE          # 许可证
├── MANIFEST.in      # 打包配置
├── readme.md        # 说明文档
└── setup.py         # 安装配置
```

## 许可证

本项目采用MIT许可证。详情请参阅LICENSE文件。
