# CppM

A CLI helper tool for easy management of C++ project, inspired on npm workflow.

The intent of this project is to provide an easy workflow for dealing with dependency and build management for C++ projects, so the main focus is easy usage, rather than full flexibility. 
The helper tool basically uses vcpkg and cmake under the hood, so you'll be able to structure and scale your project using these tools.

## Requirements

In order to use this tool, you'll need to have git installed and accessible through command line, this is the only requirement.
You don't need to have cmake installed, since the CppM tool leverages a Vcpkg's local cmake installation to build the project as well.

## Installation

In order to install CppM on your system, you can use pip:

```bash
pip install cppm
```

## How to use it

Generally, the CppM commands have this form:

```bash
cppm <command> <args>
```

The currently supported commands for CppM are:
- new: Creates a starter project on the specified directory;
- init: Initializes a starter project in the current folder;
- add: Adds a third party package on the project using vcpkg;
- install: Installs the currently added packages;
- build: Builds the project;

The projects created by CppM follows this default structure:

```
Project
|-- src
    |-- main.cpp
| -- CMakeLists.txt
| -- vcpkg.json
| -- README.md
| -- .gitignore
```

### new
- Required argument: project path;

Usage:
```bash
cppm new <pathToNewProject>
```

e.g:
```bash
cppm new my-project
```

### init
- Optional argument: --project-name

Usage:
```bash
cppm init
```
This will create a starter project with name "new-project" in the current folder

Also, this command supports the user to specify a project name to be used instead of the default "new-project":

```
cppm init --project_name <your-project-name>
```

### add
- Required arguments: a list of the vcpkg dependencies to add in the project

Usage:
```bash
cppm add <vcpkg-libs>
```
For a reference on the available C++ libs on vcpkg you might look at https://vcpkg.io/en/packages?query=
Also, the add command itself doesn't install the packages right away, it just add them to vcpkg.json. In order to properly install the packages, you need then to use the install command.

### install

Usage:
```bash
cppm install
```

Installs the packages currently specified on vcpkg.json 

### build
- Optional argument: -o, --output_dir
- Optional argument: --cmake_args

Usage:
```bash
cppm build
```
You're able to specify another build folder, rather than "build" as well:
```bash
cppm build --output_dir <build_folder_name>
```
Finally, you can also forward CMake specific args to the build command:
```bash
cppm build --cmake_args -DCMAKE_BUILD_TYPE=RelWithDebInfo
```

## Example 

Supposing a project where we'll use the 7zip and abseil libraries, a typical setup would be:

```bash
cppm new my-project
cd my-project
cppm add 7zip abseil
cppm install
cppm build
```

Aside from doing these commands, you would also need to add the proper find_package and target_link_libraries calls on your CMake. Ususally these two calls get outputted by vcpkg during installation, so it's mostly a matter of copying the calls to your CMakeLists.txt

