# coding: utf-8

"""
    Pulp 3 API

    Fetch, Upload, Organize, and Distribute Software Packages

    The version of the OpenAPI document: v3
    Contact: pulp-list@redhat.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictBytes, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated
from services-pulp_python-client.models.async_operation_response import AsyncOperationResponse
from services-pulp_python-client.models.paginatedpython_python_package_content_response_list import PaginatedpythonPythonPackageContentResponseList
from services-pulp_python-client.models.python_python_package_content_response import PythonPythonPackageContentResponse
from services-pulp_python-client.models.set_label import SetLabel
from services-pulp_python-client.models.set_label_response import SetLabelResponse
from services-pulp_python-client.models.unset_label import UnsetLabel
from services-pulp_python-client.models.unset_label_response import UnsetLabelResponse

from services-pulp_python-client.api_client import ApiClient, RequestSerialized
from services-pulp_python-client.api_response import ApiResponse
from services-pulp_python-client.rest import RESTResponseType


class ContentPackagesApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def create(
        self,
        relative_path: Annotated[str, Field(min_length=1, strict=True, description="Path where the artifact is located relative to distributions base_path")],
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        repository: Annotated[Optional[StrictStr], Field(description="A URI of a repository the new content unit should be associated with.")] = None,
        pulp_labels: Annotated[Optional[Dict[str, Optional[StrictStr]]], Field(description="A dictionary of arbitrary key/value pairs used to describe a specific Content instance.")] = None,
        artifact: Annotated[Optional[StrictStr], Field(description="Artifact file representing the physical content")] = None,
        file: Annotated[Optional[Union[StrictBytes, StrictStr, Tuple[StrictStr, StrictBytes]]], Field(description="An uploaded file that may be turned into the content unit.")] = None,
        upload: Annotated[Optional[StrictStr], Field(description="An uncommitted upload that may be turned into the content unit.")] = None,
        file_url: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="A url that Pulp can download and turn into the content unit.")] = None,
        sha256: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="The SHA256 digest of this package.")] = None,
        summary: Annotated[Optional[StrictStr], Field(description="A one-line summary of what the package does.")] = None,
        description: Annotated[Optional[StrictStr], Field(description="A longer description of the package that can run to several paragraphs.")] = None,
        description_content_type: Annotated[Optional[StrictStr], Field(description="A string stating the markup syntax (if any) used in the distribution’s description, so that tools can intelligently render the description.")] = None,
        keywords: Annotated[Optional[StrictStr], Field(description="Additional keywords to be used to assist searching for the package in a larger catalog.")] = None,
        home_page: Annotated[Optional[StrictStr], Field(description="The URL for the package's home page.")] = None,
        download_url: Annotated[Optional[StrictStr], Field(description="Legacy field denoting the URL from which this package can be downloaded.")] = None,
        author: Annotated[Optional[StrictStr], Field(description="Text containing the author's name. Contact information can also be added, separated with newlines.")] = None,
        author_email: Annotated[Optional[StrictStr], Field(description="The author's e-mail address. ")] = None,
        maintainer: Annotated[Optional[StrictStr], Field(description="The maintainer's name at a minimum; additional contact information may be provided.")] = None,
        maintainer_email: Annotated[Optional[StrictStr], Field(description="The maintainer's e-mail address.")] = None,
        license: Annotated[Optional[StrictStr], Field(description="Text indicating the license covering the distribution")] = None,
        requires_python: Annotated[Optional[StrictStr], Field(description="The Python version(s) that the distribution is guaranteed to be compatible with.")] = None,
        project_url: Annotated[Optional[StrictStr], Field(description="A browsable URL for the project and a label for it, separated by a comma.")] = None,
        project_urls: Annotated[Optional[Any], Field(description="A dictionary of labels and URLs for the project.")] = None,
        platform: Annotated[Optional[StrictStr], Field(description="A comma-separated list of platform specifications, summarizing the operating systems supported by the package.")] = None,
        supported_platform: Annotated[Optional[StrictStr], Field(description="Field to specify the OS and CPU for which the binary package was compiled. ")] = None,
        requires_dist: Annotated[Optional[Any], Field(description="A JSON list containing names of some other distutils project required by this distribution.")] = None,
        provides_dist: Annotated[Optional[Any], Field(description="A JSON list containing names of a Distutils project which is contained within this distribution.")] = None,
        obsoletes_dist: Annotated[Optional[Any], Field(description="A JSON list containing names of a distutils project's distribution which this distribution renders obsolete, meaning that the two projects should not be installed at the same time.")] = None,
        requires_external: Annotated[Optional[Any], Field(description="A JSON list containing some dependency in the system that the distribution is to be used.")] = None,
        classifiers: Annotated[Optional[Any], Field(description="A JSON list containing classification values for a Python package.")] = None,
        pulp_domain: StrictStr = "default",
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> AsyncOperationResponse:
        """Create a python package content

        Trigger an asynchronous task to create content,optionally create new repository version.

        :param pulp_domain: (required)
        :type pulp_domain: str
        :param relative_path: Path where the artifact is located relative to distributions base_path (required)
        :type relative_path: str
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param repository: A URI of a repository the new content unit should be associated with.
        :type repository: str
        :param pulp_labels: A dictionary of arbitrary key/value pairs used to describe a specific Content instance.
        :type pulp_labels: Dict[str, Optional[str]]
        :param artifact: Artifact file representing the physical content
        :type artifact: str
        :param file: An uploaded file that may be turned into the content unit.
        :type file: bytearray
        :param upload: An uncommitted upload that may be turned into the content unit.
        :type upload: str
        :param file_url: A url that Pulp can download and turn into the content unit.
        :type file_url: str
        :param sha256: The SHA256 digest of this package.
        :type sha256: str
        :param summary: A one-line summary of what the package does.
        :type summary: str
        :param description: A longer description of the package that can run to several paragraphs.
        :type description: str
        :param description_content_type: A string stating the markup syntax (if any) used in the distribution’s description, so that tools can intelligently render the description.
        :type description_content_type: str
        :param keywords: Additional keywords to be used to assist searching for the package in a larger catalog.
        :type keywords: str
        :param home_page: The URL for the package's home page.
        :type home_page: str
        :param download_url: Legacy field denoting the URL from which this package can be downloaded.
        :type download_url: str
        :param author: Text containing the author's name. Contact information can also be added, separated with newlines.
        :type author: str
        :param author_email: The author's e-mail address. 
        :type author_email: str
        :param maintainer: The maintainer's name at a minimum; additional contact information may be provided.
        :type maintainer: str
        :param maintainer_email: The maintainer's e-mail address.
        :type maintainer_email: str
        :param license: Text indicating the license covering the distribution
        :type license: str
        :param requires_python: The Python version(s) that the distribution is guaranteed to be compatible with.
        :type requires_python: str
        :param project_url: A browsable URL for the project and a label for it, separated by a comma.
        :type project_url: str
        :param project_urls: A dictionary of labels and URLs for the project.
        :type project_urls: object
        :param platform: A comma-separated list of platform specifications, summarizing the operating systems supported by the package.
        :type platform: str
        :param supported_platform: Field to specify the OS and CPU for which the binary package was compiled. 
        :type supported_platform: str
        :param requires_dist: A JSON list containing names of some other distutils project required by this distribution.
        :type requires_dist: object
        :param provides_dist: A JSON list containing names of a Distutils project which is contained within this distribution.
        :type provides_dist: object
        :param obsoletes_dist: A JSON list containing names of a distutils project's distribution which this distribution renders obsolete, meaning that the two projects should not be installed at the same time.
        :type obsoletes_dist: object
        :param requires_external: A JSON list containing some dependency in the system that the distribution is to be used.
        :type requires_external: object
        :param classifiers: A JSON list containing classification values for a Python package.
        :type classifiers: object
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_serialize(
            pulp_domain=pulp_domain,
            relative_path=relative_path,
            x_task_diagnostics=x_task_diagnostics,
            repository=repository,
            pulp_labels=pulp_labels,
            artifact=artifact,
            file=file,
            upload=upload,
            file_url=file_url,
            sha256=sha256,
            summary=summary,
            description=description,
            description_content_type=description_content_type,
            keywords=keywords,
            home_page=home_page,
            download_url=download_url,
            author=author,
            author_email=author_email,
            maintainer=maintainer,
            maintainer_email=maintainer_email,
            license=license,
            requires_python=requires_python,
            project_url=project_url,
            project_urls=project_urls,
            platform=platform,
            supported_platform=supported_platform,
            requires_dist=requires_dist,
            provides_dist=provides_dist,
            obsoletes_dist=obsoletes_dist,
            requires_external=requires_external,
            classifiers=classifiers,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '202': "AsyncOperationResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def create_with_http_info(
        self,
        relative_path: Annotated[str, Field(min_length=1, strict=True, description="Path where the artifact is located relative to distributions base_path")],
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        repository: Annotated[Optional[StrictStr], Field(description="A URI of a repository the new content unit should be associated with.")] = None,
        pulp_labels: Annotated[Optional[Dict[str, Optional[StrictStr]]], Field(description="A dictionary of arbitrary key/value pairs used to describe a specific Content instance.")] = None,
        artifact: Annotated[Optional[StrictStr], Field(description="Artifact file representing the physical content")] = None,
        file: Annotated[Optional[Union[StrictBytes, StrictStr, Tuple[StrictStr, StrictBytes]]], Field(description="An uploaded file that may be turned into the content unit.")] = None,
        upload: Annotated[Optional[StrictStr], Field(description="An uncommitted upload that may be turned into the content unit.")] = None,
        file_url: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="A url that Pulp can download and turn into the content unit.")] = None,
        sha256: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="The SHA256 digest of this package.")] = None,
        summary: Annotated[Optional[StrictStr], Field(description="A one-line summary of what the package does.")] = None,
        description: Annotated[Optional[StrictStr], Field(description="A longer description of the package that can run to several paragraphs.")] = None,
        description_content_type: Annotated[Optional[StrictStr], Field(description="A string stating the markup syntax (if any) used in the distribution’s description, so that tools can intelligently render the description.")] = None,
        keywords: Annotated[Optional[StrictStr], Field(description="Additional keywords to be used to assist searching for the package in a larger catalog.")] = None,
        home_page: Annotated[Optional[StrictStr], Field(description="The URL for the package's home page.")] = None,
        download_url: Annotated[Optional[StrictStr], Field(description="Legacy field denoting the URL from which this package can be downloaded.")] = None,
        author: Annotated[Optional[StrictStr], Field(description="Text containing the author's name. Contact information can also be added, separated with newlines.")] = None,
        author_email: Annotated[Optional[StrictStr], Field(description="The author's e-mail address. ")] = None,
        maintainer: Annotated[Optional[StrictStr], Field(description="The maintainer's name at a minimum; additional contact information may be provided.")] = None,
        maintainer_email: Annotated[Optional[StrictStr], Field(description="The maintainer's e-mail address.")] = None,
        license: Annotated[Optional[StrictStr], Field(description="Text indicating the license covering the distribution")] = None,
        requires_python: Annotated[Optional[StrictStr], Field(description="The Python version(s) that the distribution is guaranteed to be compatible with.")] = None,
        project_url: Annotated[Optional[StrictStr], Field(description="A browsable URL for the project and a label for it, separated by a comma.")] = None,
        project_urls: Annotated[Optional[Any], Field(description="A dictionary of labels and URLs for the project.")] = None,
        platform: Annotated[Optional[StrictStr], Field(description="A comma-separated list of platform specifications, summarizing the operating systems supported by the package.")] = None,
        supported_platform: Annotated[Optional[StrictStr], Field(description="Field to specify the OS and CPU for which the binary package was compiled. ")] = None,
        requires_dist: Annotated[Optional[Any], Field(description="A JSON list containing names of some other distutils project required by this distribution.")] = None,
        provides_dist: Annotated[Optional[Any], Field(description="A JSON list containing names of a Distutils project which is contained within this distribution.")] = None,
        obsoletes_dist: Annotated[Optional[Any], Field(description="A JSON list containing names of a distutils project's distribution which this distribution renders obsolete, meaning that the two projects should not be installed at the same time.")] = None,
        requires_external: Annotated[Optional[Any], Field(description="A JSON list containing some dependency in the system that the distribution is to be used.")] = None,
        classifiers: Annotated[Optional[Any], Field(description="A JSON list containing classification values for a Python package.")] = None,
        pulp_domain: StrictStr = "default",
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[AsyncOperationResponse]:
        """Create a python package content

        Trigger an asynchronous task to create content,optionally create new repository version.

        :param pulp_domain: (required)
        :type pulp_domain: str
        :param relative_path: Path where the artifact is located relative to distributions base_path (required)
        :type relative_path: str
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param repository: A URI of a repository the new content unit should be associated with.
        :type repository: str
        :param pulp_labels: A dictionary of arbitrary key/value pairs used to describe a specific Content instance.
        :type pulp_labels: Dict[str, Optional[str]]
        :param artifact: Artifact file representing the physical content
        :type artifact: str
        :param file: An uploaded file that may be turned into the content unit.
        :type file: bytearray
        :param upload: An uncommitted upload that may be turned into the content unit.
        :type upload: str
        :param file_url: A url that Pulp can download and turn into the content unit.
        :type file_url: str
        :param sha256: The SHA256 digest of this package.
        :type sha256: str
        :param summary: A one-line summary of what the package does.
        :type summary: str
        :param description: A longer description of the package that can run to several paragraphs.
        :type description: str
        :param description_content_type: A string stating the markup syntax (if any) used in the distribution’s description, so that tools can intelligently render the description.
        :type description_content_type: str
        :param keywords: Additional keywords to be used to assist searching for the package in a larger catalog.
        :type keywords: str
        :param home_page: The URL for the package's home page.
        :type home_page: str
        :param download_url: Legacy field denoting the URL from which this package can be downloaded.
        :type download_url: str
        :param author: Text containing the author's name. Contact information can also be added, separated with newlines.
        :type author: str
        :param author_email: The author's e-mail address. 
        :type author_email: str
        :param maintainer: The maintainer's name at a minimum; additional contact information may be provided.
        :type maintainer: str
        :param maintainer_email: The maintainer's e-mail address.
        :type maintainer_email: str
        :param license: Text indicating the license covering the distribution
        :type license: str
        :param requires_python: The Python version(s) that the distribution is guaranteed to be compatible with.
        :type requires_python: str
        :param project_url: A browsable URL for the project and a label for it, separated by a comma.
        :type project_url: str
        :param project_urls: A dictionary of labels and URLs for the project.
        :type project_urls: object
        :param platform: A comma-separated list of platform specifications, summarizing the operating systems supported by the package.
        :type platform: str
        :param supported_platform: Field to specify the OS and CPU for which the binary package was compiled. 
        :type supported_platform: str
        :param requires_dist: A JSON list containing names of some other distutils project required by this distribution.
        :type requires_dist: object
        :param provides_dist: A JSON list containing names of a Distutils project which is contained within this distribution.
        :type provides_dist: object
        :param obsoletes_dist: A JSON list containing names of a distutils project's distribution which this distribution renders obsolete, meaning that the two projects should not be installed at the same time.
        :type obsoletes_dist: object
        :param requires_external: A JSON list containing some dependency in the system that the distribution is to be used.
        :type requires_external: object
        :param classifiers: A JSON list containing classification values for a Python package.
        :type classifiers: object
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_serialize(
            pulp_domain=pulp_domain,
            relative_path=relative_path,
            x_task_diagnostics=x_task_diagnostics,
            repository=repository,
            pulp_labels=pulp_labels,
            artifact=artifact,
            file=file,
            upload=upload,
            file_url=file_url,
            sha256=sha256,
            summary=summary,
            description=description,
            description_content_type=description_content_type,
            keywords=keywords,
            home_page=home_page,
            download_url=download_url,
            author=author,
            author_email=author_email,
            maintainer=maintainer,
            maintainer_email=maintainer_email,
            license=license,
            requires_python=requires_python,
            project_url=project_url,
            project_urls=project_urls,
            platform=platform,
            supported_platform=supported_platform,
            requires_dist=requires_dist,
            provides_dist=provides_dist,
            obsoletes_dist=obsoletes_dist,
            requires_external=requires_external,
            classifiers=classifiers,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '202': "AsyncOperationResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def create_without_preload_content(
        self,
        relative_path: Annotated[str, Field(min_length=1, strict=True, description="Path where the artifact is located relative to distributions base_path")],
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        repository: Annotated[Optional[StrictStr], Field(description="A URI of a repository the new content unit should be associated with.")] = None,
        pulp_labels: Annotated[Optional[Dict[str, Optional[StrictStr]]], Field(description="A dictionary of arbitrary key/value pairs used to describe a specific Content instance.")] = None,
        artifact: Annotated[Optional[StrictStr], Field(description="Artifact file representing the physical content")] = None,
        file: Annotated[Optional[Union[StrictBytes, StrictStr, Tuple[StrictStr, StrictBytes]]], Field(description="An uploaded file that may be turned into the content unit.")] = None,
        upload: Annotated[Optional[StrictStr], Field(description="An uncommitted upload that may be turned into the content unit.")] = None,
        file_url: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="A url that Pulp can download and turn into the content unit.")] = None,
        sha256: Annotated[Optional[Annotated[str, Field(min_length=1, strict=True)]], Field(description="The SHA256 digest of this package.")] = None,
        summary: Annotated[Optional[StrictStr], Field(description="A one-line summary of what the package does.")] = None,
        description: Annotated[Optional[StrictStr], Field(description="A longer description of the package that can run to several paragraphs.")] = None,
        description_content_type: Annotated[Optional[StrictStr], Field(description="A string stating the markup syntax (if any) used in the distribution’s description, so that tools can intelligently render the description.")] = None,
        keywords: Annotated[Optional[StrictStr], Field(description="Additional keywords to be used to assist searching for the package in a larger catalog.")] = None,
        home_page: Annotated[Optional[StrictStr], Field(description="The URL for the package's home page.")] = None,
        download_url: Annotated[Optional[StrictStr], Field(description="Legacy field denoting the URL from which this package can be downloaded.")] = None,
        author: Annotated[Optional[StrictStr], Field(description="Text containing the author's name. Contact information can also be added, separated with newlines.")] = None,
        author_email: Annotated[Optional[StrictStr], Field(description="The author's e-mail address. ")] = None,
        maintainer: Annotated[Optional[StrictStr], Field(description="The maintainer's name at a minimum; additional contact information may be provided.")] = None,
        maintainer_email: Annotated[Optional[StrictStr], Field(description="The maintainer's e-mail address.")] = None,
        license: Annotated[Optional[StrictStr], Field(description="Text indicating the license covering the distribution")] = None,
        requires_python: Annotated[Optional[StrictStr], Field(description="The Python version(s) that the distribution is guaranteed to be compatible with.")] = None,
        project_url: Annotated[Optional[StrictStr], Field(description="A browsable URL for the project and a label for it, separated by a comma.")] = None,
        project_urls: Annotated[Optional[Any], Field(description="A dictionary of labels and URLs for the project.")] = None,
        platform: Annotated[Optional[StrictStr], Field(description="A comma-separated list of platform specifications, summarizing the operating systems supported by the package.")] = None,
        supported_platform: Annotated[Optional[StrictStr], Field(description="Field to specify the OS and CPU for which the binary package was compiled. ")] = None,
        requires_dist: Annotated[Optional[Any], Field(description="A JSON list containing names of some other distutils project required by this distribution.")] = None,
        provides_dist: Annotated[Optional[Any], Field(description="A JSON list containing names of a Distutils project which is contained within this distribution.")] = None,
        obsoletes_dist: Annotated[Optional[Any], Field(description="A JSON list containing names of a distutils project's distribution which this distribution renders obsolete, meaning that the two projects should not be installed at the same time.")] = None,
        requires_external: Annotated[Optional[Any], Field(description="A JSON list containing some dependency in the system that the distribution is to be used.")] = None,
        classifiers: Annotated[Optional[Any], Field(description="A JSON list containing classification values for a Python package.")] = None,
        pulp_domain: StrictStr = "default",
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create a python package content

        Trigger an asynchronous task to create content,optionally create new repository version.

        :param pulp_domain: (required)
        :type pulp_domain: str
        :param relative_path: Path where the artifact is located relative to distributions base_path (required)
        :type relative_path: str
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param repository: A URI of a repository the new content unit should be associated with.
        :type repository: str
        :param pulp_labels: A dictionary of arbitrary key/value pairs used to describe a specific Content instance.
        :type pulp_labels: Dict[str, Optional[str]]
        :param artifact: Artifact file representing the physical content
        :type artifact: str
        :param file: An uploaded file that may be turned into the content unit.
        :type file: bytearray
        :param upload: An uncommitted upload that may be turned into the content unit.
        :type upload: str
        :param file_url: A url that Pulp can download and turn into the content unit.
        :type file_url: str
        :param sha256: The SHA256 digest of this package.
        :type sha256: str
        :param summary: A one-line summary of what the package does.
        :type summary: str
        :param description: A longer description of the package that can run to several paragraphs.
        :type description: str
        :param description_content_type: A string stating the markup syntax (if any) used in the distribution’s description, so that tools can intelligently render the description.
        :type description_content_type: str
        :param keywords: Additional keywords to be used to assist searching for the package in a larger catalog.
        :type keywords: str
        :param home_page: The URL for the package's home page.
        :type home_page: str
        :param download_url: Legacy field denoting the URL from which this package can be downloaded.
        :type download_url: str
        :param author: Text containing the author's name. Contact information can also be added, separated with newlines.
        :type author: str
        :param author_email: The author's e-mail address. 
        :type author_email: str
        :param maintainer: The maintainer's name at a minimum; additional contact information may be provided.
        :type maintainer: str
        :param maintainer_email: The maintainer's e-mail address.
        :type maintainer_email: str
        :param license: Text indicating the license covering the distribution
        :type license: str
        :param requires_python: The Python version(s) that the distribution is guaranteed to be compatible with.
        :type requires_python: str
        :param project_url: A browsable URL for the project and a label for it, separated by a comma.
        :type project_url: str
        :param project_urls: A dictionary of labels and URLs for the project.
        :type project_urls: object
        :param platform: A comma-separated list of platform specifications, summarizing the operating systems supported by the package.
        :type platform: str
        :param supported_platform: Field to specify the OS and CPU for which the binary package was compiled. 
        :type supported_platform: str
        :param requires_dist: A JSON list containing names of some other distutils project required by this distribution.
        :type requires_dist: object
        :param provides_dist: A JSON list containing names of a Distutils project which is contained within this distribution.
        :type provides_dist: object
        :param obsoletes_dist: A JSON list containing names of a distutils project's distribution which this distribution renders obsolete, meaning that the two projects should not be installed at the same time.
        :type obsoletes_dist: object
        :param requires_external: A JSON list containing some dependency in the system that the distribution is to be used.
        :type requires_external: object
        :param classifiers: A JSON list containing classification values for a Python package.
        :type classifiers: object
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_serialize(
            pulp_domain=pulp_domain,
            relative_path=relative_path,
            x_task_diagnostics=x_task_diagnostics,
            repository=repository,
            pulp_labels=pulp_labels,
            artifact=artifact,
            file=file,
            upload=upload,
            file_url=file_url,
            sha256=sha256,
            summary=summary,
            description=description,
            description_content_type=description_content_type,
            keywords=keywords,
            home_page=home_page,
            download_url=download_url,
            author=author,
            author_email=author_email,
            maintainer=maintainer,
            maintainer_email=maintainer_email,
            license=license,
            requires_python=requires_python,
            project_url=project_url,
            project_urls=project_urls,
            platform=platform,
            supported_platform=supported_platform,
            requires_dist=requires_dist,
            provides_dist=provides_dist,
            obsoletes_dist=obsoletes_dist,
            requires_external=requires_external,
            classifiers=classifiers,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '202': "AsyncOperationResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_serialize(
        self,
        pulp_domain,
        relative_path,
        x_task_diagnostics,
        repository,
        pulp_labels,
        artifact,
        file,
        upload,
        file_url,
        sha256,
        summary,
        description,
        description_content_type,
        keywords,
        home_page,
        download_url,
        author,
        author_email,
        maintainer,
        maintainer_email,
        license,
        requires_python,
        project_url,
        project_urls,
        platform,
        supported_platform,
        requires_dist,
        provides_dist,
        obsoletes_dist,
        requires_external,
        classifiers,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'X-Task-Diagnostics': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if pulp_domain is not None:
            _path_params['pulp_domain'] = pulp_domain
        # process the query parameters
        # process the header parameters
        if x_task_diagnostics is not None:
            _header_params['X-Task-Diagnostics'] = x_task_diagnostics
        # process the form parameters
        if repository is not None:
            _form_params.append(('repository', repository))
        if pulp_labels is not None:
            _form_params.append(('pulp_labels', pulp_labels))
        if artifact is not None:
            _form_params.append(('artifact', artifact))
        if relative_path is not None:
            _form_params.append(('relative_path', relative_path))
        if file is not None:
            _files['file'] = file
        if upload is not None:
            _form_params.append(('upload', upload))
        if file_url is not None:
            _form_params.append(('file_url', file_url))
        if sha256 is not None:
            _form_params.append(('sha256', sha256))
        if summary is not None:
            _form_params.append(('summary', summary))
        if description is not None:
            _form_params.append(('description', description))
        if description_content_type is not None:
            _form_params.append(('description_content_type', description_content_type))
        if keywords is not None:
            _form_params.append(('keywords', keywords))
        if home_page is not None:
            _form_params.append(('home_page', home_page))
        if download_url is not None:
            _form_params.append(('download_url', download_url))
        if author is not None:
            _form_params.append(('author', author))
        if author_email is not None:
            _form_params.append(('author_email', author_email))
        if maintainer is not None:
            _form_params.append(('maintainer', maintainer))
        if maintainer_email is not None:
            _form_params.append(('maintainer_email', maintainer_email))
        if license is not None:
            _form_params.append(('license', license))
        if requires_python is not None:
            _form_params.append(('requires_python', requires_python))
        if project_url is not None:
            _form_params.append(('project_url', project_url))
        if project_urls is not None:
            _form_params.append(('project_urls', project_urls))
        if platform is not None:
            _form_params.append(('platform', platform))
        if supported_platform is not None:
            _form_params.append(('supported_platform', supported_platform))
        if requires_dist is not None:
            _form_params.append(('requires_dist', requires_dist))
        if provides_dist is not None:
            _form_params.append(('provides_dist', provides_dist))
        if obsoletes_dist is not None:
            _form_params.append(('obsoletes_dist', obsoletes_dist))
        if requires_external is not None:
            _form_params.append(('requires_external', requires_external))
        if classifiers is not None:
            _form_params.append(('classifiers', classifiers))
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'multipart/form-data', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'json_header_remote_authentication', 
            'basicAuth', 
            'cookieAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/pulp/{pulp_domain}/api/v3/content/python/packages/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def list(
        self,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        author: Annotated[Optional[StrictStr], Field(description="Filter results where author matches value")] = None,
        author__in: Annotated[Optional[List[StrictStr]], Field(description="Filter results where author is in a comma-separated list of values")] = None,
        filename: Annotated[Optional[StrictStr], Field(description="Filter results where filename matches value")] = None,
        filename__contains: Annotated[Optional[StrictStr], Field(description="Filter results where filename contains value")] = None,
        filename__in: Annotated[Optional[List[StrictStr]], Field(description="Filter results where filename is in a comma-separated list of values")] = None,
        keywords__contains: Annotated[Optional[StrictStr], Field(description="Filter results where keywords contains value")] = None,
        keywords__in: Annotated[Optional[List[StrictStr]], Field(description="Filter results where keywords is in a comma-separated list of values")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Number of results to return per page.")] = None,
        name: Annotated[Optional[StrictStr], Field(description="Filter results where name matches value")] = None,
        name__in: Annotated[Optional[List[StrictStr]], Field(description="Filter results where name is in a comma-separated list of values")] = None,
        offset: Annotated[Optional[StrictInt], Field(description="The initial index from which to return the results.")] = None,
        ordering: Annotated[Optional[List[StrictStr]], Field(description="Ordering  * `pulp_id` - Pulp id * `-pulp_id` - Pulp id (descending) * `pulp_created` - Pulp created * `-pulp_created` - Pulp created (descending) * `pulp_last_updated` - Pulp last updated * `-pulp_last_updated` - Pulp last updated (descending) * `pulp_type` - Pulp type * `-pulp_type` - Pulp type (descending) * `upstream_id` - Upstream id * `-upstream_id` - Upstream id (descending) * `pulp_labels` - Pulp labels * `-pulp_labels` - Pulp labels (descending) * `timestamp_of_interest` - Timestamp of interest * `-timestamp_of_interest` - Timestamp of interest (descending) * `filename` - Filename * `-filename` - Filename (descending) * `packagetype` - Packagetype * `-packagetype` - Packagetype (descending) * `name` - Name * `-name` - Name (descending) * `version` - Version * `-version` - Version (descending) * `sha256` - Sha256 * `-sha256` - Sha256 (descending) * `python_version` - Python version * `-python_version` - Python version (descending) * `metadata_version` - Metadata version * `-metadata_version` - Metadata version (descending) * `summary` - Summary * `-summary` - Summary (descending) * `description` - Description * `-description` - Description (descending) * `keywords` - Keywords * `-keywords` - Keywords (descending) * `home_page` - Home page * `-home_page` - Home page (descending) * `download_url` - Download url * `-download_url` - Download url (descending) * `author` - Author * `-author` - Author (descending) * `author_email` - Author email * `-author_email` - Author email (descending) * `maintainer` - Maintainer * `-maintainer` - Maintainer (descending) * `maintainer_email` - Maintainer email * `-maintainer_email` - Maintainer email (descending) * `license` - License * `-license` - License (descending) * `requires_python` - Requires python * `-requires_python` - Requires python (descending) * `project_url` - Project url * `-project_url` - Project url (descending) * `platform` - Platform * `-platform` - Platform (descending) * `supported_platform` - Supported platform * `-supported_platform` - Supported platform (descending) * `requires_dist` - Requires dist * `-requires_dist` - Requires dist (descending) * `provides_dist` - Provides dist * `-provides_dist` - Provides dist (descending) * `obsoletes_dist` - Obsoletes dist * `-obsoletes_dist` - Obsoletes dist (descending) * `requires_external` - Requires external * `-requires_external` - Requires external (descending) * `classifiers` - Classifiers * `-classifiers` - Classifiers (descending) * `project_urls` - Project urls * `-project_urls` - Project urls (descending) * `description_content_type` - Description content type * `-description_content_type` - Description content type (descending) * `pk` - Pk * `-pk` - Pk (descending)")] = None,
        orphaned_for: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Minutes Content has been orphaned for. -1 uses ORPHAN_PROTECTION_TIME.")] = None,
        packagetype: Annotated[Optional[StrictStr], Field(description="Filter results where packagetype matches value  * `bdist_dmg` - bdist_dmg * `bdist_dumb` - bdist_dumb * `bdist_egg` - bdist_egg * `bdist_msi` - bdist_msi * `bdist_rpm` - bdist_rpm * `bdist_wheel` - bdist_wheel * `bdist_wininst` - bdist_wininst * `sdist` - sdist")] = None,
        packagetype__in: Annotated[Optional[List[StrictStr]], Field(description="Filter results where packagetype is in a comma-separated list of values")] = None,
        prn__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        pulp_href__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        pulp_id__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        pulp_label_select: Annotated[Optional[StrictStr], Field(description="Filter labels by search string")] = None,
        q: Annotated[Optional[StrictStr], Field(description="Filter results by using NOT, AND and OR operations on other filters")] = None,
        repository_version: Annotated[Optional[StrictStr], Field(description="Repository Version referenced by HREF/PRN")] = None,
        repository_version_added: Annotated[Optional[StrictStr], Field(description="Repository Version referenced by HREF/PRN")] = None,
        repository_version_removed: Annotated[Optional[StrictStr], Field(description="Repository Version referenced by HREF/PRN")] = None,
        requires_python: Annotated[Optional[StrictStr], Field(description="Filter results where requires_python matches value")] = None,
        requires_python__contains: Annotated[Optional[StrictStr], Field(description="Filter results where requires_python contains value")] = None,
        requires_python__in: Annotated[Optional[List[StrictStr]], Field(description="Filter results where requires_python is in a comma-separated list of values")] = None,
        sha256: Annotated[Optional[StrictStr], Field(description="Filter results where sha256 matches value")] = None,
        sha256__in: Annotated[Optional[List[StrictStr]], Field(description="Filter results where sha256 is in a comma-separated list of values")] = None,
        version: Annotated[Optional[StrictStr], Field(description="Filter results where version matches value")] = None,
        version__gt: Annotated[Optional[StrictStr], Field(description="Filter results where version is greater than value")] = None,
        version__gte: Annotated[Optional[StrictStr], Field(description="Filter results where version is greater than or equal to value")] = None,
        version__lt: Annotated[Optional[StrictStr], Field(description="Filter results where version is less than value")] = None,
        version__lte: Annotated[Optional[StrictStr], Field(description="Filter results where version is less than or equal to value")] = None,
        fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to include in the response.")] = None,
        exclude_fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to exclude from the response.")] = None,
        pulp_domain: StrictStr = "default",
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> PaginatedpythonPythonPackageContentResponseList:
        """List python package contents

         PythonPackageContent represents each individually installable Python package. In the Python ecosystem, this is called a Python Distribution, sometimes (ambiguously) refered to as a package. In Pulp Python, we refer to it as PythonPackageContent. Each PythonPackageContent corresponds to a single filename, for example `pulpcore-3.0.0rc1-py3-none-any.whl` or `pulpcore-3.0.0rc1.tar.gz`.

        :param pulp_domain: (required)
        :type pulp_domain: str
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param author: Filter results where author matches value
        :type author: str
        :param author__in: Filter results where author is in a comma-separated list of values
        :type author__in: List[str]
        :param filename: Filter results where filename matches value
        :type filename: str
        :param filename__contains: Filter results where filename contains value
        :type filename__contains: str
        :param filename__in: Filter results where filename is in a comma-separated list of values
        :type filename__in: List[str]
        :param keywords__contains: Filter results where keywords contains value
        :type keywords__contains: str
        :param keywords__in: Filter results where keywords is in a comma-separated list of values
        :type keywords__in: List[str]
        :param limit: Number of results to return per page.
        :type limit: int
        :param name: Filter results where name matches value
        :type name: str
        :param name__in: Filter results where name is in a comma-separated list of values
        :type name__in: List[str]
        :param offset: The initial index from which to return the results.
        :type offset: int
        :param ordering: Ordering  * `pulp_id` - Pulp id * `-pulp_id` - Pulp id (descending) * `pulp_created` - Pulp created * `-pulp_created` - Pulp created (descending) * `pulp_last_updated` - Pulp last updated * `-pulp_last_updated` - Pulp last updated (descending) * `pulp_type` - Pulp type * `-pulp_type` - Pulp type (descending) * `upstream_id` - Upstream id * `-upstream_id` - Upstream id (descending) * `pulp_labels` - Pulp labels * `-pulp_labels` - Pulp labels (descending) * `timestamp_of_interest` - Timestamp of interest * `-timestamp_of_interest` - Timestamp of interest (descending) * `filename` - Filename * `-filename` - Filename (descending) * `packagetype` - Packagetype * `-packagetype` - Packagetype (descending) * `name` - Name * `-name` - Name (descending) * `version` - Version * `-version` - Version (descending) * `sha256` - Sha256 * `-sha256` - Sha256 (descending) * `python_version` - Python version * `-python_version` - Python version (descending) * `metadata_version` - Metadata version * `-metadata_version` - Metadata version (descending) * `summary` - Summary * `-summary` - Summary (descending) * `description` - Description * `-description` - Description (descending) * `keywords` - Keywords * `-keywords` - Keywords (descending) * `home_page` - Home page * `-home_page` - Home page (descending) * `download_url` - Download url * `-download_url` - Download url (descending) * `author` - Author * `-author` - Author (descending) * `author_email` - Author email * `-author_email` - Author email (descending) * `maintainer` - Maintainer * `-maintainer` - Maintainer (descending) * `maintainer_email` - Maintainer email * `-maintainer_email` - Maintainer email (descending) * `license` - License * `-license` - License (descending) * `requires_python` - Requires python * `-requires_python` - Requires python (descending) * `project_url` - Project url * `-project_url` - Project url (descending) * `platform` - Platform * `-platform` - Platform (descending) * `supported_platform` - Supported platform * `-supported_platform` - Supported platform (descending) * `requires_dist` - Requires dist * `-requires_dist` - Requires dist (descending) * `provides_dist` - Provides dist * `-provides_dist` - Provides dist (descending) * `obsoletes_dist` - Obsoletes dist * `-obsoletes_dist` - Obsoletes dist (descending) * `requires_external` - Requires external * `-requires_external` - Requires external (descending) * `classifiers` - Classifiers * `-classifiers` - Classifiers (descending) * `project_urls` - Project urls * `-project_urls` - Project urls (descending) * `description_content_type` - Description content type * `-description_content_type` - Description content type (descending) * `pk` - Pk * `-pk` - Pk (descending)
        :type ordering: List[str]
        :param orphaned_for: Minutes Content has been orphaned for. -1 uses ORPHAN_PROTECTION_TIME.
        :type orphaned_for: float
        :param packagetype: Filter results where packagetype matches value  * `bdist_dmg` - bdist_dmg * `bdist_dumb` - bdist_dumb * `bdist_egg` - bdist_egg * `bdist_msi` - bdist_msi * `bdist_rpm` - bdist_rpm * `bdist_wheel` - bdist_wheel * `bdist_wininst` - bdist_wininst * `sdist` - sdist
        :type packagetype: str
        :param packagetype__in: Filter results where packagetype is in a comma-separated list of values
        :type packagetype__in: List[str]
        :param prn__in: Multiple values may be separated by commas.
        :type prn__in: List[str]
        :param pulp_href__in: Multiple values may be separated by commas.
        :type pulp_href__in: List[str]
        :param pulp_id__in: Multiple values may be separated by commas.
        :type pulp_id__in: List[str]
        :param pulp_label_select: Filter labels by search string
        :type pulp_label_select: str
        :param q: Filter results by using NOT, AND and OR operations on other filters
        :type q: str
        :param repository_version: Repository Version referenced by HREF/PRN
        :type repository_version: str
        :param repository_version_added: Repository Version referenced by HREF/PRN
        :type repository_version_added: str
        :param repository_version_removed: Repository Version referenced by HREF/PRN
        :type repository_version_removed: str
        :param requires_python: Filter results where requires_python matches value
        :type requires_python: str
        :param requires_python__contains: Filter results where requires_python contains value
        :type requires_python__contains: str
        :param requires_python__in: Filter results where requires_python is in a comma-separated list of values
        :type requires_python__in: List[str]
        :param sha256: Filter results where sha256 matches value
        :type sha256: str
        :param sha256__in: Filter results where sha256 is in a comma-separated list of values
        :type sha256__in: List[str]
        :param version: Filter results where version matches value
        :type version: str
        :param version__gt: Filter results where version is greater than value
        :type version__gt: str
        :param version__gte: Filter results where version is greater than or equal to value
        :type version__gte: str
        :param version__lt: Filter results where version is less than value
        :type version__lt: str
        :param version__lte: Filter results where version is less than or equal to value
        :type version__lte: str
        :param fields: A list of fields to include in the response.
        :type fields: List[str]
        :param exclude_fields: A list of fields to exclude from the response.
        :type exclude_fields: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_serialize(
            pulp_domain=pulp_domain,
            x_task_diagnostics=x_task_diagnostics,
            author=author,
            author__in=author__in,
            filename=filename,
            filename__contains=filename__contains,
            filename__in=filename__in,
            keywords__contains=keywords__contains,
            keywords__in=keywords__in,
            limit=limit,
            name=name,
            name__in=name__in,
            offset=offset,
            ordering=ordering,
            orphaned_for=orphaned_for,
            packagetype=packagetype,
            packagetype__in=packagetype__in,
            prn__in=prn__in,
            pulp_href__in=pulp_href__in,
            pulp_id__in=pulp_id__in,
            pulp_label_select=pulp_label_select,
            q=q,
            repository_version=repository_version,
            repository_version_added=repository_version_added,
            repository_version_removed=repository_version_removed,
            requires_python=requires_python,
            requires_python__contains=requires_python__contains,
            requires_python__in=requires_python__in,
            sha256=sha256,
            sha256__in=sha256__in,
            version=version,
            version__gt=version__gt,
            version__gte=version__gte,
            version__lt=version__lt,
            version__lte=version__lte,
            fields=fields,
            exclude_fields=exclude_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginatedpythonPythonPackageContentResponseList",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def list_with_http_info(
        self,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        author: Annotated[Optional[StrictStr], Field(description="Filter results where author matches value")] = None,
        author__in: Annotated[Optional[List[StrictStr]], Field(description="Filter results where author is in a comma-separated list of values")] = None,
        filename: Annotated[Optional[StrictStr], Field(description="Filter results where filename matches value")] = None,
        filename__contains: Annotated[Optional[StrictStr], Field(description="Filter results where filename contains value")] = None,
        filename__in: Annotated[Optional[List[StrictStr]], Field(description="Filter results where filename is in a comma-separated list of values")] = None,
        keywords__contains: Annotated[Optional[StrictStr], Field(description="Filter results where keywords contains value")] = None,
        keywords__in: Annotated[Optional[List[StrictStr]], Field(description="Filter results where keywords is in a comma-separated list of values")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Number of results to return per page.")] = None,
        name: Annotated[Optional[StrictStr], Field(description="Filter results where name matches value")] = None,
        name__in: Annotated[Optional[List[StrictStr]], Field(description="Filter results where name is in a comma-separated list of values")] = None,
        offset: Annotated[Optional[StrictInt], Field(description="The initial index from which to return the results.")] = None,
        ordering: Annotated[Optional[List[StrictStr]], Field(description="Ordering  * `pulp_id` - Pulp id * `-pulp_id` - Pulp id (descending) * `pulp_created` - Pulp created * `-pulp_created` - Pulp created (descending) * `pulp_last_updated` - Pulp last updated * `-pulp_last_updated` - Pulp last updated (descending) * `pulp_type` - Pulp type * `-pulp_type` - Pulp type (descending) * `upstream_id` - Upstream id * `-upstream_id` - Upstream id (descending) * `pulp_labels` - Pulp labels * `-pulp_labels` - Pulp labels (descending) * `timestamp_of_interest` - Timestamp of interest * `-timestamp_of_interest` - Timestamp of interest (descending) * `filename` - Filename * `-filename` - Filename (descending) * `packagetype` - Packagetype * `-packagetype` - Packagetype (descending) * `name` - Name * `-name` - Name (descending) * `version` - Version * `-version` - Version (descending) * `sha256` - Sha256 * `-sha256` - Sha256 (descending) * `python_version` - Python version * `-python_version` - Python version (descending) * `metadata_version` - Metadata version * `-metadata_version` - Metadata version (descending) * `summary` - Summary * `-summary` - Summary (descending) * `description` - Description * `-description` - Description (descending) * `keywords` - Keywords * `-keywords` - Keywords (descending) * `home_page` - Home page * `-home_page` - Home page (descending) * `download_url` - Download url * `-download_url` - Download url (descending) * `author` - Author * `-author` - Author (descending) * `author_email` - Author email * `-author_email` - Author email (descending) * `maintainer` - Maintainer * `-maintainer` - Maintainer (descending) * `maintainer_email` - Maintainer email * `-maintainer_email` - Maintainer email (descending) * `license` - License * `-license` - License (descending) * `requires_python` - Requires python * `-requires_python` - Requires python (descending) * `project_url` - Project url * `-project_url` - Project url (descending) * `platform` - Platform * `-platform` - Platform (descending) * `supported_platform` - Supported platform * `-supported_platform` - Supported platform (descending) * `requires_dist` - Requires dist * `-requires_dist` - Requires dist (descending) * `provides_dist` - Provides dist * `-provides_dist` - Provides dist (descending) * `obsoletes_dist` - Obsoletes dist * `-obsoletes_dist` - Obsoletes dist (descending) * `requires_external` - Requires external * `-requires_external` - Requires external (descending) * `classifiers` - Classifiers * `-classifiers` - Classifiers (descending) * `project_urls` - Project urls * `-project_urls` - Project urls (descending) * `description_content_type` - Description content type * `-description_content_type` - Description content type (descending) * `pk` - Pk * `-pk` - Pk (descending)")] = None,
        orphaned_for: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Minutes Content has been orphaned for. -1 uses ORPHAN_PROTECTION_TIME.")] = None,
        packagetype: Annotated[Optional[StrictStr], Field(description="Filter results where packagetype matches value  * `bdist_dmg` - bdist_dmg * `bdist_dumb` - bdist_dumb * `bdist_egg` - bdist_egg * `bdist_msi` - bdist_msi * `bdist_rpm` - bdist_rpm * `bdist_wheel` - bdist_wheel * `bdist_wininst` - bdist_wininst * `sdist` - sdist")] = None,
        packagetype__in: Annotated[Optional[List[StrictStr]], Field(description="Filter results where packagetype is in a comma-separated list of values")] = None,
        prn__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        pulp_href__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        pulp_id__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        pulp_label_select: Annotated[Optional[StrictStr], Field(description="Filter labels by search string")] = None,
        q: Annotated[Optional[StrictStr], Field(description="Filter results by using NOT, AND and OR operations on other filters")] = None,
        repository_version: Annotated[Optional[StrictStr], Field(description="Repository Version referenced by HREF/PRN")] = None,
        repository_version_added: Annotated[Optional[StrictStr], Field(description="Repository Version referenced by HREF/PRN")] = None,
        repository_version_removed: Annotated[Optional[StrictStr], Field(description="Repository Version referenced by HREF/PRN")] = None,
        requires_python: Annotated[Optional[StrictStr], Field(description="Filter results where requires_python matches value")] = None,
        requires_python__contains: Annotated[Optional[StrictStr], Field(description="Filter results where requires_python contains value")] = None,
        requires_python__in: Annotated[Optional[List[StrictStr]], Field(description="Filter results where requires_python is in a comma-separated list of values")] = None,
        sha256: Annotated[Optional[StrictStr], Field(description="Filter results where sha256 matches value")] = None,
        sha256__in: Annotated[Optional[List[StrictStr]], Field(description="Filter results where sha256 is in a comma-separated list of values")] = None,
        version: Annotated[Optional[StrictStr], Field(description="Filter results where version matches value")] = None,
        version__gt: Annotated[Optional[StrictStr], Field(description="Filter results where version is greater than value")] = None,
        version__gte: Annotated[Optional[StrictStr], Field(description="Filter results where version is greater than or equal to value")] = None,
        version__lt: Annotated[Optional[StrictStr], Field(description="Filter results where version is less than value")] = None,
        version__lte: Annotated[Optional[StrictStr], Field(description="Filter results where version is less than or equal to value")] = None,
        fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to include in the response.")] = None,
        exclude_fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to exclude from the response.")] = None,
        pulp_domain: StrictStr = "default",
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[PaginatedpythonPythonPackageContentResponseList]:
        """List python package contents

         PythonPackageContent represents each individually installable Python package. In the Python ecosystem, this is called a Python Distribution, sometimes (ambiguously) refered to as a package. In Pulp Python, we refer to it as PythonPackageContent. Each PythonPackageContent corresponds to a single filename, for example `pulpcore-3.0.0rc1-py3-none-any.whl` or `pulpcore-3.0.0rc1.tar.gz`.

        :param pulp_domain: (required)
        :type pulp_domain: str
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param author: Filter results where author matches value
        :type author: str
        :param author__in: Filter results where author is in a comma-separated list of values
        :type author__in: List[str]
        :param filename: Filter results where filename matches value
        :type filename: str
        :param filename__contains: Filter results where filename contains value
        :type filename__contains: str
        :param filename__in: Filter results where filename is in a comma-separated list of values
        :type filename__in: List[str]
        :param keywords__contains: Filter results where keywords contains value
        :type keywords__contains: str
        :param keywords__in: Filter results where keywords is in a comma-separated list of values
        :type keywords__in: List[str]
        :param limit: Number of results to return per page.
        :type limit: int
        :param name: Filter results where name matches value
        :type name: str
        :param name__in: Filter results where name is in a comma-separated list of values
        :type name__in: List[str]
        :param offset: The initial index from which to return the results.
        :type offset: int
        :param ordering: Ordering  * `pulp_id` - Pulp id * `-pulp_id` - Pulp id (descending) * `pulp_created` - Pulp created * `-pulp_created` - Pulp created (descending) * `pulp_last_updated` - Pulp last updated * `-pulp_last_updated` - Pulp last updated (descending) * `pulp_type` - Pulp type * `-pulp_type` - Pulp type (descending) * `upstream_id` - Upstream id * `-upstream_id` - Upstream id (descending) * `pulp_labels` - Pulp labels * `-pulp_labels` - Pulp labels (descending) * `timestamp_of_interest` - Timestamp of interest * `-timestamp_of_interest` - Timestamp of interest (descending) * `filename` - Filename * `-filename` - Filename (descending) * `packagetype` - Packagetype * `-packagetype` - Packagetype (descending) * `name` - Name * `-name` - Name (descending) * `version` - Version * `-version` - Version (descending) * `sha256` - Sha256 * `-sha256` - Sha256 (descending) * `python_version` - Python version * `-python_version` - Python version (descending) * `metadata_version` - Metadata version * `-metadata_version` - Metadata version (descending) * `summary` - Summary * `-summary` - Summary (descending) * `description` - Description * `-description` - Description (descending) * `keywords` - Keywords * `-keywords` - Keywords (descending) * `home_page` - Home page * `-home_page` - Home page (descending) * `download_url` - Download url * `-download_url` - Download url (descending) * `author` - Author * `-author` - Author (descending) * `author_email` - Author email * `-author_email` - Author email (descending) * `maintainer` - Maintainer * `-maintainer` - Maintainer (descending) * `maintainer_email` - Maintainer email * `-maintainer_email` - Maintainer email (descending) * `license` - License * `-license` - License (descending) * `requires_python` - Requires python * `-requires_python` - Requires python (descending) * `project_url` - Project url * `-project_url` - Project url (descending) * `platform` - Platform * `-platform` - Platform (descending) * `supported_platform` - Supported platform * `-supported_platform` - Supported platform (descending) * `requires_dist` - Requires dist * `-requires_dist` - Requires dist (descending) * `provides_dist` - Provides dist * `-provides_dist` - Provides dist (descending) * `obsoletes_dist` - Obsoletes dist * `-obsoletes_dist` - Obsoletes dist (descending) * `requires_external` - Requires external * `-requires_external` - Requires external (descending) * `classifiers` - Classifiers * `-classifiers` - Classifiers (descending) * `project_urls` - Project urls * `-project_urls` - Project urls (descending) * `description_content_type` - Description content type * `-description_content_type` - Description content type (descending) * `pk` - Pk * `-pk` - Pk (descending)
        :type ordering: List[str]
        :param orphaned_for: Minutes Content has been orphaned for. -1 uses ORPHAN_PROTECTION_TIME.
        :type orphaned_for: float
        :param packagetype: Filter results where packagetype matches value  * `bdist_dmg` - bdist_dmg * `bdist_dumb` - bdist_dumb * `bdist_egg` - bdist_egg * `bdist_msi` - bdist_msi * `bdist_rpm` - bdist_rpm * `bdist_wheel` - bdist_wheel * `bdist_wininst` - bdist_wininst * `sdist` - sdist
        :type packagetype: str
        :param packagetype__in: Filter results where packagetype is in a comma-separated list of values
        :type packagetype__in: List[str]
        :param prn__in: Multiple values may be separated by commas.
        :type prn__in: List[str]
        :param pulp_href__in: Multiple values may be separated by commas.
        :type pulp_href__in: List[str]
        :param pulp_id__in: Multiple values may be separated by commas.
        :type pulp_id__in: List[str]
        :param pulp_label_select: Filter labels by search string
        :type pulp_label_select: str
        :param q: Filter results by using NOT, AND and OR operations on other filters
        :type q: str
        :param repository_version: Repository Version referenced by HREF/PRN
        :type repository_version: str
        :param repository_version_added: Repository Version referenced by HREF/PRN
        :type repository_version_added: str
        :param repository_version_removed: Repository Version referenced by HREF/PRN
        :type repository_version_removed: str
        :param requires_python: Filter results where requires_python matches value
        :type requires_python: str
        :param requires_python__contains: Filter results where requires_python contains value
        :type requires_python__contains: str
        :param requires_python__in: Filter results where requires_python is in a comma-separated list of values
        :type requires_python__in: List[str]
        :param sha256: Filter results where sha256 matches value
        :type sha256: str
        :param sha256__in: Filter results where sha256 is in a comma-separated list of values
        :type sha256__in: List[str]
        :param version: Filter results where version matches value
        :type version: str
        :param version__gt: Filter results where version is greater than value
        :type version__gt: str
        :param version__gte: Filter results where version is greater than or equal to value
        :type version__gte: str
        :param version__lt: Filter results where version is less than value
        :type version__lt: str
        :param version__lte: Filter results where version is less than or equal to value
        :type version__lte: str
        :param fields: A list of fields to include in the response.
        :type fields: List[str]
        :param exclude_fields: A list of fields to exclude from the response.
        :type exclude_fields: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_serialize(
            pulp_domain=pulp_domain,
            x_task_diagnostics=x_task_diagnostics,
            author=author,
            author__in=author__in,
            filename=filename,
            filename__contains=filename__contains,
            filename__in=filename__in,
            keywords__contains=keywords__contains,
            keywords__in=keywords__in,
            limit=limit,
            name=name,
            name__in=name__in,
            offset=offset,
            ordering=ordering,
            orphaned_for=orphaned_for,
            packagetype=packagetype,
            packagetype__in=packagetype__in,
            prn__in=prn__in,
            pulp_href__in=pulp_href__in,
            pulp_id__in=pulp_id__in,
            pulp_label_select=pulp_label_select,
            q=q,
            repository_version=repository_version,
            repository_version_added=repository_version_added,
            repository_version_removed=repository_version_removed,
            requires_python=requires_python,
            requires_python__contains=requires_python__contains,
            requires_python__in=requires_python__in,
            sha256=sha256,
            sha256__in=sha256__in,
            version=version,
            version__gt=version__gt,
            version__gte=version__gte,
            version__lt=version__lt,
            version__lte=version__lte,
            fields=fields,
            exclude_fields=exclude_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginatedpythonPythonPackageContentResponseList",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def list_without_preload_content(
        self,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        author: Annotated[Optional[StrictStr], Field(description="Filter results where author matches value")] = None,
        author__in: Annotated[Optional[List[StrictStr]], Field(description="Filter results where author is in a comma-separated list of values")] = None,
        filename: Annotated[Optional[StrictStr], Field(description="Filter results where filename matches value")] = None,
        filename__contains: Annotated[Optional[StrictStr], Field(description="Filter results where filename contains value")] = None,
        filename__in: Annotated[Optional[List[StrictStr]], Field(description="Filter results where filename is in a comma-separated list of values")] = None,
        keywords__contains: Annotated[Optional[StrictStr], Field(description="Filter results where keywords contains value")] = None,
        keywords__in: Annotated[Optional[List[StrictStr]], Field(description="Filter results where keywords is in a comma-separated list of values")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Number of results to return per page.")] = None,
        name: Annotated[Optional[StrictStr], Field(description="Filter results where name matches value")] = None,
        name__in: Annotated[Optional[List[StrictStr]], Field(description="Filter results where name is in a comma-separated list of values")] = None,
        offset: Annotated[Optional[StrictInt], Field(description="The initial index from which to return the results.")] = None,
        ordering: Annotated[Optional[List[StrictStr]], Field(description="Ordering  * `pulp_id` - Pulp id * `-pulp_id` - Pulp id (descending) * `pulp_created` - Pulp created * `-pulp_created` - Pulp created (descending) * `pulp_last_updated` - Pulp last updated * `-pulp_last_updated` - Pulp last updated (descending) * `pulp_type` - Pulp type * `-pulp_type` - Pulp type (descending) * `upstream_id` - Upstream id * `-upstream_id` - Upstream id (descending) * `pulp_labels` - Pulp labels * `-pulp_labels` - Pulp labels (descending) * `timestamp_of_interest` - Timestamp of interest * `-timestamp_of_interest` - Timestamp of interest (descending) * `filename` - Filename * `-filename` - Filename (descending) * `packagetype` - Packagetype * `-packagetype` - Packagetype (descending) * `name` - Name * `-name` - Name (descending) * `version` - Version * `-version` - Version (descending) * `sha256` - Sha256 * `-sha256` - Sha256 (descending) * `python_version` - Python version * `-python_version` - Python version (descending) * `metadata_version` - Metadata version * `-metadata_version` - Metadata version (descending) * `summary` - Summary * `-summary` - Summary (descending) * `description` - Description * `-description` - Description (descending) * `keywords` - Keywords * `-keywords` - Keywords (descending) * `home_page` - Home page * `-home_page` - Home page (descending) * `download_url` - Download url * `-download_url` - Download url (descending) * `author` - Author * `-author` - Author (descending) * `author_email` - Author email * `-author_email` - Author email (descending) * `maintainer` - Maintainer * `-maintainer` - Maintainer (descending) * `maintainer_email` - Maintainer email * `-maintainer_email` - Maintainer email (descending) * `license` - License * `-license` - License (descending) * `requires_python` - Requires python * `-requires_python` - Requires python (descending) * `project_url` - Project url * `-project_url` - Project url (descending) * `platform` - Platform * `-platform` - Platform (descending) * `supported_platform` - Supported platform * `-supported_platform` - Supported platform (descending) * `requires_dist` - Requires dist * `-requires_dist` - Requires dist (descending) * `provides_dist` - Provides dist * `-provides_dist` - Provides dist (descending) * `obsoletes_dist` - Obsoletes dist * `-obsoletes_dist` - Obsoletes dist (descending) * `requires_external` - Requires external * `-requires_external` - Requires external (descending) * `classifiers` - Classifiers * `-classifiers` - Classifiers (descending) * `project_urls` - Project urls * `-project_urls` - Project urls (descending) * `description_content_type` - Description content type * `-description_content_type` - Description content type (descending) * `pk` - Pk * `-pk` - Pk (descending)")] = None,
        orphaned_for: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Minutes Content has been orphaned for. -1 uses ORPHAN_PROTECTION_TIME.")] = None,
        packagetype: Annotated[Optional[StrictStr], Field(description="Filter results where packagetype matches value  * `bdist_dmg` - bdist_dmg * `bdist_dumb` - bdist_dumb * `bdist_egg` - bdist_egg * `bdist_msi` - bdist_msi * `bdist_rpm` - bdist_rpm * `bdist_wheel` - bdist_wheel * `bdist_wininst` - bdist_wininst * `sdist` - sdist")] = None,
        packagetype__in: Annotated[Optional[List[StrictStr]], Field(description="Filter results where packagetype is in a comma-separated list of values")] = None,
        prn__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        pulp_href__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        pulp_id__in: Annotated[Optional[List[StrictStr]], Field(description="Multiple values may be separated by commas.")] = None,
        pulp_label_select: Annotated[Optional[StrictStr], Field(description="Filter labels by search string")] = None,
        q: Annotated[Optional[StrictStr], Field(description="Filter results by using NOT, AND and OR operations on other filters")] = None,
        repository_version: Annotated[Optional[StrictStr], Field(description="Repository Version referenced by HREF/PRN")] = None,
        repository_version_added: Annotated[Optional[StrictStr], Field(description="Repository Version referenced by HREF/PRN")] = None,
        repository_version_removed: Annotated[Optional[StrictStr], Field(description="Repository Version referenced by HREF/PRN")] = None,
        requires_python: Annotated[Optional[StrictStr], Field(description="Filter results where requires_python matches value")] = None,
        requires_python__contains: Annotated[Optional[StrictStr], Field(description="Filter results where requires_python contains value")] = None,
        requires_python__in: Annotated[Optional[List[StrictStr]], Field(description="Filter results where requires_python is in a comma-separated list of values")] = None,
        sha256: Annotated[Optional[StrictStr], Field(description="Filter results where sha256 matches value")] = None,
        sha256__in: Annotated[Optional[List[StrictStr]], Field(description="Filter results where sha256 is in a comma-separated list of values")] = None,
        version: Annotated[Optional[StrictStr], Field(description="Filter results where version matches value")] = None,
        version__gt: Annotated[Optional[StrictStr], Field(description="Filter results where version is greater than value")] = None,
        version__gte: Annotated[Optional[StrictStr], Field(description="Filter results where version is greater than or equal to value")] = None,
        version__lt: Annotated[Optional[StrictStr], Field(description="Filter results where version is less than value")] = None,
        version__lte: Annotated[Optional[StrictStr], Field(description="Filter results where version is less than or equal to value")] = None,
        fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to include in the response.")] = None,
        exclude_fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to exclude from the response.")] = None,
        pulp_domain: StrictStr = "default",
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List python package contents

         PythonPackageContent represents each individually installable Python package. In the Python ecosystem, this is called a Python Distribution, sometimes (ambiguously) refered to as a package. In Pulp Python, we refer to it as PythonPackageContent. Each PythonPackageContent corresponds to a single filename, for example `pulpcore-3.0.0rc1-py3-none-any.whl` or `pulpcore-3.0.0rc1.tar.gz`.

        :param pulp_domain: (required)
        :type pulp_domain: str
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param author: Filter results where author matches value
        :type author: str
        :param author__in: Filter results where author is in a comma-separated list of values
        :type author__in: List[str]
        :param filename: Filter results where filename matches value
        :type filename: str
        :param filename__contains: Filter results where filename contains value
        :type filename__contains: str
        :param filename__in: Filter results where filename is in a comma-separated list of values
        :type filename__in: List[str]
        :param keywords__contains: Filter results where keywords contains value
        :type keywords__contains: str
        :param keywords__in: Filter results where keywords is in a comma-separated list of values
        :type keywords__in: List[str]
        :param limit: Number of results to return per page.
        :type limit: int
        :param name: Filter results where name matches value
        :type name: str
        :param name__in: Filter results where name is in a comma-separated list of values
        :type name__in: List[str]
        :param offset: The initial index from which to return the results.
        :type offset: int
        :param ordering: Ordering  * `pulp_id` - Pulp id * `-pulp_id` - Pulp id (descending) * `pulp_created` - Pulp created * `-pulp_created` - Pulp created (descending) * `pulp_last_updated` - Pulp last updated * `-pulp_last_updated` - Pulp last updated (descending) * `pulp_type` - Pulp type * `-pulp_type` - Pulp type (descending) * `upstream_id` - Upstream id * `-upstream_id` - Upstream id (descending) * `pulp_labels` - Pulp labels * `-pulp_labels` - Pulp labels (descending) * `timestamp_of_interest` - Timestamp of interest * `-timestamp_of_interest` - Timestamp of interest (descending) * `filename` - Filename * `-filename` - Filename (descending) * `packagetype` - Packagetype * `-packagetype` - Packagetype (descending) * `name` - Name * `-name` - Name (descending) * `version` - Version * `-version` - Version (descending) * `sha256` - Sha256 * `-sha256` - Sha256 (descending) * `python_version` - Python version * `-python_version` - Python version (descending) * `metadata_version` - Metadata version * `-metadata_version` - Metadata version (descending) * `summary` - Summary * `-summary` - Summary (descending) * `description` - Description * `-description` - Description (descending) * `keywords` - Keywords * `-keywords` - Keywords (descending) * `home_page` - Home page * `-home_page` - Home page (descending) * `download_url` - Download url * `-download_url` - Download url (descending) * `author` - Author * `-author` - Author (descending) * `author_email` - Author email * `-author_email` - Author email (descending) * `maintainer` - Maintainer * `-maintainer` - Maintainer (descending) * `maintainer_email` - Maintainer email * `-maintainer_email` - Maintainer email (descending) * `license` - License * `-license` - License (descending) * `requires_python` - Requires python * `-requires_python` - Requires python (descending) * `project_url` - Project url * `-project_url` - Project url (descending) * `platform` - Platform * `-platform` - Platform (descending) * `supported_platform` - Supported platform * `-supported_platform` - Supported platform (descending) * `requires_dist` - Requires dist * `-requires_dist` - Requires dist (descending) * `provides_dist` - Provides dist * `-provides_dist` - Provides dist (descending) * `obsoletes_dist` - Obsoletes dist * `-obsoletes_dist` - Obsoletes dist (descending) * `requires_external` - Requires external * `-requires_external` - Requires external (descending) * `classifiers` - Classifiers * `-classifiers` - Classifiers (descending) * `project_urls` - Project urls * `-project_urls` - Project urls (descending) * `description_content_type` - Description content type * `-description_content_type` - Description content type (descending) * `pk` - Pk * `-pk` - Pk (descending)
        :type ordering: List[str]
        :param orphaned_for: Minutes Content has been orphaned for. -1 uses ORPHAN_PROTECTION_TIME.
        :type orphaned_for: float
        :param packagetype: Filter results where packagetype matches value  * `bdist_dmg` - bdist_dmg * `bdist_dumb` - bdist_dumb * `bdist_egg` - bdist_egg * `bdist_msi` - bdist_msi * `bdist_rpm` - bdist_rpm * `bdist_wheel` - bdist_wheel * `bdist_wininst` - bdist_wininst * `sdist` - sdist
        :type packagetype: str
        :param packagetype__in: Filter results where packagetype is in a comma-separated list of values
        :type packagetype__in: List[str]
        :param prn__in: Multiple values may be separated by commas.
        :type prn__in: List[str]
        :param pulp_href__in: Multiple values may be separated by commas.
        :type pulp_href__in: List[str]
        :param pulp_id__in: Multiple values may be separated by commas.
        :type pulp_id__in: List[str]
        :param pulp_label_select: Filter labels by search string
        :type pulp_label_select: str
        :param q: Filter results by using NOT, AND and OR operations on other filters
        :type q: str
        :param repository_version: Repository Version referenced by HREF/PRN
        :type repository_version: str
        :param repository_version_added: Repository Version referenced by HREF/PRN
        :type repository_version_added: str
        :param repository_version_removed: Repository Version referenced by HREF/PRN
        :type repository_version_removed: str
        :param requires_python: Filter results where requires_python matches value
        :type requires_python: str
        :param requires_python__contains: Filter results where requires_python contains value
        :type requires_python__contains: str
        :param requires_python__in: Filter results where requires_python is in a comma-separated list of values
        :type requires_python__in: List[str]
        :param sha256: Filter results where sha256 matches value
        :type sha256: str
        :param sha256__in: Filter results where sha256 is in a comma-separated list of values
        :type sha256__in: List[str]
        :param version: Filter results where version matches value
        :type version: str
        :param version__gt: Filter results where version is greater than value
        :type version__gt: str
        :param version__gte: Filter results where version is greater than or equal to value
        :type version__gte: str
        :param version__lt: Filter results where version is less than value
        :type version__lt: str
        :param version__lte: Filter results where version is less than or equal to value
        :type version__lte: str
        :param fields: A list of fields to include in the response.
        :type fields: List[str]
        :param exclude_fields: A list of fields to exclude from the response.
        :type exclude_fields: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_serialize(
            pulp_domain=pulp_domain,
            x_task_diagnostics=x_task_diagnostics,
            author=author,
            author__in=author__in,
            filename=filename,
            filename__contains=filename__contains,
            filename__in=filename__in,
            keywords__contains=keywords__contains,
            keywords__in=keywords__in,
            limit=limit,
            name=name,
            name__in=name__in,
            offset=offset,
            ordering=ordering,
            orphaned_for=orphaned_for,
            packagetype=packagetype,
            packagetype__in=packagetype__in,
            prn__in=prn__in,
            pulp_href__in=pulp_href__in,
            pulp_id__in=pulp_id__in,
            pulp_label_select=pulp_label_select,
            q=q,
            repository_version=repository_version,
            repository_version_added=repository_version_added,
            repository_version_removed=repository_version_removed,
            requires_python=requires_python,
            requires_python__contains=requires_python__contains,
            requires_python__in=requires_python__in,
            sha256=sha256,
            sha256__in=sha256__in,
            version=version,
            version__gt=version__gt,
            version__gte=version__gte,
            version__lt=version__lt,
            version__lte=version__lte,
            fields=fields,
            exclude_fields=exclude_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginatedpythonPythonPackageContentResponseList",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _list_serialize(
        self,
        pulp_domain,
        x_task_diagnostics,
        author,
        author__in,
        filename,
        filename__contains,
        filename__in,
        keywords__contains,
        keywords__in,
        limit,
        name,
        name__in,
        offset,
        ordering,
        orphaned_for,
        packagetype,
        packagetype__in,
        prn__in,
        pulp_href__in,
        pulp_id__in,
        pulp_label_select,
        q,
        repository_version,
        repository_version_added,
        repository_version_removed,
        requires_python,
        requires_python__contains,
        requires_python__in,
        sha256,
        sha256__in,
        version,
        version__gt,
        version__gte,
        version__lt,
        version__lte,
        fields,
        exclude_fields,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'X-Task-Diagnostics': 'csv',
            'author__in': 'csv',
            'filename__in': 'csv',
            'keywords__in': 'csv',
            'name__in': 'csv',
            'ordering': 'csv',
            'packagetype__in': 'csv',
            'prn__in': 'csv',
            'pulp_href__in': 'csv',
            'pulp_id__in': 'csv',
            'requires_python__in': 'csv',
            'sha256__in': 'csv',
            'fields': 'multi',
            'exclude_fields': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if pulp_domain is not None:
            _path_params['pulp_domain'] = pulp_domain
        # process the query parameters
        if author is not None:
            
            _query_params.append(('author', author))
            
        if author__in is not None:
            
            _query_params.append(('author__in', author__in))
            
        if filename is not None:
            
            _query_params.append(('filename', filename))
            
        if filename__contains is not None:
            
            _query_params.append(('filename__contains', filename__contains))
            
        if filename__in is not None:
            
            _query_params.append(('filename__in', filename__in))
            
        if keywords__contains is not None:
            
            _query_params.append(('keywords__contains', keywords__contains))
            
        if keywords__in is not None:
            
            _query_params.append(('keywords__in', keywords__in))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if name is not None:
            
            _query_params.append(('name', name))
            
        if name__in is not None:
            
            _query_params.append(('name__in', name__in))
            
        if offset is not None:
            
            _query_params.append(('offset', offset))
            
        if ordering is not None:
            
            _query_params.append(('ordering', ordering))
            
        if orphaned_for is not None:
            
            _query_params.append(('orphaned_for', orphaned_for))
            
        if packagetype is not None:
            
            _query_params.append(('packagetype', packagetype))
            
        if packagetype__in is not None:
            
            _query_params.append(('packagetype__in', packagetype__in))
            
        if prn__in is not None:
            
            _query_params.append(('prn__in', prn__in))
            
        if pulp_href__in is not None:
            
            _query_params.append(('pulp_href__in', pulp_href__in))
            
        if pulp_id__in is not None:
            
            _query_params.append(('pulp_id__in', pulp_id__in))
            
        if pulp_label_select is not None:
            
            _query_params.append(('pulp_label_select', pulp_label_select))
            
        if q is not None:
            
            _query_params.append(('q', q))
            
        if repository_version is not None:
            
            _query_params.append(('repository_version', repository_version))
            
        if repository_version_added is not None:
            
            _query_params.append(('repository_version_added', repository_version_added))
            
        if repository_version_removed is not None:
            
            _query_params.append(('repository_version_removed', repository_version_removed))
            
        if requires_python is not None:
            
            _query_params.append(('requires_python', requires_python))
            
        if requires_python__contains is not None:
            
            _query_params.append(('requires_python__contains', requires_python__contains))
            
        if requires_python__in is not None:
            
            _query_params.append(('requires_python__in', requires_python__in))
            
        if sha256 is not None:
            
            _query_params.append(('sha256', sha256))
            
        if sha256__in is not None:
            
            _query_params.append(('sha256__in', sha256__in))
            
        if version is not None:
            
            _query_params.append(('version', version))
            
        if version__gt is not None:
            
            _query_params.append(('version__gt', version__gt))
            
        if version__gte is not None:
            
            _query_params.append(('version__gte', version__gte))
            
        if version__lt is not None:
            
            _query_params.append(('version__lt', version__lt))
            
        if version__lte is not None:
            
            _query_params.append(('version__lte', version__lte))
            
        if fields is not None:
            
            _query_params.append(('fields', fields))
            
        if exclude_fields is not None:
            
            _query_params.append(('exclude_fields', exclude_fields))
            
        # process the header parameters
        if x_task_diagnostics is not None:
            _header_params['X-Task-Diagnostics'] = x_task_diagnostics
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'json_header_remote_authentication', 
            'basicAuth', 
            'cookieAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/pulp/{pulp_domain}/api/v3/content/python/packages/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def read(
        self,
        python_python_package_content_href: StrictStr,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to include in the response.")] = None,
        exclude_fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to exclude from the response.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> PythonPythonPackageContentResponse:
        """Inspect a python package content

         PythonPackageContent represents each individually installable Python package. In the Python ecosystem, this is called a Python Distribution, sometimes (ambiguously) refered to as a package. In Pulp Python, we refer to it as PythonPackageContent. Each PythonPackageContent corresponds to a single filename, for example `pulpcore-3.0.0rc1-py3-none-any.whl` or `pulpcore-3.0.0rc1.tar.gz`.

        :param python_python_package_content_href: (required)
        :type python_python_package_content_href: str
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param fields: A list of fields to include in the response.
        :type fields: List[str]
        :param exclude_fields: A list of fields to exclude from the response.
        :type exclude_fields: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._read_serialize(
            python_python_package_content_href=python_python_package_content_href,
            x_task_diagnostics=x_task_diagnostics,
            fields=fields,
            exclude_fields=exclude_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PythonPythonPackageContentResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def read_with_http_info(
        self,
        python_python_package_content_href: StrictStr,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to include in the response.")] = None,
        exclude_fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to exclude from the response.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[PythonPythonPackageContentResponse]:
        """Inspect a python package content

         PythonPackageContent represents each individually installable Python package. In the Python ecosystem, this is called a Python Distribution, sometimes (ambiguously) refered to as a package. In Pulp Python, we refer to it as PythonPackageContent. Each PythonPackageContent corresponds to a single filename, for example `pulpcore-3.0.0rc1-py3-none-any.whl` or `pulpcore-3.0.0rc1.tar.gz`.

        :param python_python_package_content_href: (required)
        :type python_python_package_content_href: str
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param fields: A list of fields to include in the response.
        :type fields: List[str]
        :param exclude_fields: A list of fields to exclude from the response.
        :type exclude_fields: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._read_serialize(
            python_python_package_content_href=python_python_package_content_href,
            x_task_diagnostics=x_task_diagnostics,
            fields=fields,
            exclude_fields=exclude_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PythonPythonPackageContentResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def read_without_preload_content(
        self,
        python_python_package_content_href: StrictStr,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to include in the response.")] = None,
        exclude_fields: Annotated[Optional[List[StrictStr]], Field(description="A list of fields to exclude from the response.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Inspect a python package content

         PythonPackageContent represents each individually installable Python package. In the Python ecosystem, this is called a Python Distribution, sometimes (ambiguously) refered to as a package. In Pulp Python, we refer to it as PythonPackageContent. Each PythonPackageContent corresponds to a single filename, for example `pulpcore-3.0.0rc1-py3-none-any.whl` or `pulpcore-3.0.0rc1.tar.gz`.

        :param python_python_package_content_href: (required)
        :type python_python_package_content_href: str
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param fields: A list of fields to include in the response.
        :type fields: List[str]
        :param exclude_fields: A list of fields to exclude from the response.
        :type exclude_fields: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._read_serialize(
            python_python_package_content_href=python_python_package_content_href,
            x_task_diagnostics=x_task_diagnostics,
            fields=fields,
            exclude_fields=exclude_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PythonPythonPackageContentResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _read_serialize(
        self,
        python_python_package_content_href,
        x_task_diagnostics,
        fields,
        exclude_fields,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'X-Task-Diagnostics': 'csv',
            'fields': 'multi',
            'exclude_fields': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if python_python_package_content_href is not None:
            _path_params['python_python_package_content_href'] = python_python_package_content_href
        # process the query parameters
        if fields is not None:
            
            _query_params.append(('fields', fields))
            
        if exclude_fields is not None:
            
            _query_params.append(('exclude_fields', exclude_fields))
            
        # process the header parameters
        if x_task_diagnostics is not None:
            _header_params['X-Task-Diagnostics'] = x_task_diagnostics
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'json_header_remote_authentication', 
            'basicAuth', 
            'cookieAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='{python_python_package_content_href}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def set_label(
        self,
        python_python_package_content_href: StrictStr,
        set_label: SetLabel,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> SetLabelResponse:
        """Set a label

        Set a single pulp_label on the object to a specific value or null.

        :param python_python_package_content_href: (required)
        :type python_python_package_content_href: str
        :param set_label: (required)
        :type set_label: SetLabel
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._set_label_serialize(
            python_python_package_content_href=python_python_package_content_href,
            set_label=set_label,
            x_task_diagnostics=x_task_diagnostics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "SetLabelResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def set_label_with_http_info(
        self,
        python_python_package_content_href: StrictStr,
        set_label: SetLabel,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[SetLabelResponse]:
        """Set a label

        Set a single pulp_label on the object to a specific value or null.

        :param python_python_package_content_href: (required)
        :type python_python_package_content_href: str
        :param set_label: (required)
        :type set_label: SetLabel
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._set_label_serialize(
            python_python_package_content_href=python_python_package_content_href,
            set_label=set_label,
            x_task_diagnostics=x_task_diagnostics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "SetLabelResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def set_label_without_preload_content(
        self,
        python_python_package_content_href: StrictStr,
        set_label: SetLabel,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Set a label

        Set a single pulp_label on the object to a specific value or null.

        :param python_python_package_content_href: (required)
        :type python_python_package_content_href: str
        :param set_label: (required)
        :type set_label: SetLabel
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._set_label_serialize(
            python_python_package_content_href=python_python_package_content_href,
            set_label=set_label,
            x_task_diagnostics=x_task_diagnostics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "SetLabelResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _set_label_serialize(
        self,
        python_python_package_content_href,
        set_label,
        x_task_diagnostics,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'X-Task-Diagnostics': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if python_python_package_content_href is not None:
            _path_params['python_python_package_content_href'] = python_python_package_content_href
        # process the query parameters
        # process the header parameters
        if x_task_diagnostics is not None:
            _header_params['X-Task-Diagnostics'] = x_task_diagnostics
        # process the form parameters
        # process the body parameter
        if set_label is not None:
            _body_params = set_label


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'json_header_remote_authentication', 
            'basicAuth', 
            'cookieAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='{python_python_package_content_href}set_label/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def unset_label(
        self,
        python_python_package_content_href: StrictStr,
        unset_label: UnsetLabel,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> UnsetLabelResponse:
        """Unset a label

        Unset a single pulp_label on the object.

        :param python_python_package_content_href: (required)
        :type python_python_package_content_href: str
        :param unset_label: (required)
        :type unset_label: UnsetLabel
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._unset_label_serialize(
            python_python_package_content_href=python_python_package_content_href,
            unset_label=unset_label,
            x_task_diagnostics=x_task_diagnostics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "UnsetLabelResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def unset_label_with_http_info(
        self,
        python_python_package_content_href: StrictStr,
        unset_label: UnsetLabel,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[UnsetLabelResponse]:
        """Unset a label

        Unset a single pulp_label on the object.

        :param python_python_package_content_href: (required)
        :type python_python_package_content_href: str
        :param unset_label: (required)
        :type unset_label: UnsetLabel
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._unset_label_serialize(
            python_python_package_content_href=python_python_package_content_href,
            unset_label=unset_label,
            x_task_diagnostics=x_task_diagnostics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "UnsetLabelResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def unset_label_without_preload_content(
        self,
        python_python_package_content_href: StrictStr,
        unset_label: UnsetLabel,
        x_task_diagnostics: Annotated[Optional[List[StrictStr]], Field(description="List of profilers to use on tasks.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Unset a label

        Unset a single pulp_label on the object.

        :param python_python_package_content_href: (required)
        :type python_python_package_content_href: str
        :param unset_label: (required)
        :type unset_label: UnsetLabel
        :param x_task_diagnostics: List of profilers to use on tasks.
        :type x_task_diagnostics: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._unset_label_serialize(
            python_python_package_content_href=python_python_package_content_href,
            unset_label=unset_label,
            x_task_diagnostics=x_task_diagnostics,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "UnsetLabelResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _unset_label_serialize(
        self,
        python_python_package_content_href,
        unset_label,
        x_task_diagnostics,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'X-Task-Diagnostics': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if python_python_package_content_href is not None:
            _path_params['python_python_package_content_href'] = python_python_package_content_href
        # process the query parameters
        # process the header parameters
        if x_task_diagnostics is not None:
            _header_params['X-Task-Diagnostics'] = x_task_diagnostics
        # process the form parameters
        # process the body parameter
        if unset_label is not None:
            _body_params = unset_label


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded', 
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'json_header_remote_authentication', 
            'basicAuth', 
            'cookieAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='{python_python_package_content_href}unset_label/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


