# crc-pulp_python-client
Fetch, Upload, Organize, and Distribute Software Packages

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: v3
- Package version: 20251104.3
- Generator version: 7.10.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://pulpproject.org](https://pulpproject.org)

## Requirements.

Python 3.8+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import pulpcore.client.pulp_python
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import pulpcore.client.pulp_python
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import pulpcore.client.pulp_python
from pulpcore.client.pulp_python.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://env-ephemeral-4vgggc.apps.crc-eph.r9lp.p1.openshiftapps.com
# See configuration.py for a list of all supported configuration parameters.
configuration = pulpcore.client.pulp_python.Configuration(
    host = "https://env-ephemeral-4vgggc.apps.crc-eph.r9lp.p1.openshiftapps.com"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Configure HTTP basic authorization: basicAuth
configuration = pulpcore.client.pulp_python.Configuration(
    username = os.environ["USERNAME"],
    password = os.environ["PASSWORD"]
)

# Configure API key authorization: cookieAuth
configuration.api_key['cookieAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['cookieAuth'] = 'Bearer'


# Enter a context with an instance of the API client
with pulpcore.client.pulp_python.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = pulpcore.client.pulp_python.ApiLegacyApi(api_client)
    path = 'path_example' # str | 
    pulp_domain = 'pulp_domain_example' # str | 
    content = None # bytearray | A Python package release file to upload to the index.
    sha256_digest = 'sha256_digest_example' # str | SHA256 of package to validate upload integrity.
    x_task_diagnostics = ['x_task_diagnostics_example'] # List[str] | List of profilers to use on tasks. (optional)
    action = 'file_upload' # str | Defaults to `file_upload`, don't change it or request will fail! (optional) (default to 'file_upload')

    try:
        # Upload a package
        api_response = api_instance.create(path, pulp_domain, content, sha256_digest, x_task_diagnostics=x_task_diagnostics, action=action)
        print("The response of ApiLegacyApi->create:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling ApiLegacyApi->create: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://env-ephemeral-4vgggc.apps.crc-eph.r9lp.p1.openshiftapps.com*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ApiLegacyApi* | [**create**](docs/ApiLegacyApi.md#create) | **POST** /api/pypi/{pulp_domain}/{path}/legacy/ | Upload a package
*ApiPypiApi* | [**read**](docs/ApiPypiApi.md#read) | **GET** /api/pypi/{pulp_domain}/{path}/ | Get index summary
*ApiSimpleApi* | [**create**](docs/ApiSimpleApi.md#create) | **POST** /api/pypi/{pulp_domain}/{path}/simple/ | Upload a package
*ApiSimpleApi* | [**pypi_simple_package_read**](docs/ApiSimpleApi.md#pypi_simple_package_read) | **GET** /api/pypi/{pulp_domain}/{path}/simple/{package}/ | Get package simple page
*ApiSimpleApi* | [**read**](docs/ApiSimpleApi.md#read) | **GET** /api/pypi/{pulp_domain}/{path}/simple/ | Get index simple page
*ContentPackagesApi* | [**create**](docs/ContentPackagesApi.md#create) | **POST** /api/pulp/{pulp_domain}/api/v3/content/python/packages/ | Create a python package content
*ContentPackagesApi* | [**list**](docs/ContentPackagesApi.md#list) | **GET** /api/pulp/{pulp_domain}/api/v3/content/python/packages/ | List python package contents
*ContentPackagesApi* | [**read**](docs/ContentPackagesApi.md#read) | **GET** {python_python_package_content_href} | Inspect a python package content
*ContentPackagesApi* | [**set_label**](docs/ContentPackagesApi.md#set_label) | **POST** {python_python_package_content_href}set_label/ | Set a label
*ContentPackagesApi* | [**unset_label**](docs/ContentPackagesApi.md#unset_label) | **POST** {python_python_package_content_href}unset_label/ | Unset a label
*ContentPackagesApi* | [**upload**](docs/ContentPackagesApi.md#upload) | **POST** /api/pulp/{pulp_domain}/api/v3/content/python/packages/upload/ | Synchronous Python package upload
*DistributionsPypiApi* | [**add_role**](docs/DistributionsPypiApi.md#add_role) | **POST** {python_python_distribution_href}add_role/ | Add a role
*DistributionsPypiApi* | [**create**](docs/DistributionsPypiApi.md#create) | **POST** /api/pulp/{pulp_domain}/api/v3/distributions/python/pypi/ | Create a python distribution
*DistributionsPypiApi* | [**delete**](docs/DistributionsPypiApi.md#delete) | **DELETE** {python_python_distribution_href} | Delete a python distribution
*DistributionsPypiApi* | [**list**](docs/DistributionsPypiApi.md#list) | **GET** /api/pulp/{pulp_domain}/api/v3/distributions/python/pypi/ | List python distributions
*DistributionsPypiApi* | [**list_roles**](docs/DistributionsPypiApi.md#list_roles) | **GET** {python_python_distribution_href}list_roles/ | List roles
*DistributionsPypiApi* | [**my_permissions**](docs/DistributionsPypiApi.md#my_permissions) | **GET** {python_python_distribution_href}my_permissions/ | List user permissions
*DistributionsPypiApi* | [**partial_update**](docs/DistributionsPypiApi.md#partial_update) | **PATCH** {python_python_distribution_href} | Update a python distribution
*DistributionsPypiApi* | [**read**](docs/DistributionsPypiApi.md#read) | **GET** {python_python_distribution_href} | Inspect a python distribution
*DistributionsPypiApi* | [**remove_role**](docs/DistributionsPypiApi.md#remove_role) | **POST** {python_python_distribution_href}remove_role/ | Remove a role
*DistributionsPypiApi* | [**set_label**](docs/DistributionsPypiApi.md#set_label) | **POST** {python_python_distribution_href}set_label/ | Set a label
*DistributionsPypiApi* | [**unset_label**](docs/DistributionsPypiApi.md#unset_label) | **POST** {python_python_distribution_href}unset_label/ | Unset a label
*DistributionsPypiApi* | [**update**](docs/DistributionsPypiApi.md#update) | **PUT** {python_python_distribution_href} | Update a python distribution
*PublicationsPypiApi* | [**add_role**](docs/PublicationsPypiApi.md#add_role) | **POST** {python_python_publication_href}add_role/ | Add a role
*PublicationsPypiApi* | [**create**](docs/PublicationsPypiApi.md#create) | **POST** /api/pulp/{pulp_domain}/api/v3/publications/python/pypi/ | Create a python publication
*PublicationsPypiApi* | [**delete**](docs/PublicationsPypiApi.md#delete) | **DELETE** {python_python_publication_href} | Delete a python publication
*PublicationsPypiApi* | [**list**](docs/PublicationsPypiApi.md#list) | **GET** /api/pulp/{pulp_domain}/api/v3/publications/python/pypi/ | List python publications
*PublicationsPypiApi* | [**list_roles**](docs/PublicationsPypiApi.md#list_roles) | **GET** {python_python_publication_href}list_roles/ | List roles
*PublicationsPypiApi* | [**my_permissions**](docs/PublicationsPypiApi.md#my_permissions) | **GET** {python_python_publication_href}my_permissions/ | List user permissions
*PublicationsPypiApi* | [**read**](docs/PublicationsPypiApi.md#read) | **GET** {python_python_publication_href} | Inspect a python publication
*PublicationsPypiApi* | [**remove_role**](docs/PublicationsPypiApi.md#remove_role) | **POST** {python_python_publication_href}remove_role/ | Remove a role
*PypiMetadataApi* | [**read**](docs/PypiMetadataApi.md#read) | **GET** /api/pypi/{pulp_domain}/{path}/pypi/{meta}/ | Get package metadata
*RemotesPythonApi* | [**add_role**](docs/RemotesPythonApi.md#add_role) | **POST** {python_python_remote_href}add_role/ | Add a role
*RemotesPythonApi* | [**create**](docs/RemotesPythonApi.md#create) | **POST** /api/pulp/{pulp_domain}/api/v3/remotes/python/python/ | Create a python remote
*RemotesPythonApi* | [**delete**](docs/RemotesPythonApi.md#delete) | **DELETE** {python_python_remote_href} | Delete a python remote
*RemotesPythonApi* | [**from_bandersnatch**](docs/RemotesPythonApi.md#from_bandersnatch) | **POST** /api/pulp/{pulp_domain}/api/v3/remotes/python/python/from_bandersnatch/ | Create from Bandersnatch
*RemotesPythonApi* | [**list**](docs/RemotesPythonApi.md#list) | **GET** /api/pulp/{pulp_domain}/api/v3/remotes/python/python/ | List python remotes
*RemotesPythonApi* | [**list_roles**](docs/RemotesPythonApi.md#list_roles) | **GET** {python_python_remote_href}list_roles/ | List roles
*RemotesPythonApi* | [**my_permissions**](docs/RemotesPythonApi.md#my_permissions) | **GET** {python_python_remote_href}my_permissions/ | List user permissions
*RemotesPythonApi* | [**partial_update**](docs/RemotesPythonApi.md#partial_update) | **PATCH** {python_python_remote_href} | Update a python remote
*RemotesPythonApi* | [**read**](docs/RemotesPythonApi.md#read) | **GET** {python_python_remote_href} | Inspect a python remote
*RemotesPythonApi* | [**remove_role**](docs/RemotesPythonApi.md#remove_role) | **POST** {python_python_remote_href}remove_role/ | Remove a role
*RemotesPythonApi* | [**set_label**](docs/RemotesPythonApi.md#set_label) | **POST** {python_python_remote_href}set_label/ | Set a label
*RemotesPythonApi* | [**unset_label**](docs/RemotesPythonApi.md#unset_label) | **POST** {python_python_remote_href}unset_label/ | Unset a label
*RemotesPythonApi* | [**update**](docs/RemotesPythonApi.md#update) | **PUT** {python_python_remote_href} | Update a python remote
*RepositoriesPythonApi* | [**add_role**](docs/RepositoriesPythonApi.md#add_role) | **POST** {python_python_repository_href}add_role/ | Add a role
*RepositoriesPythonApi* | [**create**](docs/RepositoriesPythonApi.md#create) | **POST** /api/pulp/{pulp_domain}/api/v3/repositories/python/python/ | Create a python repository
*RepositoriesPythonApi* | [**delete**](docs/RepositoriesPythonApi.md#delete) | **DELETE** {python_python_repository_href} | Delete a python repository
*RepositoriesPythonApi* | [**list**](docs/RepositoriesPythonApi.md#list) | **GET** /api/pulp/{pulp_domain}/api/v3/repositories/python/python/ | List python repositorys
*RepositoriesPythonApi* | [**list_roles**](docs/RepositoriesPythonApi.md#list_roles) | **GET** {python_python_repository_href}list_roles/ | List roles
*RepositoriesPythonApi* | [**modify**](docs/RepositoriesPythonApi.md#modify) | **POST** {python_python_repository_href}modify/ | Modify Repository Content
*RepositoriesPythonApi* | [**my_permissions**](docs/RepositoriesPythonApi.md#my_permissions) | **GET** {python_python_repository_href}my_permissions/ | List user permissions
*RepositoriesPythonApi* | [**partial_update**](docs/RepositoriesPythonApi.md#partial_update) | **PATCH** {python_python_repository_href} | Update a python repository
*RepositoriesPythonApi* | [**read**](docs/RepositoriesPythonApi.md#read) | **GET** {python_python_repository_href} | Inspect a python repository
*RepositoriesPythonApi* | [**remove_role**](docs/RepositoriesPythonApi.md#remove_role) | **POST** {python_python_repository_href}remove_role/ | Remove a role
*RepositoriesPythonApi* | [**repair_metadata**](docs/RepositoriesPythonApi.md#repair_metadata) | **POST** {python_python_repository_href}repair_metadata/ | Repair metadata
*RepositoriesPythonApi* | [**set_label**](docs/RepositoriesPythonApi.md#set_label) | **POST** {python_python_repository_href}set_label/ | Set a label
*RepositoriesPythonApi* | [**sync**](docs/RepositoriesPythonApi.md#sync) | **POST** {python_python_repository_href}sync/ | Sync from remote
*RepositoriesPythonApi* | [**unset_label**](docs/RepositoriesPythonApi.md#unset_label) | **POST** {python_python_repository_href}unset_label/ | Unset a label
*RepositoriesPythonApi* | [**update**](docs/RepositoriesPythonApi.md#update) | **PUT** {python_python_repository_href} | Update a python repository
*RepositoriesPythonVersionsApi* | [**delete**](docs/RepositoriesPythonVersionsApi.md#delete) | **DELETE** {python_python_repository_version_href} | Delete a repository version
*RepositoriesPythonVersionsApi* | [**list**](docs/RepositoriesPythonVersionsApi.md#list) | **GET** {python_python_repository_href}versions/ | List repository versions
*RepositoriesPythonVersionsApi* | [**read**](docs/RepositoriesPythonVersionsApi.md#read) | **GET** {python_python_repository_version_href} | Inspect a repository version
*RepositoriesPythonVersionsApi* | [**repair**](docs/RepositoriesPythonVersionsApi.md#repair) | **POST** {python_python_repository_version_href}repair/ | 


## Documentation For Models

 - [AsyncOperationResponse](docs/AsyncOperationResponse.md)
 - [ContentSummaryResponse](docs/ContentSummaryResponse.md)
 - [ExcludePlatformsEnum](docs/ExcludePlatformsEnum.md)
 - [MyPermissionsResponse](docs/MyPermissionsResponse.md)
 - [NestedRole](docs/NestedRole.md)
 - [NestedRoleResponse](docs/NestedRoleResponse.md)
 - [ObjectRolesResponse](docs/ObjectRolesResponse.md)
 - [PackageMetadataResponse](docs/PackageMetadataResponse.md)
 - [PackageTypesEnum](docs/PackageTypesEnum.md)
 - [PackageUploadTaskResponse](docs/PackageUploadTaskResponse.md)
 - [PaginatedRepositoryVersionResponseList](docs/PaginatedRepositoryVersionResponseList.md)
 - [PaginatedpythonPythonDistributionResponseList](docs/PaginatedpythonPythonDistributionResponseList.md)
 - [PaginatedpythonPythonPackageContentResponseList](docs/PaginatedpythonPythonPackageContentResponseList.md)
 - [PaginatedpythonPythonPublicationResponseList](docs/PaginatedpythonPythonPublicationResponseList.md)
 - [PaginatedpythonPythonRemoteResponseList](docs/PaginatedpythonPythonRemoteResponseList.md)
 - [PaginatedpythonPythonRepositoryResponseList](docs/PaginatedpythonPythonRepositoryResponseList.md)
 - [PatchedpythonPythonDistribution](docs/PatchedpythonPythonDistribution.md)
 - [PatchedpythonPythonRemote](docs/PatchedpythonPythonRemote.md)
 - [PatchedpythonPythonRepository](docs/PatchedpythonPythonRepository.md)
 - [PolicyEnum](docs/PolicyEnum.md)
 - [PythonPythonDistribution](docs/PythonPythonDistribution.md)
 - [PythonPythonDistributionResponse](docs/PythonPythonDistributionResponse.md)
 - [PythonPythonPackageContentResponse](docs/PythonPythonPackageContentResponse.md)
 - [PythonPythonPublication](docs/PythonPythonPublication.md)
 - [PythonPythonPublicationResponse](docs/PythonPythonPublicationResponse.md)
 - [PythonPythonRemote](docs/PythonPythonRemote.md)
 - [PythonPythonRemoteResponse](docs/PythonPythonRemoteResponse.md)
 - [PythonPythonRemoteResponseHiddenFieldsInner](docs/PythonPythonRemoteResponseHiddenFieldsInner.md)
 - [PythonPythonRepository](docs/PythonPythonRepository.md)
 - [PythonPythonRepositoryResponse](docs/PythonPythonRepositoryResponse.md)
 - [Repair](docs/Repair.md)
 - [RepositoryAddRemoveContent](docs/RepositoryAddRemoveContent.md)
 - [RepositorySyncURL](docs/RepositorySyncURL.md)
 - [RepositoryVersionResponse](docs/RepositoryVersionResponse.md)
 - [SetLabel](docs/SetLabel.md)
 - [SetLabelResponse](docs/SetLabelResponse.md)
 - [SummaryResponse](docs/SummaryResponse.md)
 - [UnsetLabel](docs/UnsetLabel.md)
 - [UnsetLabelResponse](docs/UnsetLabelResponse.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="basicAuth"></a>
### basicAuth

- **Type**: HTTP basic authentication

<a id="cookieAuth"></a>
### cookieAuth

- **Type**: API key
- **API key parameter name**: sessionid
- **Location**: 

<a id="json_header_remote_authentication"></a>
### json_header_remote_authentication

- **Type**: OAuth
- **Flow**: application
- **Authorization URL**: 
- **Scopes**: 
 - **api.console**: grant_access_to_pulp


## Author

pulp-list@redhat.com


