# CreativePython

CreativePython is a Python-based software environment for developing algorithmic art projects.  It mirrors the [JythonMusic API](https://jythonmusic.me/api-reference/).

This package is still under development.

---

## Quick Install

The CreativePython Install Scripts [(Download)](https://www.dropbox.com/scl/fo/7cwxayca38ajcc533bpgs/AGP4pnP-xhb-5LH_7YPsgyk?rlkey=2led17m6h0ku9y3hzbsnvsio1&dl=1) install CreativePython and all its required software, including Python3, FluidSynth, PortAudio, ffmpeg, Homebrew (on Mac), and Windows Build Kit (on Windows).

### Windows 
  1. Open `win-scripts.zip`.  Right-click `windows_setup.ps1`, and **Run with PowerShell** (it will open a PowerShell window and begin installing).  
  2. Follow any prompts and let it finish.
    - If you do not have Windows Build Kit installed, it will be installed as part of this process.  This may take some time to complete.

### macOS 
  1. Open `mac-scripts.tgz`.  Control-click `mac_setup.command`, and **Open** (it will open a Terminal window and begin installing).
  2. Follow any prompts and let it finish.
    - If you do not have Command Line Tools for XCode installed, it will be installed as part of this process.  This may take some time to complete.

---

## Custom Install

---

### 1. Install Python 3 + pip

#### Windows
1. Open PowerShell as Administrator (search "PowerShell" in the Start menu, and select "Run as Administrator").  Copy and Paste the following commands at each step.

2. Install **Chocolatey** if you don't have it. [(Documentation)](https://docs.chocolatey.org/en-us/choco/setup/)  Copy/Paste the following command:

   ```Set-ExecutionPolicy Bypass -Scope Process -Force; [System.Net.ServicePointManager]::SecurityProtocol -bor 3072; iex ((New-Object System.Net.WebClient).DownloadString('https://community.chocolatey.org/install.ps1'))```

   When finished, exit this window and open a new PowerShell window.

3. Install Python 3.

   ```Invoke-Expressed "choco install python -y"```

4. Verify that Python was installed.

   ```py --version```

   You should see something like "Python 3.12.4"

#### MacOS
1. Open Terminal (press Command + Space, type "Terminal", and hit Enter).  Copy and Paste the following commands at each step.

2. Install **Homebrew** if you don't have it.

   ```/bin/bash -c "$(curl -fsSL https://raw.githubusercontent.com/Homebrew/install/HEAD/install.sh)"```

3. Install Python 3.

   ```brew install python```

4. Verify your installation.

   ```python3 --version```

   You should see something like "Python 3.12.4"

---

### 2. Install System Libraries

#### Windows
- **Microsoft Build Tools**
Microsoft Build Tools contains the necessary tools to compile C++ packages that come with some Python libraries.

   1. Open a new PowerShell window.

   2. Download the latest Microsoft Build Tools.

      ```Invoke-WebRequest -Uri "https://aka.ms/vs/17/release/vs_buildtools.exe" -OutFile "$env:TEMP\vs_buildtools.exe"```

   3. Run the Installer.

      ```Start-Process "$env:TEMP\vs_buildtools.exe" -ArgumentList "--installPath C:\Program Files\Microsoft Build Tools" --quiet --wait --norestart --nocache --includeRecommended --add Microsoft.VisualStudio.Workload.VCTools" -Wait```

   4. Add Build Tools to your PATH.

      ```[Environment]::SetEnvironmentVariable("PATH", "$(Join-Path (Get-ChildItem 'C:\Program Files\Microsoft Build Tools\VC\Tools\MSVC' -Directory | Sort-Object Name -Descending | Select-Object -First 1).FullName 'bin\Hostx64\x64');$env:PATH", [EnvironmentVariableTarget]::Machine)```

   5. Verify your Installation.

      ```Get-Command nmake.exe```

      You should see a list of Applications, likely only containing 'nmake.exe'.

      If you get an error, try the command in a new PowerShell window.


- **PortAudio**:
   On Windows, PortAudio comes with our Python libraries below.

- **FluidSynth**:
   1. Open a new PowerShell window.
   2. Install the latest FluidSynth.

      ```Invoke-Expression "choco install fluidsynth -y"```

- **ffmpeg**:
   1. Open a new PowerShell window.
   2. Install the latest FFmpeg.

      ```Invoke-Expression "choco install ffmpeg -y"```

#### Mac
- **All Libraries**:
   1. Open Terminal.
   2. Install PortAudio, FluidSynth, and ffmpeg.

      ```brew install portaudio fluidsynth ffmpeg```

---

### 3. Install CreativePython

#### Any OS
1. Open Command Prompt/Terminal.

   ```pip install CreativePython```

   ```cp-setup```

2. When prompted, download the default soundfont (It's FluidR3 GM2-2, by the way).  If you choose not to download the soundfont, you will need to provide your own.

3. Verify your installation.

   ```cp-test```

   You should hear a single MIDI note played at C4.  If so, you're all set!