# Import Existing VPC

This example demonstrates how to dynamically detect and importing
existing external resources when the external name of that resource
is a name generated by the external backend.

function-pythonic is deployed using `--pip-install` command line
option to install the AWS python client and must be configured
with the needed AWS permissions.

Here is an example of a DeploymentRuntimeConfig that uses the
`function-pythonic` ServiceAccount name which is configured
with needed EKS Pod Identity AWS permissions:
```yaml
apiVersion: pkg.crossplane.io/v1beta1
kind: DeploymentRuntimeConfig
metadata:
  name: function-pythonic
spec:
  deploymentTemplate:
    spec:
      template:
        spec:
          containers:
          - name: package-runtime
            args:
            - --debug
            - --pip-install
            - --quiet aiobotocore==2.23.2
          serviceAccountName: function-pythonic
```
To run the `render.sh` script, ensure that aiobotocore is installed
in the python environment used. The default AWS profile will be used
unless the AWS_PROFILE environment variable is set, or other
appropriate AWS environment variables.
