# generated by datamodel-codegen:
#   filename:  <stdin>
#   timestamp: 2024-10-04T21:01:52+00:00

from __future__ import annotations

from enum import Enum
from typing import Dict, List, Optional

from pydantic import AwareDatetime, BaseModel, Field

from ....k8s.apimachinery.pkg.apis.meta import v1


class DeletionPolicy(Enum):
    Orphan = 'Orphan'
    Delete = 'Delete'


class ForProvider(BaseModel):
    forceDestroy: Optional[bool] = None
    """
    Boolean that indicates all objects (including any locked objects) should be deleted from the bucket when the bucket is destroyed so that the bucket can be destroyed without error. These objects are not recoverable. This only deletes objects when the bucket is destroyed, not when setting this parameter to true. If setting this field in the same operation that would require replacing the bucket or destroying the bucket, this flag will not work.
    """
    objectLockEnabled: Optional[bool] = None
    """
    Indicates whether this bucket has an Object Lock configuration enabled. Valid values are true or false. This argument is not supported in all regions or partitions.
    """
    region: str
    """
    AWS region this bucket resides in.
    Region is the region you'd like your resource to be created in.
    """
    tags: Optional[Dict[str, str]] = None
    """
    Key-value map of resource tags.
    """


class InitProvider(BaseModel):
    forceDestroy: Optional[bool] = None
    """
    Boolean that indicates all objects (including any locked objects) should be deleted from the bucket when the bucket is destroyed so that the bucket can be destroyed without error. These objects are not recoverable. This only deletes objects when the bucket is destroyed, not when setting this parameter to true. If setting this field in the same operation that would require replacing the bucket or destroying the bucket, this flag will not work.
    """
    objectLockEnabled: Optional[bool] = None
    """
    Indicates whether this bucket has an Object Lock configuration enabled. Valid values are true or false. This argument is not supported in all regions or partitions.
    """
    tags: Optional[Dict[str, str]] = None
    """
    Key-value map of resource tags.
    """


class ManagementPolicy(Enum):
    Observe = 'Observe'
    Create = 'Create'
    Update = 'Update'
    Delete = 'Delete'
    LateInitialize = 'LateInitialize'
    field_ = '*'


class Resolution(Enum):
    Required = 'Required'
    Optional = 'Optional'


class Resolve(Enum):
    Always = 'Always'
    IfNotPresent = 'IfNotPresent'


class Policy(BaseModel):
    resolution: Optional[Resolution] = 'Required'
    """
    Resolution specifies whether resolution of this reference is required.
    The default is 'Required', which means the reconcile will fail if the
    reference cannot be resolved. 'Optional' means this reference will be
    a no-op if it cannot be resolved.
    """
    resolve: Optional[Resolve] = None
    """
    Resolve specifies when this reference should be resolved. The default
    is 'IfNotPresent', which will attempt to resolve the reference only when
    the corresponding field is not present. Use 'Always' to resolve the
    reference on every reconcile.
    """


class ProviderConfigRef(BaseModel):
    name: str
    """
    Name of the referenced object.
    """
    policy: Optional[Policy] = None
    """
    Policies for referencing.
    """


class ConfigRef(BaseModel):
    name: str
    """
    Name of the referenced object.
    """
    policy: Optional[Policy] = None
    """
    Policies for referencing.
    """


class Metadata(BaseModel):
    annotations: Optional[Dict[str, str]] = None
    """
    Annotations are the annotations to be added to connection secret.
    - For Kubernetes secrets, this will be used as "metadata.annotations".
    - It is up to Secret Store implementation for others store types.
    """
    labels: Optional[Dict[str, str]] = None
    """
    Labels are the labels/tags to be added to connection secret.
    - For Kubernetes secrets, this will be used as "metadata.labels".
    - It is up to Secret Store implementation for others store types.
    """
    type: Optional[str] = None
    """
    Type is the SecretType for the connection secret.
    - Only valid for Kubernetes Secret Stores.
    """


class PublishConnectionDetailsTo(BaseModel):
    configRef: Optional[ConfigRef] = Field(
        default_factory=lambda: ConfigRef.model_validate({'name': 'default'})
    )
    """
    SecretStoreConfigRef specifies which secret store config should be used
    for this ConnectionSecret.
    """
    metadata: Optional[Metadata] = None
    """
    Metadata is the metadata for connection secret.
    """
    name: str
    """
    Name is the name of the connection secret.
    """


class WriteConnectionSecretToRef(BaseModel):
    name: str
    """
    Name of the secret.
    """
    namespace: str
    """
    Namespace of the secret.
    """


class Spec(BaseModel):
    deletionPolicy: Optional[DeletionPolicy] = 'Delete'
    """
    DeletionPolicy specifies what will happen to the underlying external
    when this managed resource is deleted - either "Delete" or "Orphan" the
    external resource.
    This field is planned to be deprecated in favor of the ManagementPolicies
    field in a future release. Currently, both could be set independently and
    non-default values would be honored if the feature flag is enabled.
    See the design doc for more information: https://github.com/crossplane/crossplane/blob/499895a25d1a1a0ba1604944ef98ac7a1a71f197/design/design-doc-observe-only-resources.md?plain=1#L223
    """
    forProvider: ForProvider
    initProvider: Optional[InitProvider] = None
    """
    THIS IS A BETA FIELD. It will be honored
    unless the Management Policies feature flag is disabled.
    InitProvider holds the same fields as ForProvider, with the exception
    of Identifier and other resource reference fields. The fields that are
    in InitProvider are merged into ForProvider when the resource is created.
    The same fields are also added to the terraform ignore_changes hook, to
    avoid updating them after creation. This is useful for fields that are
    required on creation, but we do not desire to update them after creation,
    for example because of an external controller is managing them, like an
    autoscaler.
    """
    managementPolicies: Optional[List[ManagementPolicy]] = ['*']
    """
    THIS IS A BETA FIELD. It is on by default but can be opted out
    through a Crossplane feature flag.
    ManagementPolicies specify the array of actions Crossplane is allowed to
    take on the managed and external resources.
    This field is planned to replace the DeletionPolicy field in a future
    release. Currently, both could be set independently and non-default
    values would be honored if the feature flag is enabled. If both are
    custom, the DeletionPolicy field will be ignored.
    See the design doc for more information: https://github.com/crossplane/crossplane/blob/499895a25d1a1a0ba1604944ef98ac7a1a71f197/design/design-doc-observe-only-resources.md?plain=1#L223
    and this one: https://github.com/crossplane/crossplane/blob/444267e84783136daa93568b364a5f01228cacbe/design/one-pager-ignore-changes.md
    """
    providerConfigRef: Optional[ProviderConfigRef] = Field(
        default_factory=lambda: ProviderConfigRef.model_validate({'name': 'default'})
    )
    """
    ProviderConfigReference specifies how the provider that will be used to
    create, observe, update, and delete this managed resource should be
    configured.
    """
    publishConnectionDetailsTo: Optional[PublishConnectionDetailsTo] = None
    """
    PublishConnectionDetailsTo specifies the connection secret config which
    contains a name, metadata and a reference to secret store config to
    which any connection details for this managed resource should be written.
    Connection details frequently include the endpoint, username,
    and password required to connect to the managed resource.
    """
    writeConnectionSecretToRef: Optional[WriteConnectionSecretToRef] = None
    """
    WriteConnectionSecretToReference specifies the namespace and name of a
    Secret to which any connection details for this managed resource should
    be written. Connection details frequently include the endpoint, username,
    and password required to connect to the managed resource.
    This field is planned to be replaced in a future release in favor of
    PublishConnectionDetailsTo. Currently, both could be set independently
    and connection details would be published to both without affecting
    each other.
    """


class CorsRuleItem(BaseModel):
    allowedHeaders: Optional[List[str]] = None
    """
    List of headers allowed.
    """
    allowedMethods: Optional[List[str]] = None
    """
    One or more HTTP methods that you allow the origin to execute. Can be GET, PUT, POST, DELETE or HEAD.
    """
    allowedOrigins: Optional[List[str]] = None
    """
    One or more origins you want customers to be able to access the bucket from.
    """
    exposeHeaders: Optional[List[str]] = None
    """
    One or more headers in the response that you want customers to be able to access from their applications (for example, from a JavaScript XMLHttpRequest object).
    """
    maxAgeSeconds: Optional[float] = None
    """
    Specifies time in seconds that browser can cache the response for a preflight request.
    """


class GrantItem(BaseModel):
    id: Optional[str] = None
    """
    Canonical user id to grant for. Used only when type is CanonicalUser.
    """
    permissions: Optional[List[str]] = None
    """
    List of permissions to apply for grantee. Valid values are READ, WRITE, READ_ACP, WRITE_ACP, FULL_CONTROL.
    """
    type: Optional[str] = None
    """
    Type of grantee to apply for. Valid values are CanonicalUser and Group. AmazonCustomerByEmail is not supported.
    """
    uri: Optional[str] = None
    """
    Uri address to grant for. Used only when type is Group.
    """


class Expiration(BaseModel):
    date: Optional[str] = None
    """
    Specifies the date after which you want the corresponding action to take effect.
    """
    days: Optional[float] = None
    """
    Specifies the number of days after object creation when the specific rule action takes effect.
    """
    expiredObjectDeleteMarker: Optional[bool] = None
    """
    On a versioned bucket (versioning-enabled or versioning-suspended bucket), you can add this element in the lifecycle configuration to direct Amazon S3 to delete expired object delete markers. This cannot be specified with Days or Date in a Lifecycle Expiration Policy.
    """


class NoncurrentVersionExpiration(BaseModel):
    days: Optional[float] = None
    """
    Specifies the number of days after object creation when the specific rule action takes effect.
    """


class NoncurrentVersionTransitionItem(BaseModel):
    days: Optional[float] = None
    """
    Specifies the number of days after object creation when the specific rule action takes effect.
    """
    storageClass: Optional[str] = None
    """
    Specifies the Amazon S3 storage class to which you want the object to transition.
    """


class TransitionItem(BaseModel):
    date: Optional[str] = None
    """
    Specifies the date after which you want the corresponding action to take effect.
    """
    days: Optional[float] = None
    """
    Specifies the number of days after object creation when the specific rule action takes effect.
    """
    storageClass: Optional[str] = None
    """
    Specifies the Amazon S3 storage class to which you want the object to transition.
    """


class LifecycleRuleItem(BaseModel):
    abortIncompleteMultipartUploadDays: Optional[float] = None
    """
    Specifies the number of days after initiating a multipart upload when the multipart upload must be completed.
    """
    enabled: Optional[bool] = None
    """
    Specifies lifecycle rule status.
    """
    expiration: Optional[Expiration] = None
    """
    Specifies a period in the object's expire. See Expiration below for details.
    """
    id: Optional[str] = None
    """
    Unique identifier for the rule. Must be less than or equal to 255 characters in length.
    """
    noncurrentVersionExpiration: Optional[NoncurrentVersionExpiration] = None
    """
    Specifies when noncurrent object versions expire. See Noncurrent Version Expiration below for details.
    """
    noncurrentVersionTransition: Optional[List[NoncurrentVersionTransitionItem]] = None
    """
    Specifies when noncurrent object versions transitions. See Noncurrent Version Transition below for details.
    """
    prefix: Optional[str] = None
    """
    Object key prefix identifying one or more objects to which the rule applies.
    """
    tags: Optional[Dict[str, str]] = None
    """
    Specifies object tags key and value.
    """
    transition: Optional[List[TransitionItem]] = None
    """
    Specifies a period in the object's transitions. See Transition below for details.
    """


class Logging(BaseModel):
    targetBucket: Optional[str] = None
    """
    Name of the bucket that will receive the log objects.
    """
    targetPrefix: Optional[str] = None
    """
    To specify a key prefix for log objects.
    """


class DefaultRetention(BaseModel):
    days: Optional[float] = None
    """
    Number of days that you want to specify for the default retention period.
    """
    mode: Optional[str] = None
    """
    Default Object Lock retention mode you want to apply to new objects placed in this bucket. Valid values are GOVERNANCE and COMPLIANCE.
    """
    years: Optional[float] = None
    """
    Number of years that you want to specify for the default retention period.
    """


class Rule(BaseModel):
    defaultRetention: Optional[DefaultRetention] = None
    """
    Default retention period that you want to apply to new objects placed in this bucket (documented below).
    """


class ObjectLockConfiguration(BaseModel):
    objectLockEnabled: Optional[str] = None
    """
    Indicates whether this bucket has an Object Lock configuration enabled. Valid value is Enabled. Use the top-level argument object_lock_enabled instead.
    """
    rule: Optional[Rule] = None
    """
    Object Lock rule in place for this bucket (documented below).
    """


class AccessControlTranslation(BaseModel):
    owner: Optional[str] = None
    """
    Specifies the replica ownership. For default and valid values, see PUT bucket replication in the Amazon S3 API Reference. The only valid value is Destination.
    """


class Metrics(BaseModel):
    minutes: Optional[float] = None
    """
    Threshold within which objects are to be replicated. The only valid value is 15.
    """
    status: Optional[str] = None
    """
    Status of RTC. Either Enabled or Disabled.
    """


class ReplicationTime(BaseModel):
    minutes: Optional[float] = None
    """
    Threshold within which objects are to be replicated. The only valid value is 15.
    """
    status: Optional[str] = None
    """
    Status of RTC. Either Enabled or Disabled.
    """


class Destination(BaseModel):
    accessControlTranslation: Optional[AccessControlTranslation] = None
    """
    Specifies the overrides to use for object owners on replication (documented below). Must be used in conjunction with account_id owner override configuration.
    """
    accountId: Optional[str] = None
    """
    Account ID to use for overriding the object owner on replication. Must be used in conjunction with access_control_translation override configuration.
    """
    bucket: Optional[str] = None
    """
    ARN of the S3 bucket where you want Amazon S3 to store replicas of the object identified by the rule.
    """
    metrics: Optional[Metrics] = None
    """
    Enables replication metrics  (documented below).
    """
    replicaKmsKeyId: Optional[str] = None
    """
    Destination KMS encryption key ARN for SSE-KMS replication. Must be used in conjunction with
    sse_kms_encrypted_objects source selection criteria.
    """
    replicationTime: Optional[ReplicationTime] = None
    """
    Enables S3 Replication Time Control (S3 RTC) (documented below).
    """
    storageClass: Optional[str] = None
    """
    Specifies the Amazon S3 storage class to which you want the object to transition.
    """


class Filter(BaseModel):
    prefix: Optional[str] = None
    """
    Object keyname prefix that identifies subset of objects to which the rule applies. Must be less than or equal to 1024 characters in length.
    """
    tags: Optional[Dict[str, str]] = None
    """
    A map of tags that identifies subset of objects to which the rule applies.
    The rule applies only to objects having all the tags in its tagset.
    """


class SseKmsEncryptedObjects(BaseModel):
    enabled: Optional[bool] = None
    """
    Enable versioning. Once you version-enable a bucket, it can never return to an unversioned state. You can, however, suspend versioning on that bucket.
    """


class SourceSelectionCriteria(BaseModel):
    sseKmsEncryptedObjects: Optional[SseKmsEncryptedObjects] = None
    """
    Match SSE-KMS encrypted objects (documented below). If specified, replica_kms_key_id
    in destination must be specified as well.
    """


class RuleModel(BaseModel):
    deleteMarkerReplicationStatus: Optional[str] = None
    """
    Whether delete markers are replicated. The only valid value is Enabled. To disable, omit this argument. This argument is only valid with V2 replication configurations (i.e., when filter is used).
    """
    destination: Optional[Destination] = None
    """
    Specifies the destination for the rule (documented below).
    """
    filter: Optional[Filter] = None
    """
    Filter that identifies subset of objects to which the replication rule applies (documented below).
    """
    id: Optional[str] = None
    """
    Unique identifier for the rule. Must be less than or equal to 255 characters in length.
    """
    prefix: Optional[str] = None
    """
    Object keyname prefix identifying one or more objects to which the rule applies. Must be less than or equal to 1024 characters in length.
    """
    priority: Optional[float] = None
    """
    Priority associated with the rule. Priority should only be set if filter is configured. If not provided, defaults to 0. Priority must be unique between multiple rules.
    """
    sourceSelectionCriteria: Optional[SourceSelectionCriteria] = None
    """
    Specifies special object selection criteria (documented below).
    """
    status: Optional[str] = None
    """
    Status of the rule. Either Enabled or Disabled. The rule is ignored if status is not Enabled.
    """


class ReplicationConfiguration(BaseModel):
    role: Optional[str] = None
    """
    ARN of the IAM role for Amazon S3 to assume when replicating the objects.
    """
    rules: Optional[List[RuleModel]] = None
    """
    Specifies the rules managing the replication (documented below).
    """


class ApplyServerSideEncryptionByDefault(BaseModel):
    kmsMasterKeyId: Optional[str] = None
    """
    AWS KMS master key ID used for the SSE-KMS encryption. This can only be used when you set the value of sse_algorithm as aws:kms. The default aws/s3 AWS KMS master key is used if this element is absent while the sse_algorithm is aws:kms.
    """
    sseAlgorithm: Optional[str] = None
    """
    Server-side encryption algorithm to use. Valid values are AES256 and aws:kms
    """


class RuleModel1(BaseModel):
    applyServerSideEncryptionByDefault: Optional[ApplyServerSideEncryptionByDefault] = (
        None
    )
    """
    Single object for setting server-side encryption by default. (documented below)
    """
    bucketKeyEnabled: Optional[bool] = None
    """
    Whether or not to use Amazon S3 Bucket Keys for SSE-KMS.
    """


class ServerSideEncryptionConfiguration(BaseModel):
    rule: Optional[RuleModel1] = None
    """
    Single object for server-side encryption by default configuration. (documented below)
    """


class Versioning(BaseModel):
    enabled: Optional[bool] = None
    """
    Enable versioning. Once you version-enable a bucket, it can never return to an unversioned state. You can, however, suspend versioning on that bucket.
    """
    mfaDelete: Optional[bool] = None
    """
    Enable MFA delete for either Change the versioning state of your bucket or Permanently delete an object version. Default is false. This cannot be used to toggle this setting but is available to allow managed buckets to reflect the state in AWS
    """


class Website(BaseModel):
    errorDocument: Optional[str] = None
    """
    Absolute path to the document to return in case of a 4XX error.
    """
    indexDocument: Optional[str] = None
    """
    Amazon S3 returns this index document when requests are made to the root domain or any of the subfolders.
    """
    redirectAllRequestsTo: Optional[str] = None
    """
    Hostname to redirect all website requests for this bucket to. Hostname can optionally be prefixed with a protocol (http:// or https://) to use when redirecting requests. The default is the protocol that is used in the original request.
    """
    routingRules: Optional[str] = None
    """
    JSON array containing routing rules
    describing redirect behavior and when redirects are applied.
    """


class AtProvider(BaseModel):
    accelerationStatus: Optional[str] = None
    """
    Sets the accelerate configuration of an existing bucket. Can be Enabled or Suspended. Cannot be used in cn-north-1 or us-gov-west-1.
    Use the resource aws_s3_bucket_accelerate_configuration instead.
    """
    acl: Optional[str] = None
    """
    The canned ACL to apply. Valid values are private, public-read, public-read-write, aws-exec-read, authenticated-read, and log-delivery-write. Defaults to private.  Conflicts with grant. Use the resource aws_s3_bucket_acl instead.
    """
    arn: Optional[str] = None
    """
    ARN of the bucket. Will be of format arn:aws:s3:::bucketname.
    """
    bucketDomainName: Optional[str] = None
    """
    Bucket domain name. Will be of format bucketname.s3.amazonaws.com.
    """
    bucketRegionalDomainName: Optional[str] = None
    """
    The bucket region-specific domain name. The bucket domain name including the region name. Please refer to the S3 endpoints reference for format. Note: AWS CloudFront allows specifying an S3 region-specific endpoint when creating an S3 origin. This will prevent redirect issues from CloudFront to the S3 Origin URL. For more information, see the Virtual Hosted-Style Requests for Other Regions section in the AWS S3 User Guide.
    """
    corsRule: Optional[List[CorsRuleItem]] = None
    """
    Rule of Cross-Origin Resource Sharing. See CORS rule below for details. Use the resource aws_s3_bucket_cors_configuration instead.
    """
    forceDestroy: Optional[bool] = None
    """
    Boolean that indicates all objects (including any locked objects) should be deleted from the bucket when the bucket is destroyed so that the bucket can be destroyed without error. These objects are not recoverable. This only deletes objects when the bucket is destroyed, not when setting this parameter to true. If setting this field in the same operation that would require replacing the bucket or destroying the bucket, this flag will not work.
    """
    grant: Optional[List[GrantItem]] = None
    """
    An ACL policy grant. See Grant below for details. Conflicts with acl. Use the resource aws_s3_bucket_acl instead.
    """
    hostedZoneId: Optional[str] = None
    """
    Route 53 Hosted Zone ID for this bucket's region.
    """
    id: Optional[str] = None
    """
    Name of the bucket.
    """
    lifecycleRule: Optional[List[LifecycleRuleItem]] = None
    """
    Configuration of object lifecycle management. See Lifecycle Rule below for details.
    Use the resource aws_s3_bucket_lifecycle_configuration instead.
    """
    logging: Optional[Logging] = None
    """
    Configuration of S3 bucket logging parameters. See Logging below for details.
    Use the resource aws_s3_bucket_logging instead.
    """
    objectLockConfiguration: Optional[ObjectLockConfiguration] = None
    """
    Configuration of S3 object locking. See Object Lock Configuration below for details.
    Use the object_lock_enabled parameter and the resource aws_s3_bucket_object_lock_configuration instead.
    """
    objectLockEnabled: Optional[bool] = None
    """
    Indicates whether this bucket has an Object Lock configuration enabled. Valid values are true or false. This argument is not supported in all regions or partitions.
    """
    policy: Optional[str] = None
    """
    Valid bucket policy JSON document. In this case, please make sure you use the verbose/specific version of the policy.
    Use the resource aws_s3_bucket_policy instead.
    """
    region: Optional[str] = None
    """
    AWS region this bucket resides in.
    Region is the region you'd like your resource to be created in.
    """
    replicationConfiguration: Optional[ReplicationConfiguration] = None
    """
    Configuration of replication configuration. See Replication Configuration below for details.
    Use the resource aws_s3_bucket_replication_configuration instead.
    """
    requestPayer: Optional[str] = None
    """
    Specifies who should bear the cost of Amazon S3 data transfer.
    Can be either BucketOwner or Requester. By default, the owner of the S3 bucket would incur the costs of any data transfer.
    See Requester Pays Buckets developer guide for more information.
    Use the resource aws_s3_bucket_request_payment_configuration instead.
    """
    serverSideEncryptionConfiguration: Optional[ServerSideEncryptionConfiguration] = (
        None
    )
    """
    Configuration of server-side encryption configuration. See Server Side Encryption Configuration below for details.
    Use the resource aws_s3_bucket_server_side_encryption_configuration instead.
    """
    tags: Optional[Dict[str, str]] = None
    """
    Key-value map of resource tags.
    """
    tagsAll: Optional[Dict[str, str]] = None
    """
    Map of tags assigned to the resource, including those inherited from the provider default_tags configuration block.
    """
    versioning: Optional[Versioning] = None
    """
    Configuration of the S3 bucket versioning state. See Versioning below for details. Use the resource aws_s3_bucket_versioning instead.
    """
    website: Optional[Website] = None
    """
    Configuration of the S3 bucket website. See Website below for details.
    Use the resource aws_s3_bucket_website_configuration instead.
    """
    websiteDomain: Optional[str] = None
    """
    (Deprecated) Domain of the website endpoint, if the bucket is configured with a website. If not, this will be an empty string. This is used to create Route 53 alias records. Use the resource aws_s3_bucket_website_configuration instead.
    """
    websiteEndpoint: Optional[str] = None
    """
    (Deprecated) Website endpoint, if the bucket is configured with a website. If not, this will be an empty string. Use the resource aws_s3_bucket_website_configuration instead.
    """


class Condition(BaseModel):
    lastTransitionTime: AwareDatetime
    """
    LastTransitionTime is the last time this condition transitioned from one
    status to another.
    """
    message: Optional[str] = None
    """
    A Message containing details about this condition's last transition from
    one status to another, if any.
    """
    observedGeneration: Optional[int] = None
    """
    ObservedGeneration represents the .metadata.generation that the condition was set based upon.
    For instance, if .metadata.generation is currently 12, but the .status.conditions[x].observedGeneration is 9, the condition is out of date
    with respect to the current state of the instance.
    """
    reason: str
    """
    A Reason for this condition's last transition from one status to another.
    """
    status: str
    """
    Status of this condition; is it currently True, False, or Unknown?
    """
    type: str
    """
    Type of this condition. At most one of each condition type may apply to
    a resource at any point in time.
    """


class Status(BaseModel):
    atProvider: Optional[AtProvider] = None
    conditions: Optional[List[Condition]] = None
    """
    Conditions of the resource.
    """
    observedGeneration: Optional[int] = None
    """
    ObservedGeneration is the latest metadata.generation
    which resulted in either a ready state, or stalled due to error
    it can not recover from without human intervention.
    """


class Bucket(BaseModel):
    apiVersion: Optional[str] = 's3.aws.upbound.io/v1beta2'
    """
    APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
    """
    kind: Optional[str] = 'Bucket'
    """
    Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    metadata: Optional[v1.ObjectMeta] = None
    """
    Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    spec: Spec
    """
    BucketSpec defines the desired state of Bucket
    """
    status: Optional[Status] = None
    """
    BucketStatus defines the observed state of Bucket.
    """


class BucketList(BaseModel):
    apiVersion: Optional[str] = None
    """
    APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
    """
    items: List[Bucket]
    """
    List of buckets. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md
    """
    kind: Optional[str] = None
    """
    Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    metadata: Optional[v1.ListMeta] = None
    """
    Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
