from typing import Any, Dict, List, Type, TypeVar, Union

import attr

from ..types import UNSET, Unset

T = TypeVar("T", bound="Postv3AccountsJsonBody")


@attr.s(auto_attribs=True)
class Postv3AccountsJsonBody:
    """
    Attributes:
        first_name (Union[Unset, str]): First name of the user.
        last_name (Union[Unset, str]): Last name of the user.
        email (Union[Unset, str]): Email address of the user.
        password (Union[Unset, str]): Password of the user.
        company (Union[Unset, str]): Name of the company.
        company_id (Union[Unset, str]): Unique company identifier.
    """

    first_name: Union[Unset, str] = UNSET
    last_name: Union[Unset, str] = UNSET
    email: Union[Unset, str] = UNSET
    password: Union[Unset, str] = UNSET
    company: Union[Unset, str] = UNSET
    company_id: Union[Unset, str] = UNSET
    additional_properties: Dict[str, Any] = attr.ib(init=False, factory=dict)

    def to_dict(self) -> Dict[str, Any]:
        first_name = self.first_name
        last_name = self.last_name
        email = self.email
        password = self.password
        company = self.company
        company_id = self.company_id

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if first_name is not UNSET:
            field_dict["firstName"] = first_name
        if last_name is not UNSET:
            field_dict["lastName"] = last_name
        if email is not UNSET:
            field_dict["email"] = email
        if password is not UNSET:
            field_dict["password"] = password
        if company is not UNSET:
            field_dict["company"] = company
        if company_id is not UNSET:
            field_dict["companyId"] = company_id

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        d = src_dict.copy()
        first_name = d.pop("firstName", UNSET)

        last_name = d.pop("lastName", UNSET)

        email = d.pop("email", UNSET)

        password = d.pop("password", UNSET)

        company = d.pop("company", UNSET)

        company_id = d.pop("companyId", UNSET)

        postv_3_accounts_json_body = cls(
            first_name=first_name,
            last_name=last_name,
            email=email,
            password=password,
            company=company,
            company_id=company_id,
        )

        postv_3_accounts_json_body.additional_properties = d
        return postv_3_accounts_json_body

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
