# generated by datamodel-codegen:
#   filename:  json_schemas.json
#   timestamp: 2026-01-02T15:53:06+00:00

from __future__ import annotations

from enum import IntEnum, IntFlag
from typing import Annotated, Any, TypeAlias

from msgspec import UNSET, Meta, Struct, UnsetType

AllTypeSchemas: TypeAlias = Annotated[
    Any,
    Meta(description='Schemas for privid_fhe data types.', title='All Type Schemas'),
]
# Define the constrained base type
NonNegativeInt = Annotated[int, Meta(ge=0)]

class AgeData(Struct):
    age_confidence_score: float
    estimated_age: float


class BarCodeData(Struct):
    type: str
    format: str
    text: str
    first_name: str
    last_name: str
    middle_name: str
    expiration_date: str
    issue_date: str
    date_of_birth: str
    gender: str
    eye_color: str
    hair_color: str
    height: str
    street_address1: str
    street_address2: str
    res_street_address1: str
    res_street_address2: str
    city: str
    state: str
    postal_code: str
    customer_id: str
    document_id: str
    issuing_country: str
    middle_name_truncation: str
    first_name_truncation: str
    last_name_truncation: str
    place_of_birth: str
    audit_information: str
    inventory_control_number: str
    last_name_alias: str
    first_name_alias: str
    suffix_alias: str
    name_suffix: str
    barcode_key: str
    barcode_key_encoding: str
    barcode_hash64: str
    barcode_hash128: str
    document_type: str


class BarCodeDetectionStatus(IntEnum):
    BS_NO_VALID_BARCODE_FOUND = -1
    BS_SUCCESS = 0
    BS_UNSUPPORTED_BARCODE_DETECTED = 3
    BS_UNABLE_TO_PARSE_BARCODE = 4


class ReturnStatus(IntEnum):
    API_MAL_FORMED_AP_RESPONSE = -7
    API_NETWORK_ERROR = -6
    API_INVALID_ARGUMENT = -5
    API_INVALID_CONFIGURATION = -4
    API_AUTHORIZATION_ERROR = -3
    API_INVALID_SESSION_HANDLER = -2
    API_GENERIC_ERROR = -1
    API_NO_ERROR = 0


class CallResultHeader(Struct):
    return_status: Annotated[
        ReturnStatus, Meta(description='Enum value serialized as integer')
    ]
    operation_id: int
    operation_type_id: Annotated[int, Meta(ge=0)]
    return_message: str | None | UnsetType = UNSET
    mf_token: str | None | UnsetType = UNSET
    operation_tag: str | None | UnsetType = UNSET


class Collection(Struct):
    named_urls: dict[str, str]
    embedding_model_id: NonNegativeInt | UnsetType = UNSET


class CompareResult(Struct):
    face_detected_a: bool
    face_detected_b: bool
    similarity_score: float
    is_match: bool
    confidence: float
    distance_max: float
    distance_mean: float
    distance_min: float
    face_thresholds: list[float]


class DocumentTraits(IntFlag):
    DT_DOC_NO_TRAIT = 0
    DT_DOCUMENT_WITH_LOW_CONFIDENCE_SCORE = 1
    DT_DOCUMENT_IS_BLURRY = 2
    DT_DOCUMENT_IS_CLOSE = 4
    DT_DOCUMENT_IS_FAR = 8
    DT_DOCUMENT_IS_LEFT = 16
    DT_DOCUMENT_IS_RIGHT = 32
    DT_DOCUMENT_IS_UP = 64
    DT_DOCUMENT_IS_DOWN = 128
    DT_FINGERS_DETECTED = 256


class DocumentOcrAgeData(Struct):
    dob: str
    age: int


class EnrollResponse(Struct):
    status: int
    enroll_level: int | None | UnsetType = UNSET
    guid: str | None | UnsetType = UNSET
    puid: str | None | UnsetType = UNSET
    message: str | None | UnsetType = UNSET
    score: float | None | UnsetType = UNSET


class FaceId(Struct):
    puid: str
    guid: str


class FaceMetric(Struct):
    name: str
    value: float


class FaceTraitsFlags(IntFlag):
    FT_FACE_NO_TRAIT = 0
    FT_FACE_TOO_CLOSE = 1
    FT_FACE_TOO_FAR = 2
    FT_FACE_RIGHT = 4
    FT_FACE_LEFT = 8
    FT_FACE_UP = 16
    FT_FACE_DOWN = 32
    FT_IMAGE_BLURR = 64
    FT_FACE_WITH_GLASS = 128
    FT_FACE_WITH_MASK = 256
    FT_LOOKING_LEFT = 512
    FT_LOOKING_RIGHT = 1024
    FT_LOOKING_HIGH = 2048
    FT_LOOKING_DOWN = 4096
    FT_FACE_TOO_DARK = 8192
    FT_FACE_TOO_BRIGHT = 16384
    FT_FACE_LOW_VAL_CONF = 32768
    FT_INVALID_FACE_BACKGROUND = 65536
    FT_EYE_BLINK = 131072
    FT_MOUTH_OPENED = 262144
    FT_FACE_ROTATED_RIGHT = 524288
    FT_FACE_ROTATED_LEFT = 1048576
    FT_FACE_NOT_IN_OVAL = 2097152


class SpoofStatus(IntEnum):
    AS_NO_SPOOF_DETECTED = 0
    AS_GENERIC_ERROR = 1
    AS_NOT_PERFORMED = 2
    AS_INVALID_FACE = 3
    AS_SPOOF_DETECTED = 4


class Depth(IntEnum):
    P_CV_8U = 0
    P_CV_8S = 1
    P_CV_16U = 2
    P_CV_16S = 3
    P_CV_32S = 4
    P_CV_32F = 5
    P_CV_64F = 6
    P_CV_16F = 7


class Color(IntEnum):
    P_MONO = 0
    P_BGR = 1
    P_RGB = 2
    P_BGRA = 3
    P_RGBA = 4


class ImageInfo(Struct):
    width: Annotated[int, Meta(ge=0)]
    height: Annotated[int, Meta(ge=0)]
    channels: Annotated[int, Meta(ge=0)]
    depth: Annotated[Depth, Meta(description='Enum value serialized as integer')]
    color: Annotated[Color, Meta(description='Enum value serialized as integer')]


class NamedUrl(Struct):
    name: str
    url: str


class BaseLandmarksModelId(IntEnum):
    HEAD_POSE = 0
    YOLOV5_XN5_V2_1 = 22


class FaceDetectionStrategy(IntEnum):
    FDS_MULTIPLE_FACES = 0
    FDS_BEST_CONFIDENCE_SCORE_FACE = 1
    FDS_BIGGEST_FACE = 2
    FDS_SINGLE_FACE_HYBRID = 3


class AntiSpoofingMode(IntEnum):
    ASM_OFF = 0
    ASM_XMS = 1
    ASM_JPD = 2
    ASM_RECOGNITO_AND = 3


class OperationConfig(Struct):
    input_image_format: str | UnsetType = UNSET
    context_string: str | UnsetType = UNSET
    identifier: str | UnsetType = UNSET
    conf_score_thr_barcode: float | UnsetType = UNSET
    conf_score_thr_doc: float | UnsetType = UNSET
    blur_threshold_doc: float | UnsetType = UNSET
    threshold_doc_too_close: float | UnsetType = UNSET
    threshold_doc_too_far: float | UnsetType = UNSET
    threshold_doc_x: float | UnsetType = UNSET
    threshold_doc_y: float | UnsetType = UNSET
    landmark_confidence_score_threshold: float | UnsetType = UNSET
    conf_score_thr_enroll: float | UnsetType = UNSET
    conf_score_thr_predict: float | UnsetType = UNSET
    blur_threshold_enroll_pred: float | UnsetType = UNSET
    threshold_profile_enroll: float | UnsetType = UNSET
    threshold_profile_predict: float | UnsetType = UNSET
    threshold_high_vertical_enroll: float | UnsetType = UNSET
    threshold_high_vertical_predict: float | UnsetType = UNSET
    threshold_down_vertical_enroll: float | UnsetType = UNSET
    threshold_down_vertical_predict: float | UnsetType = UNSET
    eyes_blinking_threshold: float | UnsetType = UNSET
    mouth_opened_threshold: float | UnsetType = UNSET
    threshold_user_right: float | UnsetType = UNSET
    threshold_user_left: float | UnsetType = UNSET
    threshold_user_up: float | UnsetType = UNSET
    threshold_user_down: float | UnsetType = UNSET
    threshold_user_too_far: float | UnsetType = UNSET
    threshold_user_too_close: float | UnsetType = UNSET
    document_scan_barcode_only: bool | UnsetType = UNSET
    document_auto_rotation: bool | UnsetType = UNSET
    send_original_images: bool | UnsetType = UNSET
    anti_spoofing_threshold: float | UnsetType = UNSET
    angle_rotation_left_threshold: float | UnsetType = UNSET
    angle_rotation_right_threshold: float | UnsetType = UNSET
    barcode_margin: float | UnsetType = UNSET
    fingers_over_document_threshold: float | UnsetType = UNSET
    use_age_stddev: bool | UnsetType = UNSET
    anti_spoofing_detect_document: bool | UnsetType = UNSET
    fetch_timeout_ms: int | UnsetType = UNSET
    face_too_bright: float | UnsetType = UNSET
    face_too_dark: float | UnsetType = UNSET
    disable_enroll_mf: bool | UnsetType = UNSET
    disable_predict_mf: bool | UnsetType = UNSET
    disable_validate_mf: bool | UnsetType = UNSET
    disable_estimate_age_mf: bool | UnsetType = UNSET
    encrypt_compare_result: bool | UnsetType = UNSET
    check_fingers_over_document: bool | UnsetType = UNSET
    detect_barcode_without_parsing: bool | UnsetType = UNSET
    use_predict_cache: bool | UnsetType = UNSET
    get_smile_intensity: bool | UnsetType = UNSET
    process_best_image_on_enroll: bool | UnsetType = UNSET
    detect_and_recognize_mrz_code: bool | UnsetType = UNSET
    calculate_age_from_ocr_text: bool | UnsetType = UNSET
    detect_document_only: bool | UnsetType = UNSET
    background_color_rgb: NonNegativeInt | UnsetType = UNSET
    face_thresholds_min: float | UnsetType = UNSET
    face_thresholds_med: float | UnsetType = UNSET
    face_thresholds_max: float | UnsetType = UNSET
    collection_name: str | UnsetType = UNSET
    neighbors: int | UnsetType = UNSET
    doc_validations_off: bool | UnsetType = UNSET
    face_validations_off: bool | UnsetType = UNSET
    validate_face_position_oval: bool | UnsetType = UNSET
    base_landmarks_model_id: (
        Annotated[
            BaseLandmarksModelId, Meta(description='Enum value serialized as integer')
        ]
        | UnsetType
    ) = UNSET
    https_verify_peer_cert: bool | UnsetType = UNSET
    face_detection_strategy: (
        Annotated[
            FaceDetectionStrategy, Meta(description='Enum value serialized as integer')
        ]
        | UnsetType
    ) = UNSET
    anti_spoofing_mode: (
        Annotated[
            AntiSpoofingMode, Meta(description='Enum value serialized as integer')
        ]
        | UnsetType
    ) = UNSET
    allowed_face_traits_flags: FaceTraitsFlags | UnsetType = UNSET


class OvalF(Struct):
    cx: float
    cy: float
    rx: float
    ry: float


class PointF(Struct):
    x: float
    y: float


class PredictUserInformation(Struct):
    guid: str
    puid: str
    score: float
    enroll_level: int | None | UnsetType = UNSET


class SessionSettings(Struct):
    collections: dict[str, Collection]
    session_token: str
    public_key: str | None | UnsetType = UNSET
    request_timeout_ms: NonNegativeInt | UnsetType = UNSET


class TrapezeF(Struct):
    top_left: PointF
    top_right: PointF
    bottom_right: PointF
    bottom_lef: PointF


class UserDeleteResponse(Struct):
    status: int
    uuid_count: NonNegativeInt | UnsetType = UNSET
    message: str | None | UnsetType = UNSET


class AntispoofingHint(Struct):
    face_oval_template: OvalF
    face_oval: OvalF
    is_ok: bool


class BarcodeDetectionResult(Struct):
    confidence_score: float
    barcode_box_center: PointF
    non_cropped_barcode_box: TrapezeF
    cropped_barcode_box: TrapezeF
    bar_code_detection_status: Annotated[
        BarCodeDetectionStatus, Meta(description='Enum value serialized as integer')
    ]
    barcode_data: BarCodeData


class BoxF(Struct):
    top_left: PointF
    bottom_right: PointF


class DocumentData(Struct):
    document_box: TrapezeF
    document_box_center: PointF
    confidence_score: float
    document_traits: Annotated[
        DocumentTraits, Meta(description='Flags type - bitwise OR of enum values')
    ]
    mrz_data: list[str]
    ocr_age_data: DocumentOcrAgeData


class EnrollData(Struct):
    enroll_performed: bool
    message: str
    api_response: EnrollResponse | None | UnsetType = UNSET


class FaceGeometry(Struct):
    bounding_box: BoxF
    eye_left: PointF
    eye_right: PointF
    face_confidence_score: float


class Image(Struct):
    info: ImageInfo


class IsoImageResult(Struct):
    success: bool
    image: Image | None | UnsetType = UNSET


class PredictResponse(Struct):
    status: int
    enroll_level: int | None | UnsetType = UNSET
    guid: str | None | UnsetType = UNSET
    puid: str | None | UnsetType = UNSET
    message: str | None | UnsetType = UNSET
    score: float | None | UnsetType = UNSET
    PI_list: list[PredictUserInformation] | UnsetType = UNSET


class DocumentResult(Struct):
    detected_document: DocumentData
    cropped_document_image_info: Image


class FaceDetectionData(Struct):
    geometry: FaceGeometry


class FaceResult(Struct):
    geometry: FaceGeometry
    face_traits_flags: Annotated[
        FaceTraitsFlags, Meta(description='Flags type - bitwise OR of enum values')
    ]
    spoof_status: Annotated[
        SpoofStatus, Meta(description='Enum value serialized as integer')
    ]
    ids: FaceId | None | UnsetType = UNSET
    scores: list[FaceMetric] | UnsetType = UNSET
    age_data: AgeData | None | UnsetType = UNSET
    cropped_image_info: Image | None | UnsetType = UNSET


class PredictData(Struct):
    predict_performed: bool
    message: str
    api_response: PredictResponse | None | UnsetType = UNSET


class CallResult(Struct):
    call_status: CallResultHeader
    faces: list[FaceResult] | UnsetType = UNSET
    document: DocumentResult | None | UnsetType = UNSET
    barcode: BarcodeDetectionResult | None | UnsetType = UNSET
    compare: CompareResult | None | UnsetType = UNSET
    iso_image: IsoImageResult | None | UnsetType = UNSET
    enroll: EnrollData | None | UnsetType = UNSET
    predict: PredictData | None | UnsetType = UNSET
    user_delete: UserDeleteResponse | None | UnsetType = UNSET
    user_feedback_message: str | None | UnsetType = UNSET
