# SteelCalc

**SteelCalc** is a Python package for structural engineers working with CSA S16:19. It includes a comprehensive set of functions to calculate factored resistances for tension, compression, shear, bending, block shear, seismic design, and more — all in accordance with CSA S16.

This package is designed for use in Jupyter notebooks and web applications, with support for rendered equations via the `handcalcs` and `IPython.display` libraries.

---

## ✨ Features

- Factored resistance calculations (tension, compression, shear, bending, etc.)
- Clause-by-clause support for CSA S16:19
- Seismic design support (including panel zones and probable moment resistance)
- Pretty equation rendering for Jupyter Notebooks
- Compatible with `forallpeople` for dimensional units
- Helper functions for bolt spacing and section class checks

---

## 🛠 Installation

```bash
pip install steelcalc
