"""
CSSRuleList implements DOM Level 2 CSS CSSRuleList.
"""
__all__ = ['CSSRuleList']
__docformat__ = 'restructuredtext'
__author__ = '$LastChangedBy: doerwalter $'
__date__ = '$LastChangedDate: 2007-08-07 11:24:45 +0200 (Di, 07 Aug 2007) $'
__version__ = '0.9.2a1, $LastChangedRevision: 184 $'


class CSSRuleList(list):
    """
    The CSSRuleList interface provides the abstraction of an ordered
    collection of CSS rules.

    The items in the CSSRuleList are accessible via an integral index,
    starting from 0.

    Subclasses a standard Python list so all standard list methods are
    available.

    Properties
    ==========
    length: of type unsigned long, readonly
        The number of CSSRules in the list. The range of valid child rule
        indices is 0 to length-1 inclusive.
    """

    def _getLength(self):
        return len(self)

    length = property(_getLength,
        doc="(DOM) The number of CSSRules in the list.")


    def item(self, index):
        """
        (DOM)
        Used to retrieve a CSS rule by ordinal index. The order in this
        collection represents the order of the rules in the CSS style
        sheet. If index is greater than or equal to the number of rules in
        the list, this returns None.

        Returns CSSRule, the style rule at the index position in the
        CSSRuleList, or None if that is not a valid index.
        """
        try:
            return self[index]
        except IndexError:
            return None

