from .memory import Memory

class MemoryContainer(Memory):
    '''
    This class represents a Memory Container. The Memory Container is responsible
    for implementing an important element in the Dynamic Subsumption mechanism
    used in CST. All the Memory Objects in a Container are of the same type, and
    hold the same parameters. The only differences among them are that they were
    generated by a different codelet, and they might have different evaluations.
    An evaluation is an inner parameter from any Memory Object, which holds a
    value (usually a real value between 0 and 1) that measures a relative
    importance given by the codelet, and which is used by the Evaluation codelet
    within the Container to decide which from all input Memory Objects will be
    sent to the output.
    '''

    def __init__(self) -> None:
        super().__init__()
        raise NotImplementedError()