# coding: utf-8

"""
    ConfigTree API

    ConfigTree API definitions  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ct_python.api_client import ApiClient


class CTApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_application(self, body, organization_slug, **kwargs):  # noqa: E501
        """create_application  # noqa: E501

        Create a new Application  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_application(body, organization_slug, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Application body: (required)
        :param str organization_slug: (required)
        :return: Application
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_application_with_http_info(body, organization_slug, **kwargs)  # noqa: E501
        else:
            (data) = self.create_application_with_http_info(body, organization_slug, **kwargs)  # noqa: E501
            return data

    def create_application_with_http_info(self, body, organization_slug, **kwargs):  # noqa: E501
        """create_application  # noqa: E501

        Create a new Application  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_application_with_http_info(body, organization_slug, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Application body: (required)
        :param str organization_slug: (required)
        :return: Application
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'organization_slug']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_application" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_application`")  # noqa: E501
        # verify the required parameter 'organization_slug' is set
        if ('organization_slug' not in params or
                params['organization_slug'] is None):
            raise ValueError("Missing the required parameter `organization_slug` when calling `create_application`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_slug' in params:
            path_params['organizationSlug'] = params['organization_slug']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Basic']  # noqa: E501

        return self.api_client.call_api(
            '/v1/{organizationSlug}/applications/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Application',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_configuration(self, body, organization_slug, **kwargs):  # noqa: E501
        """create_configuration  # noqa: E501

        Create a new Configuration  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_configuration(body, organization_slug, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Configuration body: (required)
        :param str organization_slug: (required)
        :return: Configuration
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_configuration_with_http_info(body, organization_slug, **kwargs)  # noqa: E501
        else:
            (data) = self.create_configuration_with_http_info(body, organization_slug, **kwargs)  # noqa: E501
            return data

    def create_configuration_with_http_info(self, body, organization_slug, **kwargs):  # noqa: E501
        """create_configuration  # noqa: E501

        Create a new Configuration  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_configuration_with_http_info(body, organization_slug, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Configuration body: (required)
        :param str organization_slug: (required)
        :return: Configuration
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'organization_slug']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_configuration" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_configuration`")  # noqa: E501
        # verify the required parameter 'organization_slug' is set
        if ('organization_slug' not in params or
                params['organization_slug'] is None):
            raise ValueError("Missing the required parameter `organization_slug` when calling `create_configuration`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_slug' in params:
            path_params['organizationSlug'] = params['organization_slug']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Basic']  # noqa: E501

        return self.api_client.call_api(
            '/v1/{organizationSlug}/configurations/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Configuration',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_environment(self, body, organization_slug, **kwargs):  # noqa: E501
        """create_environment  # noqa: E501

        Create a new Environment  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_environment(body, organization_slug, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Environment body: (required)
        :param str organization_slug: (required)
        :return: Environment
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_environment_with_http_info(body, organization_slug, **kwargs)  # noqa: E501
        else:
            (data) = self.create_environment_with_http_info(body, organization_slug, **kwargs)  # noqa: E501
            return data

    def create_environment_with_http_info(self, body, organization_slug, **kwargs):  # noqa: E501
        """create_environment  # noqa: E501

        Create a new Environment  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_environment_with_http_info(body, organization_slug, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Environment body: (required)
        :param str organization_slug: (required)
        :return: Environment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'organization_slug']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_environment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_environment`")  # noqa: E501
        # verify the required parameter 'organization_slug' is set
        if ('organization_slug' not in params or
                params['organization_slug'] is None):
            raise ValueError("Missing the required parameter `organization_slug` when calling `create_environment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_slug' in params:
            path_params['organizationSlug'] = params['organization_slug']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Basic']  # noqa: E501

        return self.api_client.call_api(
            '/v1/{organizationSlug}/environments/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Environment',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_version(self, body, organization_slug, **kwargs):  # noqa: E501
        """create_version  # noqa: E501

        Create a new Version  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_version(body, organization_slug, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Version body: (required)
        :param str organization_slug: (required)
        :return: Version
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_version_with_http_info(body, organization_slug, **kwargs)  # noqa: E501
        else:
            (data) = self.create_version_with_http_info(body, organization_slug, **kwargs)  # noqa: E501
            return data

    def create_version_with_http_info(self, body, organization_slug, **kwargs):  # noqa: E501
        """create_version  # noqa: E501

        Create a new Version  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_version_with_http_info(body, organization_slug, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Version body: (required)
        :param str organization_slug: (required)
        :return: Version
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'organization_slug']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_version" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_version`")  # noqa: E501
        # verify the required parameter 'organization_slug' is set
        if ('organization_slug' not in params or
                params['organization_slug'] is None):
            raise ValueError("Missing the required parameter `organization_slug` when calling `create_version`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_slug' in params:
            path_params['organizationSlug'] = params['organization_slug']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Basic']  # noqa: E501

        return self.api_client.call_api(
            '/v1/{organizationSlug}/versions/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Version',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_application(self, id, organization_slug, **kwargs):  # noqa: E501
        """delete_application  # noqa: E501

        Delete an Application  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_application(id, organization_slug, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :param str organization_slug: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_application_with_http_info(id, organization_slug, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_application_with_http_info(id, organization_slug, **kwargs)  # noqa: E501
            return data

    def delete_application_with_http_info(self, id, organization_slug, **kwargs):  # noqa: E501
        """delete_application  # noqa: E501

        Delete an Application  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_application_with_http_info(id, organization_slug, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :param str organization_slug: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'organization_slug']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_application" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_application`")  # noqa: E501
        # verify the required parameter 'organization_slug' is set
        if ('organization_slug' not in params or
                params['organization_slug'] is None):
            raise ValueError("Missing the required parameter `organization_slug` when calling `delete_application`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501
        if 'organization_slug' in params:
            path_params['organizationSlug'] = params['organization_slug']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Basic']  # noqa: E501

        return self.api_client.call_api(
            '/v1/{organizationSlug}/applications/{id}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_configuration(self, id, organization_slug, **kwargs):  # noqa: E501
        """delete_configuration  # noqa: E501

        Delete an Configuration  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_configuration(id, organization_slug, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :param str organization_slug: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_configuration_with_http_info(id, organization_slug, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_configuration_with_http_info(id, organization_slug, **kwargs)  # noqa: E501
            return data

    def delete_configuration_with_http_info(self, id, organization_slug, **kwargs):  # noqa: E501
        """delete_configuration  # noqa: E501

        Delete an Configuration  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_configuration_with_http_info(id, organization_slug, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :param str organization_slug: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'organization_slug']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_configuration" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_configuration`")  # noqa: E501
        # verify the required parameter 'organization_slug' is set
        if ('organization_slug' not in params or
                params['organization_slug'] is None):
            raise ValueError("Missing the required parameter `organization_slug` when calling `delete_configuration`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501
        if 'organization_slug' in params:
            path_params['organizationSlug'] = params['organization_slug']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Basic']  # noqa: E501

        return self.api_client.call_api(
            '/v1/{organizationSlug}/configurations/{id}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_environment(self, id, organization_slug, **kwargs):  # noqa: E501
        """delete_environment  # noqa: E501

        Delete an Environment  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_environment(id, organization_slug, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :param str organization_slug: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_environment_with_http_info(id, organization_slug, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_environment_with_http_info(id, organization_slug, **kwargs)  # noqa: E501
            return data

    def delete_environment_with_http_info(self, id, organization_slug, **kwargs):  # noqa: E501
        """delete_environment  # noqa: E501

        Delete an Environment  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_environment_with_http_info(id, organization_slug, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :param str organization_slug: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'organization_slug']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_environment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_environment`")  # noqa: E501
        # verify the required parameter 'organization_slug' is set
        if ('organization_slug' not in params or
                params['organization_slug'] is None):
            raise ValueError("Missing the required parameter `organization_slug` when calling `delete_environment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501
        if 'organization_slug' in params:
            path_params['organizationSlug'] = params['organization_slug']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Basic']  # noqa: E501

        return self.api_client.call_api(
            '/v1/{organizationSlug}/environments/{id}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_version(self, id, organization_slug, **kwargs):  # noqa: E501
        """delete_version  # noqa: E501

        Delete a Version  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_version(id, organization_slug, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :param str organization_slug: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_version_with_http_info(id, organization_slug, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_version_with_http_info(id, organization_slug, **kwargs)  # noqa: E501
            return data

    def delete_version_with_http_info(self, id, organization_slug, **kwargs):  # noqa: E501
        """delete_version  # noqa: E501

        Delete a Version  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_version_with_http_info(id, organization_slug, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :param str organization_slug: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'organization_slug']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_version" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_version`")  # noqa: E501
        # verify the required parameter 'organization_slug' is set
        if ('organization_slug' not in params or
                params['organization_slug'] is None):
            raise ValueError("Missing the required parameter `organization_slug` when calling `delete_version`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501
        if 'organization_slug' in params:
            path_params['organizationSlug'] = params['organization_slug']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Basic']  # noqa: E501

        return self.api_client.call_api(
            '/v1/{organizationSlug}/versions/{id}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def duplicate_version(self, body, id, organization_slug, **kwargs):  # noqa: E501
        """duplicate_version  # noqa: E501

        Create a new Version based on another Version  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.duplicate_version(body, id, organization_slug, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Version body: (required)
        :param str id: (required)
        :param str organization_slug: (required)
        :return: Version
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.duplicate_version_with_http_info(body, id, organization_slug, **kwargs)  # noqa: E501
        else:
            (data) = self.duplicate_version_with_http_info(body, id, organization_slug, **kwargs)  # noqa: E501
            return data

    def duplicate_version_with_http_info(self, body, id, organization_slug, **kwargs):  # noqa: E501
        """duplicate_version  # noqa: E501

        Create a new Version based on another Version  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.duplicate_version_with_http_info(body, id, organization_slug, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Version body: (required)
        :param str id: (required)
        :param str organization_slug: (required)
        :return: Version
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'id', 'organization_slug']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method duplicate_version" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `duplicate_version`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `duplicate_version`")  # noqa: E501
        # verify the required parameter 'organization_slug' is set
        if ('organization_slug' not in params or
                params['organization_slug'] is None):
            raise ValueError("Missing the required parameter `organization_slug` when calling `duplicate_version`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501
        if 'organization_slug' in params:
            path_params['organizationSlug'] = params['organization_slug']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Basic']  # noqa: E501

        return self.api_client.call_api(
            '/v1/{organizationSlug}/versions/{id}/duplicate/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Version',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all_applications(self, organization_slug, **kwargs):  # noqa: E501
        """get_all_applications  # noqa: E501

        Return a list of all Applications of an organization  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_applications(organization_slug, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organization_slug: (required)
        :return: list[Application]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_all_applications_with_http_info(organization_slug, **kwargs)  # noqa: E501
        else:
            (data) = self.get_all_applications_with_http_info(organization_slug, **kwargs)  # noqa: E501
            return data

    def get_all_applications_with_http_info(self, organization_slug, **kwargs):  # noqa: E501
        """get_all_applications  # noqa: E501

        Return a list of all Applications of an organization  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_applications_with_http_info(organization_slug, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organization_slug: (required)
        :return: list[Application]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['organization_slug']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_applications" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'organization_slug' is set
        if ('organization_slug' not in params or
                params['organization_slug'] is None):
            raise ValueError("Missing the required parameter `organization_slug` when calling `get_all_applications`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_slug' in params:
            path_params['organizationSlug'] = params['organization_slug']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Basic']  # noqa: E501

        return self.api_client.call_api(
            '/v1/{organizationSlug}/applications/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Application]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_application_by_id(self, id, organization_slug, **kwargs):  # noqa: E501
        """get_application_by_id  # noqa: E501

        Return an Application  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_application_by_id(id, organization_slug, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :param str organization_slug: (required)
        :return: Application
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_application_by_id_with_http_info(id, organization_slug, **kwargs)  # noqa: E501
        else:
            (data) = self.get_application_by_id_with_http_info(id, organization_slug, **kwargs)  # noqa: E501
            return data

    def get_application_by_id_with_http_info(self, id, organization_slug, **kwargs):  # noqa: E501
        """get_application_by_id  # noqa: E501

        Return an Application  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_application_by_id_with_http_info(id, organization_slug, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :param str organization_slug: (required)
        :return: Application
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'organization_slug']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_application_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_application_by_id`")  # noqa: E501
        # verify the required parameter 'organization_slug' is set
        if ('organization_slug' not in params or
                params['organization_slug'] is None):
            raise ValueError("Missing the required parameter `organization_slug` when calling `get_application_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501
        if 'organization_slug' in params:
            path_params['organizationSlug'] = params['organization_slug']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Basic']  # noqa: E501

        return self.api_client.call_api(
            '/v1/{organizationSlug}/applications/{id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Application',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_configuration_by_id(self, id, organization_slug, **kwargs):  # noqa: E501
        """get_configuration_by_id  # noqa: E501

        Return a Configuration  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_configuration_by_id(id, organization_slug, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :param str organization_slug: (required)
        :return: Configuration
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_configuration_by_id_with_http_info(id, organization_slug, **kwargs)  # noqa: E501
        else:
            (data) = self.get_configuration_by_id_with_http_info(id, organization_slug, **kwargs)  # noqa: E501
            return data

    def get_configuration_by_id_with_http_info(self, id, organization_slug, **kwargs):  # noqa: E501
        """get_configuration_by_id  # noqa: E501

        Return a Configuration  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_configuration_by_id_with_http_info(id, organization_slug, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :param str organization_slug: (required)
        :return: Configuration
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'organization_slug']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_configuration_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_configuration_by_id`")  # noqa: E501
        # verify the required parameter 'organization_slug' is set
        if ('organization_slug' not in params or
                params['organization_slug'] is None):
            raise ValueError("Missing the required parameter `organization_slug` when calling `get_configuration_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501
        if 'organization_slug' in params:
            path_params['organizationSlug'] = params['organization_slug']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Basic']  # noqa: E501

        return self.api_client.call_api(
            '/v1/{organizationSlug}/configurations/{id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Configuration',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_environment_by_id(self, id, organization_slug, **kwargs):  # noqa: E501
        """get_environment_by_id  # noqa: E501

        Return an Environment  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_environment_by_id(id, organization_slug, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :param str organization_slug: (required)
        :return: Environment
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_environment_by_id_with_http_info(id, organization_slug, **kwargs)  # noqa: E501
        else:
            (data) = self.get_environment_by_id_with_http_info(id, organization_slug, **kwargs)  # noqa: E501
            return data

    def get_environment_by_id_with_http_info(self, id, organization_slug, **kwargs):  # noqa: E501
        """get_environment_by_id  # noqa: E501

        Return an Environment  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_environment_by_id_with_http_info(id, organization_slug, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :param str organization_slug: (required)
        :return: Environment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'organization_slug']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_environment_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_environment_by_id`")  # noqa: E501
        # verify the required parameter 'organization_slug' is set
        if ('organization_slug' not in params or
                params['organization_slug'] is None):
            raise ValueError("Missing the required parameter `organization_slug` when calling `get_environment_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501
        if 'organization_slug' in params:
            path_params['organizationSlug'] = params['organization_slug']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Basic']  # noqa: E501

        return self.api_client.call_api(
            '/v1/{organizationSlug}/environments/{id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Environment',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_environment_live_version(self, id, organization_slug, **kwargs):  # noqa: E501
        """get_environment_live_version  # noqa: E501

        Get version marked as live for a given environment  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_environment_live_version(id, organization_slug, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :param str organization_slug: (required)
        :return: Environment
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_environment_live_version_with_http_info(id, organization_slug, **kwargs)  # noqa: E501
        else:
            (data) = self.get_environment_live_version_with_http_info(id, organization_slug, **kwargs)  # noqa: E501
            return data

    def get_environment_live_version_with_http_info(self, id, organization_slug, **kwargs):  # noqa: E501
        """get_environment_live_version  # noqa: E501

        Get version marked as live for a given environment  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_environment_live_version_with_http_info(id, organization_slug, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :param str organization_slug: (required)
        :return: Environment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'organization_slug']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_environment_live_version" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_environment_live_version`")  # noqa: E501
        # verify the required parameter 'organization_slug' is set
        if ('organization_slug' not in params or
                params['organization_slug'] is None):
            raise ValueError("Missing the required parameter `organization_slug` when calling `get_environment_live_version`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501
        if 'organization_slug' in params:
            path_params['organizationSlug'] = params['organization_slug']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Basic']  # noqa: E501

        return self.api_client.call_api(
            '/v1/{organizationSlug}/environments/{id}/liveVersion/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Environment',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_organization_by_slug(self, organization_slug, **kwargs):  # noqa: E501
        """get_organization_by_slug  # noqa: E501

        Return an Organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_organization_by_slug(organization_slug, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organization_slug: The name in all lowercase, suitable for URL identification (required)
        :return: Organization
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_organization_by_slug_with_http_info(organization_slug, **kwargs)  # noqa: E501
        else:
            (data) = self.get_organization_by_slug_with_http_info(organization_slug, **kwargs)  # noqa: E501
            return data

    def get_organization_by_slug_with_http_info(self, organization_slug, **kwargs):  # noqa: E501
        """get_organization_by_slug  # noqa: E501

        Return an Organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_organization_by_slug_with_http_info(organization_slug, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organization_slug: The name in all lowercase, suitable for URL identification (required)
        :return: Organization
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['organization_slug']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_organization_by_slug" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'organization_slug' is set
        if ('organization_slug' not in params or
                params['organization_slug'] is None):
            raise ValueError("Missing the required parameter `organization_slug` when calling `get_organization_by_slug`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_slug' in params:
            path_params['organizationSlug'] = params['organization_slug']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Basic']  # noqa: E501

        return self.api_client.call_api(
            '/v1/{organizationSlug}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Organization',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_version(self, organization_slug, **kwargs):  # noqa: E501
        """get_version  # noqa: E501

        Return the live Version given applicationName, environmentName query param. An optional versionName query param to get a specific Version  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_version(organization_slug, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organization_slug: (required)
        :param str application_name: Application Name
        :param str environment_name: Environment Name
        :param str version_name: Version Name
        :return: Version
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_version_with_http_info(organization_slug, **kwargs)  # noqa: E501
        else:
            (data) = self.get_version_with_http_info(organization_slug, **kwargs)  # noqa: E501
            return data

    def get_version_with_http_info(self, organization_slug, **kwargs):  # noqa: E501
        """get_version  # noqa: E501

        Return the live Version given applicationName, environmentName query param. An optional versionName query param to get a specific Version  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_version_with_http_info(organization_slug, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organization_slug: (required)
        :param str application_name: Application Name
        :param str environment_name: Environment Name
        :param str version_name: Version Name
        :return: Version
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['organization_slug', 'application_name', 'environment_name', 'version_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_version" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'organization_slug' is set
        if ('organization_slug' not in params or
                params['organization_slug'] is None):
            raise ValueError("Missing the required parameter `organization_slug` when calling `get_version`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_slug' in params:
            path_params['organizationSlug'] = params['organization_slug']  # noqa: E501

        query_params = []
        if 'application_name' in params:
            query_params.append(('applicationName', params['application_name']))  # noqa: E501
        if 'environment_name' in params:
            query_params.append(('environmentName', params['environment_name']))  # noqa: E501
        if 'version_name' in params:
            query_params.append(('versionName', params['version_name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Basic']  # noqa: E501

        return self.api_client.call_api(
            '/v1/{organizationSlug}/versions/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Version',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_version_by_id(self, id, organization_slug, **kwargs):  # noqa: E501
        """get_version_by_id  # noqa: E501

        Return a Version  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_version_by_id(id, organization_slug, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :param str organization_slug: (required)
        :return: Version
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_version_by_id_with_http_info(id, organization_slug, **kwargs)  # noqa: E501
        else:
            (data) = self.get_version_by_id_with_http_info(id, organization_slug, **kwargs)  # noqa: E501
            return data

    def get_version_by_id_with_http_info(self, id, organization_slug, **kwargs):  # noqa: E501
        """get_version_by_id  # noqa: E501

        Return a Version  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_version_by_id_with_http_info(id, organization_slug, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :param str organization_slug: (required)
        :return: Version
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'organization_slug']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_version_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_version_by_id`")  # noqa: E501
        # verify the required parameter 'organization_slug' is set
        if ('organization_slug' not in params or
                params['organization_slug'] is None):
            raise ValueError("Missing the required parameter `organization_slug` when calling `get_version_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501
        if 'organization_slug' in params:
            path_params['organizationSlug'] = params['organization_slug']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Basic']  # noqa: E501

        return self.api_client.call_api(
            '/v1/{organizationSlug}/versions/{id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Version',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def login(self, body, **kwargs):  # noqa: E501
        """login  # noqa: E501

        Takes a set of user credentials and returns an access and refresh JSON web token pair to prove the authentication of those credentials.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.login(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CustomTokenObtainPair body: (required)
        :return: CustomTokenObtainPair
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.login_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.login_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def login_with_http_info(self, body, **kwargs):  # noqa: E501
        """login  # noqa: E501

        Takes a set of user credentials and returns an access and refresh JSON web token pair to prove the authentication of those credentials.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.login_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CustomTokenObtainPair body: (required)
        :return: CustomTokenObtainPair
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method login" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `login`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Basic']  # noqa: E501

        return self.api_client.call_api(
            '/v1/login/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomTokenObtainPair',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def partial_update_application(self, body, id, organization_slug, **kwargs):  # noqa: E501
        """partial_update_application  # noqa: E501

        Update one or more fields on an existing Application  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.partial_update_application(body, id, organization_slug, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Application body: (required)
        :param str id: (required)
        :param str organization_slug: (required)
        :return: Application
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.partial_update_application_with_http_info(body, id, organization_slug, **kwargs)  # noqa: E501
        else:
            (data) = self.partial_update_application_with_http_info(body, id, organization_slug, **kwargs)  # noqa: E501
            return data

    def partial_update_application_with_http_info(self, body, id, organization_slug, **kwargs):  # noqa: E501
        """partial_update_application  # noqa: E501

        Update one or more fields on an existing Application  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.partial_update_application_with_http_info(body, id, organization_slug, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Application body: (required)
        :param str id: (required)
        :param str organization_slug: (required)
        :return: Application
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'id', 'organization_slug']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method partial_update_application" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `partial_update_application`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `partial_update_application`")  # noqa: E501
        # verify the required parameter 'organization_slug' is set
        if ('organization_slug' not in params or
                params['organization_slug'] is None):
            raise ValueError("Missing the required parameter `organization_slug` when calling `partial_update_application`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501
        if 'organization_slug' in params:
            path_params['organizationSlug'] = params['organization_slug']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Basic']  # noqa: E501

        return self.api_client.call_api(
            '/v1/{organizationSlug}/applications/{id}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Application',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def partial_update_configuration(self, body, id, organization_slug, **kwargs):  # noqa: E501
        """partial_update_configuration  # noqa: E501

        Update one or more fields on an existing Configuration  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.partial_update_configuration(body, id, organization_slug, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Configuration body: (required)
        :param str id: (required)
        :param str organization_slug: (required)
        :return: Configuration
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.partial_update_configuration_with_http_info(body, id, organization_slug, **kwargs)  # noqa: E501
        else:
            (data) = self.partial_update_configuration_with_http_info(body, id, organization_slug, **kwargs)  # noqa: E501
            return data

    def partial_update_configuration_with_http_info(self, body, id, organization_slug, **kwargs):  # noqa: E501
        """partial_update_configuration  # noqa: E501

        Update one or more fields on an existing Configuration  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.partial_update_configuration_with_http_info(body, id, organization_slug, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Configuration body: (required)
        :param str id: (required)
        :param str organization_slug: (required)
        :return: Configuration
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'id', 'organization_slug']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method partial_update_configuration" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `partial_update_configuration`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `partial_update_configuration`")  # noqa: E501
        # verify the required parameter 'organization_slug' is set
        if ('organization_slug' not in params or
                params['organization_slug'] is None):
            raise ValueError("Missing the required parameter `organization_slug` when calling `partial_update_configuration`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501
        if 'organization_slug' in params:
            path_params['organizationSlug'] = params['organization_slug']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Basic']  # noqa: E501

        return self.api_client.call_api(
            '/v1/{organizationSlug}/configurations/{id}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Configuration',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def partial_update_environment(self, body, id, organization_slug, **kwargs):  # noqa: E501
        """partial_update_environment  # noqa: E501

        Update one or more fields on an existing Environment  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.partial_update_environment(body, id, organization_slug, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Environment body: (required)
        :param str id: (required)
        :param str organization_slug: (required)
        :return: Environment
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.partial_update_environment_with_http_info(body, id, organization_slug, **kwargs)  # noqa: E501
        else:
            (data) = self.partial_update_environment_with_http_info(body, id, organization_slug, **kwargs)  # noqa: E501
            return data

    def partial_update_environment_with_http_info(self, body, id, organization_slug, **kwargs):  # noqa: E501
        """partial_update_environment  # noqa: E501

        Update one or more fields on an existing Environment  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.partial_update_environment_with_http_info(body, id, organization_slug, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Environment body: (required)
        :param str id: (required)
        :param str organization_slug: (required)
        :return: Environment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'id', 'organization_slug']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method partial_update_environment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `partial_update_environment`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `partial_update_environment`")  # noqa: E501
        # verify the required parameter 'organization_slug' is set
        if ('organization_slug' not in params or
                params['organization_slug'] is None):
            raise ValueError("Missing the required parameter `organization_slug` when calling `partial_update_environment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501
        if 'organization_slug' in params:
            path_params['organizationSlug'] = params['organization_slug']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Basic']  # noqa: E501

        return self.api_client.call_api(
            '/v1/{organizationSlug}/environments/{id}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Environment',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def partial_update_version(self, body, id, organization_slug, **kwargs):  # noqa: E501
        """partial_update_version  # noqa: E501

        Update one or more fields of an existing Version  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.partial_update_version(body, id, organization_slug, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Version body: (required)
        :param str id: (required)
        :param str organization_slug: (required)
        :return: Version
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.partial_update_version_with_http_info(body, id, organization_slug, **kwargs)  # noqa: E501
        else:
            (data) = self.partial_update_version_with_http_info(body, id, organization_slug, **kwargs)  # noqa: E501
            return data

    def partial_update_version_with_http_info(self, body, id, organization_slug, **kwargs):  # noqa: E501
        """partial_update_version  # noqa: E501

        Update one or more fields of an existing Version  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.partial_update_version_with_http_info(body, id, organization_slug, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Version body: (required)
        :param str id: (required)
        :param str organization_slug: (required)
        :return: Version
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'id', 'organization_slug']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method partial_update_version" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `partial_update_version`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `partial_update_version`")  # noqa: E501
        # verify the required parameter 'organization_slug' is set
        if ('organization_slug' not in params or
                params['organization_slug'] is None):
            raise ValueError("Missing the required parameter `organization_slug` when calling `partial_update_version`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501
        if 'organization_slug' in params:
            path_params['organizationSlug'] = params['organization_slug']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Basic']  # noqa: E501

        return self.api_client.call_api(
            '/v1/{organizationSlug}/versions/{id}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Version',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def refresh_token(self, body, **kwargs):  # noqa: E501
        """refresh_token  # noqa: E501

        Takes a refresh type JSON web token and returns an access type JSON web token if the refresh token is valid.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.refresh_token(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TokenRefresh body: (required)
        :return: TokenRefresh
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.refresh_token_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.refresh_token_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def refresh_token_with_http_info(self, body, **kwargs):  # noqa: E501
        """refresh_token  # noqa: E501

        Takes a refresh type JSON web token and returns an access type JSON web token if the refresh token is valid.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.refresh_token_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TokenRefresh body: (required)
        :return: TokenRefresh
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method refresh_token" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `refresh_token`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Basic']  # noqa: E501

        return self.api_client.call_api(
            '/v1/login/refresh/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TokenRefresh',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_application(self, body, id, organization_slug, **kwargs):  # noqa: E501
        """update_application  # noqa: E501

        Update an existing Application  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_application(body, id, organization_slug, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Application body: (required)
        :param str id: (required)
        :param str organization_slug: (required)
        :return: Application
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_application_with_http_info(body, id, organization_slug, **kwargs)  # noqa: E501
        else:
            (data) = self.update_application_with_http_info(body, id, organization_slug, **kwargs)  # noqa: E501
            return data

    def update_application_with_http_info(self, body, id, organization_slug, **kwargs):  # noqa: E501
        """update_application  # noqa: E501

        Update an existing Application  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_application_with_http_info(body, id, organization_slug, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Application body: (required)
        :param str id: (required)
        :param str organization_slug: (required)
        :return: Application
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'id', 'organization_slug']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_application" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_application`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_application`")  # noqa: E501
        # verify the required parameter 'organization_slug' is set
        if ('organization_slug' not in params or
                params['organization_slug'] is None):
            raise ValueError("Missing the required parameter `organization_slug` when calling `update_application`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501
        if 'organization_slug' in params:
            path_params['organizationSlug'] = params['organization_slug']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Basic']  # noqa: E501

        return self.api_client.call_api(
            '/v1/{organizationSlug}/applications/{id}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Application',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_configuration(self, body, id, organization_slug, **kwargs):  # noqa: E501
        """update_configuration  # noqa: E501

        Update an existing Configuration  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_configuration(body, id, organization_slug, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Configuration body: (required)
        :param str id: (required)
        :param str organization_slug: (required)
        :return: Configuration
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_configuration_with_http_info(body, id, organization_slug, **kwargs)  # noqa: E501
        else:
            (data) = self.update_configuration_with_http_info(body, id, organization_slug, **kwargs)  # noqa: E501
            return data

    def update_configuration_with_http_info(self, body, id, organization_slug, **kwargs):  # noqa: E501
        """update_configuration  # noqa: E501

        Update an existing Configuration  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_configuration_with_http_info(body, id, organization_slug, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Configuration body: (required)
        :param str id: (required)
        :param str organization_slug: (required)
        :return: Configuration
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'id', 'organization_slug']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_configuration" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_configuration`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_configuration`")  # noqa: E501
        # verify the required parameter 'organization_slug' is set
        if ('organization_slug' not in params or
                params['organization_slug'] is None):
            raise ValueError("Missing the required parameter `organization_slug` when calling `update_configuration`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501
        if 'organization_slug' in params:
            path_params['organizationSlug'] = params['organization_slug']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Basic']  # noqa: E501

        return self.api_client.call_api(
            '/v1/{organizationSlug}/configurations/{id}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Configuration',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_environment(self, body, id, organization_slug, **kwargs):  # noqa: E501
        """update_environment  # noqa: E501

        Update an existing Environment  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_environment(body, id, organization_slug, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Environment body: (required)
        :param str id: (required)
        :param str organization_slug: (required)
        :return: Environment
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_environment_with_http_info(body, id, organization_slug, **kwargs)  # noqa: E501
        else:
            (data) = self.update_environment_with_http_info(body, id, organization_slug, **kwargs)  # noqa: E501
            return data

    def update_environment_with_http_info(self, body, id, organization_slug, **kwargs):  # noqa: E501
        """update_environment  # noqa: E501

        Update an existing Environment  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_environment_with_http_info(body, id, organization_slug, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Environment body: (required)
        :param str id: (required)
        :param str organization_slug: (required)
        :return: Environment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'id', 'organization_slug']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_environment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_environment`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_environment`")  # noqa: E501
        # verify the required parameter 'organization_slug' is set
        if ('organization_slug' not in params or
                params['organization_slug'] is None):
            raise ValueError("Missing the required parameter `organization_slug` when calling `update_environment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501
        if 'organization_slug' in params:
            path_params['organizationSlug'] = params['organization_slug']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Basic']  # noqa: E501

        return self.api_client.call_api(
            '/v1/{organizationSlug}/environments/{id}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Environment',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_version(self, body, id, organization_slug, **kwargs):  # noqa: E501
        """update_version  # noqa: E501

        Update an existing Version  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_version(body, id, organization_slug, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Version body: (required)
        :param str id: (required)
        :param str organization_slug: (required)
        :return: Version
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_version_with_http_info(body, id, organization_slug, **kwargs)  # noqa: E501
        else:
            (data) = self.update_version_with_http_info(body, id, organization_slug, **kwargs)  # noqa: E501
            return data

    def update_version_with_http_info(self, body, id, organization_slug, **kwargs):  # noqa: E501
        """update_version  # noqa: E501

        Update an existing Version  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_version_with_http_info(body, id, organization_slug, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Version body: (required)
        :param str id: (required)
        :param str organization_slug: (required)
        :return: Version
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'id', 'organization_slug']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_version" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_version`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_version`")  # noqa: E501
        # verify the required parameter 'organization_slug' is set
        if ('organization_slug' not in params or
                params['organization_slug'] is None):
            raise ValueError("Missing the required parameter `organization_slug` when calling `update_version`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501
        if 'organization_slug' in params:
            path_params['organizationSlug'] = params['organization_slug']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Basic']  # noqa: E501

        return self.api_client.call_api(
            '/v1/{organizationSlug}/versions/{id}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Version',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def upload_configuration_file(self, file, ext, organization_slug, **kwargs):  # noqa: E501
        """upload_configuration_file  # noqa: E501

        Upload file to be parsed to JSON  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_configuration_file(file, ext, organization_slug, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file file: (required)
        :param str ext: (required)
        :param str organization_slug: (required)
        :return: ConfigurationFile
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.upload_configuration_file_with_http_info(file, ext, organization_slug, **kwargs)  # noqa: E501
        else:
            (data) = self.upload_configuration_file_with_http_info(file, ext, organization_slug, **kwargs)  # noqa: E501
            return data

    def upload_configuration_file_with_http_info(self, file, ext, organization_slug, **kwargs):  # noqa: E501
        """upload_configuration_file  # noqa: E501

        Upload file to be parsed to JSON  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_configuration_file_with_http_info(file, ext, organization_slug, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file file: (required)
        :param str ext: (required)
        :param str organization_slug: (required)
        :return: ConfigurationFile
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file', 'ext', 'organization_slug']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upload_configuration_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file' is set
        if ('file' not in params or
                params['file'] is None):
            raise ValueError("Missing the required parameter `file` when calling `upload_configuration_file`")  # noqa: E501
        # verify the required parameter 'ext' is set
        if ('ext' not in params or
                params['ext'] is None):
            raise ValueError("Missing the required parameter `ext` when calling `upload_configuration_file`")  # noqa: E501
        # verify the required parameter 'organization_slug' is set
        if ('organization_slug' not in params or
                params['organization_slug'] is None):
            raise ValueError("Missing the required parameter `organization_slug` when calling `upload_configuration_file`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_slug' in params:
            path_params['organizationSlug'] = params['organization_slug']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'file' in params:
            local_var_files['file'] = params['file']  # noqa: E501
        if 'ext' in params:
            form_params.append(('ext', params['ext']))  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Basic']  # noqa: E501

        return self.api_client.call_api(
            '/v1/{organizationSlug}/configurations/upload_config/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConfigurationFile',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
