# ct-python
ConfigTree API definitions

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: v1
- Package version: 1.0.3
- Build package: io.swagger.codegen.v3.generators.python.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install
It's recommended to install the SDK from PyPI useing:

```sh
pip install ct-python
```

You can also install it directly from Github

```sh
pip install git+https://github.com/configtree/ct-python-sdk
```

(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/configtree/ct-python-sdk`)

Then import the package:

```python
import ct_python 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import ct_python
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then you can use the SDK. A sample usage:

```python
from __future__ import print_function
import time
import ct_python
from ct_python.rest import ApiException
from pprint import pprint

# Configure API key authorization: Bearer
configuration = ct_python.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'
configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = ct_python.CTApi(ct_python.ApiClient(configuration))
body = ct_python.Application() # Application | 
organization_slug = 'organization_slug_example' # str | 

try:
    api_response = api_instance.create_application(body, organization_slug)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling CTApi->create_application: %s\n" % e)

# Configure API key authorization: Bearer
configuration = ct_python.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'

configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = ct_python.CTApi(ct_python.ApiClient(configuration))
body = ct_python.Configuration() # Configuration | 
organization_slug = 'organization_slug_example' # str | 

try:
    api_response = api_instance.create_configuration(body, organization_slug)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling CTApi->create_configuration: %s\n" % e)

# Configure API key authorization: Bearer
configuration = ct_python.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'

configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = ct_python.CTApi(ct_python.ApiClient(configuration))
body = ct_python.Environment() # Environment | 
organization_slug = 'organization_slug_example' # str | 

try:
    api_response = api_instance.create_environment(body, organization_slug)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling CTApi->create_environment: %s\n" % e)

# Configure API key authorization: Bearer
configuration = ct_python.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'

configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = ct_python.CTApi(ct_python.ApiClient(configuration))
body = ct_python.Version() # Version | 
organization_slug = 'organization_slug_example' # str | 

try:
    api_response = api_instance.create_version(body, organization_slug)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling CTApi->create_version: %s\n" % e)

# Configure API key authorization: Bearer
configuration = ct_python.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'

configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = ct_python.CTApi(ct_python.ApiClient(configuration))
id = 'id_example' # str | 
organization_slug = 'organization_slug_example' # str | 

try:
    api_instance.delete_application(id, organization_slug)
except ApiException as e:
    print("Exception when calling CTApi->delete_application: %s\n" % e)

# Configure API key authorization: Bearer
configuration = ct_python.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'

configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = ct_python.CTApi(ct_python.ApiClient(configuration))
id = 'id_example' # str | 
organization_slug = 'organization_slug_example' # str | 

try:
    api_instance.delete_configuration(id, organization_slug)
except ApiException as e:
    print("Exception when calling CTApi->delete_configuration: %s\n" % e)

# Configure API key authorization: Bearer
configuration = ct_python.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'

configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = ct_python.CTApi(ct_python.ApiClient(configuration))
id = 'id_example' # str | 
organization_slug = 'organization_slug_example' # str | 

try:
    api_instance.delete_environment(id, organization_slug)
except ApiException as e:
    print("Exception when calling CTApi->delete_environment: %s\n" % e)

# Configure API key authorization: Bearer
configuration = ct_python.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'

configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = ct_python.CTApi(ct_python.ApiClient(configuration))
id = 'id_example' # str | 
organization_slug = 'organization_slug_example' # str | 

try:
    api_instance.delete_version(id, organization_slug)
except ApiException as e:
    print("Exception when calling CTApi->delete_version: %s\n" % e)

# Configure API key authorization: Bearer
configuration = ct_python.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'

configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = ct_python.CTApi(ct_python.ApiClient(configuration))
body = ct_python.Version() # Version | 
id = 'id_example' # str | 
organization_slug = 'organization_slug_example' # str | 

try:
    api_response = api_instance.duplicate_version(body, id, organization_slug)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling CTApi->duplicate_version: %s\n" % e)

# Configure API key authorization: Bearer
configuration = ct_python.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'

configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = ct_python.CTApi(ct_python.ApiClient(configuration))
organization_slug = 'organization_slug_example' # str | 

try:
    api_response = api_instance.get_all_applications(organization_slug)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling CTApi->get_all_applications: %s\n" % e)

# Configure API key authorization: Bearer
configuration = ct_python.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'

configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = ct_python.CTApi(ct_python.ApiClient(configuration))
id = 'id_example' # str | 
organization_slug = 'organization_slug_example' # str | 

try:
    api_response = api_instance.get_application_by_id(id, organization_slug)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling CTApi->get_application_by_id: %s\n" % e)

# Configure API key authorization: Bearer
configuration = ct_python.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'

configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = ct_python.CTApi(ct_python.ApiClient(configuration))
id = 'id_example' # str | 
organization_slug = 'organization_slug_example' # str | 

try:
    api_response = api_instance.get_configuration_by_id(id, organization_slug)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling CTApi->get_configuration_by_id: %s\n" % e)

# Configure API key authorization: Bearer
configuration = ct_python.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'

configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = ct_python.CTApi(ct_python.ApiClient(configuration))
id = 'id_example' # str | 
organization_slug = 'organization_slug_example' # str | 

try:
    api_response = api_instance.get_environment_by_id(id, organization_slug)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling CTApi->get_environment_by_id: %s\n" % e)

# Configure API key authorization: Bearer
configuration = ct_python.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'

configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = ct_python.CTApi(ct_python.ApiClient(configuration))
id = 'id_example' # str | 
organization_slug = 'organization_slug_example' # str | 

try:
    api_response = api_instance.get_environment_live_version(id, organization_slug)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling CTApi->get_environment_live_version: %s\n" % e)

# Configure API key authorization: Bearer
configuration = ct_python.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'

configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = ct_python.CTApi(ct_python.ApiClient(configuration))
organization_slug = 'organization_slug_example' # str | The name in all lowercase, suitable for URL identification

try:
    api_response = api_instance.get_organization_by_slug(organization_slug)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling CTApi->get_organization_by_slug: %s\n" % e)

# Configure API key authorization: Bearer
configuration = ct_python.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'

configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = ct_python.CTApi(ct_python.ApiClient(configuration))
organization_slug = 'organization_slug_example' # str | 
application_name = 'application_name_example' # str | Application Name (optional)
environment_name = 'environment_name_example' # str | Environment Name (optional)
version_name = 'version_name_example' # str | Version Name (optional)

try:
    api_response = api_instance.get_version(organization_slug, application_name=application_name, environment_name=environment_name, version_name=version_name)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling CTApi->get_version: %s\n" % e)

# Configure API key authorization: Bearer
configuration = ct_python.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'

configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = ct_python.CTApi(ct_python.ApiClient(configuration))
id = 'id_example' # str | 
organization_slug = 'organization_slug_example' # str | 

try:
    api_response = api_instance.get_version_by_id(id, organization_slug)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling CTApi->get_version_by_id: %s\n" % e)

# Configure API key authorization: Bearer
configuration = ct_python.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'

configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = ct_python.CTApi(ct_python.ApiClient(configuration))
body = ct_python.CustomTokenObtainPair() # CustomTokenObtainPair | 

try:
    api_response = api_instance.login(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling CTApi->login: %s\n" % e)

# Configure API key authorization: Bearer
configuration = ct_python.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'

configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = ct_python.CTApi(ct_python.ApiClient(configuration))
body = ct_python.Application() # Application | 
id = 'id_example' # str | 
organization_slug = 'organization_slug_example' # str | 

try:
    api_response = api_instance.partial_update_application(body, id, organization_slug)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling CTApi->partial_update_application: %s\n" % e)

# Configure API key authorization: Bearer
configuration = ct_python.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'

configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = ct_python.CTApi(ct_python.ApiClient(configuration))
body = ct_python.Configuration() # Configuration | 
id = 'id_example' # str | 
organization_slug = 'organization_slug_example' # str | 

try:
    api_response = api_instance.partial_update_configuration(body, id, organization_slug)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling CTApi->partial_update_configuration: %s\n" % e)

# Configure API key authorization: Bearer
configuration = ct_python.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'

configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = ct_python.CTApi(ct_python.ApiClient(configuration))
body = ct_python.Environment() # Environment | 
id = 'id_example' # str | 
organization_slug = 'organization_slug_example' # str | 

try:
    api_response = api_instance.partial_update_environment(body, id, organization_slug)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling CTApi->partial_update_environment: %s\n" % e)

# Configure API key authorization: Bearer
configuration = ct_python.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'

configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = ct_python.CTApi(ct_python.ApiClient(configuration))
body = ct_python.Version() # Version | 
id = 'id_example' # str | 
organization_slug = 'organization_slug_example' # str | 

try:
    api_response = api_instance.partial_update_version(body, id, organization_slug)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling CTApi->partial_update_version: %s\n" % e)

# Configure API key authorization: Bearer
configuration = ct_python.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'

configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = ct_python.CTApi(ct_python.ApiClient(configuration))
body = ct_python.TokenRefresh() # TokenRefresh | 

try:
    api_response = api_instance.refresh_token(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling CTApi->refresh_token: %s\n" % e)

# Configure API key authorization: Bearer
configuration = ct_python.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'

configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = ct_python.CTApi(ct_python.ApiClient(configuration))
body = ct_python.Application() # Application | 
id = 'id_example' # str | 
organization_slug = 'organization_slug_example' # str | 

try:
    api_response = api_instance.update_application(body, id, organization_slug)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling CTApi->update_application: %s\n" % e)

# Configure API key authorization: Bearer
configuration = ct_python.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'

configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = ct_python.CTApi(ct_python.ApiClient(configuration))
body = ct_python.Configuration() # Configuration | 
id = 'id_example' # str | 
organization_slug = 'organization_slug_example' # str | 

try:
    api_response = api_instance.update_configuration(body, id, organization_slug)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling CTApi->update_configuration: %s\n" % e)

# Configure API key authorization: Bearer
configuration = ct_python.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'

configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = ct_python.CTApi(ct_python.ApiClient(configuration))
body = ct_python.Environment() # Environment | 
id = 'id_example' # str | 
organization_slug = 'organization_slug_example' # str | 

try:
    api_response = api_instance.update_environment(body, id, organization_slug)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling CTApi->update_environment: %s\n" % e)

# Configure API key authorization: Bearer
configuration = ct_python.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'

configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = ct_python.CTApi(ct_python.ApiClient(configuration))
body = ct_python.Version() # Version | 
id = 'id_example' # str | 
organization_slug = 'organization_slug_example' # str | 

try:
    api_response = api_instance.update_version(body, id, organization_slug)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling CTApi->update_version: %s\n" % e)

# Configure API key authorization: Bearer
configuration = ct_python.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'

configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = ct_python.CTApi(ct_python.ApiClient(configuration))
file = 'file_example' # file | 
ext = 'ext_example' # str | 
organization_slug = 'organization_slug_example' # str | 

try:
    api_response = api_instance.upload_configuration_file(file, ext, organization_slug)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling CTApi->upload_configuration_file: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://api.configtree.co/*

Method | HTTP request | Description
------------ | ------------- | -------------
[**create_application**](docs/CTApi.md#create_application) | **POST** /v1/{organizationSlug}/applications/ | 
[**create_configuration**](docs/CTApi.md#create_configuration) | **POST** /v1/{organizationSlug}/configurations/ | 
[**create_environment**](docs/CTApi.md#create_environment) | **POST** /v1/{organizationSlug}/environments/ | 
[**create_version**](docs/CTApi.md#create_version) | **POST** /v1/{organizationSlug}/versions/ | 
[**delete_application**](docs/CTApi.md#delete_application) | **DELETE** /v1/{organizationSlug}/applications/{id}/ | 
[**delete_configuration**](docs/CTApi.md#delete_configuration) | **DELETE** /v1/{organizationSlug}/configurations/{id}/ | 
[**delete_environment**](docs/CTApi.md#delete_environment) | **DELETE** /v1/{organizationSlug}/environments/{id}/ | 
[**delete_version**](docs/CTApi.md#delete_version) | **DELETE** /v1/{organizationSlug}/versions/{id}/ | 
[**duplicate_version**](docs/CTApi.md#duplicate_version) | **POST** /v1/{organizationSlug}/versions/{id}/duplicate/ | 
[**get_all_applications**](docs/CTApi.md#get_all_applications) | **GET** /v1/{organizationSlug}/applications/ | 
[**get_application_by_id**](docs/CTApi.md#get_application_by_id) | **GET** /v1/{organizationSlug}/applications/{id}/ | 
[**get_configuration_by_id**](docs/CTApi.md#get_configuration_by_id) | **GET** /v1/{organizationSlug}/configurations/{id}/ | 
[**get_environment_by_id**](docs/CTApi.md#get_environment_by_id) | **GET** /v1/{organizationSlug}/environments/{id}/ | 
[**get_environment_live_version**](docs/CTApi.md#get_environment_live_version) | **GET** /v1/{organizationSlug}/environments/{id}/liveVersion/ | 
[**get_organization_by_slug**](docs/CTApi.md#get_organization_by_slug) | **GET** /v1/{organizationSlug}/ | 
[**get_version**](docs/CTApi.md#get_version) | **GET** /v1/{organizationSlug}/versions/ | 
[**get_version_by_id**](docs/CTApi.md#get_version_by_id) | **GET** /v1/{organizationSlug}/versions/{id}/ | 
[**login**](docs/CTApi.md#login) | **POST** /v1/login/ | 
[**partial_update_application**](docs/CTApi.md#partial_update_application) | **PATCH** /v1/{organizationSlug}/applications/{id}/ | 
[**partial_update_configuration**](docs/CTApi.md#partial_update_configuration) | **PATCH** /v1/{organizationSlug}/configurations/{id}/ | 
[**partial_update_environment**](docs/CTApi.md#partial_update_environment) | **PATCH** /v1/{organizationSlug}/environments/{id}/ | 
[**partial_update_version**](docs/CTApi.md#partial_update_version) | **PATCH** /v1/{organizationSlug}/versions/{id}/ | 
[**refresh_token**](docs/CTApi.md#refresh_token) | **POST** /v1/login/refresh/ | 
[**update_application**](docs/CTApi.md#update_application) | **PUT** /v1/{organizationSlug}/applications/{id}/ | 
[**update_configuration**](docs/CTApi.md#update_configuration) | **PUT** /v1/{organizationSlug}/configurations/{id}/ | 
[**update_environment**](docs/CTApi.md#update_environment) | **PUT** /v1/{organizationSlug}/environments/{id}/ | 
[**update_version**](docs/CTApi.md#update_version) | **PUT** /v1/{organizationSlug}/versions/{id}/ | 
[**upload_configuration_file**](docs/CTApi.md#upload_configuration_file) | **POST** /v1/{organizationSlug}/configurations/upload_config/ | 

## Documentation For Models

 - [Application](docs/Application.md)
 - [Configuration](docs/Configuration.md)
 - [ConfigurationFile](docs/ConfigurationFile.md)
 - [CustomTokenObtainPair](docs/CustomTokenObtainPair.md)
 - [CustomTokenObtainPairResponse](docs/CustomTokenObtainPairResponse.md)
 - [Environment](docs/Environment.md)
 - [Organization](docs/Organization.md)
 - [OrganizationGroup](docs/OrganizationGroup.md)
 - [TokenRefresh](docs/TokenRefresh.md)
 - [TokenUserResponse](docs/TokenUserResponse.md)
 - [Version](docs/Version.md)

## Documentation For Authorization


## Bearer

- **Type**: API key
- **API key parameter name**: Authorization
- **Location**: HTTP header


## Author


