from pygments.lexers import (python, javascript, c_cpp, dotnet, html, shell,
                             css, data, go, jvm, php, ruby, rust, pascal,
                             scripting, perl, objective, jsx, sql, special)

common_langs = {
    "text": special.TextLexer,
    "bash": shell.BashLexer,
    "powershell": shell.PowerShellLexer,
    "python": python.PythonLexer,
    "python2": python.Python2Lexer,
    "cython": python.CythonLexer,
    "googlesql": sql.GoogleSqlLexer,
    "sql": sql.SqlLexer,
    "postgres": sql.PostgresLexer,
    "mysql": sql.MySqlLexer,
    "c": c_cpp.CLexer,
    "cpp": c_cpp.CppLexer,
    "c++": c_cpp.CppLexer,
    "c#": dotnet.CSharpLexer,
    "csharp": dotnet.CSharpLexer,
    "html": html.HtmlLexer,
    "javascript": javascript.JavascriptLexer,
    "xml": html.XmlLexer,
    "css": css.CssLexer,
    "json": data.JsonLexer,
    "yaml": data.YamlLexer,
    "go": go.GoLexer,
    "typescript": javascript.TypeScriptLexer,
    "kotlin": jvm.KotlinLexer,
    "php": php.PhpLexer,
    "ruby": ruby.RubyLexer,
    "rust": rust.RustLexer,
    "lua": scripting.LuaLexer,
    "luau": scripting.LuauLexer,
    "pascal": pascal.DelphiLexer,
    "delphi": pascal.DelphiLexer,
    "applescript": scripting.AppleScriptLexer,
    "java": jvm.JavaLexer,
    "perl": perl.PerlLexer,
    "swift": objective.SwiftLexer,
    "react": jsx.JsxLexer,
}
