# coding: utf-8

"""
    Control-M Services

    Provides access to BMC Control-M Services  # noqa: E501

    OpenAPI spec version: 9.20.215
    Contact: customer_support@bmc.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from clients.ctm_api_client.configuration import Configuration


class RunResult(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {"run_id": "str", "status_uri": "str", "monitor_page_uri": "str"}

    attribute_map = {
        "run_id": "runId",
        "status_uri": "statusURI",
        "monitor_page_uri": "monitorPageURI",
    }

    def __init__(
        self, run_id=None, status_uri=None, monitor_page_uri=None, _configuration=None
    ):  # noqa: E501
        """RunResult - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._run_id = None
        self._status_uri = None
        self._monitor_page_uri = None
        self.discriminator = None

        self.run_id = run_id
        if status_uri is not None:
            self.status_uri = status_uri
        if monitor_page_uri is not None:
            self.monitor_page_uri = monitor_page_uri

    @property
    def run_id(self):
        """Gets the run_id of this RunResult.  # noqa: E501

        An ID that identifies running jobs and can be used to track their status.  # noqa: E501

        :return: The run_id of this RunResult.  # noqa: E501
        :rtype: str
        """
        return self._run_id

    @run_id.setter
    def run_id(self, run_id):
        """Sets the run_id of this RunResult.

        An ID that identifies running jobs and can be used to track their status.  # noqa: E501

        :param run_id: The run_id of this RunResult.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and run_id is None:
            raise ValueError(
                "Invalid value for `run_id`, must not be `None`"
            )  # noqa: E501

        self._run_id = run_id

    @property
    def status_uri(self):
        """Gets the status_uri of this RunResult.  # noqa: E501

        A URI that can be used to get the status of the run jobs.  # noqa: E501

        :return: The status_uri of this RunResult.  # noqa: E501
        :rtype: str
        """
        return self._status_uri

    @status_uri.setter
    def status_uri(self, status_uri):
        """Sets the status_uri of this RunResult.

        A URI that can be used to get the status of the run jobs.  # noqa: E501

        :param status_uri: The status_uri of this RunResult.  # noqa: E501
        :type: str
        """

        self._status_uri = status_uri

    @property
    def monitor_page_uri(self):
        """Gets the monitor_page_uri of this RunResult.  # noqa: E501

        A URI to a page displaying the workflow run live.  # noqa: E501

        :return: The monitor_page_uri of this RunResult.  # noqa: E501
        :rtype: str
        """
        return self._monitor_page_uri

    @monitor_page_uri.setter
    def monitor_page_uri(self, monitor_page_uri):
        """Sets the monitor_page_uri of this RunResult.

        A URI to a page displaying the workflow run live.  # noqa: E501

        :param monitor_page_uri: The monitor_page_uri of this RunResult.  # noqa: E501
        :type: str
        """

        self._monitor_page_uri = monitor_page_uri

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (item[0], item[1].to_dict())
                        if hasattr(item[1], "to_dict")
                        else item,
                        value.items(),
                    )
                )
            else:
                result[attr] = value
        if issubclass(RunResult, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RunResult):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, RunResult):
            return True

        return self.to_dict() != other.to_dict()
