# coding: utf-8

"""
    Control-M Services

    Provides access to BMC Control-M Services  # noqa: E501

    OpenAPI spec version: 9.20.215
    Contact: customer_support@bmc.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from clients.ctm_api_client.api_client import ApiClient


class DeployApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete_calendar(self, calendar_name, **kwargs):  # noqa: E501
        """delete a calendar  # noqa: E501

        Delete a calendar  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_calendar(calendar_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str calendar_name: The name of the calendar to be deleted. (required)
        :param str server: The name of the server in which the calendar deploy.
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.delete_calendar_with_http_info(
                calendar_name, **kwargs
            )  # noqa: E501
        else:
            (data) = self.delete_calendar_with_http_info(
                calendar_name, **kwargs
            )  # noqa: E501
            return data

    def delete_calendar_with_http_info(self, calendar_name, **kwargs):  # noqa: E501
        """delete a calendar  # noqa: E501

        Delete a calendar  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_calendar_with_http_info(calendar_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str calendar_name: The name of the calendar to be deleted. (required)
        :param str server: The name of the server in which the calendar deploy.
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["calendar_name", "server"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_calendar" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'calendar_name' is set
        if self.api_client.client_side_validation and (
            "calendar_name" not in params or params["calendar_name"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `calendar_name` when calling `delete_calendar`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "calendar_name" in params:
            path_params["calendarName"] = params["calendar_name"]  # noqa: E501

        query_params = []
        if "server" in params:
            query_params.append(("server", params["server"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Bearer"]  # noqa: E501

        return self.api_client.call_api(
            "/deploy/calendar/{calendarName}",
            "DELETE",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="SuccessData",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def delete_connection_profile(
        self, server, agent, type, name, **kwargs
    ):  # noqa: E501
        """Delete Local Connection Profile  # noqa: E501

        Delete Local Connection Profile.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_connection_profile(server, agent, type, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server: The name of the Control-M in which the connection profile is deployed. (required)
        :param str agent: The name of the agent the connection profile is deployed on. (required)
        :param str type: The type of connection profile to delete. (required)
        :param str name: Name of the Connection Profile (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.delete_connection_profile_with_http_info(
                server, agent, type, name, **kwargs
            )  # noqa: E501
        else:
            (data) = self.delete_connection_profile_with_http_info(
                server, agent, type, name, **kwargs
            )  # noqa: E501
            return data

    def delete_connection_profile_with_http_info(
        self, server, agent, type, name, **kwargs
    ):  # noqa: E501
        """Delete Local Connection Profile  # noqa: E501

        Delete Local Connection Profile.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_connection_profile_with_http_info(server, agent, type, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server: The name of the Control-M in which the connection profile is deployed. (required)
        :param str agent: The name of the agent the connection profile is deployed on. (required)
        :param str type: The type of connection profile to delete. (required)
        :param str name: Name of the Connection Profile (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["server", "agent", "type", "name"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_connection_profile" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and (
            "server" not in params or params["server"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `server` when calling `delete_connection_profile`"
            )  # noqa: E501
        # verify the required parameter 'agent' is set
        if self.api_client.client_side_validation and (
            "agent" not in params or params["agent"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `agent` when calling `delete_connection_profile`"
            )  # noqa: E501
        # verify the required parameter 'type' is set
        if self.api_client.client_side_validation and (
            "type" not in params or params["type"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `type` when calling `delete_connection_profile`"
            )  # noqa: E501
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and (
            "name" not in params or params["name"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `name` when calling `delete_connection_profile`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "server" in params:
            path_params["server"] = params["server"]  # noqa: E501
        if "agent" in params:
            path_params["agent"] = params["agent"]  # noqa: E501
        if "type" in params:
            path_params["type"] = params["type"]  # noqa: E501
        if "name" in params:
            path_params["name"] = params["name"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Bearer"]  # noqa: E501

        return self.api_client.call_api(
            "/deploy/connectionprofile/{server}/{agent}/{type}/{name}",
            "DELETE",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="SuccessData",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def delete_folder(self, control_m, folder_name, **kwargs):  # noqa: E501
        """delete a folder  # noqa: E501

        Delete a folder  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_folder(control_m, folder_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str control_m: The name of the Control-M in which the folder(s) are deployed. (required)
        :param str folder_name: The name of the required folder(s). (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.delete_folder_with_http_info(
                control_m, folder_name, **kwargs
            )  # noqa: E501
        else:
            (data) = self.delete_folder_with_http_info(
                control_m, folder_name, **kwargs
            )  # noqa: E501
            return data

    def delete_folder_with_http_info(
        self, control_m, folder_name, **kwargs
    ):  # noqa: E501
        """delete a folder  # noqa: E501

        Delete a folder  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_folder_with_http_info(control_m, folder_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str control_m: The name of the Control-M in which the folder(s) are deployed. (required)
        :param str folder_name: The name of the required folder(s). (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["control_m", "folder_name"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_folder" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'control_m' is set
        if self.api_client.client_side_validation and (
            "control_m" not in params or params["control_m"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `control_m` when calling `delete_folder`"
            )  # noqa: E501
        # verify the required parameter 'folder_name' is set
        if self.api_client.client_side_validation and (
            "folder_name" not in params or params["folder_name"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `folder_name` when calling `delete_folder`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "control_m" in params:
            path_params["controlM"] = params["control_m"]  # noqa: E501
        if "folder_name" in params:
            path_params["folderName"] = params["folder_name"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Bearer"]  # noqa: E501

        return self.api_client.call_api(
            "/deploy/folder/{controlM}/{folderName}",
            "DELETE",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="SuccessData",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def delete_local_connection_profile(
        self, server, agent, type, name, **kwargs
    ):  # noqa: E501
        """Delete Local Connection Profile  # noqa: E501

        Delete Local Connection Profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_local_connection_profile(server, agent, type, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server: The name of the Control-M in which the connection profile is deployed. (required)
        :param str agent: The name of the agent the connection profile is deployed on. (required)
        :param str type: The type of connection profile to delete. (required)
        :param str name: Name of the Connection Profile (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.delete_local_connection_profile_with_http_info(
                server, agent, type, name, **kwargs
            )  # noqa: E501
        else:
            (data) = self.delete_local_connection_profile_with_http_info(
                server, agent, type, name, **kwargs
            )  # noqa: E501
            return data

    def delete_local_connection_profile_with_http_info(
        self, server, agent, type, name, **kwargs
    ):  # noqa: E501
        """Delete Local Connection Profile  # noqa: E501

        Delete Local Connection Profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_local_connection_profile_with_http_info(server, agent, type, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server: The name of the Control-M in which the connection profile is deployed. (required)
        :param str agent: The name of the agent the connection profile is deployed on. (required)
        :param str type: The type of connection profile to delete. (required)
        :param str name: Name of the Connection Profile (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["server", "agent", "type", "name"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_local_connection_profile" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and (
            "server" not in params or params["server"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `server` when calling `delete_local_connection_profile`"
            )  # noqa: E501
        # verify the required parameter 'agent' is set
        if self.api_client.client_side_validation and (
            "agent" not in params or params["agent"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `agent` when calling `delete_local_connection_profile`"
            )  # noqa: E501
        # verify the required parameter 'type' is set
        if self.api_client.client_side_validation and (
            "type" not in params or params["type"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `type` when calling `delete_local_connection_profile`"
            )  # noqa: E501
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and (
            "name" not in params or params["name"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `name` when calling `delete_local_connection_profile`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "server" in params:
            path_params["server"] = params["server"]  # noqa: E501
        if "agent" in params:
            path_params["agent"] = params["agent"]  # noqa: E501
        if "type" in params:
            path_params["type"] = params["type"]  # noqa: E501
        if "name" in params:
            path_params["name"] = params["name"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Bearer"]  # noqa: E501

        return self.api_client.call_api(
            "/deploy/connectionprofile/local/{server}/{agent}/{type}/{name}",
            "DELETE",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="SuccessData",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def delete_shared_connection_profile(self, type, name, **kwargs):  # noqa: E501
        """Delete centralized Connection Profile  # noqa: E501

        Delete centralized Connection Profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_shared_connection_profile(type, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str type: The type of connection profile to delete. (required)
        :param str name: Name of the Connection Profile (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.delete_shared_connection_profile_with_http_info(
                type, name, **kwargs
            )  # noqa: E501
        else:
            (data) = self.delete_shared_connection_profile_with_http_info(
                type, name, **kwargs
            )  # noqa: E501
            return data

    def delete_shared_connection_profile_with_http_info(
        self, type, name, **kwargs
    ):  # noqa: E501
        """Delete centralized Connection Profile  # noqa: E501

        Delete centralized Connection Profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_shared_connection_profile_with_http_info(type, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str type: The type of connection profile to delete. (required)
        :param str name: Name of the Connection Profile (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["type", "name"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_shared_connection_profile" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'type' is set
        if self.api_client.client_side_validation and (
            "type" not in params or params["type"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `type` when calling `delete_shared_connection_profile`"
            )  # noqa: E501
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and (
            "name" not in params or params["name"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `name` when calling `delete_shared_connection_profile`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "type" in params:
            path_params["type"] = params["type"]  # noqa: E501
        if "name" in params:
            path_params["name"] = params["name"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Bearer"]  # noqa: E501

        return self.api_client.call_api(
            "/deploy/connectionprofile/centralized/{type}/{name}",
            "DELETE",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="SuccessData",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def deploy_ai_jobtype(self, ctm, agent, job_type_id, **kwargs):  # noqa: E501
        """Deploy of Application Integrator job type.  # noqa: E501

        Deploy an exsiting Application Integrator job type to agent in order to allow it to run  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deploy_ai_jobtype(ctm, agent, job_type_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ctm: (required)
        :param str agent: (required)
        :param str job_type_id: (required)
        :return: AiDeployResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.deploy_ai_jobtype_with_http_info(
                ctm, agent, job_type_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.deploy_ai_jobtype_with_http_info(
                ctm, agent, job_type_id, **kwargs
            )  # noqa: E501
            return data

    def deploy_ai_jobtype_with_http_info(
        self, ctm, agent, job_type_id, **kwargs
    ):  # noqa: E501
        """Deploy of Application Integrator job type.  # noqa: E501

        Deploy an exsiting Application Integrator job type to agent in order to allow it to run  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deploy_ai_jobtype_with_http_info(ctm, agent, job_type_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ctm: (required)
        :param str agent: (required)
        :param str job_type_id: (required)
        :return: AiDeployResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["ctm", "agent", "job_type_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deploy_ai_jobtype" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'ctm' is set
        if self.api_client.client_side_validation and (
            "ctm" not in params or params["ctm"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `ctm` when calling `deploy_ai_jobtype`"
            )  # noqa: E501
        # verify the required parameter 'agent' is set
        if self.api_client.client_side_validation and (
            "agent" not in params or params["agent"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `agent` when calling `deploy_ai_jobtype`"
            )  # noqa: E501
        # verify the required parameter 'job_type_id' is set
        if self.api_client.client_side_validation and (
            "job_type_id" not in params or params["job_type_id"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `job_type_id` when calling `deploy_ai_jobtype`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if "ctm" in params:
            query_params.append(("ctm", params["ctm"]))  # noqa: E501
        if "agent" in params:
            query_params.append(("agent", params["agent"]))  # noqa: E501
        if "job_type_id" in params:
            query_params.append(("jobTypeId", params["job_type_id"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Bearer"]  # noqa: E501

        return self.api_client.call_api(
            "/deploy/ai/jobtype",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="AiDeployResponse",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def deploy_file(self, definitions_file, **kwargs):  # noqa: E501
        """Deploy definitions file  # noqa: E501

        Deploy the provided definition file (JSON, XML or zip) to Control-M  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deploy_file(definitions_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file definitions_file: A file that contains definitions to be deployed to the server. Can be either a JSON definition file, an XML definition file, or a zip file that contains multiple JSON or XML definition files. (required)
        :param file deploy_descriptor_file: Deploy Descriptor JSON file.
        :param file additional_configuration: additionalConfiguration to enable skip testing for local connection profile
        :return: list[DeploymentFileResults]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.deploy_file_with_http_info(
                definitions_file, **kwargs
            )  # noqa: E501
        else:
            (data) = self.deploy_file_with_http_info(
                definitions_file, **kwargs
            )  # noqa: E501
            return data

    def deploy_file_with_http_info(self, definitions_file, **kwargs):  # noqa: E501
        """Deploy definitions file  # noqa: E501

        Deploy the provided definition file (JSON, XML or zip) to Control-M  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deploy_file_with_http_info(definitions_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file definitions_file: A file that contains definitions to be deployed to the server. Can be either a JSON definition file, an XML definition file, or a zip file that contains multiple JSON or XML definition files. (required)
        :param file deploy_descriptor_file: Deploy Descriptor JSON file.
        :param file additional_configuration: additionalConfiguration to enable skip testing for local connection profile
        :return: list[DeploymentFileResults]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = [
            "definitions_file",
            "deploy_descriptor_file",
            "additional_configuration",
        ]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deploy_file" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'definitions_file' is set
        if self.api_client.client_side_validation and (
            "definitions_file" not in params or params["definitions_file"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `definitions_file` when calling `deploy_file`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if "definitions_file" in params:
            local_var_files["definitionsFile"] = params[
                "definitions_file"
            ]  # noqa: E501
        if "deploy_descriptor_file" in params:
            local_var_files["deployDescriptorFile"] = params[
                "deploy_descriptor_file"
            ]  # noqa: E501
        if "additional_configuration" in params:
            local_var_files["additionalConfiguration"] = params[
                "additional_configuration"
            ]  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["multipart/form-data"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Bearer"]  # noqa: E501

        return self.api_client.call_api(
            "/deploy",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="list[DeploymentFileResults]",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def deploy_jobtype_file(self, definitions_file, **kwargs):  # noqa: E501
        """Deploy jobtype  # noqa: E501

        Deploy the provided jobtype to AI server, EM server, and Agent.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deploy_jobtype_file(definitions_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file definitions_file: A .ctmai file that contains definitions of jobtype to be deployed to the server. (required)
        :param file payload_file: A JSON file that contains specifications of an agent.
        :param str agent:
        :param str server:
        :return: DeployJobtypeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.deploy_jobtype_file_with_http_info(
                definitions_file, **kwargs
            )  # noqa: E501
        else:
            (data) = self.deploy_jobtype_file_with_http_info(
                definitions_file, **kwargs
            )  # noqa: E501
            return data

    def deploy_jobtype_file_with_http_info(
        self, definitions_file, **kwargs
    ):  # noqa: E501
        """Deploy jobtype  # noqa: E501

        Deploy the provided jobtype to AI server, EM server, and Agent.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deploy_jobtype_file_with_http_info(definitions_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file definitions_file: A .ctmai file that contains definitions of jobtype to be deployed to the server. (required)
        :param file payload_file: A JSON file that contains specifications of an agent.
        :param str agent:
        :param str server:
        :return: DeployJobtypeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = [
            "definitions_file",
            "payload_file",
            "agent",
            "server",
        ]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deploy_jobtype_file" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'definitions_file' is set
        if self.api_client.client_side_validation and (
            "definitions_file" not in params or params["definitions_file"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `definitions_file` when calling `deploy_jobtype_file`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if "agent" in params:
            query_params.append(("agent", params["agent"]))  # noqa: E501
        if "server" in params:
            query_params.append(("server", params["server"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}
        if "definitions_file" in params:
            local_var_files["definitionsFile"] = params[
                "definitions_file"
            ]  # noqa: E501
        if "payload_file" in params:
            local_var_files["payloadFile"] = params["payload_file"]  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["multipart/form-data"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Bearer"]  # noqa: E501

        return self.api_client.call_api(
            "/deploy/jobtype",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="DeployJobtypeResponse",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_connection_profiles_deployment_status(
        self, type, name, **kwargs
    ):  # noqa: E501
        """Get deployed connection profiles deployment status  # noqa: E501

        Get currently deployed connection profiles deployment status according to the search query as JSON.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_connection_profiles_deployment_status(type, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str type: The type of connection profile such as Database, FileTransfer, Hadoop, Informatica, SAP. (required)
        :param str name: Name of the Connection Profile (required)
        :return: ConnectionProfilesDeploymentStatusResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_connection_profiles_deployment_status_with_http_info(
                type, name, **kwargs
            )  # noqa: E501
        else:
            (data) = self.get_connection_profiles_deployment_status_with_http_info(
                type, name, **kwargs
            )  # noqa: E501
            return data

    def get_connection_profiles_deployment_status_with_http_info(
        self, type, name, **kwargs
    ):  # noqa: E501
        """Get deployed connection profiles deployment status  # noqa: E501

        Get currently deployed connection profiles deployment status according to the search query as JSON.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_connection_profiles_deployment_status_with_http_info(type, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str type: The type of connection profile such as Database, FileTransfer, Hadoop, Informatica, SAP. (required)
        :param str name: Name of the Connection Profile (required)
        :return: ConnectionProfilesDeploymentStatusResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["type", "name"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_connection_profiles_deployment_status" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'type' is set
        if self.api_client.client_side_validation and (
            "type" not in params or params["type"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `type` when calling `get_connection_profiles_deployment_status`"
            )  # noqa: E501
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and (
            "name" not in params or params["name"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `name` when calling `get_connection_profiles_deployment_status`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "type" in params:
            path_params["type"] = params["type"]  # noqa: E501
        if "name" in params:
            path_params["name"] = params["name"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Bearer"]  # noqa: E501

        return self.api_client.call_api(
            "/deploy/connectionprofile/centralized/deploymentstatus/{type}/{name}",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="ConnectionProfilesDeploymentStatusResult",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_deployed_ai_jobtypes(self, **kwargs):  # noqa: E501
        """Get Application Integrator job types  # noqa: E501

        Get deployed Application Integrator job types that match the requested search criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_deployed_ai_jobtypes(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_type_name: Job type display name ( or partial name ) for query. It accepts * as wildcard.
        :param str job_type_id: Job type id ( or partial name ) for query. It accepts * as wildcard.
        :return: AiJobtypeList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_deployed_ai_jobtypes_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_deployed_ai_jobtypes_with_http_info(
                **kwargs
            )  # noqa: E501
            return data

    def get_deployed_ai_jobtypes_with_http_info(self, **kwargs):  # noqa: E501
        """Get Application Integrator job types  # noqa: E501

        Get deployed Application Integrator job types that match the requested search criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_deployed_ai_jobtypes_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str job_type_name: Job type display name ( or partial name ) for query. It accepts * as wildcard.
        :param str job_type_id: Job type id ( or partial name ) for query. It accepts * as wildcard.
        :return: AiJobtypeList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["job_type_name", "job_type_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_deployed_ai_jobtypes" % key
                )
            params[key] = val
        del params["kwargs"]

        collection_formats = {}

        path_params = {}

        query_params = []
        if "job_type_name" in params:
            query_params.append(("jobTypeName", params["job_type_name"]))  # noqa: E501
        if "job_type_id" in params:
            query_params.append(("jobTypeId", params["job_type_id"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Bearer"]  # noqa: E501

        return self.api_client.call_api(
            "/deploy/ai/jobtypes",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="AiJobtypeList",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_deployed_calendars(self, **kwargs):  # noqa: E501
        """Get deployed calendars that match the search criteria.  # noqa: E501

        Get definition of calendars as json code that match the requested search criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_deployed_calendars(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name:
        :param str server:
        :param str type: Calendar type.
        :param str alias: Calendar alias name for z/OS servers.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_deployed_calendars_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_deployed_calendars_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_deployed_calendars_with_http_info(self, **kwargs):  # noqa: E501
        """Get deployed calendars that match the search criteria.  # noqa: E501

        Get definition of calendars as json code that match the requested search criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_deployed_calendars_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name:
        :param str server:
        :param str type: Calendar type.
        :param str alias: Calendar alias name for z/OS servers.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["name", "server", "type", "alias"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_deployed_calendars" % key
                )
            params[key] = val
        del params["kwargs"]

        collection_formats = {}

        path_params = {}

        query_params = []
        if "name" in params:
            query_params.append(("name", params["name"]))  # noqa: E501
        if "server" in params:
            query_params.append(("server", params["server"]))  # noqa: E501
        if "type" in params:
            query_params.append(("type", params["type"]))  # noqa: E501
        if "alias" in params:
            query_params.append(("alias", params["alias"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Bearer"]  # noqa: E501

        return self.api_client.call_api(
            "/deploy/calendars",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="str",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_deployed_connection_profiles(self, agent, type, **kwargs):  # noqa: E501
        """Get local deployed connection profiles  # noqa: E501

        Get currently local deployed connection profiles according to the search query as JSON.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_deployed_connection_profiles(agent, type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str agent: The name of the agent the connection profile is deployed on (required)
        :param str type: The type of connection profile such as Database, FileTransfer, Hadoop, Informatica, SAP. (required)
        :param str ctm: The name of the Control-M in which the connection profile is deployed on
        :param str server: The name of the Control-M in which the connection profile is deployed on
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_deployed_connection_profiles_with_http_info(
                agent, type, **kwargs
            )  # noqa: E501
        else:
            (data) = self.get_deployed_connection_profiles_with_http_info(
                agent, type, **kwargs
            )  # noqa: E501
            return data

    def get_deployed_connection_profiles_with_http_info(
        self, agent, type, **kwargs
    ):  # noqa: E501
        """Get local deployed connection profiles  # noqa: E501

        Get currently local deployed connection profiles according to the search query as JSON.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_deployed_connection_profiles_with_http_info(agent, type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str agent: The name of the agent the connection profile is deployed on (required)
        :param str type: The type of connection profile such as Database, FileTransfer, Hadoop, Informatica, SAP. (required)
        :param str ctm: The name of the Control-M in which the connection profile is deployed on
        :param str server: The name of the Control-M in which the connection profile is deployed on
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["agent", "type", "ctm", "server"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_deployed_connection_profiles" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'agent' is set
        if self.api_client.client_side_validation and (
            "agent" not in params or params["agent"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `agent` when calling `get_deployed_connection_profiles`"
            )  # noqa: E501
        # verify the required parameter 'type' is set
        if self.api_client.client_side_validation and (
            "type" not in params or params["type"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `type` when calling `get_deployed_connection_profiles`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if "ctm" in params:
            query_params.append(("ctm", params["ctm"]))  # noqa: E501
        if "server" in params:
            query_params.append(("server", params["server"]))  # noqa: E501
        if "agent" in params:
            query_params.append(("agent", params["agent"]))  # noqa: E501
        if "type" in params:
            query_params.append(("type", params["type"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Bearer"]  # noqa: E501

        return self.api_client.call_api(
            "/deploy/connectionprofiles",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="str",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_deployed_connection_profiles_status(self, **kwargs):  # noqa: E501
        """Get deployed connection profiles status  # noqa: E501

        Get currently deployed connection profiles status according to the search query as JSON.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_deployed_connection_profiles_status(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: number to limit the returned connection profiles. If missed - get all
        :param str name: conn profile name (support *, ?, and comma, default is * for all).
        :param str type: conn profile type (default is * for accounts from all CMs).
        :return: ConnectionProfilesStatusResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_deployed_connection_profiles_status_with_http_info(
                **kwargs
            )  # noqa: E501
        else:
            (data) = self.get_deployed_connection_profiles_status_with_http_info(
                **kwargs
            )  # noqa: E501
            return data

    def get_deployed_connection_profiles_status_with_http_info(
        self, **kwargs
    ):  # noqa: E501
        """Get deployed connection profiles status  # noqa: E501

        Get currently deployed connection profiles status according to the search query as JSON.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_deployed_connection_profiles_status_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: number to limit the returned connection profiles. If missed - get all
        :param str name: conn profile name (support *, ?, and comma, default is * for all).
        :param str type: conn profile type (default is * for accounts from all CMs).
        :return: ConnectionProfilesStatusResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["limit", "name", "type"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_deployed_connection_profiles_status" % key
                )
            params[key] = val
        del params["kwargs"]

        collection_formats = {}

        path_params = {}

        query_params = []
        if "limit" in params:
            query_params.append(("limit", params["limit"]))  # noqa: E501
        if "name" in params:
            query_params.append(("name", params["name"]))  # noqa: E501
        if "type" in params:
            query_params.append(("type", params["type"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Bearer"]  # noqa: E501

        return self.api_client.call_api(
            "/deploy/connectionprofiles/centralized/status",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="ConnectionProfilesStatusResult",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_deployed_folders_new(self, **kwargs):  # noqa: E501
        """Get deployed jobs that match the search criteria.  # noqa: E501

        Get definition of jobs and folders (in the desired format - JSON or XML) that match the requested search criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_deployed_folders_new(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str format: Output format (json or xml)
        :param str folder:
        :param str ctm:
        :param str server:
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_deployed_folders_new_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_deployed_folders_new_with_http_info(
                **kwargs
            )  # noqa: E501
            return data

    def get_deployed_folders_new_with_http_info(self, **kwargs):  # noqa: E501
        """Get deployed jobs that match the search criteria.  # noqa: E501

        Get definition of jobs and folders (in the desired format - JSON or XML) that match the requested search criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_deployed_folders_new_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str format: Output format (json or xml)
        :param str folder:
        :param str ctm:
        :param str server:
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["format", "folder", "ctm", "server"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_deployed_folders_new" % key
                )
            params[key] = val
        del params["kwargs"]

        collection_formats = {}

        path_params = {}

        query_params = []
        if "format" in params:
            query_params.append(("format", params["format"]))  # noqa: E501
        if "folder" in params:
            query_params.append(("folder", params["folder"]))  # noqa: E501
        if "ctm" in params:
            query_params.append(("ctm", params["ctm"]))  # noqa: E501
        if "server" in params:
            query_params.append(("server", params["server"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Bearer"]  # noqa: E501

        return self.api_client.call_api(
            "/deploy/jobs",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="str",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_local_connection_profiles(self, agent, type, **kwargs):  # noqa: E501
        """Get local deployed connection profiles  # noqa: E501

        Get currently local deployed connection profiles according to the search query as JSON.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_local_connection_profiles(agent, type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str agent: The name of the agent the connection profile is deployed on (required)
        :param str type: The type of connection profile such as Database, FileTransfer, Hadoop, Informatica, SAP. (required)
        :param str ctm: The name of the Control-M in which the connection profile is deployed on
        :param str server: The name of the Control-M in which the connection profile is deployed on
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_local_connection_profiles_with_http_info(
                agent, type, **kwargs
            )  # noqa: E501
        else:
            (data) = self.get_local_connection_profiles_with_http_info(
                agent, type, **kwargs
            )  # noqa: E501
            return data

    def get_local_connection_profiles_with_http_info(
        self, agent, type, **kwargs
    ):  # noqa: E501
        """Get local deployed connection profiles  # noqa: E501

        Get currently local deployed connection profiles according to the search query as JSON.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_local_connection_profiles_with_http_info(agent, type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str agent: The name of the agent the connection profile is deployed on (required)
        :param str type: The type of connection profile such as Database, FileTransfer, Hadoop, Informatica, SAP. (required)
        :param str ctm: The name of the Control-M in which the connection profile is deployed on
        :param str server: The name of the Control-M in which the connection profile is deployed on
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["agent", "type", "ctm", "server"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_local_connection_profiles" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'agent' is set
        if self.api_client.client_side_validation and (
            "agent" not in params or params["agent"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `agent` when calling `get_local_connection_profiles`"
            )  # noqa: E501
        # verify the required parameter 'type' is set
        if self.api_client.client_side_validation and (
            "type" not in params or params["type"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `type` when calling `get_local_connection_profiles`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if "ctm" in params:
            query_params.append(("ctm", params["ctm"]))  # noqa: E501
        if "server" in params:
            query_params.append(("server", params["server"]))  # noqa: E501
        if "agent" in params:
            query_params.append(("agent", params["agent"]))  # noqa: E501
        if "type" in params:
            query_params.append(("type", params["type"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Bearer"]  # noqa: E501

        return self.api_client.call_api(
            "/deploy/connectionprofiles/local",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="str",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_shared_connection_profiles(self, type, **kwargs):  # noqa: E501
        """Get centralized deployed connection profile  # noqa: E501

        Get currently centralized deployed connection profiles according to the search query as JSON.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_shared_connection_profiles(type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str type: The type of connection profile such as Database, FileTransfer, Hadoop, Informatica, SAP. Use * to get all types (required)
        :param str name: The name of centralized connection profile. Supports for *, ?, and comma. By default is *
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_shared_connection_profiles_with_http_info(
                type, **kwargs
            )  # noqa: E501
        else:
            (data) = self.get_shared_connection_profiles_with_http_info(
                type, **kwargs
            )  # noqa: E501
            return data

    def get_shared_connection_profiles_with_http_info(
        self, type, **kwargs
    ):  # noqa: E501
        """Get centralized deployed connection profile  # noqa: E501

        Get currently centralized deployed connection profiles according to the search query as JSON.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_shared_connection_profiles_with_http_info(type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str type: The type of connection profile such as Database, FileTransfer, Hadoop, Informatica, SAP. Use * to get all types (required)
        :param str name: The name of centralized connection profile. Supports for *, ?, and comma. By default is *
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["type", "name"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_shared_connection_profiles" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'type' is set
        if self.api_client.client_side_validation and (
            "type" not in params or params["type"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `type` when calling `get_shared_connection_profiles`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if "type" in params:
            query_params.append(("type", params["type"]))  # noqa: E501
        if "name" in params:
            query_params.append(("name", params["name"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Bearer"]  # noqa: E501

        return self.api_client.call_api(
            "/deploy/connectionprofiles/centralized",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="str",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_site_standard_field_restrictions(
        self, standard_name, field_name, **kwargs
    ):  # noqa: E501
        """Get the allowed values for the specified field in the specified site standard.  # noqa: E501

        Get the allowed values for the specified field in the specified site standard.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_site_standard_field_restrictions(standard_name, field_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str standard_name: (required)
        :param str field_name: (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_site_standard_field_restrictions_with_http_info(
                standard_name, field_name, **kwargs
            )  # noqa: E501
        else:
            (data) = self.get_site_standard_field_restrictions_with_http_info(
                standard_name, field_name, **kwargs
            )  # noqa: E501
            return data

    def get_site_standard_field_restrictions_with_http_info(
        self, standard_name, field_name, **kwargs
    ):  # noqa: E501
        """Get the allowed values for the specified field in the specified site standard.  # noqa: E501

        Get the allowed values for the specified field in the specified site standard.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_site_standard_field_restrictions_with_http_info(standard_name, field_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str standard_name: (required)
        :param str field_name: (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["standard_name", "field_name"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_site_standard_field_restrictions" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'standard_name' is set
        if self.api_client.client_side_validation and (
            "standard_name" not in params or params["standard_name"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `standard_name` when calling `get_site_standard_field_restrictions`"
            )  # noqa: E501
        # verify the required parameter 'field_name' is set
        if self.api_client.client_side_validation and (
            "field_name" not in params or params["field_name"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `field_name` when calling `get_site_standard_field_restrictions`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "standard_name" in params:
            path_params["standardName"] = params["standard_name"]  # noqa: E501
        if "field_name" in params:
            path_params["fieldName"] = params["field_name"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Bearer"]  # noqa: E501

        return self.api_client.call_api(
            "/deploy/sitestandard/{standardName}/fieldRestriction/{fieldName}",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="str",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def set_site_standard_field_restrictions(
        self, standard_name, field_name, values_file, **kwargs
    ):  # noqa: E501
        """Replace the allowed values for the specified field in the specified site standard.  # noqa: E501

        Replace the allowed values for the specified field in the specified site standard.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_site_standard_field_restrictions(standard_name, field_name, values_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str standard_name: (required)
        :param str field_name: (required)
        :param FieldValues values_file: The JSON file with the allowed values (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.set_site_standard_field_restrictions_with_http_info(
                standard_name, field_name, values_file, **kwargs
            )  # noqa: E501
        else:
            (data) = self.set_site_standard_field_restrictions_with_http_info(
                standard_name, field_name, values_file, **kwargs
            )  # noqa: E501
            return data

    def set_site_standard_field_restrictions_with_http_info(
        self, standard_name, field_name, values_file, **kwargs
    ):  # noqa: E501
        """Replace the allowed values for the specified field in the specified site standard.  # noqa: E501

        Replace the allowed values for the specified field in the specified site standard.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_site_standard_field_restrictions_with_http_info(standard_name, field_name, values_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str standard_name: (required)
        :param str field_name: (required)
        :param FieldValues values_file: The JSON file with the allowed values (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["standard_name", "field_name", "values_file"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_site_standard_field_restrictions" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'standard_name' is set
        if self.api_client.client_side_validation and (
            "standard_name" not in params or params["standard_name"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `standard_name` when calling `set_site_standard_field_restrictions`"
            )  # noqa: E501
        # verify the required parameter 'field_name' is set
        if self.api_client.client_side_validation and (
            "field_name" not in params or params["field_name"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `field_name` when calling `set_site_standard_field_restrictions`"
            )  # noqa: E501
        # verify the required parameter 'values_file' is set
        if self.api_client.client_side_validation and (
            "values_file" not in params or params["values_file"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `values_file` when calling `set_site_standard_field_restrictions`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "standard_name" in params:
            path_params["standardName"] = params["standard_name"]  # noqa: E501
        if "field_name" in params:
            path_params["fieldName"] = params["field_name"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "values_file" in params:
            body_params = params["values_file"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Bearer"]  # noqa: E501

        return self.api_client.call_api(
            "/deploy/sitestandard/{standardName}/fieldRestriction/{fieldName}",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="SuccessData",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def test_connection_profile(self, definitions_file, **kwargs):  # noqa: E501
        """Test connection profile on agent  # noqa: E501

        Test connection profile on agent  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.test_connection_profile(definitions_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file definitions_file: A file that contains definitions of the connection profile to be tested (required)
        :param str ctm:
        :param str agent:
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.test_connection_profile_with_http_info(
                definitions_file, **kwargs
            )  # noqa: E501
        else:
            (data) = self.test_connection_profile_with_http_info(
                definitions_file, **kwargs
            )  # noqa: E501
            return data

    def test_connection_profile_with_http_info(
        self, definitions_file, **kwargs
    ):  # noqa: E501
        """Test connection profile on agent  # noqa: E501

        Test connection profile on agent  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.test_connection_profile_with_http_info(definitions_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file definitions_file: A file that contains definitions of the connection profile to be tested (required)
        :param str ctm:
        :param str agent:
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["definitions_file", "ctm", "agent"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method test_connection_profile" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'definitions_file' is set
        if self.api_client.client_side_validation and (
            "definitions_file" not in params or params["definitions_file"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `definitions_file` when calling `test_connection_profile`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if "ctm" in params:
            query_params.append(("ctm", params["ctm"]))  # noqa: E501
        if "agent" in params:
            query_params.append(("agent", params["agent"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}
        if "definitions_file" in params:
            local_var_files["definitionsFile"] = params[
                "definitions_file"
            ]  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["multipart/form-data"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Bearer"]  # noqa: E501

        return self.api_client.call_api(
            "/deploy/connectionprofile/test",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="SuccessData",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def transform_file(
        self, definitions_file, deploy_descriptor_file, **kwargs
    ):  # noqa: E501
        """Transform a definitions file  # noqa: E501

        Transform the provided definitions file (JSON) according to the provided Deploy Descriptor file (JSON).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.transform_file(definitions_file, deploy_descriptor_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file definitions_file: A file that contains definitions to be deployed to the server. Can be either a JSON definition file, an XML definition file, or a zip file that contains multiple JSON or XML definition files. (required)
        :param file deploy_descriptor_file: Deploy Descriptor JSON file. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.transform_file_with_http_info(
                definitions_file, deploy_descriptor_file, **kwargs
            )  # noqa: E501
        else:
            (data) = self.transform_file_with_http_info(
                definitions_file, deploy_descriptor_file, **kwargs
            )  # noqa: E501
            return data

    def transform_file_with_http_info(
        self, definitions_file, deploy_descriptor_file, **kwargs
    ):  # noqa: E501
        """Transform a definitions file  # noqa: E501

        Transform the provided definitions file (JSON) according to the provided Deploy Descriptor file (JSON).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.transform_file_with_http_info(definitions_file, deploy_descriptor_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file definitions_file: A file that contains definitions to be deployed to the server. Can be either a JSON definition file, an XML definition file, or a zip file that contains multiple JSON or XML definition files. (required)
        :param file deploy_descriptor_file: Deploy Descriptor JSON file. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["definitions_file", "deploy_descriptor_file"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method transform_file" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'definitions_file' is set
        if self.api_client.client_side_validation and (
            "definitions_file" not in params or params["definitions_file"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `definitions_file` when calling `transform_file`"
            )  # noqa: E501
        # verify the required parameter 'deploy_descriptor_file' is set
        if self.api_client.client_side_validation and (
            "deploy_descriptor_file" not in params
            or params["deploy_descriptor_file"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `deploy_descriptor_file` when calling `transform_file`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if "definitions_file" in params:
            local_var_files["definitionsFile"] = params[
                "definitions_file"
            ]  # noqa: E501
        if "deploy_descriptor_file" in params:
            local_var_files["deployDescriptorFile"] = params[
                "deploy_descriptor_file"
            ]  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["multipart/form-data"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Bearer"]  # noqa: E501

        return self.api_client.call_api(
            "/deploy/transform",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="str",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )
