# coding: utf-8

"""
    Control-M Services

    Provides access to BMC Control-M Services  # noqa: E501

    OpenAPI spec version: 9.20.215
    Contact: customer_support@bmc.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from clients.ctm_api_client.api_client import ApiClient


class ProvisionApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def cancel_upgrade_activity(self, upgrade_id, **kwargs):  # noqa: E501
        """Cancel upgrade activity  # noqa: E501

        Cancel upgrade activity  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel_upgrade_activity(upgrade_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str upgrade_id: Id of upgrade to cancel (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.cancel_upgrade_activity_with_http_info(
                upgrade_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.cancel_upgrade_activity_with_http_info(
                upgrade_id, **kwargs
            )  # noqa: E501
            return data

    def cancel_upgrade_activity_with_http_info(
        self, upgrade_id, **kwargs
    ):  # noqa: E501
        """Cancel upgrade activity  # noqa: E501

        Cancel upgrade activity  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel_upgrade_activity_with_http_info(upgrade_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str upgrade_id: Id of upgrade to cancel (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["upgrade_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cancel_upgrade_activity" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'upgrade_id' is set
        if self.api_client.client_side_validation and (
            "upgrade_id" not in params or params["upgrade_id"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `upgrade_id` when calling `cancel_upgrade_activity`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "upgrade_id" in params:
            path_params["upgradeId"] = params["upgrade_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Bearer"]  # noqa: E501

        return self.api_client.call_api(
            "/provision/upgrade/{upgradeId}/cancel",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="SuccessData",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def delete_upgrade_activity(self, upgrade_id, **kwargs):  # noqa: E501
        """Delete upgrade activity status for specific upgrade id.  # noqa: E501

        Delete upgrade activity status for specific upgrade id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_upgrade_activity(upgrade_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str upgrade_id: The upgrade id. (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.delete_upgrade_activity_with_http_info(
                upgrade_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.delete_upgrade_activity_with_http_info(
                upgrade_id, **kwargs
            )  # noqa: E501
            return data

    def delete_upgrade_activity_with_http_info(
        self, upgrade_id, **kwargs
    ):  # noqa: E501
        """Delete upgrade activity status for specific upgrade id.  # noqa: E501

        Delete upgrade activity status for specific upgrade id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_upgrade_activity_with_http_info(upgrade_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str upgrade_id: The upgrade id. (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["upgrade_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_upgrade_activity" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'upgrade_id' is set
        if self.api_client.client_side_validation and (
            "upgrade_id" not in params or params["upgrade_id"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `upgrade_id` when calling `delete_upgrade_activity`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "upgrade_id" in params:
            path_params["upgradeId"] = params["upgrade_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Bearer"]  # noqa: E501

        return self.api_client.call_api(
            "/provision/upgrade/{upgradeId}",
            "DELETE",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="SuccessData",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_all_upgrade_activities_status(self, **kwargs):  # noqa: E501
        """Get all upgrade activities status.  # noqa: E501

        Get all upgrade activities status.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_upgrade_activities_status(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ctm: The Control-M server name
        :param str server: The Control-M server name
        :param str agent: The Control-M Agent name
        :param str from_version: Current product version
        :param str to_version: Upgrade to version
        :param str activity: Activity type (Install, Uninstall)
        :param str status: Upgrade activity status (Cancel, Running, Completed, TransferCompleted, Failed, Unavailable)
        :param str activity_name: Name of the upgrade activity
        :return: UpgradeRecordList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_all_upgrade_activities_status_with_http_info(
                **kwargs
            )  # noqa: E501
        else:
            (data) = self.get_all_upgrade_activities_status_with_http_info(
                **kwargs
            )  # noqa: E501
            return data

    def get_all_upgrade_activities_status_with_http_info(self, **kwargs):  # noqa: E501
        """Get all upgrade activities status.  # noqa: E501

        Get all upgrade activities status.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_upgrade_activities_status_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ctm: The Control-M server name
        :param str server: The Control-M server name
        :param str agent: The Control-M Agent name
        :param str from_version: Current product version
        :param str to_version: Upgrade to version
        :param str activity: Activity type (Install, Uninstall)
        :param str status: Upgrade activity status (Cancel, Running, Completed, TransferCompleted, Failed, Unavailable)
        :param str activity_name: Name of the upgrade activity
        :return: UpgradeRecordList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = [
            "ctm",
            "server",
            "agent",
            "from_version",
            "to_version",
            "activity",
            "status",
            "activity_name",
        ]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_upgrade_activities_status" % key
                )
            params[key] = val
        del params["kwargs"]

        collection_formats = {}

        path_params = {}

        query_params = []
        if "ctm" in params:
            query_params.append(("ctm", params["ctm"]))  # noqa: E501
        if "server" in params:
            query_params.append(("server", params["server"]))  # noqa: E501
        if "agent" in params:
            query_params.append(("agent", params["agent"]))  # noqa: E501
        if "from_version" in params:
            query_params.append(("fromVersion", params["from_version"]))  # noqa: E501
        if "to_version" in params:
            query_params.append(("toVersion", params["to_version"]))  # noqa: E501
        if "activity" in params:
            query_params.append(("activity", params["activity"]))  # noqa: E501
        if "status" in params:
            query_params.append(("status", params["status"]))  # noqa: E501
        if "activity_name" in params:
            query_params.append(("activityName", params["activity_name"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Bearer"]  # noqa: E501

        return self.api_client.call_api(
            "/provision/upgrades",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="UpgradeRecordList",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_deploy_versions(self, **kwargs):  # noqa: E501
        """Get available versions for upgrade.  # noqa: E501

        Get available versions for upgrade  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_deploy_versions(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[UpgradeInfo]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_deploy_versions_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_deploy_versions_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_deploy_versions_with_http_info(self, **kwargs):  # noqa: E501
        """Get available versions for upgrade.  # noqa: E501

        Get available versions for upgrade  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_deploy_versions_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[UpgradeInfo]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_deploy_versions" % key
                )
            params[key] = val
        del params["kwargs"]

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Bearer"]  # noqa: E501

        return self.api_client.call_api(
            "/provision/upgrades/versions",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="list[UpgradeInfo]",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_eligible_agents_for_upgrade(self, **kwargs):  # noqa: E501
        """Get eligible agents for upgrade that match the requested search criteria.  # noqa: E501

        Get eligible agents for upgrade that match the requested search criteria from Control-M server.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_eligible_agents_for_upgrade(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str type: The type (Agent, MFT, AppPack).
        :param str version: The version.
        :return: UpgradeAgentInfoList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_eligible_agents_for_upgrade_with_http_info(
                **kwargs
            )  # noqa: E501
        else:
            (data) = self.get_eligible_agents_for_upgrade_with_http_info(
                **kwargs
            )  # noqa: E501
            return data

    def get_eligible_agents_for_upgrade_with_http_info(self, **kwargs):  # noqa: E501
        """Get eligible agents for upgrade that match the requested search criteria.  # noqa: E501

        Get eligible agents for upgrade that match the requested search criteria from Control-M server.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_eligible_agents_for_upgrade_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str type: The type (Agent, MFT, AppPack).
        :param str version: The version.
        :return: UpgradeAgentInfoList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["type", "version"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_eligible_agents_for_upgrade" % key
                )
            params[key] = val
        del params["kwargs"]

        collection_formats = {}

        path_params = {}

        query_params = []
        if "type" in params:
            query_params.append(("type", params["type"]))  # noqa: E501
        if "version" in params:
            query_params.append(("version", params["version"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Bearer"]  # noqa: E501

        return self.api_client.call_api(
            "/provision/upgrades/agents",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="UpgradeAgentInfoList",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_images(self, os, **kwargs):  # noqa: E501
        """get list of available images for the requested OS  # noqa: E501

        Get a list of the images in the system for the requested OS.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_images(os, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str os: The OS name of the requested images. (required)
        :param str version: filter according to specific version.
        :return: StringListResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_images_with_http_info(os, **kwargs)  # noqa: E501
        else:
            (data) = self.get_images_with_http_info(os, **kwargs)  # noqa: E501
            return data

    def get_images_with_http_info(self, os, **kwargs):  # noqa: E501
        """get list of available images for the requested OS  # noqa: E501

        Get a list of the images in the system for the requested OS.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_images_with_http_info(os, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str os: The OS name of the requested images. (required)
        :param str version: filter according to specific version.
        :return: StringListResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["os", "version"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_images" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'os' is set
        if self.api_client.client_side_validation and (
            "os" not in params or params["os"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `os` when calling `get_images`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "os" in params:
            path_params["os"] = params["os"]  # noqa: E501

        query_params = []
        if "version" in params:
            query_params.append(("version", params["version"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Bearer"]  # noqa: E501

        return self.api_client.call_api(
            "/provision/images/{os}",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="StringListResult",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_upgrade_activity_log(self, upgrade_id, **kwargs):  # noqa: E501
        """Returns log of upgrade activity.  # noqa: E501

        Returns log of upgrade activity  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_upgrade_activity_log(upgrade_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str upgrade_id: The upgrade id. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_upgrade_activity_log_with_http_info(
                upgrade_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.get_upgrade_activity_log_with_http_info(
                upgrade_id, **kwargs
            )  # noqa: E501
            return data

    def get_upgrade_activity_log_with_http_info(
        self, upgrade_id, **kwargs
    ):  # noqa: E501
        """Returns log of upgrade activity.  # noqa: E501

        Returns log of upgrade activity  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_upgrade_activity_log_with_http_info(upgrade_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str upgrade_id: The upgrade id. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["upgrade_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_upgrade_activity_log" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'upgrade_id' is set
        if self.api_client.client_side_validation and (
            "upgrade_id" not in params or params["upgrade_id"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `upgrade_id` when calling `get_upgrade_activity_log`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "upgrade_id" in params:
            path_params["upgradeId"] = params["upgrade_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "text/plain"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Bearer"]  # noqa: E501

        return self.api_client.call_api(
            "/provision/upgrade/{upgradeId}/output",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="str",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_upgrade_activity_status_per_upgrade_id(
        self, upgrade_id, **kwargs
    ):  # noqa: E501
        """Get upgrade activity status for specific upgrade id.  # noqa: E501

        Get upgrade activity status for specific upgrade id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_upgrade_activity_status_per_upgrade_id(upgrade_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str upgrade_id: The upgrade id. (required)
        :return: UpgradeRecord
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_upgrade_activity_status_per_upgrade_id_with_http_info(
                upgrade_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.get_upgrade_activity_status_per_upgrade_id_with_http_info(
                upgrade_id, **kwargs
            )  # noqa: E501
            return data

    def get_upgrade_activity_status_per_upgrade_id_with_http_info(
        self, upgrade_id, **kwargs
    ):  # noqa: E501
        """Get upgrade activity status for specific upgrade id.  # noqa: E501

        Get upgrade activity status for specific upgrade id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_upgrade_activity_status_per_upgrade_id_with_http_info(upgrade_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str upgrade_id: The upgrade id. (required)
        :return: UpgradeRecord
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["upgrade_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_upgrade_activity_status_per_upgrade_id" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'upgrade_id' is set
        if self.api_client.client_side_validation and (
            "upgrade_id" not in params or params["upgrade_id"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `upgrade_id` when calling `get_upgrade_activity_status_per_upgrade_id`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "upgrade_id" in params:
            path_params["upgradeId"] = params["upgrade_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Bearer"]  # noqa: E501

        return self.api_client.call_api(
            "/provision/upgrade/{upgradeId}",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="UpgradeRecord",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def retry_upgrade_activity(self, upgrade_id, **kwargs):  # noqa: E501
        """Retry upgrade activity  # noqa: E501

        Retry upgrade activity  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.retry_upgrade_activity(upgrade_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str upgrade_id: Id of upgrade to retry (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.retry_upgrade_activity_with_http_info(
                upgrade_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.retry_upgrade_activity_with_http_info(
                upgrade_id, **kwargs
            )  # noqa: E501
            return data

    def retry_upgrade_activity_with_http_info(self, upgrade_id, **kwargs):  # noqa: E501
        """Retry upgrade activity  # noqa: E501

        Retry upgrade activity  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.retry_upgrade_activity_with_http_info(upgrade_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str upgrade_id: Id of upgrade to retry (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["upgrade_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method retry_upgrade_activity" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'upgrade_id' is set
        if self.api_client.client_side_validation and (
            "upgrade_id" not in params or params["upgrade_id"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `upgrade_id` when calling `retry_upgrade_activity`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "upgrade_id" in params:
            path_params["upgradeId"] = params["upgrade_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Bearer"]  # noqa: E501

        return self.api_client.call_api(
            "/provision/upgrade/{upgradeId}/retry",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="SuccessData",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def transfer_and_install_product(self, upgrade_request, **kwargs):  # noqa: E501
        """Transfer and install a product on an agent  # noqa: E501

        Transfer and install a product on an agent  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.transfer_and_install_product(upgrade_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UpgradeRequest upgrade_request: Upgrade request details (required)
        :return: UpgradeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.transfer_and_install_product_with_http_info(
                upgrade_request, **kwargs
            )  # noqa: E501
        else:
            (data) = self.transfer_and_install_product_with_http_info(
                upgrade_request, **kwargs
            )  # noqa: E501
            return data

    def transfer_and_install_product_with_http_info(
        self, upgrade_request, **kwargs
    ):  # noqa: E501
        """Transfer and install a product on an agent  # noqa: E501

        Transfer and install a product on an agent  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.transfer_and_install_product_with_http_info(upgrade_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UpgradeRequest upgrade_request: Upgrade request details (required)
        :return: UpgradeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["upgrade_request"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method transfer_and_install_product" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'upgrade_request' is set
        if self.api_client.client_side_validation and (
            "upgrade_request" not in params or params["upgrade_request"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `upgrade_request` when calling `transfer_and_install_product`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "upgrade_request" in params:
            body_params = params["upgrade_request"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Bearer"]  # noqa: E501

        return self.api_client.call_api(
            "/provision/upgrade/install",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="UpgradeResponse",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def uninstall_product(self, rollback_request, **kwargs):  # noqa: E501
        """Uninstall a product from an agent  # noqa: E501

        Uninstall a product from an agent  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.uninstall_product(rollback_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UpgradeRequest rollback_request: Rollback request details (required)
        :return: UpgradeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.uninstall_product_with_http_info(
                rollback_request, **kwargs
            )  # noqa: E501
        else:
            (data) = self.uninstall_product_with_http_info(
                rollback_request, **kwargs
            )  # noqa: E501
            return data

    def uninstall_product_with_http_info(
        self, rollback_request, **kwargs
    ):  # noqa: E501
        """Uninstall a product from an agent  # noqa: E501

        Uninstall a product from an agent  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.uninstall_product_with_http_info(rollback_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UpgradeRequest rollback_request: Rollback request details (required)
        :return: UpgradeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["rollback_request"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method uninstall_product" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'rollback_request' is set
        if self.api_client.client_side_validation and (
            "rollback_request" not in params or params["rollback_request"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `rollback_request` when calling `uninstall_product`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "rollback_request" in params:
            body_params = params["rollback_request"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Bearer"]  # noqa: E501

        return self.api_client.call_api(
            "/provision/upgrade/uninstall",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="UpgradeResponse",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )
