# coding: utf-8

"""
    Control-M Services

    Provides access to BMC Control-M Services  # noqa: E501

    OpenAPI spec version: 9.20.30
    Contact: customer_support@bmc.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from clients.ctm_saas_client.api_client import ApiClient


class ConfigApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_host_to_hostgroup(self, server, hostgroup, agent, **kwargs):  # noqa: E501
        """add agent to hostgroup  # noqa: E501

        Add an agent to hostgroup. Create the the hostgroup if it does not exist.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_host_to_hostgroup(server, hostgroup, agent, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server: The Server the hostgroup belongs to. (required)
        :param str hostgroup: The hostgroup name (required)
        :param AgentInHostgroup agent: The hostname of the new agent (required)
        :return: AgentsInGroupSuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_host_to_hostgroup_with_http_info(server, hostgroup, agent, **kwargs)  # noqa: E501
        else:
            (data) = self.add_host_to_hostgroup_with_http_info(server, hostgroup, agent, **kwargs)  # noqa: E501
            return data

    def add_host_to_hostgroup_with_http_info(self, server, hostgroup, agent, **kwargs):  # noqa: E501
        """add agent to hostgroup  # noqa: E501

        Add an agent to hostgroup. Create the the hostgroup if it does not exist.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_host_to_hostgroup_with_http_info(server, hostgroup, agent, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server: The Server the hostgroup belongs to. (required)
        :param str hostgroup: The hostgroup name (required)
        :param AgentInHostgroup agent: The hostname of the new agent (required)
        :return: AgentsInGroupSuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['server', 'hostgroup', 'agent']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_host_to_hostgroup" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in params or
                                                       params['server'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `server` when calling `add_host_to_hostgroup`")  # noqa: E501
        # verify the required parameter 'hostgroup' is set
        if self.api_client.client_side_validation and ('hostgroup' not in params or
                                                       params['hostgroup'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `hostgroup` when calling `add_host_to_hostgroup`")  # noqa: E501
        # verify the required parameter 'agent' is set
        if self.api_client.client_side_validation and ('agent' not in params or
                                                       params['agent'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `agent` when calling `add_host_to_hostgroup`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in params:
            path_params['server'] = params['server']  # noqa: E501
        if 'hostgroup' in params:
            path_params['hostgroup'] = params['hostgroup']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'agent' in params:
            body_params = params['agent']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/config/server/{server}/hostgroup/{hostgroup}/agent', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AgentsInGroupSuccessData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_pgp_template(self, server, agent, template_name, pgp_template_data, **kwargs):  # noqa: E501
        """Add PGP Template  # noqa: E501

        Add PGP Template  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_pgp_template(server, agent, template_name, pgp_template_data, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server: The Server (required)
        :param str agent: The Agent (required)
        :param str template_name: The PGP Template Name (required)
        :param PgpTemplateData pgp_template_data: PGP Template Data (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_pgp_template_with_http_info(server, agent, template_name, pgp_template_data, **kwargs)  # noqa: E501
        else:
            (data) = self.add_pgp_template_with_http_info(server, agent, template_name, pgp_template_data, **kwargs)  # noqa: E501
            return data

    def add_pgp_template_with_http_info(self, server, agent, template_name, pgp_template_data, **kwargs):  # noqa: E501
        """Add PGP Template  # noqa: E501

        Add PGP Template  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_pgp_template_with_http_info(server, agent, template_name, pgp_template_data, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server: The Server (required)
        :param str agent: The Agent (required)
        :param str template_name: The PGP Template Name (required)
        :param PgpTemplateData pgp_template_data: PGP Template Data (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['server', 'agent', 'template_name', 'pgp_template_data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_pgp_template" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in params or
                                                       params['server'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `server` when calling `add_pgp_template`")  # noqa: E501
        # verify the required parameter 'agent' is set
        if self.api_client.client_side_validation and ('agent' not in params or
                                                       params['agent'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `agent` when calling `add_pgp_template`")  # noqa: E501
        # verify the required parameter 'template_name' is set
        if self.api_client.client_side_validation and ('template_name' not in params or
                                                       params['template_name'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `template_name` when calling `add_pgp_template`")  # noqa: E501
        # verify the required parameter 'pgp_template_data' is set
        if self.api_client.client_side_validation and ('pgp_template_data' not in params or
                                                       params['pgp_template_data'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `pgp_template_data` when calling `add_pgp_template`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in params:
            path_params['server'] = params['server']  # noqa: E501
        if 'agent' in params:
            path_params['agent'] = params['agent']  # noqa: E501
        if 'template_name' in params:
            path_params['templateName'] = params['template_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'pgp_template_data' in params:
            body_params = params['pgp_template_data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/config/server/{server}/agent/{agent}/mft/pgptemplate/{templateName}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_role(self, role_file, **kwargs):  # noqa: E501
        """Add Authorization Role  # noqa: E501

        Add Authorization Role  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_role(role_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file role_file: File with contenet of Role Data. (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_role_with_http_info(role_file, **kwargs)  # noqa: E501
        else:
            (data) = self.add_role_with_http_info(role_file, **kwargs)  # noqa: E501
            return data

    def add_role_with_http_info(self, role_file, **kwargs):  # noqa: E501
        """Add Authorization Role  # noqa: E501

        Add Authorization Role  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_role_with_http_info(role_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file role_file: File with contenet of Role Data. (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['role_file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_role" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'role_file' is set
        if self.api_client.client_side_validation and ('role_file' not in params or
                                                       params['role_file'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `role_file` when calling `add_role`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'role_file' in params:
            local_var_files['roleFile'] = params['role_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/config/authorization/role', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_role_to_ldap_group(self, ldapgroup, role, **kwargs):  # noqa: E501
        """Add a role to LDAP group  # noqa: E501

        Add a role to LDAP group so any user belong to the LDAP group will get all permissions defined in the role  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_role_to_ldap_group(ldapgroup, role, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ldapgroup: Name of LDAP group (required)
        :param str role: Name of role (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_role_to_ldap_group_with_http_info(ldapgroup, role, **kwargs)  # noqa: E501
        else:
            (data) = self.add_role_to_ldap_group_with_http_info(ldapgroup, role, **kwargs)  # noqa: E501
            return data

    def add_role_to_ldap_group_with_http_info(self, ldapgroup, role, **kwargs):  # noqa: E501
        """Add a role to LDAP group  # noqa: E501

        Add a role to LDAP group so any user belong to the LDAP group will get all permissions defined in the role  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_role_to_ldap_group_with_http_info(ldapgroup, role, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ldapgroup: Name of LDAP group (required)
        :param str role: Name of role (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ldapgroup', 'role']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_role_to_ldap_group" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ldapgroup' is set
        if self.api_client.client_side_validation and ('ldapgroup' not in params or
                                                       params['ldapgroup'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `ldapgroup` when calling `add_role_to_ldap_group`")  # noqa: E501
        # verify the required parameter 'role' is set
        if self.api_client.client_side_validation and ('role' not in params or
                                                       params['role'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `role` when calling `add_role_to_ldap_group`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ldapgroup' in params:
            path_params['ldapgroup'] = params['ldapgroup']  # noqa: E501
        if 'role' in params:
            path_params['role'] = params['role']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/config/authorization/ldap/{ldapgroup}/role/{role}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_secret(self, name_value, **kwargs):  # noqa: E501
        """Add a new secret  # noqa: E501

        Add a new secret to the secrets vault.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_secret(name_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SecretKeyValue name_value: The new secret value (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_secret_with_http_info(name_value, **kwargs)  # noqa: E501
        else:
            (data) = self.add_secret_with_http_info(name_value, **kwargs)  # noqa: E501
            return data

    def add_secret_with_http_info(self, name_value, **kwargs):  # noqa: E501
        """Add a new secret  # noqa: E501

        Add a new secret to the secrets vault.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_secret_with_http_info(name_value, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SecretKeyValue name_value: The new secret value (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name_value']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_secret" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name_value' is set
        if self.api_client.client_side_validation and ('name_value' not in params or
                                                       params['name_value'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `name_value` when calling `add_secret`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'name_value' in params:
            body_params = params['name_value']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/config/secret', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_user(self, user_file, **kwargs):  # noqa: E501
        """Add user  # noqa: E501

        Add user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_user(user_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file user_file: File with contenet of user data. (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_user_with_http_info(user_file, **kwargs)  # noqa: E501
        else:
            (data) = self.add_user_with_http_info(user_file, **kwargs)  # noqa: E501
            return data

    def add_user_with_http_info(self, user_file, **kwargs):  # noqa: E501
        """Add user  # noqa: E501

        Add user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_user_with_http_info(user_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file user_file: File with contenet of user data. (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_user" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'user_file' is set
        if self.api_client.client_side_validation and ('user_file' not in params or
                                                       params['user_file'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `user_file` when calling `add_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'user_file' in params:
            local_var_files['userFile'] = params['user_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/config/authorization/user', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_zos_template(self, server, agent, template_name, zos_template_data, **kwargs):  # noqa: E501
        """Add z/OS Template  # noqa: E501

        Add z/OS Template  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_zos_template(server, agent, template_name, zos_template_data, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server: The Server (required)
        :param str agent: The Agent (required)
        :param str template_name: The z/OS Template Name (required)
        :param ZosTemplateData zos_template_data: z/OS Template Data (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_zos_template_with_http_info(server, agent, template_name, zos_template_data, **kwargs)  # noqa: E501
        else:
            (data) = self.add_zos_template_with_http_info(server, agent, template_name, zos_template_data, **kwargs)  # noqa: E501
            return data

    def add_zos_template_with_http_info(self, server, agent, template_name, zos_template_data, **kwargs):  # noqa: E501
        """Add z/OS Template  # noqa: E501

        Add z/OS Template  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_zos_template_with_http_info(server, agent, template_name, zos_template_data, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server: The Server (required)
        :param str agent: The Agent (required)
        :param str template_name: The z/OS Template Name (required)
        :param ZosTemplateData zos_template_data: z/OS Template Data (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['server', 'agent', 'template_name', 'zos_template_data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_zos_template" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in params or
                                                       params['server'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `server` when calling `add_zos_template`")  # noqa: E501
        # verify the required parameter 'agent' is set
        if self.api_client.client_side_validation and ('agent' not in params or
                                                       params['agent'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `agent` when calling `add_zos_template`")  # noqa: E501
        # verify the required parameter 'template_name' is set
        if self.api_client.client_side_validation and ('template_name' not in params or
                                                       params['template_name'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `template_name` when calling `add_zos_template`")  # noqa: E501
        # verify the required parameter 'zos_template_data' is set
        if self.api_client.client_side_validation and ('zos_template_data' not in params or
                                                       params['zos_template_data'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `zos_template_data` when calling `add_zos_template`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in params:
            path_params['server'] = params['server']  # noqa: E501
        if 'agent' in params:
            path_params['agent'] = params['agent']  # noqa: E501
        if 'template_name' in params:
            path_params['templateName'] = params['template_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'zos_template_data' in params:
            body_params = params['zos_template_data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/config/server/{server}/agent/{agent}/mft/zostemplate/{templateName}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def authorize_mft_ssh_cluster(self, server, agent, cluster_name, hostname_port_list, **kwargs):  # noqa: E501
        """Authorize SSH Cluster  # noqa: E501

        Authorize SSH Cluster  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.authorize_mft_ssh_cluster(server, agent, cluster_name, hostname_port_list, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server: The Server (required)
        :param str agent: The Agent (required)
        :param str cluster_name: Ssh Cluster Name (required)
        :param ClusterAuthorizationData hostname_port_list: File with content of hostnames and ports (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.authorize_mft_ssh_cluster_with_http_info(server, agent, cluster_name, hostname_port_list, **kwargs)  # noqa: E501
        else:
            (data) = self.authorize_mft_ssh_cluster_with_http_info(server, agent, cluster_name, hostname_port_list, **kwargs)  # noqa: E501
            return data

    def authorize_mft_ssh_cluster_with_http_info(self, server, agent, cluster_name, hostname_port_list, **kwargs):  # noqa: E501
        """Authorize SSH Cluster  # noqa: E501

        Authorize SSH Cluster  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.authorize_mft_ssh_cluster_with_http_info(server, agent, cluster_name, hostname_port_list, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server: The Server (required)
        :param str agent: The Agent (required)
        :param str cluster_name: Ssh Cluster Name (required)
        :param ClusterAuthorizationData hostname_port_list: File with content of hostnames and ports (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['server', 'agent', 'cluster_name', 'hostname_port_list']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method authorize_mft_ssh_cluster" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in params or
                                                       params['server'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `server` when calling `authorize_mft_ssh_cluster`")  # noqa: E501
        # verify the required parameter 'agent' is set
        if self.api_client.client_side_validation and ('agent' not in params or
                                                       params['agent'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `agent` when calling `authorize_mft_ssh_cluster`")  # noqa: E501
        # verify the required parameter 'cluster_name' is set
        if self.api_client.client_side_validation and ('cluster_name' not in params or
                                                       params['cluster_name'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `cluster_name` when calling `authorize_mft_ssh_cluster`")  # noqa: E501
        # verify the required parameter 'hostname_port_list' is set
        if self.api_client.client_side_validation and ('hostname_port_list' not in params or
                                                       params['hostname_port_list'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `hostname_port_list` when calling `authorize_mft_ssh_cluster`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in params:
            path_params['server'] = params['server']  # noqa: E501
        if 'agent' in params:
            path_params['agent'] = params['agent']  # noqa: E501
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'hostname_port_list' in params:
            body_params = params['hostname_port_list']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/config/server/{server}/agent/{agent}/mft/ssh/cluster/{clusterName}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def authorize_mft_ssh_host(self, server, agent, hostname, **kwargs):  # noqa: E501
        """Authorize SSH Host  # noqa: E501

        Authorize SSH Host for SFTP account  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.authorize_mft_ssh_host(server, agent, hostname, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server: The Server (required)
        :param str agent: The Agent (required)
        :param str hostname: Ssh Hostname (required)
        :param str port: Ssh port for the relevant host
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.authorize_mft_ssh_host_with_http_info(server, agent, hostname, **kwargs)  # noqa: E501
        else:
            (data) = self.authorize_mft_ssh_host_with_http_info(server, agent, hostname, **kwargs)  # noqa: E501
            return data

    def authorize_mft_ssh_host_with_http_info(self, server, agent, hostname, **kwargs):  # noqa: E501
        """Authorize SSH Host  # noqa: E501

        Authorize SSH Host for SFTP account  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.authorize_mft_ssh_host_with_http_info(server, agent, hostname, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server: The Server (required)
        :param str agent: The Agent (required)
        :param str hostname: Ssh Hostname (required)
        :param str port: Ssh port for the relevant host
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['server', 'agent', 'hostname', 'port']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method authorize_mft_ssh_host" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in params or
                                                       params['server'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `server` when calling `authorize_mft_ssh_host`")  # noqa: E501
        # verify the required parameter 'agent' is set
        if self.api_client.client_side_validation and ('agent' not in params or
                                                       params['agent'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `agent` when calling `authorize_mft_ssh_host`")  # noqa: E501
        # verify the required parameter 'hostname' is set
        if self.api_client.client_side_validation and ('hostname' not in params or
                                                       params['hostname'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `hostname` when calling `authorize_mft_ssh_host`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in params:
            path_params['server'] = params['server']  # noqa: E501
        if 'agent' in params:
            path_params['agent'] = params['agent']  # noqa: E501
        if 'hostname' in params:
            path_params['hostname'] = params['hostname']  # noqa: E501

        query_params = []
        if 'port' in params:
            query_params.append(('port', params['port']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/config/server/{server}/agent/{agent}/mft/ssh/host/{hostname}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_run_as_user(self, server, run_as_user_data, **kwargs):  # noqa: E501
        """Add a new Run-as user  # noqa: E501

        Add a new Run-as user to server.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_run_as_user(server, run_as_user_data, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server: The Server. (required)
        :param RunAsUserData run_as_user_data: Run as user data (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_run_as_user_with_http_info(server, run_as_user_data, **kwargs)  # noqa: E501
        else:
            (data) = self.create_run_as_user_with_http_info(server, run_as_user_data, **kwargs)  # noqa: E501
            return data

    def create_run_as_user_with_http_info(self, server, run_as_user_data, **kwargs):  # noqa: E501
        """Add a new Run-as user  # noqa: E501

        Add a new Run-as user to server.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_run_as_user_with_http_info(server, run_as_user_data, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server: The Server. (required)
        :param RunAsUserData run_as_user_data: Run as user data (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['server', 'run_as_user_data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_run_as_user" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in params or
                                                       params['server'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `server` when calling `create_run_as_user`")  # noqa: E501
        # verify the required parameter 'run_as_user_data' is set
        if self.api_client.client_side_validation and ('run_as_user_data' not in params or
                                                       params['run_as_user_data'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `run_as_user_data` when calling `create_run_as_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in params:
            path_params['server'] = params['server']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'run_as_user_data' in params:
            body_params = params['run_as_user_data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/config/server/{server}/runasuser', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_agent(self, server, agent, **kwargs):  # noqa: E501
        """delete an agent from Server  # noqa: E501

        Delete an agent from a Server. This will not shut the agent down. It only disconnects and removes it from the list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_agent(server, agent, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server: The Server the agent is connected to. (required)
        :param str agent: The name of the agent to delete. (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_agent_with_http_info(server, agent, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_agent_with_http_info(server, agent, **kwargs)  # noqa: E501
            return data

    def delete_agent_with_http_info(self, server, agent, **kwargs):  # noqa: E501
        """delete an agent from Server  # noqa: E501

        Delete an agent from a Server. This will not shut the agent down. It only disconnects and removes it from the list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_agent_with_http_info(server, agent, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server: The Server the agent is connected to. (required)
        :param str agent: The name of the agent to delete. (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['server', 'agent']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_agent" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in params or
                                                       params['server'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `server` when calling `delete_agent`")  # noqa: E501
        # verify the required parameter 'agent' is set
        if self.api_client.client_side_validation and ('agent' not in params or
                                                       params['agent'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `agent` when calling `delete_agent`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in params:
            path_params['server'] = params['server']  # noqa: E501
        if 'agent' in params:
            path_params['agent'] = params['agent']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/config/server/{server}/agent/{agent}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_authorization_role(self, role, **kwargs):  # noqa: E501
        """Delete Authorization Role  # noqa: E501

        Delete Authorization Role  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_authorization_role(role, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str role: The Role name. (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_authorization_role_with_http_info(role, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_authorization_role_with_http_info(role, **kwargs)  # noqa: E501
            return data

    def delete_authorization_role_with_http_info(self, role, **kwargs):  # noqa: E501
        """Delete Authorization Role  # noqa: E501

        Delete Authorization Role  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_authorization_role_with_http_info(role, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str role: The Role name. (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['role']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_authorization_role" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'role' is set
        if self.api_client.client_side_validation and ('role' not in params or
                                                       params['role'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `role` when calling `delete_authorization_role`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'role' in params:
            path_params['role'] = params['role']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/config/authorization/role/{role}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_host_from_group(self, server, hostgroup, host, **kwargs):  # noqa: E501
        """delete an agent from a hostgroup  # noqa: E501

        Delete an agent from the specified hostgroup. If the group is empty it will also be deleted.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_host_from_group(server, hostgroup, host, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server: The Server the hostgroup belongs to. (required)
        :param str hostgroup: The hostgroup name (required)
        :param str host: The agent to be deleted (required)
        :return: AgentsInGroupSuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_host_from_group_with_http_info(server, hostgroup, host, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_host_from_group_with_http_info(server, hostgroup, host, **kwargs)  # noqa: E501
            return data

    def delete_host_from_group_with_http_info(self, server, hostgroup, host, **kwargs):  # noqa: E501
        """delete an agent from a hostgroup  # noqa: E501

        Delete an agent from the specified hostgroup. If the group is empty it will also be deleted.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_host_from_group_with_http_info(server, hostgroup, host, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server: The Server the hostgroup belongs to. (required)
        :param str hostgroup: The hostgroup name (required)
        :param str host: The agent to be deleted (required)
        :return: AgentsInGroupSuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['server', 'hostgroup', 'host']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_host_from_group" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in params or
                                                       params['server'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `server` when calling `delete_host_from_group`")  # noqa: E501
        # verify the required parameter 'hostgroup' is set
        if self.api_client.client_side_validation and ('hostgroup' not in params or
                                                       params['hostgroup'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `hostgroup` when calling `delete_host_from_group`")  # noqa: E501
        # verify the required parameter 'host' is set
        if self.api_client.client_side_validation and ('host' not in params or
                                                       params['host'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `host` when calling `delete_host_from_group`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in params:
            path_params['server'] = params['server']  # noqa: E501
        if 'hostgroup' in params:
            path_params['hostgroup'] = params['hostgroup']  # noqa: E501
        if 'host' in params:
            path_params['host'] = params['host']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/config/server/{server}/hostgroup/{hostgroup}/agent/{host}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AgentsInGroupSuccessData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_host_group(self, server, hostgroup, **kwargs):  # noqa: E501
        """delete host group  # noqa: E501

        delete host group  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_host_group(server, hostgroup, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server: The Server the agent is connected to. (required)
        :param str hostgroup: The hostgroup name (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_host_group_with_http_info(server, hostgroup, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_host_group_with_http_info(server, hostgroup, **kwargs)  # noqa: E501
            return data

    def delete_host_group_with_http_info(self, server, hostgroup, **kwargs):  # noqa: E501
        """delete host group  # noqa: E501

        delete host group  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_host_group_with_http_info(server, hostgroup, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server: The Server the agent is connected to. (required)
        :param str hostgroup: The hostgroup name (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['server', 'hostgroup']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_host_group" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in params or
                                                       params['server'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `server` when calling `delete_host_group`")  # noqa: E501
        # verify the required parameter 'hostgroup' is set
        if self.api_client.client_side_validation and ('hostgroup' not in params or
                                                       params['hostgroup'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `hostgroup` when calling `delete_host_group`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in params:
            path_params['server'] = params['server']  # noqa: E501
        if 'hostgroup' in params:
            path_params['hostgroup'] = params['hostgroup']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/config/server/{server}/hostgroup/{hostgroup}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_pgp_template(self, server, agent, template_name, **kwargs):  # noqa: E501
        """Delete PGP Template  # noqa: E501

        Delete PGP Template  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_pgp_template(server, agent, template_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server: The Server (required)
        :param str agent: The Agent (required)
        :param str template_name: The PGP Template Name (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_pgp_template_with_http_info(server, agent, template_name, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_pgp_template_with_http_info(server, agent, template_name, **kwargs)  # noqa: E501
            return data

    def delete_pgp_template_with_http_info(self, server, agent, template_name, **kwargs):  # noqa: E501
        """Delete PGP Template  # noqa: E501

        Delete PGP Template  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_pgp_template_with_http_info(server, agent, template_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server: The Server (required)
        :param str agent: The Agent (required)
        :param str template_name: The PGP Template Name (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['server', 'agent', 'template_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_pgp_template" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in params or
                                                       params['server'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `server` when calling `delete_pgp_template`")  # noqa: E501
        # verify the required parameter 'agent' is set
        if self.api_client.client_side_validation and ('agent' not in params or
                                                       params['agent'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `agent` when calling `delete_pgp_template`")  # noqa: E501
        # verify the required parameter 'template_name' is set
        if self.api_client.client_side_validation and ('template_name' not in params or
                                                       params['template_name'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `template_name` when calling `delete_pgp_template`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in params:
            path_params['server'] = params['server']  # noqa: E501
        if 'agent' in params:
            path_params['agent'] = params['agent']  # noqa: E501
        if 'template_name' in params:
            path_params['templateName'] = params['template_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/config/server/{server}/agent/{agent}/mft/pgptemplate/{templateName}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_role_from_ldap_group(self, ldapgroup, role, **kwargs):  # noqa: E501
        """Delete a role from LDAP group  # noqa: E501

        Delete a role from LDAP group  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_role_from_ldap_group(ldapgroup, role, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ldapgroup: Name of LDAP group (required)
        :param str role: Name of role (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_role_from_ldap_group_with_http_info(ldapgroup, role, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_role_from_ldap_group_with_http_info(ldapgroup, role, **kwargs)  # noqa: E501
            return data

    def delete_role_from_ldap_group_with_http_info(self, ldapgroup, role, **kwargs):  # noqa: E501
        """Delete a role from LDAP group  # noqa: E501

        Delete a role from LDAP group  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_role_from_ldap_group_with_http_info(ldapgroup, role, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str ldapgroup: Name of LDAP group (required)
        :param str role: Name of role (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ldapgroup', 'role']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_role_from_ldap_group" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'ldapgroup' is set
        if self.api_client.client_side_validation and ('ldapgroup' not in params or
                                                       params['ldapgroup'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `ldapgroup` when calling `delete_role_from_ldap_group`")  # noqa: E501
        # verify the required parameter 'role' is set
        if self.api_client.client_side_validation and ('role' not in params or
                                                       params['role'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `role` when calling `delete_role_from_ldap_group`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'ldapgroup' in params:
            path_params['ldapgroup'] = params['ldapgroup']  # noqa: E501
        if 'role' in params:
            path_params['role'] = params['role']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/config/authorization/ldap/{ldapgroup}/role/{role}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_run_as_user(self, server, agent, user, **kwargs):  # noqa: E501
        """delete Run-as user  # noqa: E501

        Delete Run-as user from server  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_run_as_user(server, agent, user, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server: The Server. (required)
        :param str agent: The Agent (required)
        :param str user: The user name (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_run_as_user_with_http_info(server, agent, user, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_run_as_user_with_http_info(server, agent, user, **kwargs)  # noqa: E501
            return data

    def delete_run_as_user_with_http_info(self, server, agent, user, **kwargs):  # noqa: E501
        """delete Run-as user  # noqa: E501

        Delete Run-as user from server  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_run_as_user_with_http_info(server, agent, user, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server: The Server. (required)
        :param str agent: The Agent (required)
        :param str user: The user name (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['server', 'agent', 'user']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_run_as_user" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in params or
                                                       params['server'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `server` when calling `delete_run_as_user`")  # noqa: E501
        # verify the required parameter 'agent' is set
        if self.api_client.client_side_validation and ('agent' not in params or
                                                       params['agent'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `agent` when calling `delete_run_as_user`")  # noqa: E501
        # verify the required parameter 'user' is set
        if self.api_client.client_side_validation and ('user' not in params or
                                                       params['user'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `user` when calling `delete_run_as_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in params:
            path_params['server'] = params['server']  # noqa: E501
        if 'agent' in params:
            path_params['agent'] = params['agent']  # noqa: E501
        if 'user' in params:
            path_params['user'] = params['user']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/config/server/{server}/runasuser/{agent}/{user}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_secret(self, name, **kwargs):  # noqa: E501
        """Delete an existing secret  # noqa: E501

        Delete an existing secret from the secrets vault.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_secret(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: The name of the secret to update (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_secret_with_http_info(name, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_secret_with_http_info(name, **kwargs)  # noqa: E501
            return data

    def delete_secret_with_http_info(self, name, **kwargs):  # noqa: E501
        """Delete an existing secret  # noqa: E501

        Delete an existing secret from the secrets vault.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_secret_with_http_info(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: The name of the secret to update (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_secret" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in params or
                                                       params['name'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `name` when calling `delete_secret`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/config/secret/{name}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_user(self, user, **kwargs):  # noqa: E501
        """Delete user  # noqa: E501

        Delete user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_user(user, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user: The user name. (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_user_with_http_info(user, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_user_with_http_info(user, **kwargs)  # noqa: E501
            return data

    def delete_user_with_http_info(self, user, **kwargs):  # noqa: E501
        """Delete user  # noqa: E501

        Delete user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_user_with_http_info(user, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user: The user name. (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_user" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'user' is set
        if self.api_client.client_side_validation and ('user' not in params or
                                                       params['user'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `user` when calling `delete_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user' in params:
            path_params['user'] = params['user']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/config/authorization/user/{user}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_zos_template(self, server, agent, template_name, **kwargs):  # noqa: E501
        """Delete z/OS Template  # noqa: E501

        Delete z/OS Template  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_zos_template(server, agent, template_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server: The Server (required)
        :param str agent: The Agent (required)
        :param str template_name: The z/OS Template Name (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_zos_template_with_http_info(server, agent, template_name, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_zos_template_with_http_info(server, agent, template_name, **kwargs)  # noqa: E501
            return data

    def delete_zos_template_with_http_info(self, server, agent, template_name, **kwargs):  # noqa: E501
        """Delete z/OS Template  # noqa: E501

        Delete z/OS Template  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_zos_template_with_http_info(server, agent, template_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server: The Server (required)
        :param str agent: The Agent (required)
        :param str template_name: The z/OS Template Name (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['server', 'agent', 'template_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_zos_template" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in params or
                                                       params['server'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `server` when calling `delete_zos_template`")  # noqa: E501
        # verify the required parameter 'agent' is set
        if self.api_client.client_side_validation and ('agent' not in params or
                                                       params['agent'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `agent` when calling `delete_zos_template`")  # noqa: E501
        # verify the required parameter 'template_name' is set
        if self.api_client.client_side_validation and ('template_name' not in params or
                                                       params['template_name'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `template_name` when calling `delete_zos_template`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in params:
            path_params['server'] = params['server']  # noqa: E501
        if 'agent' in params:
            path_params['agent'] = params['agent']  # noqa: E501
        if 'template_name' in params:
            path_params['templateName'] = params['template_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/config/server/{server}/agent/{agent}/mft/zostemplate/{templateName}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def disable_agent(self, server, agent, **kwargs):  # noqa: E501
        """disable agent from the Server  # noqa: E501

        Disable an Agent.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.disable_agent(server, agent, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server: The Server the agent is connected too. (required)
        :param str agent: The Agent to be disabled. (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.disable_agent_with_http_info(server, agent, **kwargs)  # noqa: E501
        else:
            (data) = self.disable_agent_with_http_info(server, agent, **kwargs)  # noqa: E501
            return data

    def disable_agent_with_http_info(self, server, agent, **kwargs):  # noqa: E501
        """disable agent from the Server  # noqa: E501

        Disable an Agent.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.disable_agent_with_http_info(server, agent, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server: The Server the agent is connected too. (required)
        :param str agent: The Agent to be disabled. (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['server', 'agent']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method disable_agent" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in params or
                                                       params['server'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `server` when calling `disable_agent`")  # noqa: E501
        # verify the required parameter 'agent' is set
        if self.api_client.client_side_validation and ('agent' not in params or
                                                       params['agent'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `agent` when calling `disable_agent`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in params:
            path_params['server'] = params['server']  # noqa: E501
        if 'agent' in params:
            path_params['agent'] = params['agent']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/config/server/{server}/agent/{agent}/disable', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def enable_agent(self, server, agent, **kwargs):  # noqa: E501
        """enable agent from the Server  # noqa: E501

        Enable an Agent. This command does not install or configure the agent. It only enable existing agent in the system.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.enable_agent(server, agent, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server: The Server the agent is connected too. (required)
        :param str agent: The Agent to be enabled. (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.enable_agent_with_http_info(server, agent, **kwargs)  # noqa: E501
        else:
            (data) = self.enable_agent_with_http_info(server, agent, **kwargs)  # noqa: E501
            return data

    def enable_agent_with_http_info(self, server, agent, **kwargs):  # noqa: E501
        """enable agent from the Server  # noqa: E501

        Enable an Agent. This command does not install or configure the agent. It only enable existing agent in the system.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.enable_agent_with_http_info(server, agent, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server: The Server the agent is connected too. (required)
        :param str agent: The Agent to be enabled. (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['server', 'agent']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method enable_agent" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in params or
                                                       params['server'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `server` when calling `enable_agent`")  # noqa: E501
        # verify the required parameter 'agent' is set
        if self.api_client.client_side_validation and ('agent' not in params or
                                                       params['agent'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `agent` when calling `enable_agent`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in params:
            path_params['server'] = params['server']  # noqa: E501
        if 'agent' in params:
            path_params['agent'] = params['agent']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/config/server/{server}/agent/{agent}/enable', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def export_role(self, role, **kwargs):  # noqa: E501
        """Export Authorization Role  # noqa: E501

        Export Authorization Role  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_role(role, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str role: The Role name. (required)
        :return: RoleDataFull
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.export_role_with_http_info(role, **kwargs)  # noqa: E501
        else:
            (data) = self.export_role_with_http_info(role, **kwargs)  # noqa: E501
            return data

    def export_role_with_http_info(self, role, **kwargs):  # noqa: E501
        """Export Authorization Role  # noqa: E501

        Export Authorization Role  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_role_with_http_info(role, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str role: The Role name. (required)
        :return: RoleDataFull
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['role']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method export_role" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'role' is set
        if self.api_client.client_side_validation and ('role' not in params or
                                                       params['role'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `role` when calling `export_role`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'role' in params:
            path_params['role'] = params['role']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/config/authorization/role/{role}/export', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RoleDataFull',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def generate_mft_rsa_ssh_key(self, server, agent, ssh_key_properties, **kwargs):  # noqa: E501
        """Generate RSA SSH Key  # noqa: E501

        Generate RSA SSH Key pair for SFTP account authentication  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.generate_mft_rsa_ssh_key(server, agent, ssh_key_properties, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server: The Server (required)
        :param str agent: The Agent (required)
        :param SshKeyProperties ssh_key_properties: Ssh Key pair properites (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.generate_mft_rsa_ssh_key_with_http_info(server, agent, ssh_key_properties, **kwargs)  # noqa: E501
        else:
            (data) = self.generate_mft_rsa_ssh_key_with_http_info(server, agent, ssh_key_properties, **kwargs)  # noqa: E501
            return data

    def generate_mft_rsa_ssh_key_with_http_info(self, server, agent, ssh_key_properties, **kwargs):  # noqa: E501
        """Generate RSA SSH Key  # noqa: E501

        Generate RSA SSH Key pair for SFTP account authentication  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.generate_mft_rsa_ssh_key_with_http_info(server, agent, ssh_key_properties, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server: The Server (required)
        :param str agent: The Agent (required)
        :param SshKeyProperties ssh_key_properties: Ssh Key pair properites (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['server', 'agent', 'ssh_key_properties']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method generate_mft_rsa_ssh_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in params or
                                                       params['server'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `server` when calling `generate_mft_rsa_ssh_key`")  # noqa: E501
        # verify the required parameter 'agent' is set
        if self.api_client.client_side_validation and ('agent' not in params or
                                                       params['agent'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `agent` when calling `generate_mft_rsa_ssh_key`")  # noqa: E501
        # verify the required parameter 'ssh_key_properties' is set
        if self.api_client.client_side_validation and ('ssh_key_properties' not in params or
                                                       params['ssh_key_properties'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `ssh_key_properties` when calling `generate_mft_rsa_ssh_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in params:
            path_params['server'] = params['server']  # noqa: E501
        if 'agent' in params:
            path_params['agent'] = params['agent']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'ssh_key_properties' in params:
            body_params = params['ssh_key_properties']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/config/server/{server}/agent/{agent}/mft/ssh/key', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_agent_parameters(self, server, agent, **kwargs):  # noqa: E501
        """get agent parameters  # noqa: E501

        Get all the parameters of the specified Agent.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_agent_parameters(server, agent, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server: The Server the agent is connected to. (required)
        :param str agent: The name of the agent to query. (required)
        :param bool extended_data: True to return more agent parameters. HIDDEN
        :return: KeyValueListResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_agent_parameters_with_http_info(server, agent, **kwargs)  # noqa: E501
        else:
            (data) = self.get_agent_parameters_with_http_info(server, agent, **kwargs)  # noqa: E501
            return data

    def get_agent_parameters_with_http_info(self, server, agent, **kwargs):  # noqa: E501
        """get agent parameters  # noqa: E501

        Get all the parameters of the specified Agent.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_agent_parameters_with_http_info(server, agent, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server: The Server the agent is connected to. (required)
        :param str agent: The name of the agent to query. (required)
        :param bool extended_data: True to return more agent parameters. HIDDEN
        :return: KeyValueListResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['server', 'agent', 'extended_data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_agent_parameters" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in params or
                                                       params['server'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `server` when calling `get_agent_parameters`")  # noqa: E501
        # verify the required parameter 'agent' is set
        if self.api_client.client_side_validation and ('agent' not in params or
                                                       params['agent'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `agent` when calling `get_agent_parameters`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in params:
            path_params['server'] = params['server']  # noqa: E501
        if 'agent' in params:
            path_params['agent'] = params['agent']  # noqa: E501

        query_params = []
        if 'extended_data' in params:
            query_params.append(('extendedData', params['extended_data']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/config/server/{server}/agent/{agent}/params', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='KeyValueListResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_agents(self, server, **kwargs):  # noqa: E501
        """get Server agents  # noqa: E501

        Get all the agents of the specified Server.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_agents(server, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server: The Server to query. Optionally you can filter agent name of host or alias of the Agent (required)
        :param str agent: Optionally case insensitive agent name filter of host or alias of the Agent. `ctm server:agents::get Server AgentName` returns all agents which names start with `agentname`
        :return: AgentDetailsList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_agents_with_http_info(server, **kwargs)  # noqa: E501
        else:
            (data) = self.get_agents_with_http_info(server, **kwargs)  # noqa: E501
            return data

    def get_agents_with_http_info(self, server, **kwargs):  # noqa: E501
        """get Server agents  # noqa: E501

        Get all the agents of the specified Server.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_agents_with_http_info(server, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server: The Server to query. Optionally you can filter agent name of host or alias of the Agent (required)
        :param str agent: Optionally case insensitive agent name filter of host or alias of the Agent. `ctm server:agents::get Server AgentName` returns all agents which names start with `agentname`
        :return: AgentDetailsList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['server', 'agent']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_agents" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in params or
                                                       params['server'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `server` when calling `get_agents`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in params:
            path_params['server'] = params['server']  # noqa: E501

        query_params = []
        if 'agent' in params:
            query_params.append(('agent', params['agent']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/config/server/{server}/agents', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AgentDetailsList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all_authorization_roles(self, **kwargs):  # noqa: E501
        """Get Authorization Roles  # noqa: E501

        Get Authorization Roles  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_authorization_roles(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str role: The Role name.
        :param str description: The Role description.
        :return: RoleHeaderList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_all_authorization_roles_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_all_authorization_roles_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_all_authorization_roles_with_http_info(self, **kwargs):  # noqa: E501
        """Get Authorization Roles  # noqa: E501

        Get Authorization Roles  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_authorization_roles_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str role: The Role name.
        :param str description: The Role description.
        :return: RoleHeaderList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['role', 'description']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_authorization_roles" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'role' in params:
            query_params.append(('role', params['role']))  # noqa: E501
        if 'description' in params:
            query_params.append(('description', params['description']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/config/authorization/roles', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RoleHeaderList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all_organization_groups(self, **kwargs):  # noqa: E501
        """Get All organization groups  # noqa: E501

        Get All organization groups  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_organization_groups(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organizationgroup: The organization group name.
        :return: list[str]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_all_organization_groups_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_all_organization_groups_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_all_organization_groups_with_http_info(self, **kwargs):  # noqa: E501
        """Get All organization groups  # noqa: E501

        Get All organization groups  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_organization_groups_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organizationgroup: The organization group name.
        :return: list[str]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['organizationgroup']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_organization_groups" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'organizationgroup' in params:
            query_params.append(('organizationgroup', params['organizationgroup']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/config/authorization/organizationgroups', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[str]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all_roles_associated_with_organization_group(self, organizationgroup, **kwargs):  # noqa: E501
        """Get Authorization Roles associated with an organization group  # noqa: E501

        Get Authorization Roles associated with an organization group  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_roles_associated_with_organization_group(organizationgroup, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organizationgroup: Name of organization group (required)
        :param str role: The Role name.
        :return: list[str]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_all_roles_associated_with_organization_group_with_http_info(organizationgroup, **kwargs)  # noqa: E501
        else:
            (data) = self.get_all_roles_associated_with_organization_group_with_http_info(organizationgroup, **kwargs)  # noqa: E501
            return data

    def get_all_roles_associated_with_organization_group_with_http_info(self, organizationgroup, **kwargs):  # noqa: E501
        """Get Authorization Roles associated with an organization group  # noqa: E501

        Get Authorization Roles associated with an organization group  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_roles_associated_with_organization_group_with_http_info(organizationgroup, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organizationgroup: Name of organization group (required)
        :param str role: The Role name.
        :return: list[str]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['organizationgroup', 'role']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_roles_associated_with_organization_group" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'organizationgroup' is set
        if self.api_client.client_side_validation and ('organizationgroup' not in params or
                                                       params['organizationgroup'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `organizationgroup` when calling `get_all_roles_associated_with_organization_group`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organizationgroup' in params:
            path_params['organizationgroup'] = params['organizationgroup']  # noqa: E501

        query_params = []
        if 'role' in params:
            query_params.append(('role', params['role']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/config/authorization/organizationgroup/{organizationgroup}/roles', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[str]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all_users(self, **kwargs):  # noqa: E501
        """Get users  # noqa: E501

        Get users  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_users(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: The user name.
        :param str full_name: The user full name.
        :param str description: The user description.
        :return: list[UserHeader]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_all_users_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_all_users_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_all_users_with_http_info(self, **kwargs):  # noqa: E501
        """Get users  # noqa: E501

        Get users  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_users_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: The user name.
        :param str full_name: The user full name.
        :param str description: The user description.
        :return: list[UserHeader]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'full_name', 'description']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_users" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'full_name' in params:
            query_params.append(('fullName', params['full_name']))  # noqa: E501
        if 'description' in params:
            query_params.append(('description', params['description']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/config/authorization/users', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[UserHeader]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_fts_settings(self, server, agent, **kwargs):  # noqa: E501
        """Get File Transfer Server (FTS) configuration data.  # noqa: E501

        Get File Transfer Server (FTS) configuration data.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_fts_settings(server, agent, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server: The Server (required)
        :param str agent: The Agent (required)
        :return: FtsSettingsData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_fts_settings_with_http_info(server, agent, **kwargs)  # noqa: E501
        else:
            (data) = self.get_fts_settings_with_http_info(server, agent, **kwargs)  # noqa: E501
            return data

    def get_fts_settings_with_http_info(self, server, agent, **kwargs):  # noqa: E501
        """Get File Transfer Server (FTS) configuration data.  # noqa: E501

        Get File Transfer Server (FTS) configuration data.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_fts_settings_with_http_info(server, agent, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server: The Server (required)
        :param str agent: The Agent (required)
        :return: FtsSettingsData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['server', 'agent']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_fts_settings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in params or
                                                       params['server'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `server` when calling `get_fts_settings`")  # noqa: E501
        # verify the required parameter 'agent' is set
        if self.api_client.client_side_validation and ('agent' not in params or
                                                       params['agent'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `agent` when calling `get_fts_settings`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in params:
            path_params['server'] = params['server']  # noqa: E501
        if 'agent' in params:
            path_params['agent'] = params['agent']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/config/server/{server}/agent/{agent}/mft/fts/settings', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FtsSettingsData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_hostgroups(self, server, **kwargs):  # noqa: E501
        """get Server hostgroups  # noqa: E501

        Get all the hostgroups of the specified Server.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_hostgroups(server, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server: The Server the hostgroups belong to. (required)
        :return: StringListResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_hostgroups_with_http_info(server, **kwargs)  # noqa: E501
        else:
            (data) = self.get_hostgroups_with_http_info(server, **kwargs)  # noqa: E501
            return data

    def get_hostgroups_with_http_info(self, server, **kwargs):  # noqa: E501
        """get Server hostgroups  # noqa: E501

        Get all the hostgroups of the specified Server.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_hostgroups_with_http_info(server, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server: The Server the hostgroups belong to. (required)
        :return: StringListResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['server']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_hostgroups" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in params or
                                                       params['server'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `server` when calling `get_hostgroups`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in params:
            path_params['server'] = params['server']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/config/server/{server}/hostgroups', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StringListResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_hosts_in_group(self, server, hostgroup, **kwargs):  # noqa: E501
        """get hostgroup agents  # noqa: E501

        Get the agents that compose the specified hostgroup  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_hosts_in_group(server, hostgroup, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server: The Server the hostgroup belongs to. (required)
        :param str hostgroup: The hostgroup name (required)
        :return: AgentsInGroupListResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_hosts_in_group_with_http_info(server, hostgroup, **kwargs)  # noqa: E501
        else:
            (data) = self.get_hosts_in_group_with_http_info(server, hostgroup, **kwargs)  # noqa: E501
            return data

    def get_hosts_in_group_with_http_info(self, server, hostgroup, **kwargs):  # noqa: E501
        """get hostgroup agents  # noqa: E501

        Get the agents that compose the specified hostgroup  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_hosts_in_group_with_http_info(server, hostgroup, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server: The Server the hostgroup belongs to. (required)
        :param str hostgroup: The hostgroup name (required)
        :return: AgentsInGroupListResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['server', 'hostgroup']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_hosts_in_group" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in params or
                                                       params['server'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `server` when calling `get_hosts_in_group`")  # noqa: E501
        # verify the required parameter 'hostgroup' is set
        if self.api_client.client_side_validation and ('hostgroup' not in params or
                                                       params['hostgroup'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `hostgroup` when calling `get_hosts_in_group`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in params:
            path_params['server'] = params['server']  # noqa: E501
        if 'hostgroup' in params:
            path_params['hostgroup'] = params['hostgroup']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/config/server/{server}/hostgroup/{hostgroup}/agents', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AgentsInGroupListResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_identity_provider_metadata(self, **kwargs):  # noqa: E501
        """Get identity Provider Metadata file  # noqa: E501

        Get identity Provider Metadata file  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_identity_provider_metadata(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_identity_provider_metadata_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_identity_provider_metadata_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_identity_provider_metadata_with_http_info(self, **kwargs):  # noqa: E501
        """Get identity Provider Metadata file  # noqa: E501

        Get identity Provider Metadata file  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_identity_provider_metadata_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_identity_provider_metadata" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/config/systemsettings/saml2identityprovidermetadata', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_mft_configuration(self, server, agent, **kwargs):  # noqa: E501
        """Get MFT Configuration  # noqa: E501

        Get MFT Configuration  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_mft_configuration(server, agent, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server: The Server (required)
        :param str agent: The Agent (required)
        :return: MftConfigurationData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_mft_configuration_with_http_info(server, agent, **kwargs)  # noqa: E501
        else:
            (data) = self.get_mft_configuration_with_http_info(server, agent, **kwargs)  # noqa: E501
            return data

    def get_mft_configuration_with_http_info(self, server, agent, **kwargs):  # noqa: E501
        """Get MFT Configuration  # noqa: E501

        Get MFT Configuration  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_mft_configuration_with_http_info(server, agent, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server: The Server (required)
        :param str agent: The Agent (required)
        :return: MftConfigurationData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['server', 'agent']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_mft_configuration" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in params or
                                                       params['server'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `server` when calling `get_mft_configuration`")  # noqa: E501
        # verify the required parameter 'agent' is set
        if self.api_client.client_side_validation and ('agent' not in params or
                                                       params['agent'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `agent` when calling `get_mft_configuration`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in params:
            path_params['server'] = params['server']  # noqa: E501
        if 'agent' in params:
            path_params['agent'] = params['agent']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/config/server/{server}/agent/{agent}/mft/configuration', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MftConfigurationData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_pgp_templates(self, server, agent, **kwargs):  # noqa: E501
        """Get PGP Templates  # noqa: E501

        Get PGP Templates  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_pgp_templates(server, agent, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server: The Server (required)
        :param str agent: The Agent (required)
        :param str name: The PGP Template Name
        :return: list[PgpTemplateData]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_pgp_templates_with_http_info(server, agent, **kwargs)  # noqa: E501
        else:
            (data) = self.get_pgp_templates_with_http_info(server, agent, **kwargs)  # noqa: E501
            return data

    def get_pgp_templates_with_http_info(self, server, agent, **kwargs):  # noqa: E501
        """Get PGP Templates  # noqa: E501

        Get PGP Templates  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_pgp_templates_with_http_info(server, agent, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server: The Server (required)
        :param str agent: The Agent (required)
        :param str name: The PGP Template Name
        :return: list[PgpTemplateData]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['server', 'agent', 'name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_pgp_templates" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in params or
                                                       params['server'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `server` when calling `get_pgp_templates`")  # noqa: E501
        # verify the required parameter 'agent' is set
        if self.api_client.client_side_validation and ('agent' not in params or
                                                       params['agent'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `agent` when calling `get_pgp_templates`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in params:
            path_params['server'] = params['server']  # noqa: E501
        if 'agent' in params:
            path_params['agent'] = params['agent']  # noqa: E501

        query_params = []
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/config/server/{server}/agent/{agent}/mft/pgptemplates', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[PgpTemplateData]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_role(self, role, **kwargs):  # noqa: E501
        """Get Authorization Role  # noqa: E501

        Get Authorization Role  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_role(role, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str role: The Role name. (required)
        :return: RoleData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_role_with_http_info(role, **kwargs)  # noqa: E501
        else:
            (data) = self.get_role_with_http_info(role, **kwargs)  # noqa: E501
            return data

    def get_role_with_http_info(self, role, **kwargs):  # noqa: E501
        """Get Authorization Role  # noqa: E501

        Get Authorization Role  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_role_with_http_info(role, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str role: The Role name. (required)
        :return: RoleData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['role']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_role" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'role' is set
        if self.api_client.client_side_validation and ('role' not in params or
                                                       params['role'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `role` when calling `get_role`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'role' in params:
            path_params['role'] = params['role']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/config/authorization/role/{role}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RoleData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_role_associates(self, role, **kwargs):  # noqa: E501
        """Get all authorization entities associated with role  # noqa: E501

        Get all authorization entities associated with role  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_role_associates(role, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str role: role name. (required)
        :return: list[AssociateData]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_role_associates_with_http_info(role, **kwargs)  # noqa: E501
        else:
            (data) = self.get_role_associates_with_http_info(role, **kwargs)  # noqa: E501
            return data

    def get_role_associates_with_http_info(self, role, **kwargs):  # noqa: E501
        """Get all authorization entities associated with role  # noqa: E501

        Get all authorization entities associated with role  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_role_associates_with_http_info(role, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str role: role name. (required)
        :return: list[AssociateData]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['role']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_role_associates" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'role' is set
        if self.api_client.client_side_validation and ('role' not in params or
                                                       params['role'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `role` when calling `get_role_associates`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'role' in params:
            path_params['role'] = params['role']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/config/authorization/role/{role}/associates', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[AssociateData]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_run_as_user(self, server, agent, user, **kwargs):  # noqa: E501
        """Get Run-as user  # noqa: E501

        Get Run-as user details from server.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_run_as_user(server, agent, user, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server: The Server. (required)
        :param str agent: The Agent (required)
        :param str user: The user name (required)
        :return: RunAsUserData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_run_as_user_with_http_info(server, agent, user, **kwargs)  # noqa: E501
        else:
            (data) = self.get_run_as_user_with_http_info(server, agent, user, **kwargs)  # noqa: E501
            return data

    def get_run_as_user_with_http_info(self, server, agent, user, **kwargs):  # noqa: E501
        """Get Run-as user  # noqa: E501

        Get Run-as user details from server.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_run_as_user_with_http_info(server, agent, user, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server: The Server. (required)
        :param str agent: The Agent (required)
        :param str user: The user name (required)
        :return: RunAsUserData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['server', 'agent', 'user']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_run_as_user" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in params or
                                                       params['server'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `server` when calling `get_run_as_user`")  # noqa: E501
        # verify the required parameter 'agent' is set
        if self.api_client.client_side_validation and ('agent' not in params or
                                                       params['agent'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `agent` when calling `get_run_as_user`")  # noqa: E501
        # verify the required parameter 'user' is set
        if self.api_client.client_side_validation and ('user' not in params or
                                                       params['user'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `user` when calling `get_run_as_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in params:
            path_params['server'] = params['server']  # noqa: E501
        if 'agent' in params:
            path_params['agent'] = params['agent']  # noqa: E501
        if 'user' in params:
            path_params['user'] = params['user']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/config/server/{server}/runasuser/{agent}/{user}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RunAsUserData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_run_as_users_list(self, server, **kwargs):  # noqa: E501
        """Get Run-as user list that match the requested search criteria.  # noqa: E501

        Get Run-as user list that match the requested search criteria from server.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_run_as_users_list(server, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server: The Server. (required)
        :param str user: The Run-as user.
        :param str agent: The agent.
        :return: RunAsUsersList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_run_as_users_list_with_http_info(server, **kwargs)  # noqa: E501
        else:
            (data) = self.get_run_as_users_list_with_http_info(server, **kwargs)  # noqa: E501
            return data

    def get_run_as_users_list_with_http_info(self, server, **kwargs):  # noqa: E501
        """Get Run-as user list that match the requested search criteria.  # noqa: E501

        Get Run-as user list that match the requested search criteria from server.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_run_as_users_list_with_http_info(server, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server: The Server. (required)
        :param str user: The Run-as user.
        :param str agent: The agent.
        :return: RunAsUsersList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['server', 'user', 'agent']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_run_as_users_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in params or
                                                       params['server'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `server` when calling `get_run_as_users_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in params:
            path_params['server'] = params['server']  # noqa: E501

        query_params = []
        if 'user' in params:
            query_params.append(('user', params['user']))  # noqa: E501
        if 'agent' in params:
            query_params.append(('agent', params['agent']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/config/server/{server}/runasusers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RunAsUsersList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_servers(self, **kwargs):  # noqa: E501
        """get all the Servers name and hostname in the system  # noqa: E501

        Get the names and hostnames of all Servers in the system.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_servers(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: CtmDetailsList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_servers_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_servers_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_servers_with_http_info(self, **kwargs):  # noqa: E501
        """get all the Servers name and hostname in the system  # noqa: E501

        Get the names and hostnames of all Servers in the system.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_servers_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: CtmDetailsList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_servers" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/config/servers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CtmDetailsList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_system_setting(self, **kwargs):  # noqa: E501
        """Get system setting for Control-M environment  # noqa: E501

        Get system setting for Control-M environment  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_system_setting(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server: Server to which the system settings are applied
        :return: SystemSetting
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_system_setting_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_system_setting_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_system_setting_with_http_info(self, **kwargs):  # noqa: E501
        """Get system setting for Control-M environment  # noqa: E501

        Get system setting for Control-M environment  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_system_setting_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server: Server to which the system settings are applied
        :return: SystemSetting
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['server']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_system_setting" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'server' in params:
            query_params.append(('server', params['server']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/config/systemsettings', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SystemSetting',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_user(self, user, **kwargs):  # noqa: E501
        """Get user  # noqa: E501

        Get user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_user(user, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user: The user name. (required)
        :return: UserData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_user_with_http_info(user, **kwargs)  # noqa: E501
        else:
            (data) = self.get_user_with_http_info(user, **kwargs)  # noqa: E501
            return data

    def get_user_with_http_info(self, user, **kwargs):  # noqa: E501
        """Get user  # noqa: E501

        Get user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_user_with_http_info(user, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user: The user name. (required)
        :return: UserData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_user" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'user' is set
        if self.api_client.client_side_validation and ('user' not in params or
                                                       params['user'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `user` when calling `get_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user' in params:
            path_params['user'] = params['user']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/config/authorization/user/{user}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UserData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_user_effective_rights(self, **kwargs):  # noqa: E501
        """Get user real effective authorizations  # noqa: E501

        Get user real effective authorizations by all his roles  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_user_effective_rights(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: RoleData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_user_effective_rights_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_user_effective_rights_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_user_effective_rights_with_http_info(self, **kwargs):  # noqa: E501
        """Get user real effective authorizations  # noqa: E501

        Get user real effective authorizations by all his roles  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_user_effective_rights_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: RoleData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_user_effective_rights" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/config/authorization/user/effectiveRights', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RoleData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_zos_templates(self, server, agent, **kwargs):  # noqa: E501
        """Get z/OS Templates  # noqa: E501

        Get z/OS Templates  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_zos_templates(server, agent, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server: The Server (required)
        :param str agent: The Agent (required)
        :param str name: The z/OS Template Name
        :return: list[ZosTemplateData]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_zos_templates_with_http_info(server, agent, **kwargs)  # noqa: E501
        else:
            (data) = self.get_zos_templates_with_http_info(server, agent, **kwargs)  # noqa: E501
            return data

    def get_zos_templates_with_http_info(self, server, agent, **kwargs):  # noqa: E501
        """Get z/OS Templates  # noqa: E501

        Get z/OS Templates  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_zos_templates_with_http_info(server, agent, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server: The Server (required)
        :param str agent: The Agent (required)
        :param str name: The z/OS Template Name
        :return: list[ZosTemplateData]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['server', 'agent', 'name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_zos_templates" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in params or
                                                       params['server'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `server` when calling `get_zos_templates`")  # noqa: E501
        # verify the required parameter 'agent' is set
        if self.api_client.client_side_validation and ('agent' not in params or
                                                       params['agent'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `agent` when calling `get_zos_templates`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in params:
            path_params['server'] = params['server']  # noqa: E501
        if 'agent' in params:
            path_params['agent'] = params['agent']  # noqa: E501

        query_params = []
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/config/server/{server}/agent/{agent}/mft/zostemplates', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ZosTemplateData]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def import_role(self, role_file, **kwargs):  # noqa: E501
        """Import Authorization Role  # noqa: E501

        Import Authorization Role  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_role(role_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file role_file: File with contenet of RoleDataFull. (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.import_role_with_http_info(role_file, **kwargs)  # noqa: E501
        else:
            (data) = self.import_role_with_http_info(role_file, **kwargs)  # noqa: E501
            return data

    def import_role_with_http_info(self, role_file, **kwargs):  # noqa: E501
        """Import Authorization Role  # noqa: E501

        Import Authorization Role  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_role_with_http_info(role_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file role_file: File with contenet of RoleDataFull. (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['role_file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method import_role" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'role_file' is set
        if self.api_client.client_side_validation and ('role_file' not in params or
                                                       params['role_file'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `role_file` when calling `import_role`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'role_file' in params:
            local_var_files['roleFile'] = params['role_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/config/authorization/role/import', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_secrets(self, **kwargs):  # noqa: E501
        """Get list of secret names  # noqa: E501

        Get the list of names of all the secrets in the vault  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_secrets(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: StringListResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_secrets_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_secrets_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_secrets_with_http_info(self, **kwargs):  # noqa: E501
        """Get list of secret names  # noqa: E501

        Get the list of names of all the secrets in the vault  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_secrets_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: StringListResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_secrets" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/config/secrets', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StringListResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def ping_agent(self, server, agent, **kwargs):  # noqa: E501
        """ping to the agent in the Server  # noqa: E501

        Ping an Agent.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.ping_agent(server, agent, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server: The Server. (required)
        :param str agent: The Agent. (required)
        :param PingAgentParams body:
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.ping_agent_with_http_info(server, agent, **kwargs)  # noqa: E501
        else:
            (data) = self.ping_agent_with_http_info(server, agent, **kwargs)  # noqa: E501
            return data

    def ping_agent_with_http_info(self, server, agent, **kwargs):  # noqa: E501
        """ping to the agent in the Server  # noqa: E501

        Ping an Agent.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.ping_agent_with_http_info(server, agent, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server: The Server. (required)
        :param str agent: The Agent. (required)
        :param PingAgentParams body:
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['server', 'agent', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method ping_agent" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in params or
                                                       params['server'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `server` when calling `ping_agent`")  # noqa: E501
        # verify the required parameter 'agent' is set
        if self.api_client.client_side_validation and ('agent' not in params or
                                                       params['agent'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `agent` when calling `ping_agent`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in params:
            path_params['server'] = params['server']  # noqa: E501
        if 'agent' in params:
            path_params['agent'] = params['agent']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/config/server/{server}/agent/{agent}/ping', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def recycle_item(self, id, **kwargs):  # noqa: E501
        """recycle item  # noqa: E501

        Recycle an item  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.recycle_item(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: item data (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.recycle_item_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.recycle_item_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def recycle_item_with_http_info(self, id, **kwargs):  # noqa: E501
        """recycle item  # noqa: E501

        Recycle an item  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.recycle_item_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: item data (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method recycle_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in params or
                                                       params['id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `id` when calling `recycle_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/config/item/{id}/recycle', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_agent_parameter(self, server, agent, name, **kwargs):  # noqa: E501
        """set agent parameter  # noqa: E501

        Set the value of the specified parameter in the specified agent.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_agent_parameter(server, agent, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server: The Server the agent is connected to. (required)
        :param str agent: The name of the agent to update. (required)
        :param str name: The parameter name. (required)
        :param OptionalValue body: The new parameter value.
        :return: KeyValue
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.set_agent_parameter_with_http_info(server, agent, name, **kwargs)  # noqa: E501
        else:
            (data) = self.set_agent_parameter_with_http_info(server, agent, name, **kwargs)  # noqa: E501
            return data

    def set_agent_parameter_with_http_info(self, server, agent, name, **kwargs):  # noqa: E501
        """set agent parameter  # noqa: E501

        Set the value of the specified parameter in the specified agent.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_agent_parameter_with_http_info(server, agent, name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server: The Server the agent is connected to. (required)
        :param str agent: The name of the agent to update. (required)
        :param str name: The parameter name. (required)
        :param OptionalValue body: The new parameter value.
        :return: KeyValue
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['server', 'agent', 'name', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_agent_parameter" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in params or
                                                       params['server'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `server` when calling `set_agent_parameter`")  # noqa: E501
        # verify the required parameter 'agent' is set
        if self.api_client.client_side_validation and ('agent' not in params or
                                                       params['agent'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `agent` when calling `set_agent_parameter`")  # noqa: E501
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in params or
                                                       params['name'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `name` when calling `set_agent_parameter`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in params:
            path_params['server'] = params['server']  # noqa: E501
        if 'agent' in params:
            path_params['agent'] = params['agent']  # noqa: E501
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/config/server/{server}/agent/{agent}/param/{name}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='KeyValue',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_system_setting(self, systemsetting, **kwargs):  # noqa: E501
        """Set system setting for Control-M environment  # noqa: E501

        Set system setting for Control-M environment  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_system_setting(systemsetting, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file systemsetting: System Setting JSON file (required)
        :param file saml2metadatafile: SAML2 Identity Provider Metadata file to upload
        :param str server: Server to which the system settings are applied
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.set_system_setting_with_http_info(systemsetting, **kwargs)  # noqa: E501
        else:
            (data) = self.set_system_setting_with_http_info(systemsetting, **kwargs)  # noqa: E501
            return data

    def set_system_setting_with_http_info(self, systemsetting, **kwargs):  # noqa: E501
        """Set system setting for Control-M environment  # noqa: E501

        Set system setting for Control-M environment  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_system_setting_with_http_info(systemsetting, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file systemsetting: System Setting JSON file (required)
        :param file saml2metadatafile: SAML2 Identity Provider Metadata file to upload
        :param str server: Server to which the system settings are applied
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['systemsetting', 'saml2metadatafile', 'server']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_system_setting" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'systemsetting' is set
        if self.api_client.client_side_validation and ('systemsetting' not in params or
                                                       params['systemsetting'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `systemsetting` when calling `set_system_setting`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'server' in params:
            query_params.append(('server', params['server']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'systemsetting' in params:
            local_var_files['systemsetting'] = params['systemsetting']  # noqa: E501
        if 'saml2metadatafile' in params:
            local_var_files['saml2metadatafile'] = params['saml2metadatafile']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/config/systemsettings', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_user_preferences(self, user_name, user_preferences, **kwargs):  # noqa: E501
        """Set user preferences by user name  # noqa: E501

        Set user preferences by user name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_user_preferences(user_name, user_preferences, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_name: The name of the user (required)
        :param UserPreferences user_preferences: The new value of UserPreferences to set (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.set_user_preferences_with_http_info(user_name, user_preferences, **kwargs)  # noqa: E501
        else:
            (data) = self.set_user_preferences_with_http_info(user_name, user_preferences, **kwargs)  # noqa: E501
            return data

    def set_user_preferences_with_http_info(self, user_name, user_preferences, **kwargs):  # noqa: E501
        """Set user preferences by user name  # noqa: E501

        Set user preferences by user name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_user_preferences_with_http_info(user_name, user_preferences, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_name: The name of the user (required)
        :param UserPreferences user_preferences: The new value of UserPreferences to set (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_name', 'user_preferences']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_user_preferences" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'user_name' is set
        if self.api_client.client_side_validation and ('user_name' not in params or
                                                       params['user_name'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `user_name` when calling `set_user_preferences`")  # noqa: E501
        # verify the required parameter 'user_preferences' is set
        if self.api_client.client_side_validation and ('user_preferences' not in params or
                                                       params['user_preferences'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `user_preferences` when calling `set_user_preferences`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'user_name' in params:
            query_params.append(('userName', params['user_name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'user_preferences' in params:
            body_params = params['user_preferences']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/config/authorization/user/preferences', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def test_run_as_user(self, server, agent, user, **kwargs):  # noqa: E501
        """Test existed Run-as user  # noqa: E501

        Test existing Run-as user in server.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.test_run_as_user(server, agent, user, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server: The Server. (required)
        :param str agent: The Agent (required)
        :param str user: The user name (required)
        :param RunAsUserDetailsData run_as_user_details_data: Run as user details data
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.test_run_as_user_with_http_info(server, agent, user, **kwargs)  # noqa: E501
        else:
            (data) = self.test_run_as_user_with_http_info(server, agent, user, **kwargs)  # noqa: E501
            return data

    def test_run_as_user_with_http_info(self, server, agent, user, **kwargs):  # noqa: E501
        """Test existed Run-as user  # noqa: E501

        Test existing Run-as user in server.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.test_run_as_user_with_http_info(server, agent, user, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server: The Server. (required)
        :param str agent: The Agent (required)
        :param str user: The user name (required)
        :param RunAsUserDetailsData run_as_user_details_data: Run as user details data
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['server', 'agent', 'user', 'run_as_user_details_data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method test_run_as_user" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in params or
                                                       params['server'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `server` when calling `test_run_as_user`")  # noqa: E501
        # verify the required parameter 'agent' is set
        if self.api_client.client_side_validation and ('agent' not in params or
                                                       params['agent'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `agent` when calling `test_run_as_user`")  # noqa: E501
        # verify the required parameter 'user' is set
        if self.api_client.client_side_validation and ('user' not in params or
                                                       params['user'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `user` when calling `test_run_as_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in params:
            path_params['server'] = params['server']  # noqa: E501
        if 'agent' in params:
            path_params['agent'] = params['agent']  # noqa: E501
        if 'user' in params:
            path_params['user'] = params['user']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'run_as_user_details_data' in params:
            body_params = params['run_as_user_details_data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/config/server/{server}/runasuser/{agent}/{user}/test', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_fts_settings(self, server, agent, fts_settings_data, **kwargs):  # noqa: E501
        """Update File Transfer Server (FTS) configuration data.  # noqa: E501

        Update File Transfer Server (FTS) configuration data.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_fts_settings(server, agent, fts_settings_data, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server: The Server (required)
        :param str agent: The Agent (required)
        :param FtsSettingsData fts_settings_data: File Transfer Server (FTS) configuration data (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_fts_settings_with_http_info(server, agent, fts_settings_data, **kwargs)  # noqa: E501
        else:
            (data) = self.update_fts_settings_with_http_info(server, agent, fts_settings_data, **kwargs)  # noqa: E501
            return data

    def update_fts_settings_with_http_info(self, server, agent, fts_settings_data, **kwargs):  # noqa: E501
        """Update File Transfer Server (FTS) configuration data.  # noqa: E501

        Update File Transfer Server (FTS) configuration data.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_fts_settings_with_http_info(server, agent, fts_settings_data, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server: The Server (required)
        :param str agent: The Agent (required)
        :param FtsSettingsData fts_settings_data: File Transfer Server (FTS) configuration data (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['server', 'agent', 'fts_settings_data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_fts_settings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in params or
                                                       params['server'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `server` when calling `update_fts_settings`")  # noqa: E501
        # verify the required parameter 'agent' is set
        if self.api_client.client_side_validation and ('agent' not in params or
                                                       params['agent'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `agent` when calling `update_fts_settings`")  # noqa: E501
        # verify the required parameter 'fts_settings_data' is set
        if self.api_client.client_side_validation and ('fts_settings_data' not in params or
                                                       params['fts_settings_data'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `fts_settings_data` when calling `update_fts_settings`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in params:
            path_params['server'] = params['server']  # noqa: E501
        if 'agent' in params:
            path_params['agent'] = params['agent']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'fts_settings_data' in params:
            body_params = params['fts_settings_data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/config/server/{server}/agent/{agent}/mft/fts/settings', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_hosts_in_hostgroup(self, server, hostgroup, host_group_member_params_list, **kwargs):  # noqa: E501
        """update agents in hostgroup.  # noqa: E501

        update agents in hostgroup.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_hosts_in_hostgroup(server, hostgroup, host_group_member_params_list, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server: The Server the agent is connected to. (required)
        :param str hostgroup: The hostgroup name (required)
        :param HostgroupProperties host_group_member_params_list: Agent list to update in a hostgroup (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_hosts_in_hostgroup_with_http_info(server, hostgroup, host_group_member_params_list, **kwargs)  # noqa: E501
        else:
            (data) = self.update_hosts_in_hostgroup_with_http_info(server, hostgroup, host_group_member_params_list, **kwargs)  # noqa: E501
            return data

    def update_hosts_in_hostgroup_with_http_info(self, server, hostgroup, host_group_member_params_list, **kwargs):  # noqa: E501
        """update agents in hostgroup.  # noqa: E501

        update agents in hostgroup.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_hosts_in_hostgroup_with_http_info(server, hostgroup, host_group_member_params_list, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server: The Server the agent is connected to. (required)
        :param str hostgroup: The hostgroup name (required)
        :param HostgroupProperties host_group_member_params_list: Agent list to update in a hostgroup (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['server', 'hostgroup', 'host_group_member_params_list']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_hosts_in_hostgroup" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in params or
                                                       params['server'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `server` when calling `update_hosts_in_hostgroup`")  # noqa: E501
        # verify the required parameter 'hostgroup' is set
        if self.api_client.client_side_validation and ('hostgroup' not in params or
                                                       params['hostgroup'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `hostgroup` when calling `update_hosts_in_hostgroup`")  # noqa: E501
        # verify the required parameter 'host_group_member_params_list' is set
        if self.api_client.client_side_validation and ('host_group_member_params_list' not in params or
                                                       params['host_group_member_params_list'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `host_group_member_params_list` when calling `update_hosts_in_hostgroup`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in params:
            path_params['server'] = params['server']  # noqa: E501
        if 'hostgroup' in params:
            path_params['hostgroup'] = params['hostgroup']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'host_group_member_params_list' in params:
            body_params = params['host_group_member_params_list']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/config/server/{server}/hostgroup/{hostgroup}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_mft_configuration(self, server, agent, mft_configuration_data, **kwargs):  # noqa: E501
        """Update MFT Configuration  # noqa: E501

        Update MFT Configuration  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_mft_configuration(server, agent, mft_configuration_data, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server: The Server (required)
        :param str agent: The Agent (required)
        :param MftConfigurationData mft_configuration_data: MFT Configuration Data (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_mft_configuration_with_http_info(server, agent, mft_configuration_data, **kwargs)  # noqa: E501
        else:
            (data) = self.update_mft_configuration_with_http_info(server, agent, mft_configuration_data, **kwargs)  # noqa: E501
            return data

    def update_mft_configuration_with_http_info(self, server, agent, mft_configuration_data, **kwargs):  # noqa: E501
        """Update MFT Configuration  # noqa: E501

        Update MFT Configuration  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_mft_configuration_with_http_info(server, agent, mft_configuration_data, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server: The Server (required)
        :param str agent: The Agent (required)
        :param MftConfigurationData mft_configuration_data: MFT Configuration Data (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['server', 'agent', 'mft_configuration_data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_mft_configuration" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in params or
                                                       params['server'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `server` when calling `update_mft_configuration`")  # noqa: E501
        # verify the required parameter 'agent' is set
        if self.api_client.client_side_validation and ('agent' not in params or
                                                       params['agent'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `agent` when calling `update_mft_configuration`")  # noqa: E501
        # verify the required parameter 'mft_configuration_data' is set
        if self.api_client.client_side_validation and ('mft_configuration_data' not in params or
                                                       params['mft_configuration_data'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `mft_configuration_data` when calling `update_mft_configuration`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in params:
            path_params['server'] = params['server']  # noqa: E501
        if 'agent' in params:
            path_params['agent'] = params['agent']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'mft_configuration_data' in params:
            body_params = params['mft_configuration_data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/config/server/{server}/agent/{agent}/mft/configuration', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_pgp_template(self, server, agent, template_name, pgp_template_data, **kwargs):  # noqa: E501
        """Update PGP Template  # noqa: E501

        Update PGP Template  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_pgp_template(server, agent, template_name, pgp_template_data, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server: The Server (required)
        :param str agent: The Agent (required)
        :param str template_name: The PGP Template Name (required)
        :param PgpTemplateData pgp_template_data: PGP Template Data (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_pgp_template_with_http_info(server, agent, template_name, pgp_template_data, **kwargs)  # noqa: E501
        else:
            (data) = self.update_pgp_template_with_http_info(server, agent, template_name, pgp_template_data, **kwargs)  # noqa: E501
            return data

    def update_pgp_template_with_http_info(self, server, agent, template_name, pgp_template_data, **kwargs):  # noqa: E501
        """Update PGP Template  # noqa: E501

        Update PGP Template  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_pgp_template_with_http_info(server, agent, template_name, pgp_template_data, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server: The Server (required)
        :param str agent: The Agent (required)
        :param str template_name: The PGP Template Name (required)
        :param PgpTemplateData pgp_template_data: PGP Template Data (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['server', 'agent', 'template_name', 'pgp_template_data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_pgp_template" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in params or
                                                       params['server'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `server` when calling `update_pgp_template`")  # noqa: E501
        # verify the required parameter 'agent' is set
        if self.api_client.client_side_validation and ('agent' not in params or
                                                       params['agent'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `agent` when calling `update_pgp_template`")  # noqa: E501
        # verify the required parameter 'template_name' is set
        if self.api_client.client_side_validation and ('template_name' not in params or
                                                       params['template_name'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `template_name` when calling `update_pgp_template`")  # noqa: E501
        # verify the required parameter 'pgp_template_data' is set
        if self.api_client.client_side_validation and ('pgp_template_data' not in params or
                                                       params['pgp_template_data'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `pgp_template_data` when calling `update_pgp_template`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in params:
            path_params['server'] = params['server']  # noqa: E501
        if 'agent' in params:
            path_params['agent'] = params['agent']  # noqa: E501
        if 'template_name' in params:
            path_params['templateName'] = params['template_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'pgp_template_data' in params:
            body_params = params['pgp_template_data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/config/server/{server}/agent/{agent}/mft/pgptemplate/{templateName}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_role(self, role, role_file, **kwargs):  # noqa: E501
        """Update Authorization Role  # noqa: E501

        Update Authorization Role  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_role(role, role_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str role: The Role name. (required)
        :param file role_file: File with contenet of Role Data. (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_role_with_http_info(role, role_file, **kwargs)  # noqa: E501
        else:
            (data) = self.update_role_with_http_info(role, role_file, **kwargs)  # noqa: E501
            return data

    def update_role_with_http_info(self, role, role_file, **kwargs):  # noqa: E501
        """Update Authorization Role  # noqa: E501

        Update Authorization Role  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_role_with_http_info(role, role_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str role: The Role name. (required)
        :param file role_file: File with contenet of Role Data. (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['role', 'role_file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_role" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'role' is set
        if self.api_client.client_side_validation and ('role' not in params or
                                                       params['role'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `role` when calling `update_role`")  # noqa: E501
        # verify the required parameter 'role_file' is set
        if self.api_client.client_side_validation and ('role_file' not in params or
                                                       params['role_file'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `role_file` when calling `update_role`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'role' in params:
            path_params['role'] = params['role']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'role_file' in params:
            local_var_files['roleFile'] = params['role_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/config/authorization/role/{role}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_run_as_user(self, server, agent, user, run_as_user_details_data, **kwargs):  # noqa: E501
        """Update Run-as user  # noqa: E501

        Update Run-as user details in server.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_run_as_user(server, agent, user, run_as_user_details_data, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server: The Server. (required)
        :param str agent: The Agent (required)
        :param str user: The user name (required)
        :param RunAsUserDetailsData run_as_user_details_data: Run as user details data (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_run_as_user_with_http_info(server, agent, user, run_as_user_details_data, **kwargs)  # noqa: E501
        else:
            (data) = self.update_run_as_user_with_http_info(server, agent, user, run_as_user_details_data, **kwargs)  # noqa: E501
            return data

    def update_run_as_user_with_http_info(self, server, agent, user, run_as_user_details_data, **kwargs):  # noqa: E501
        """Update Run-as user  # noqa: E501

        Update Run-as user details in server.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_run_as_user_with_http_info(server, agent, user, run_as_user_details_data, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server: The Server. (required)
        :param str agent: The Agent (required)
        :param str user: The user name (required)
        :param RunAsUserDetailsData run_as_user_details_data: Run as user details data (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['server', 'agent', 'user', 'run_as_user_details_data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_run_as_user" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in params or
                                                       params['server'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `server` when calling `update_run_as_user`")  # noqa: E501
        # verify the required parameter 'agent' is set
        if self.api_client.client_side_validation and ('agent' not in params or
                                                       params['agent'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `agent` when calling `update_run_as_user`")  # noqa: E501
        # verify the required parameter 'user' is set
        if self.api_client.client_side_validation and ('user' not in params or
                                                       params['user'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `user` when calling `update_run_as_user`")  # noqa: E501
        # verify the required parameter 'run_as_user_details_data' is set
        if self.api_client.client_side_validation and ('run_as_user_details_data' not in params or
                                                       params['run_as_user_details_data'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `run_as_user_details_data` when calling `update_run_as_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in params:
            path_params['server'] = params['server']  # noqa: E501
        if 'agent' in params:
            path_params['agent'] = params['agent']  # noqa: E501
        if 'user' in params:
            path_params['user'] = params['user']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'run_as_user_details_data' in params:
            body_params = params['run_as_user_details_data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/config/server/{server}/runasuser/{agent}/{user}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_secret(self, name, **kwargs):  # noqa: E501
        """Update an existing secret  # noqa: E501

        Update an existing secret in the secrets vault.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_secret(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: The name of the secret to update (required)
        :param SecretValue value: The new value for the secret
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_secret_with_http_info(name, **kwargs)  # noqa: E501
        else:
            (data) = self.update_secret_with_http_info(name, **kwargs)  # noqa: E501
            return data

    def update_secret_with_http_info(self, name, **kwargs):  # noqa: E501
        """Update an existing secret  # noqa: E501

        Update an existing secret in the secrets vault.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_secret_with_http_info(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: The name of the secret to update (required)
        :param SecretValue value: The new value for the secret
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'value']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_secret" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in params or
                                                       params['name'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `name` when calling `update_secret`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'value' in params:
            body_params = params['value']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/config/secret/{name}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_user(self, user, user_file, **kwargs):  # noqa: E501
        """Update user  # noqa: E501

        Update user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_user(user, user_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user: The user name. (required)
        :param file user_file: File with contenet of user data. (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_user_with_http_info(user, user_file, **kwargs)  # noqa: E501
        else:
            (data) = self.update_user_with_http_info(user, user_file, **kwargs)  # noqa: E501
            return data

    def update_user_with_http_info(self, user, user_file, **kwargs):  # noqa: E501
        """Update user  # noqa: E501

        Update user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_user_with_http_info(user, user_file, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user: The user name. (required)
        :param file user_file: File with contenet of user data. (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user', 'user_file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_user" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'user' is set
        if self.api_client.client_side_validation and ('user' not in params or
                                                       params['user'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `user` when calling `update_user`")  # noqa: E501
        # verify the required parameter 'user_file' is set
        if self.api_client.client_side_validation and ('user_file' not in params or
                                                       params['user_file'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `user_file` when calling `update_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user' in params:
            path_params['user'] = params['user']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'user_file' in params:
            local_var_files['userFile'] = params['user_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/config/authorization/user/{user}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_zos_template(self, server, agent, template_name, zos_template_data, **kwargs):  # noqa: E501
        """Update z/OS Template  # noqa: E501

        Update z/OS Template  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_zos_template(server, agent, template_name, zos_template_data, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server: The Server (required)
        :param str agent: The Agent (required)
        :param str template_name: The z/OS Template Name (required)
        :param ZosTemplateData zos_template_data: z/OS Template Data (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_zos_template_with_http_info(server, agent, template_name, zos_template_data, **kwargs)  # noqa: E501
        else:
            (data) = self.update_zos_template_with_http_info(server, agent, template_name, zos_template_data, **kwargs)  # noqa: E501
            return data

    def update_zos_template_with_http_info(self, server, agent, template_name, zos_template_data, **kwargs):  # noqa: E501
        """Update z/OS Template  # noqa: E501

        Update z/OS Template  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_zos_template_with_http_info(server, agent, template_name, zos_template_data, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str server: The Server (required)
        :param str agent: The Agent (required)
        :param str template_name: The z/OS Template Name (required)
        :param ZosTemplateData zos_template_data: z/OS Template Data (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['server', 'agent', 'template_name', 'zos_template_data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_zos_template" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in params or
                                                       params['server'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `server` when calling `update_zos_template`")  # noqa: E501
        # verify the required parameter 'agent' is set
        if self.api_client.client_side_validation and ('agent' not in params or
                                                       params['agent'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `agent` when calling `update_zos_template`")  # noqa: E501
        # verify the required parameter 'template_name' is set
        if self.api_client.client_side_validation and ('template_name' not in params or
                                                       params['template_name'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `template_name` when calling `update_zos_template`")  # noqa: E501
        # verify the required parameter 'zos_template_data' is set
        if self.api_client.client_side_validation and ('zos_template_data' not in params or
                                                       params['zos_template_data'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `zos_template_data` when calling `update_zos_template`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in params:
            path_params['server'] = params['server']  # noqa: E501
        if 'agent' in params:
            path_params['agent'] = params['agent']  # noqa: E501
        if 'template_name' in params:
            path_params['templateName'] = params['template_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'zos_template_data' in params:
            body_params = params['zos_template_data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/config/server/{server}/agent/{agent}/mft/zostemplate/{templateName}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
