# coding: utf-8

"""
    Control-M Services

    Provides access to BMC Control-M Services  # noqa: E501

    The version of the OpenAPI document: 9.22.30
    Contact: customer_support@bmc.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from clients.ctm_api_client.api_client import ApiClient
from clients.ctm_api_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class ArchiveApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_archive_job_log(self, job_id, run_no, **kwargs):  # noqa: E501
        """Get job log  # noqa: E501

        Get job log by unique job key  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_archive_job_log(job_id, run_no, async_req=True)
        >>> result = thread.get()

        :param job_id: The job ID (required)
        :type job_id: str
        :param run_no: The execution number in case of multiple executions (required)
        :type run_no: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        return self.get_archive_job_log_with_http_info(job_id, run_no, **kwargs)  # noqa: E501

    def get_archive_job_log_with_http_info(self, job_id, run_no, **kwargs):  # noqa: E501
        """Get job log  # noqa: E501

        Get job log by unique job key  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_archive_job_log_with_http_info(job_id, run_no, async_req=True)
        >>> result = thread.get()

        :param job_id: The job ID (required)
        :type job_id: str
        :param run_no: The execution number in case of multiple executions (required)
        :type run_no: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'job_id',
            'run_no'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_archive_job_log" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'job_id' is set
        if self.api_client.client_side_validation and ('job_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['job_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `job_id` when calling `get_archive_job_log`")  # noqa: E501
        # verify the required parameter 'run_no' is set
        if self.api_client.client_side_validation and ('run_no' not in local_var_params or  # noqa: E501
                                                        local_var_params['run_no'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `run_no` when calling `get_archive_job_log`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'job_id' in local_var_params:
            path_params['jobId'] = local_var_params['job_id']  # noqa: E501

        query_params = []
        if 'run_no' in local_var_params and local_var_params['run_no'] is not None:  # noqa: E501
            query_params.append(('runNo', local_var_params['run_no']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "str",
            400: "ErrorList",
            401: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
            503: "ErrorList",
        }

        return self.api_client.call_api(
            '/archive/{jobId}/log', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_archive_job_output(self, job_id, run_no, **kwargs):  # noqa: E501
        """Get job output  # noqa: E501

        Get job output by unique job key  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_archive_job_output(job_id, run_no, async_req=True)
        >>> result = thread.get()

        :param job_id: The job ID (required)
        :type job_id: str
        :param run_no: The execution number in case of multiple executions (required)
        :type run_no: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        return self.get_archive_job_output_with_http_info(job_id, run_no, **kwargs)  # noqa: E501

    def get_archive_job_output_with_http_info(self, job_id, run_no, **kwargs):  # noqa: E501
        """Get job output  # noqa: E501

        Get job output by unique job key  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_archive_job_output_with_http_info(job_id, run_no, async_req=True)
        >>> result = thread.get()

        :param job_id: The job ID (required)
        :type job_id: str
        :param run_no: The execution number in case of multiple executions (required)
        :type run_no: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'job_id',
            'run_no'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_archive_job_output" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'job_id' is set
        if self.api_client.client_side_validation and ('job_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['job_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `job_id` when calling `get_archive_job_output`")  # noqa: E501
        # verify the required parameter 'run_no' is set
        if self.api_client.client_side_validation and ('run_no' not in local_var_params or  # noqa: E501
                                                        local_var_params['run_no'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `run_no` when calling `get_archive_job_output`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'job_id' in local_var_params:
            path_params['jobId'] = local_var_params['job_id']  # noqa: E501

        query_params = []
        if 'run_no' in local_var_params and local_var_params['run_no'] is not None:  # noqa: E501
            query_params.append(('runNo', local_var_params['run_no']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "str",
            400: "ErrorList",
            401: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
            503: "ErrorList",
        }

        return self.api_client.call_api(
            '/archive/{jobId}/output', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def search_jobs(self, **kwargs):  # noqa: E501
        """Search jobs in Archive  # noqa: E501

        Get all the Control-M Archiving jobs that match the search criterias  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.search_jobs(async_req=True)
        >>> result = thread.get()

        :param limit: maximum jobs to fetch (default 500).
        :type limit: int
        :param jobname: The name of the job.
        :type jobname: str
        :param jobid:
        :type jobid: str
        :param ctm: The name of the Control-M server in which the job was ordered from.
        :type ctm: str
        :param server: The name of the Control-M server in which the job was ordered from.
        :type server: str
        :param folder: The name of the parent folder.
        :type folder: str
        :param from_time: Job execution start date. Date format - YYYY-MM-DD.
        :type from_time: str
        :param to_time: Job execution end date. Date format - YYYY-MM-DD.
        :type to_time: str
        :param log_contains: Job log must contain the given phrase.
        :type log_contains: str
        :param output_contains: Job output must contain the given phrase.
        :type output_contains: str
        :param application: The name of the application the jobs belong to.
        :type application: str
        :param sub_application: The name of the sub-application the jobs belong to.
        :type sub_application: str
        :param library: The job's library name.
        :type library: str
        :param mem_name: Member name.
        :type mem_name: str
        :param mem_library: Member's library.
        :type mem_library: str
        :param host:
        :type host: str
        :param host_group: Job's host group.
        :type host_group: str
        :param run_as: Runs as (username on agent machine).
        :type run_as: str
        :param order_id: Job's order id.
        :type order_id: str
        :param status: The job's end status.
        :type status: str
        :param order_date_from: Indicating a date by which will look for jobs that their order date started afterwards. Date format - YYYY-MM-DD.
        :type order_date_from: str
        :param order_date_to: Indicating a date by which will look for jobs that their order date ended before. Date format - YYYY-MM-DD.
        :type order_date_to: str
        :param number_of_runs:
        :type number_of_runs: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ArchiveJobsList
        """
        kwargs['_return_http_data_only'] = True
        return self.search_jobs_with_http_info(**kwargs)  # noqa: E501

    def search_jobs_with_http_info(self, **kwargs):  # noqa: E501
        """Search jobs in Archive  # noqa: E501

        Get all the Control-M Archiving jobs that match the search criterias  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.search_jobs_with_http_info(async_req=True)
        >>> result = thread.get()

        :param limit: maximum jobs to fetch (default 500).
        :type limit: int
        :param jobname: The name of the job.
        :type jobname: str
        :param jobid:
        :type jobid: str
        :param ctm: The name of the Control-M server in which the job was ordered from.
        :type ctm: str
        :param server: The name of the Control-M server in which the job was ordered from.
        :type server: str
        :param folder: The name of the parent folder.
        :type folder: str
        :param from_time: Job execution start date. Date format - YYYY-MM-DD.
        :type from_time: str
        :param to_time: Job execution end date. Date format - YYYY-MM-DD.
        :type to_time: str
        :param log_contains: Job log must contain the given phrase.
        :type log_contains: str
        :param output_contains: Job output must contain the given phrase.
        :type output_contains: str
        :param application: The name of the application the jobs belong to.
        :type application: str
        :param sub_application: The name of the sub-application the jobs belong to.
        :type sub_application: str
        :param library: The job's library name.
        :type library: str
        :param mem_name: Member name.
        :type mem_name: str
        :param mem_library: Member's library.
        :type mem_library: str
        :param host:
        :type host: str
        :param host_group: Job's host group.
        :type host_group: str
        :param run_as: Runs as (username on agent machine).
        :type run_as: str
        :param order_id: Job's order id.
        :type order_id: str
        :param status: The job's end status.
        :type status: str
        :param order_date_from: Indicating a date by which will look for jobs that their order date started afterwards. Date format - YYYY-MM-DD.
        :type order_date_from: str
        :param order_date_to: Indicating a date by which will look for jobs that their order date ended before. Date format - YYYY-MM-DD.
        :type order_date_to: str
        :param number_of_runs:
        :type number_of_runs: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ArchiveJobsList, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'limit',
            'jobname',
            'jobid',
            'ctm',
            'server',
            'folder',
            'from_time',
            'to_time',
            'log_contains',
            'output_contains',
            'application',
            'sub_application',
            'library',
            'mem_name',
            'mem_library',
            'host',
            'host_group',
            'run_as',
            'order_id',
            'status',
            'order_date_from',
            'order_date_to',
            'number_of_runs'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_jobs" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] > 1000:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `search_jobs`, must be a value less than or equal to `1000`")  # noqa: E501
        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `search_jobs`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'jobname' in local_var_params and local_var_params['jobname'] is not None:  # noqa: E501
            query_params.append(('jobname', local_var_params['jobname']))  # noqa: E501
        if 'jobid' in local_var_params and local_var_params['jobid'] is not None:  # noqa: E501
            query_params.append(('jobid', local_var_params['jobid']))  # noqa: E501
        if 'ctm' in local_var_params and local_var_params['ctm'] is not None:  # noqa: E501
            query_params.append(('ctm', local_var_params['ctm']))  # noqa: E501
        if 'server' in local_var_params and local_var_params['server'] is not None:  # noqa: E501
            query_params.append(('server', local_var_params['server']))  # noqa: E501
        if 'folder' in local_var_params and local_var_params['folder'] is not None:  # noqa: E501
            query_params.append(('folder', local_var_params['folder']))  # noqa: E501
        if 'from_time' in local_var_params and local_var_params['from_time'] is not None:  # noqa: E501
            query_params.append(('fromTime', local_var_params['from_time']))  # noqa: E501
        if 'to_time' in local_var_params and local_var_params['to_time'] is not None:  # noqa: E501
            query_params.append(('toTime', local_var_params['to_time']))  # noqa: E501
        if 'log_contains' in local_var_params and local_var_params['log_contains'] is not None:  # noqa: E501
            query_params.append(('logContains', local_var_params['log_contains']))  # noqa: E501
        if 'output_contains' in local_var_params and local_var_params['output_contains'] is not None:  # noqa: E501
            query_params.append(('outputContains', local_var_params['output_contains']))  # noqa: E501
        if 'application' in local_var_params and local_var_params['application'] is not None:  # noqa: E501
            query_params.append(('application', local_var_params['application']))  # noqa: E501
        if 'sub_application' in local_var_params and local_var_params['sub_application'] is not None:  # noqa: E501
            query_params.append(('subApplication', local_var_params['sub_application']))  # noqa: E501
        if 'library' in local_var_params and local_var_params['library'] is not None:  # noqa: E501
            query_params.append(('library', local_var_params['library']))  # noqa: E501
        if 'mem_name' in local_var_params and local_var_params['mem_name'] is not None:  # noqa: E501
            query_params.append(('memName', local_var_params['mem_name']))  # noqa: E501
        if 'mem_library' in local_var_params and local_var_params['mem_library'] is not None:  # noqa: E501
            query_params.append(('memLibrary', local_var_params['mem_library']))  # noqa: E501
        if 'host' in local_var_params and local_var_params['host'] is not None:  # noqa: E501
            query_params.append(('host', local_var_params['host']))  # noqa: E501
        if 'host_group' in local_var_params and local_var_params['host_group'] is not None:  # noqa: E501
            query_params.append(('hostGroup', local_var_params['host_group']))  # noqa: E501
        if 'run_as' in local_var_params and local_var_params['run_as'] is not None:  # noqa: E501
            query_params.append(('runAs', local_var_params['run_as']))  # noqa: E501
        if 'order_id' in local_var_params and local_var_params['order_id'] is not None:  # noqa: E501
            query_params.append(('orderId', local_var_params['order_id']))  # noqa: E501
        if 'status' in local_var_params and local_var_params['status'] is not None:  # noqa: E501
            query_params.append(('status', local_var_params['status']))  # noqa: E501
        if 'order_date_from' in local_var_params and local_var_params['order_date_from'] is not None:  # noqa: E501
            query_params.append(('orderDateFrom', local_var_params['order_date_from']))  # noqa: E501
        if 'order_date_to' in local_var_params and local_var_params['order_date_to'] is not None:  # noqa: E501
            query_params.append(('orderDateTo', local_var_params['order_date_to']))  # noqa: E501
        if 'number_of_runs' in local_var_params and local_var_params['number_of_runs'] is not None:  # noqa: E501
            query_params.append(('numberOfRuns', local_var_params['number_of_runs']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "ArchiveJobsList",
            206: "ArchiveJobsList",
            400: "ErrorList",
            401: "ErrorList",
            500: "ErrorList",
            503: "ErrorList",
        }

        return self.api_client.call_api(
            '/archive/search', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))
