# coding: utf-8

"""
    Control-M Services

    Provides access to BMC Control-M Services  # noqa: E501

    The version of the OpenAPI document: 9.22.30
    Contact: customer_support@bmc.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from clients.ctm_api_client.api_client import ApiClient
from clients.ctm_api_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class RunApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def activate_workload_policy(self, policy, **kwargs):  # noqa: E501
        """activate workload policy  # noqa: E501

        Activate a workload policy, supports wildcard in names  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.activate_workload_policy(policy, async_req=True)
        >>> result = thread.get()

        :param policy: The policy name to be activated. Case sensitive. Wildcards can be used. (required)
        :type policy: str
        :param ctm: Optional Control-M Server filter.
        :type ctm: str
        :param server: Optional Control-M Server filter.
        :type server: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WorkloadPolicyStateList
        """
        kwargs['_return_http_data_only'] = True
        return self.activate_workload_policy_with_http_info(policy, **kwargs)  # noqa: E501

    def activate_workload_policy_with_http_info(self, policy, **kwargs):  # noqa: E501
        """activate workload policy  # noqa: E501

        Activate a workload policy, supports wildcard in names  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.activate_workload_policy_with_http_info(policy, async_req=True)
        >>> result = thread.get()

        :param policy: The policy name to be activated. Case sensitive. Wildcards can be used. (required)
        :type policy: str
        :param ctm: Optional Control-M Server filter.
        :type ctm: str
        :param server: Optional Control-M Server filter.
        :type server: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WorkloadPolicyStateList, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'policy',
            'ctm',
            'server'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method activate_workload_policy" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'policy' is set
        if self.api_client.client_side_validation and ('policy' not in local_var_params or  # noqa: E501
                                                        local_var_params['policy'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `policy` when calling `activate_workload_policy`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'policy' in local_var_params:
            path_params['policy'] = local_var_params['policy']  # noqa: E501

        query_params = []
        if 'ctm' in local_var_params and local_var_params['ctm'] is not None:  # noqa: E501
            query_params.append(('ctm', local_var_params['ctm']))  # noqa: E501
        if 'server' in local_var_params and local_var_params['server'] is not None:  # noqa: E501
            query_params.append(('server', local_var_params['server']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "WorkloadPolicyStateList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/run/workloadpolicy/{policy}/activate', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def add_event(self, server, event, **kwargs):  # noqa: E501
        """Add a new  event.  # noqa: E501

        Add a new  event. date may be of format MMDD, ODAT to set current controlm date, STAT to set no date. default value is ODAT.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_event(server, event, async_req=True)
        >>> result = thread.get()

        :param server: The Control-M Server hosting the event. (required)
        :type server: str
        :param event: The defined event name. (required)
        :type event: EventParam
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.add_event_with_http_info(server, event, **kwargs)  # noqa: E501

    def add_event_with_http_info(self, server, event, **kwargs):  # noqa: E501
        """Add a new  event.  # noqa: E501

        Add a new  event. date may be of format MMDD, ODAT to set current controlm date, STAT to set no date. default value is ODAT.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_event_with_http_info(server, event, async_req=True)
        >>> result = thread.get()

        :param server: The Control-M Server hosting the event. (required)
        :type server: str
        :param event: The defined event name. (required)
        :type event: EventParam
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'server',
            'event'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_event" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in local_var_params or  # noqa: E501
                                                        local_var_params['server'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `server` when calling `add_event`")  # noqa: E501
        # verify the required parameter 'event' is set
        if self.api_client.client_side_validation and ('event' not in local_var_params or  # noqa: E501
                                                        local_var_params['event'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `event` when calling `add_event`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in local_var_params:
            path_params['server'] = local_var_params['server']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'event' in local_var_params:
            body_params = local_var_params['event']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/run/event/{server}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def add_resource(self, server, resource, **kwargs):  # noqa: E501
        """Add a new pool resource.  # noqa: E501

        Add a new pool resource.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_resource(server, resource, async_req=True)
        >>> result = thread.get()

        :param server: The Control-M Server hosting the resource. (required)
        :type server: str
        :param resource: The defined resource name. (required)
        :type resource: ResourceParam
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.add_resource_with_http_info(server, resource, **kwargs)  # noqa: E501

    def add_resource_with_http_info(self, server, resource, **kwargs):  # noqa: E501
        """Add a new pool resource.  # noqa: E501

        Add a new pool resource.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_resource_with_http_info(server, resource, async_req=True)
        >>> result = thread.get()

        :param server: The Control-M Server hosting the resource. (required)
        :type server: str
        :param resource: The defined resource name. (required)
        :type resource: ResourceParam
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'server',
            'resource'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_resource" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in local_var_params or  # noqa: E501
                                                        local_var_params['server'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `server` when calling `add_resource`")  # noqa: E501
        # verify the required parameter 'resource' is set
        if self.api_client.client_side_validation and ('resource' not in local_var_params or  # noqa: E501
                                                        local_var_params['resource'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `resource` when calling `add_resource`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in local_var_params:
            path_params['server'] = local_var_params['server']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'resource' in local_var_params:
            body_params = local_var_params['resource']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/run/resource/{server}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def add_workload_policies(self, workloadpoliciesfile, **kwargs):  # noqa: E501
        """Add workload policies from definitions file  # noqa: E501

        Add workload policies from json definitions file to Control-M  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_workload_policies(workloadpoliciesfile, async_req=True)
        >>> result = thread.get()

        :param workloadpoliciesfile: A file that contains definitions of workload policies (required)
        :type workloadpoliciesfile: file
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WorkloadPoliciesFileResults
        """
        kwargs['_return_http_data_only'] = True
        return self.add_workload_policies_with_http_info(workloadpoliciesfile, **kwargs)  # noqa: E501

    def add_workload_policies_with_http_info(self, workloadpoliciesfile, **kwargs):  # noqa: E501
        """Add workload policies from definitions file  # noqa: E501

        Add workload policies from json definitions file to Control-M  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_workload_policies_with_http_info(workloadpoliciesfile, async_req=True)
        >>> result = thread.get()

        :param workloadpoliciesfile: A file that contains definitions of workload policies (required)
        :type workloadpoliciesfile: file
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WorkloadPoliciesFileResults, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'workloadpoliciesfile'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_workload_policies" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'workloadpoliciesfile' is set
        if self.api_client.client_side_validation and ('workloadpoliciesfile' not in local_var_params or  # noqa: E501
                                                        local_var_params['workloadpoliciesfile'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `workloadpoliciesfile` when calling `add_workload_policies`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}
        if 'workloadpoliciesfile' in local_var_params:
            local_var_files['workloadpoliciesfile'] = local_var_params['workloadpoliciesfile']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['multipart/form-data'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "WorkloadPoliciesFileResults",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/run/workloadpolicies', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def bypass(self, job_id, bypass_option, **kwargs):  # noqa: E501
        """Bypass scheduling criterias definition  # noqa: E501

        Bypass scheduling criterias definition  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.bypass(job_id, bypass_option, async_req=True)
        >>> result = thread.get()

        :param job_id: The job ID (required)
        :type job_id: str
        :param bypass_option: The JSON file that contains definitions of bypass option attributes. (required)
        :type bypass_option: BypassOptionAttributes
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.bypass_with_http_info(job_id, bypass_option, **kwargs)  # noqa: E501

    def bypass_with_http_info(self, job_id, bypass_option, **kwargs):  # noqa: E501
        """Bypass scheduling criterias definition  # noqa: E501

        Bypass scheduling criterias definition  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.bypass_with_http_info(job_id, bypass_option, async_req=True)
        >>> result = thread.get()

        :param job_id: The job ID (required)
        :type job_id: str
        :param bypass_option: The JSON file that contains definitions of bypass option attributes. (required)
        :type bypass_option: BypassOptionAttributes
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'job_id',
            'bypass_option'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method bypass" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'job_id' is set
        if self.api_client.client_side_validation and ('job_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['job_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `job_id` when calling `bypass`")  # noqa: E501
        # verify the required parameter 'bypass_option' is set
        if self.api_client.client_side_validation and ('bypass_option' not in local_var_params or  # noqa: E501
                                                        local_var_params['bypass_option'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `bypass_option` when calling `bypass`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'job_id' in local_var_params:
            path_params['jobId'] = local_var_params['job_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'bypass_option' in local_var_params:
            body_params = local_var_params['bypass_option']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/run/job/{jobId}/bypass', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def confirm_job(self, job_id, **kwargs):  # noqa: E501
        """confirm a job  # noqa: E501

        confirm a job that waits for confirmation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.confirm_job(job_id, async_req=True)
        >>> result = thread.get()

        :param job_id: The job ID (required)
        :type job_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.confirm_job_with_http_info(job_id, **kwargs)  # noqa: E501

    def confirm_job_with_http_info(self, job_id, **kwargs):  # noqa: E501
        """confirm a job  # noqa: E501

        confirm a job that waits for confirmation  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.confirm_job_with_http_info(job_id, async_req=True)
        >>> result = thread.get()

        :param job_id: The job ID (required)
        :type job_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'job_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method confirm_job" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'job_id' is set
        if self.api_client.client_side_validation and ('job_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['job_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `job_id` when calling `confirm_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'job_id' in local_var_params:
            path_params['jobId'] = local_var_params['job_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/run/job/{jobId}/confirm', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def deactivate_workload_policy(self, policy, **kwargs):  # noqa: E501
        """deactivate a workload policy  # noqa: E501

        Deactivate a workload policy, supports wildcard in names  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.deactivate_workload_policy(policy, async_req=True)
        >>> result = thread.get()

        :param policy: The policy name to be deactivated. Case sensitive. Wildcards can be used. (required)
        :type policy: str
        :param ctm: Optional Control-M Server filter.
        :type ctm: str
        :param server: Optional Control-M Server filter.
        :type server: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WorkloadPolicyStateList
        """
        kwargs['_return_http_data_only'] = True
        return self.deactivate_workload_policy_with_http_info(policy, **kwargs)  # noqa: E501

    def deactivate_workload_policy_with_http_info(self, policy, **kwargs):  # noqa: E501
        """deactivate a workload policy  # noqa: E501

        Deactivate a workload policy, supports wildcard in names  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.deactivate_workload_policy_with_http_info(policy, async_req=True)
        >>> result = thread.get()

        :param policy: The policy name to be deactivated. Case sensitive. Wildcards can be used. (required)
        :type policy: str
        :param ctm: Optional Control-M Server filter.
        :type ctm: str
        :param server: Optional Control-M Server filter.
        :type server: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WorkloadPolicyStateList, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'policy',
            'ctm',
            'server'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deactivate_workload_policy" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'policy' is set
        if self.api_client.client_side_validation and ('policy' not in local_var_params or  # noqa: E501
                                                        local_var_params['policy'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `policy` when calling `deactivate_workload_policy`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'policy' in local_var_params:
            path_params['policy'] = local_var_params['policy']  # noqa: E501

        query_params = []
        if 'ctm' in local_var_params and local_var_params['ctm'] is not None:  # noqa: E501
            query_params.append(('ctm', local_var_params['ctm']))  # noqa: E501
        if 'server' in local_var_params and local_var_params['server'] is not None:  # noqa: E501
            query_params.append(('server', local_var_params['server']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "WorkloadPolicyStateList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/run/workloadpolicy/{policy}/deactivate', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_event(self, server, name, date, **kwargs):  # noqa: E501
        """Delete a  event.  # noqa: E501

        Delete a  event.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_event(server, name, date, async_req=True)
        >>> result = thread.get()

        :param server: The Control-M Server hosting the event. (required)
        :type server: str
        :param name: event name (required)
        :type name: str
        :param date: event date (required)
        :type date: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_event_with_http_info(server, name, date, **kwargs)  # noqa: E501

    def delete_event_with_http_info(self, server, name, date, **kwargs):  # noqa: E501
        """Delete a  event.  # noqa: E501

        Delete a  event.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_event_with_http_info(server, name, date, async_req=True)
        >>> result = thread.get()

        :param server: The Control-M Server hosting the event. (required)
        :type server: str
        :param name: event name (required)
        :type name: str
        :param date: event date (required)
        :type date: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'server',
            'name',
            'date'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_event" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in local_var_params or  # noqa: E501
                                                        local_var_params['server'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `server` when calling `delete_event`")  # noqa: E501
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in local_var_params or  # noqa: E501
                                                        local_var_params['name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `name` when calling `delete_event`")  # noqa: E501
        # verify the required parameter 'date' is set
        if self.api_client.client_side_validation and ('date' not in local_var_params or  # noqa: E501
                                                        local_var_params['date'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `date` when calling `delete_event`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in local_var_params:
            path_params['server'] = local_var_params['server']  # noqa: E501
        if 'name' in local_var_params:
            path_params['name'] = local_var_params['name']  # noqa: E501
        if 'date' in local_var_params:
            path_params['date'] = local_var_params['date']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/run/event/{server}/{name}/{date}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_job(self, job_id, **kwargs):  # noqa: E501
        """mark job as deleted  # noqa: E501

        mark delete as deleted  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_job(job_id, async_req=True)
        >>> result = thread.get()

        :param job_id: The job ID (required)
        :type job_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_job_with_http_info(job_id, **kwargs)  # noqa: E501

    def delete_job_with_http_info(self, job_id, **kwargs):  # noqa: E501
        """mark job as deleted  # noqa: E501

        mark delete as deleted  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_job_with_http_info(job_id, async_req=True)
        >>> result = thread.get()

        :param job_id: The job ID (required)
        :type job_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'job_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_job" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'job_id' is set
        if self.api_client.client_side_validation and ('job_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['job_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `job_id` when calling `delete_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'job_id' in local_var_params:
            path_params['jobId'] = local_var_params['job_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/run/job/{jobId}/delete', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_resource(self, server, name, **kwargs):  # noqa: E501
        """Delete a pool resource.  # noqa: E501

        Delete a pool resource.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_resource(server, name, async_req=True)
        >>> result = thread.get()

        :param server: The Control-M Server hosting the resource. (required)
        :type server: str
        :param name: Resource name (required)
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_resource_with_http_info(server, name, **kwargs)  # noqa: E501

    def delete_resource_with_http_info(self, server, name, **kwargs):  # noqa: E501
        """Delete a pool resource.  # noqa: E501

        Delete a pool resource.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_resource_with_http_info(server, name, async_req=True)
        >>> result = thread.get()

        :param server: The Control-M Server hosting the resource. (required)
        :type server: str
        :param name: Resource name (required)
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'server',
            'name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_resource" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in local_var_params or  # noqa: E501
                                                        local_var_params['server'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `server` when calling `delete_resource`")  # noqa: E501
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in local_var_params or  # noqa: E501
                                                        local_var_params['name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `name` when calling `delete_resource`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in local_var_params:
            path_params['server'] = local_var_params['server']  # noqa: E501
        if 'name' in local_var_params:
            path_params['name'] = local_var_params['name']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/run/resource/{server}/{name}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_variables(self, server, variable_names, **kwargs):  # noqa: E501
        """Delete variables from the server.  # noqa: E501

        Delete variables from the server.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_variables(server, variable_names, async_req=True)
        >>> result = thread.get()

        :param server: The server that hosts the variables. (required)
        :type server: str
        :param variable_names: Variables definition file. (required)
        :type variable_names: VariableNames
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_variables_with_http_info(server, variable_names, **kwargs)  # noqa: E501

    def delete_variables_with_http_info(self, server, variable_names, **kwargs):  # noqa: E501
        """Delete variables from the server.  # noqa: E501

        Delete variables from the server.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_variables_with_http_info(server, variable_names, async_req=True)
        >>> result = thread.get()

        :param server: The server that hosts the variables. (required)
        :type server: str
        :param variable_names: Variables definition file. (required)
        :type variable_names: VariableNames
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'server',
            'variable_names'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_variables" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in local_var_params or  # noqa: E501
                                                        local_var_params['server'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `server` when calling `delete_variables`")  # noqa: E501
        # verify the required parameter 'variable_names' is set
        if self.api_client.client_side_validation and ('variable_names' not in local_var_params or  # noqa: E501
                                                        local_var_params['variable_names'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `variable_names` when calling `delete_variables`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in local_var_params:
            path_params['server'] = local_var_params['server']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'variable_names' in local_var_params:
            body_params = local_var_params['variable_names']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/run/variables/{server}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_workload_policy(self, workloadpolicy_name, **kwargs):  # noqa: E501
        """delete workloadpolicy  # noqa: E501

        Delete workloadpolicy  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_workload_policy(workloadpolicy_name, async_req=True)
        >>> result = thread.get()

        :param workloadpolicy_name: The name of the workloadPolicy to be deleted. (required)
        :type workloadpolicy_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_workload_policy_with_http_info(workloadpolicy_name, **kwargs)  # noqa: E501

    def delete_workload_policy_with_http_info(self, workloadpolicy_name, **kwargs):  # noqa: E501
        """delete workloadpolicy  # noqa: E501

        Delete workloadpolicy  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_workload_policy_with_http_info(workloadpolicy_name, async_req=True)
        >>> result = thread.get()

        :param workloadpolicy_name: The name of the workloadPolicy to be deleted. (required)
        :type workloadpolicy_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'workloadpolicy_name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_workload_policy" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'workloadpolicy_name' is set
        if self.api_client.client_side_validation and ('workloadpolicy_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['workloadpolicy_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `workloadpolicy_name` when calling `delete_workload_policy`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workloadpolicy_name' in local_var_params:
            path_params['workloadpolicyName'] = local_var_params['workloadpolicy_name']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/run/workloadpolicy/{workloadpolicyName}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def free_job(self, job_id, **kwargs):  # noqa: E501
        """free an already held the job  # noqa: E501

        free the job  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.free_job(job_id, async_req=True)
        >>> result = thread.get()

        :param job_id: The job ID (required)
        :type job_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.free_job_with_http_info(job_id, **kwargs)  # noqa: E501

    def free_job_with_http_info(self, job_id, **kwargs):  # noqa: E501
        """free an already held the job  # noqa: E501

        free the job  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.free_job_with_http_info(job_id, async_req=True)
        >>> result = thread.get()

        :param job_id: The job ID (required)
        :type job_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'job_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method free_job" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'job_id' is set
        if self.api_client.client_side_validation and ('job_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['job_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `job_id` when calling `free_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'job_id' in local_var_params:
            path_params['jobId'] = local_var_params['job_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/run/job/{jobId}/free', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_active_job(self, job_id, **kwargs):  # noqa: E501
        """get active job  # noqa: E501

        get the active job's data by job's order ID  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_active_job(job_id, async_req=True)
        >>> result = thread.get()

        :param job_id: The job ID (required)
        :type job_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        return self.get_active_job_with_http_info(job_id, **kwargs)  # noqa: E501

    def get_active_job_with_http_info(self, job_id, **kwargs):  # noqa: E501
        """get active job  # noqa: E501

        get the active job's data by job's order ID  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_active_job_with_http_info(job_id, async_req=True)
        >>> result = thread.get()

        :param job_id: The job ID (required)
        :type job_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'job_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_active_job" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'job_id' is set
        if self.api_client.client_side_validation and ('job_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['job_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `job_id` when calling `get_active_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'job_id' in local_var_params:
            path_params['jobId'] = local_var_params['job_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "str",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/run/job/{jobId}/get', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_active_services(self, **kwargs):  # noqa: E501
        """Get SLA active services  # noqa: E501

        Get all SLA active services  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_active_services(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ActiveServices
        """
        kwargs['_return_http_data_only'] = True
        return self.get_active_services_with_http_info(**kwargs)  # noqa: E501

    def get_active_services_with_http_info(self, **kwargs):  # noqa: E501
        """Get SLA active services  # noqa: E501

        Get all SLA active services  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_active_services_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ActiveServices, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_active_services" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "ActiveServices",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/run/services/sla', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_detailed_workload_policies(self, **kwargs):  # noqa: E501
        """get full workLoad policies data that match the search criteria.  # noqa: E501

        get full workLoad policies data as json code that match the requested search criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_detailed_workload_policies(async_req=True)
        >>> result = thread.get()

        :param name:
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        return self.get_detailed_workload_policies_with_http_info(**kwargs)  # noqa: E501

    def get_detailed_workload_policies_with_http_info(self, **kwargs):  # noqa: E501
        """get full workLoad policies data that match the search criteria.  # noqa: E501

        get full workLoad policies data as json code that match the requested search criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_detailed_workload_policies_with_http_info(async_req=True)
        >>> result = thread.get()

        :param name:
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_detailed_workload_policies" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "str",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/run/workloadpolicies/detailed', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_events(self, **kwargs):  # noqa: E501
        """Get all events records for specific search.  # noqa: E501

        Get all events records for specific search.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_events(async_req=True)
        >>> result = thread.get()

        :param ctm: Control-M Server filter.
        :type ctm: str
        :param server: Control-M Server filter.
        :type server: str
        :param name: The event name filter.
        :type name: str
        :param date: The event date filter.
        :type date: str
        :param limit: maximum events to fetch (default 1000).
        :type limit: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[Event]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_events_with_http_info(**kwargs)  # noqa: E501

    def get_events_with_http_info(self, **kwargs):  # noqa: E501
        """Get all events records for specific search.  # noqa: E501

        Get all events records for specific search.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_events_with_http_info(async_req=True)
        >>> result = thread.get()

        :param ctm: Control-M Server filter.
        :type ctm: str
        :param server: Control-M Server filter.
        :type server: str
        :param name: The event name filter.
        :type name: str
        :param date: The event date filter.
        :type date: str
        :param limit: maximum events to fetch (default 1000).
        :type limit: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[Event], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'ctm',
            'server',
            'name',
            'date',
            'limit'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_events" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ctm' in local_var_params and local_var_params['ctm'] is not None:  # noqa: E501
            query_params.append(('ctm', local_var_params['ctm']))  # noqa: E501
        if 'server' in local_var_params and local_var_params['server'] is not None:  # noqa: E501
            query_params.append(('server', local_var_params['server']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'date' in local_var_params and local_var_params['date'] is not None:  # noqa: E501
            query_params.append(('date', local_var_params['date']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "list[Event]",
            400: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/run/events', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_forecast_timeline(self, **kwargs):  # noqa: E501
        """Sends a request to get the schedule and returns a poll ID to track the status of the request.  # noqa: E501

        Sends a request to get the schedule and returns a poll ID to track the status of the request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_forecast_timeline(async_req=True)
        >>> result = thread.get()

        :param ctm: The Control-M/server name.
        :type ctm: str
        :param folder: Name of the folder being requested.
        :type folder: str
        :param rbc: Name of the RuleBasedCalendar being requested.
        :type rbc: str
        :param jobs: Specifies the job(s) within the folder. Defaults to all jobs if not specified. Use '*' as a wildcard for multiple jobs.
        :type jobs: str
        :param library: The name of the z/OS library that contains the jobs.
        :type library: str
        :param filter_type: The type of filter to apply. Options are 'year' or 'relativeMonths'. Defaults to 'relativeMonths'.
        :type filter_type: str
        :param year: Used only when filterType is 'year'. Specifies a particular year and returns a five-year schedule centered around the given year (e.g., input 2024 returns 2022-2026). Defaults to the current year.
        :type year: int
        :param _from: Used only when filterType is 'relativeMonths'. Specifies the start of the range in months relative to the current month. Minimum value is -24. Defaults to 0 (current month).
        :type _from: int
        :param to: Used only when filterType is 'relativeMonths'. Specifies the end of the range in months relative to the current month. Minimum value is +24. Defaults to 11.
        :type to: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ForecastTimelineResults
        """
        kwargs['_return_http_data_only'] = True
        return self.get_forecast_timeline_with_http_info(**kwargs)  # noqa: E501

    def get_forecast_timeline_with_http_info(self, **kwargs):  # noqa: E501
        """Sends a request to get the schedule and returns a poll ID to track the status of the request.  # noqa: E501

        Sends a request to get the schedule and returns a poll ID to track the status of the request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_forecast_timeline_with_http_info(async_req=True)
        >>> result = thread.get()

        :param ctm: The Control-M/server name.
        :type ctm: str
        :param folder: Name of the folder being requested.
        :type folder: str
        :param rbc: Name of the RuleBasedCalendar being requested.
        :type rbc: str
        :param jobs: Specifies the job(s) within the folder. Defaults to all jobs if not specified. Use '*' as a wildcard for multiple jobs.
        :type jobs: str
        :param library: The name of the z/OS library that contains the jobs.
        :type library: str
        :param filter_type: The type of filter to apply. Options are 'year' or 'relativeMonths'. Defaults to 'relativeMonths'.
        :type filter_type: str
        :param year: Used only when filterType is 'year'. Specifies a particular year and returns a five-year schedule centered around the given year (e.g., input 2024 returns 2022-2026). Defaults to the current year.
        :type year: int
        :param _from: Used only when filterType is 'relativeMonths'. Specifies the start of the range in months relative to the current month. Minimum value is -24. Defaults to 0 (current month).
        :type _from: int
        :param to: Used only when filterType is 'relativeMonths'. Specifies the end of the range in months relative to the current month. Minimum value is +24. Defaults to 11.
        :type to: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ForecastTimelineResults, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'ctm',
            'folder',
            'rbc',
            'jobs',
            'library',
            'filter_type',
            'year',
            '_from',
            'to'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_forecast_timeline" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ctm' in local_var_params and local_var_params['ctm'] is not None:  # noqa: E501
            query_params.append(('ctm', local_var_params['ctm']))  # noqa: E501
        if 'folder' in local_var_params and local_var_params['folder'] is not None:  # noqa: E501
            query_params.append(('folder', local_var_params['folder']))  # noqa: E501
        if 'rbc' in local_var_params and local_var_params['rbc'] is not None:  # noqa: E501
            query_params.append(('rbc', local_var_params['rbc']))  # noqa: E501
        if 'jobs' in local_var_params and local_var_params['jobs'] is not None:  # noqa: E501
            query_params.append(('jobs', local_var_params['jobs']))  # noqa: E501
        if 'library' in local_var_params and local_var_params['library'] is not None:  # noqa: E501
            query_params.append(('library', local_var_params['library']))  # noqa: E501
        if 'filter_type' in local_var_params and local_var_params['filter_type'] is not None:  # noqa: E501
            query_params.append(('filterType', local_var_params['filter_type']))  # noqa: E501
        if 'year' in local_var_params and local_var_params['year'] is not None:  # noqa: E501
            query_params.append(('year', local_var_params['year']))  # noqa: E501
        if '_from' in local_var_params and local_var_params['_from'] is not None:  # noqa: E501
            query_params.append(('from', local_var_params['_from']))  # noqa: E501
        if 'to' in local_var_params and local_var_params['to'] is not None:  # noqa: E501
            query_params.append(('to', local_var_params['to']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "ForecastTimelineResults",
            403: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/run/forecast/timeline', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_job_log(self, job_id, **kwargs):  # noqa: E501
        """Get job's log  # noqa: E501

        Get the job execution log.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_job_log(job_id, async_req=True)
        >>> result = thread.get()

        :param job_id: The job ID (required)
        :type job_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        return self.get_job_log_with_http_info(job_id, **kwargs)  # noqa: E501

    def get_job_log_with_http_info(self, job_id, **kwargs):  # noqa: E501
        """Get job's log  # noqa: E501

        Get the job execution log.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_job_log_with_http_info(job_id, async_req=True)
        >>> result = thread.get()

        :param job_id: The job ID (required)
        :type job_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'job_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_job_log" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'job_id' is set
        if self.api_client.client_side_validation and ('job_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['job_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `job_id` when calling `get_job_log`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'job_id' in local_var_params:
            path_params['jobId'] = local_var_params['job_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "str",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/run/job/{jobId}/log', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_job_output(self, job_id, **kwargs):  # noqa: E501
        """Get job output  # noqa: E501

        Get the output returned from a job.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_job_output(job_id, async_req=True)
        >>> result = thread.get()

        :param job_id: The job ID (required)
        :type job_id: str
        :param run_no: The execution number in case of multiple executions (0 will get the last execution's output)
        :type run_no: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        return self.get_job_output_with_http_info(job_id, **kwargs)  # noqa: E501

    def get_job_output_with_http_info(self, job_id, **kwargs):  # noqa: E501
        """Get job output  # noqa: E501

        Get the output returned from a job.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_job_output_with_http_info(job_id, async_req=True)
        >>> result = thread.get()

        :param job_id: The job ID (required)
        :type job_id: str
        :param run_no: The execution number in case of multiple executions (0 will get the last execution's output)
        :type run_no: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'job_id',
            'run_no'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_job_output" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'job_id' is set
        if self.api_client.client_side_validation and ('job_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['job_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `job_id` when calling `get_job_output`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'job_id' in local_var_params:
            path_params['jobId'] = local_var_params['job_id']  # noqa: E501

        query_params = []
        if 'run_no' in local_var_params and local_var_params['run_no'] is not None:  # noqa: E501
            query_params.append(('runNo', local_var_params['run_no']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "str",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/run/job/{jobId}/output', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_job_statistics(self, job_id, **kwargs):  # noqa: E501
        """Get job statistics  # noqa: E501

        Get the statistics from a job.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_job_statistics(job_id, async_req=True)
        >>> result = thread.get()

        :param job_id: The job ID (required)
        :type job_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Statistics
        """
        kwargs['_return_http_data_only'] = True
        return self.get_job_statistics_with_http_info(job_id, **kwargs)  # noqa: E501

    def get_job_statistics_with_http_info(self, job_id, **kwargs):  # noqa: E501
        """Get job statistics  # noqa: E501

        Get the statistics from a job.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_job_statistics_with_http_info(job_id, async_req=True)
        >>> result = thread.get()

        :param job_id: The job ID (required)
        :type job_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Statistics, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'job_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_job_statistics" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'job_id' is set
        if self.api_client.client_side_validation and ('job_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['job_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `job_id` when calling `get_job_statistics`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'job_id' in local_var_params:
            path_params['jobId'] = local_var_params['job_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "Statistics",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/run/job/{jobId}/statistics', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_job_status(self, job_id, **kwargs):  # noqa: E501
        """Get status of a job  # noqa: E501

        Get the job status.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_job_status(job_id, async_req=True)
        >>> result = thread.get()

        :param job_id: Job ID returned from the run status action. (required)
        :type job_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: JobRunStatus
        """
        kwargs['_return_http_data_only'] = True
        return self.get_job_status_with_http_info(job_id, **kwargs)  # noqa: E501

    def get_job_status_with_http_info(self, job_id, **kwargs):  # noqa: E501
        """Get status of a job  # noqa: E501

        Get the job status.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_job_status_with_http_info(job_id, async_req=True)
        >>> result = thread.get()

        :param job_id: Job ID returned from the run status action. (required)
        :type job_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(JobRunStatus, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'job_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_job_status" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'job_id' is set
        if self.api_client.client_side_validation and ('job_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['job_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `job_id` when calling `get_job_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'job_id' in local_var_params:
            path_params['jobId'] = local_var_params['job_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "JobRunStatus",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/run/job/{jobId}/status', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_jobs_status(self, run_id, **kwargs):  # noqa: E501
        """Get status of running jobs  # noqa: E501

        Run status of jobs started with the Run service.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_jobs_status(run_id, async_req=True)
        >>> result = thread.get()

        :param run_id: Run ID returned from the run action. (required)
        :type run_id: str
        :param start_index: The index of the job status from which to start. returning results
        :type start_index: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: JobStatusResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_jobs_status_with_http_info(run_id, **kwargs)  # noqa: E501

    def get_jobs_status_with_http_info(self, run_id, **kwargs):  # noqa: E501
        """Get status of running jobs  # noqa: E501

        Run status of jobs started with the Run service.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_jobs_status_with_http_info(run_id, async_req=True)
        >>> result = thread.get()

        :param run_id: Run ID returned from the run action. (required)
        :type run_id: str
        :param start_index: The index of the job status from which to start. returning results
        :type start_index: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(JobStatusResult, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'run_id',
            'start_index'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_jobs_status" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'run_id' is set
        if self.api_client.client_side_validation and ('run_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['run_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `run_id` when calling `get_jobs_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'run_id' in local_var_params:
            path_params['runId'] = local_var_params['run_id']  # noqa: E501

        query_params = []
        if 'start_index' in local_var_params and local_var_params['start_index'] is not None:  # noqa: E501
            query_params.append(('startIndex', local_var_params['start_index']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "JobStatusResult",
            404: "ErrorList",
            500: "ErrorList",
            503: "ErrorList",
        }

        return self.api_client.call_api(
            '/run/status/{runId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_jobs_status_by_filter(self, **kwargs):  # noqa: E501
        """Get jobs that match the search criteria.  # noqa: E501

        Get status of jobs that match the requested search criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_jobs_status_by_filter(async_req=True)
        >>> result = thread.get()

        :param limit: maximum jobs status to fetch (default 1000).
        :type limit: int
        :param jobname:
        :type jobname: str
        :param ctm:
        :type ctm: str
        :param server:
        :type server: str
        :param application:
        :type application: str
        :param sub_application:
        :type sub_application: str
        :param host:
        :type host: str
        :param status:
        :type status: str
        :param folder:
        :type folder: str
        :param description:
        :type description: str
        :param jobid:
        :type jobid: str
        :param neighborhood:
        :type neighborhood: str
        :param depth:
        :type depth: int
        :param direction:
        :type direction: str
        :param order_date_from:
        :type order_date_from: str
        :param order_date_to:
        :type order_date_to: str
        :param history_run_date:
        :type history_run_date: str
        :param from_time:
        :type from_time: str
        :param to_time:
        :type to_time: str
        :param folder_library:
        :type folder_library: str
        :param host_group:
        :type host_group: str
        :param run_as:
        :type run_as: str
        :param command:
        :type command: str
        :param file_path:
        :type file_path: str
        :param file_name:
        :type file_name: str
        :param workload_policy:
        :type workload_policy: str
        :param rule_based_calendar:
        :type rule_based_calendar: str
        :param resource_mutex:
        :type resource_mutex: str
        :param resource_semaphore:
        :type resource_semaphore: str
        :param resource_lock:
        :type resource_lock: str
        :param resource_pool:
        :type resource_pool: str
        :param held:
        :type held: bool
        :param folder_held:
        :type folder_held: bool
        :param cyclic:
        :type cyclic: bool
        :param deleted:
        :type deleted: bool
        :param event_date:
        :type event_date: str
        :param event_name:
        :type event_name: str
        :param wait_for_event_date:
        :type wait_for_event_date: str
        :param wait_for_event_name:
        :type wait_for_event_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: JobStatusResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_jobs_status_by_filter_with_http_info(**kwargs)  # noqa: E501

    def get_jobs_status_by_filter_with_http_info(self, **kwargs):  # noqa: E501
        """Get jobs that match the search criteria.  # noqa: E501

        Get status of jobs that match the requested search criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_jobs_status_by_filter_with_http_info(async_req=True)
        >>> result = thread.get()

        :param limit: maximum jobs status to fetch (default 1000).
        :type limit: int
        :param jobname:
        :type jobname: str
        :param ctm:
        :type ctm: str
        :param server:
        :type server: str
        :param application:
        :type application: str
        :param sub_application:
        :type sub_application: str
        :param host:
        :type host: str
        :param status:
        :type status: str
        :param folder:
        :type folder: str
        :param description:
        :type description: str
        :param jobid:
        :type jobid: str
        :param neighborhood:
        :type neighborhood: str
        :param depth:
        :type depth: int
        :param direction:
        :type direction: str
        :param order_date_from:
        :type order_date_from: str
        :param order_date_to:
        :type order_date_to: str
        :param history_run_date:
        :type history_run_date: str
        :param from_time:
        :type from_time: str
        :param to_time:
        :type to_time: str
        :param folder_library:
        :type folder_library: str
        :param host_group:
        :type host_group: str
        :param run_as:
        :type run_as: str
        :param command:
        :type command: str
        :param file_path:
        :type file_path: str
        :param file_name:
        :type file_name: str
        :param workload_policy:
        :type workload_policy: str
        :param rule_based_calendar:
        :type rule_based_calendar: str
        :param resource_mutex:
        :type resource_mutex: str
        :param resource_semaphore:
        :type resource_semaphore: str
        :param resource_lock:
        :type resource_lock: str
        :param resource_pool:
        :type resource_pool: str
        :param held:
        :type held: bool
        :param folder_held:
        :type folder_held: bool
        :param cyclic:
        :type cyclic: bool
        :param deleted:
        :type deleted: bool
        :param event_date:
        :type event_date: str
        :param event_name:
        :type event_name: str
        :param wait_for_event_date:
        :type wait_for_event_date: str
        :param wait_for_event_name:
        :type wait_for_event_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(JobStatusResult, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'limit',
            'jobname',
            'ctm',
            'server',
            'application',
            'sub_application',
            'host',
            'status',
            'folder',
            'description',
            'jobid',
            'neighborhood',
            'depth',
            'direction',
            'order_date_from',
            'order_date_to',
            'history_run_date',
            'from_time',
            'to_time',
            'folder_library',
            'host_group',
            'run_as',
            'command',
            'file_path',
            'file_name',
            'workload_policy',
            'rule_based_calendar',
            'resource_mutex',
            'resource_semaphore',
            'resource_lock',
            'resource_pool',
            'held',
            'folder_held',
            'cyclic',
            'deleted',
            'event_date',
            'event_name',
            'wait_for_event_date',
            'wait_for_event_name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_jobs_status_by_filter" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'jobname' in local_var_params and local_var_params['jobname'] is not None:  # noqa: E501
            query_params.append(('jobname', local_var_params['jobname']))  # noqa: E501
        if 'ctm' in local_var_params and local_var_params['ctm'] is not None:  # noqa: E501
            query_params.append(('ctm', local_var_params['ctm']))  # noqa: E501
        if 'server' in local_var_params and local_var_params['server'] is not None:  # noqa: E501
            query_params.append(('server', local_var_params['server']))  # noqa: E501
        if 'application' in local_var_params and local_var_params['application'] is not None:  # noqa: E501
            query_params.append(('application', local_var_params['application']))  # noqa: E501
        if 'sub_application' in local_var_params and local_var_params['sub_application'] is not None:  # noqa: E501
            query_params.append(('subApplication', local_var_params['sub_application']))  # noqa: E501
        if 'host' in local_var_params and local_var_params['host'] is not None:  # noqa: E501
            query_params.append(('host', local_var_params['host']))  # noqa: E501
        if 'status' in local_var_params and local_var_params['status'] is not None:  # noqa: E501
            query_params.append(('status', local_var_params['status']))  # noqa: E501
        if 'folder' in local_var_params and local_var_params['folder'] is not None:  # noqa: E501
            query_params.append(('folder', local_var_params['folder']))  # noqa: E501
        if 'description' in local_var_params and local_var_params['description'] is not None:  # noqa: E501
            query_params.append(('description', local_var_params['description']))  # noqa: E501
        if 'jobid' in local_var_params and local_var_params['jobid'] is not None:  # noqa: E501
            query_params.append(('jobid', local_var_params['jobid']))  # noqa: E501
        if 'neighborhood' in local_var_params and local_var_params['neighborhood'] is not None:  # noqa: E501
            query_params.append(('neighborhood', local_var_params['neighborhood']))  # noqa: E501
        if 'depth' in local_var_params and local_var_params['depth'] is not None:  # noqa: E501
            query_params.append(('depth', local_var_params['depth']))  # noqa: E501
        if 'direction' in local_var_params and local_var_params['direction'] is not None:  # noqa: E501
            query_params.append(('direction', local_var_params['direction']))  # noqa: E501
        if 'order_date_from' in local_var_params and local_var_params['order_date_from'] is not None:  # noqa: E501
            query_params.append(('orderDateFrom', local_var_params['order_date_from']))  # noqa: E501
        if 'order_date_to' in local_var_params and local_var_params['order_date_to'] is not None:  # noqa: E501
            query_params.append(('orderDateTo', local_var_params['order_date_to']))  # noqa: E501
        if 'history_run_date' in local_var_params and local_var_params['history_run_date'] is not None:  # noqa: E501
            query_params.append(('historyRunDate', local_var_params['history_run_date']))  # noqa: E501
        if 'from_time' in local_var_params and local_var_params['from_time'] is not None:  # noqa: E501
            query_params.append(('fromTime', local_var_params['from_time']))  # noqa: E501
        if 'to_time' in local_var_params and local_var_params['to_time'] is not None:  # noqa: E501
            query_params.append(('toTime', local_var_params['to_time']))  # noqa: E501
        if 'folder_library' in local_var_params and local_var_params['folder_library'] is not None:  # noqa: E501
            query_params.append(('folderLibrary', local_var_params['folder_library']))  # noqa: E501
        if 'host_group' in local_var_params and local_var_params['host_group'] is not None:  # noqa: E501
            query_params.append(('hostGroup', local_var_params['host_group']))  # noqa: E501
        if 'run_as' in local_var_params and local_var_params['run_as'] is not None:  # noqa: E501
            query_params.append(('runAs', local_var_params['run_as']))  # noqa: E501
        if 'command' in local_var_params and local_var_params['command'] is not None:  # noqa: E501
            query_params.append(('command', local_var_params['command']))  # noqa: E501
        if 'file_path' in local_var_params and local_var_params['file_path'] is not None:  # noqa: E501
            query_params.append(('filePath', local_var_params['file_path']))  # noqa: E501
        if 'file_name' in local_var_params and local_var_params['file_name'] is not None:  # noqa: E501
            query_params.append(('fileName', local_var_params['file_name']))  # noqa: E501
        if 'workload_policy' in local_var_params and local_var_params['workload_policy'] is not None:  # noqa: E501
            query_params.append(('workloadPolicy', local_var_params['workload_policy']))  # noqa: E501
        if 'rule_based_calendar' in local_var_params and local_var_params['rule_based_calendar'] is not None:  # noqa: E501
            query_params.append(('ruleBasedCalendar', local_var_params['rule_based_calendar']))  # noqa: E501
        if 'resource_mutex' in local_var_params and local_var_params['resource_mutex'] is not None:  # noqa: E501
            query_params.append(('resourceMutex', local_var_params['resource_mutex']))  # noqa: E501
        if 'resource_semaphore' in local_var_params and local_var_params['resource_semaphore'] is not None:  # noqa: E501
            query_params.append(('resourceSemaphore', local_var_params['resource_semaphore']))  # noqa: E501
        if 'resource_lock' in local_var_params and local_var_params['resource_lock'] is not None:  # noqa: E501
            query_params.append(('resourceLock', local_var_params['resource_lock']))  # noqa: E501
        if 'resource_pool' in local_var_params and local_var_params['resource_pool'] is not None:  # noqa: E501
            query_params.append(('resourcePool', local_var_params['resource_pool']))  # noqa: E501
        if 'held' in local_var_params and local_var_params['held'] is not None:  # noqa: E501
            query_params.append(('held', local_var_params['held']))  # noqa: E501
        if 'folder_held' in local_var_params and local_var_params['folder_held'] is not None:  # noqa: E501
            query_params.append(('folderHeld', local_var_params['folder_held']))  # noqa: E501
        if 'cyclic' in local_var_params and local_var_params['cyclic'] is not None:  # noqa: E501
            query_params.append(('cyclic', local_var_params['cyclic']))  # noqa: E501
        if 'deleted' in local_var_params and local_var_params['deleted'] is not None:  # noqa: E501
            query_params.append(('deleted', local_var_params['deleted']))  # noqa: E501
        if 'event_date' in local_var_params and local_var_params['event_date'] is not None:  # noqa: E501
            query_params.append(('eventDate', local_var_params['event_date']))  # noqa: E501
        if 'event_name' in local_var_params and local_var_params['event_name'] is not None:  # noqa: E501
            query_params.append(('eventName', local_var_params['event_name']))  # noqa: E501
        if 'wait_for_event_date' in local_var_params and local_var_params['wait_for_event_date'] is not None:  # noqa: E501
            query_params.append(('waitForEventDate', local_var_params['wait_for_event_date']))  # noqa: E501
        if 'wait_for_event_name' in local_var_params and local_var_params['wait_for_event_name'] is not None:  # noqa: E501
            query_params.append(('waitForEventName', local_var_params['wait_for_event_name']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "JobStatusResult",
            206: "JobStatusResult",
            400: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/run/jobs/status', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_list_of_un_ordered_jobs_for_specified_user_daily(self, poll, **kwargs):  # noqa: E501
        """Enables you to get all the Jobs that were not ordered for a specified user daily.  # noqa: E501

        Enables you to get all the Jobs that were not ordered for a specified user daily.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_list_of_un_ordered_jobs_for_specified_user_daily(poll, async_req=True)
        >>> result = thread.get()

        :param poll: (required)
        :type poll: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CtmudchkJobsResults
        """
        kwargs['_return_http_data_only'] = True
        return self.get_list_of_un_ordered_jobs_for_specified_user_daily_with_http_info(poll, **kwargs)  # noqa: E501

    def get_list_of_un_ordered_jobs_for_specified_user_daily_with_http_info(self, poll, **kwargs):  # noqa: E501
        """Enables you to get all the Jobs that were not ordered for a specified user daily.  # noqa: E501

        Enables you to get all the Jobs that were not ordered for a specified user daily.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_list_of_un_ordered_jobs_for_specified_user_daily_with_http_info(poll, async_req=True)
        >>> result = thread.get()

        :param poll: (required)
        :type poll: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CtmudchkJobsResults, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'poll'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_list_of_un_ordered_jobs_for_specified_user_daily" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'poll' is set
        if self.api_client.client_side_validation and ('poll' not in local_var_params or  # noqa: E501
                                                        local_var_params['poll'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `poll` when calling `get_list_of_un_ordered_jobs_for_specified_user_daily`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'poll' in local_var_params:
            path_params['poll'] = local_var_params['poll']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "CtmudchkJobsResults",
            403: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/run/userDaily/missing/poll/{poll}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_related_job_services(self, job_id, **kwargs):  # noqa: E501
        """Get related  services  # noqa: E501

        Get related  services to the job, according to job id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_related_job_services(job_id, async_req=True)
        >>> result = thread.get()

        :param job_id: The job ID (required)
        :type job_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: JobRelatedServicesData
        """
        kwargs['_return_http_data_only'] = True
        return self.get_related_job_services_with_http_info(job_id, **kwargs)  # noqa: E501

    def get_related_job_services_with_http_info(self, job_id, **kwargs):  # noqa: E501
        """Get related  services  # noqa: E501

        Get related  services to the job, according to job id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_related_job_services_with_http_info(job_id, async_req=True)
        >>> result = thread.get()

        :param job_id: The job ID (required)
        :type job_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(JobRelatedServicesData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'job_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_related_job_services" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'job_id' is set
        if self.api_client.client_side_validation and ('job_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['job_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `job_id` when calling `get_related_job_services`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'job_id' in local_var_params:
            path_params['jobId'] = local_var_params['job_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "JobRelatedServicesData",
            400: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/run/job/{jobId}/related', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_resources(self, **kwargs):  # noqa: E501
        """Get all resources records matching search.  # noqa: E501

        Get all resources records matching search.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_resources(async_req=True)
        >>> result = thread.get()

        :param ctm: Control-M Server filter.
        :type ctm: str
        :param server: Control-M Server filter.
        :type server: str
        :param name: The resource name filter.
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[ResourceObj]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_resources_with_http_info(**kwargs)  # noqa: E501

    def get_resources_with_http_info(self, **kwargs):  # noqa: E501
        """Get all resources records matching search.  # noqa: E501

        Get all resources records matching search.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_resources_with_http_info(async_req=True)
        >>> result = thread.get()

        :param ctm: Control-M Server filter.
        :type ctm: str
        :param server: Control-M Server filter.
        :type server: str
        :param name: The resource name filter.
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[ResourceObj], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'ctm',
            'server',
            'name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_resources" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ctm' in local_var_params and local_var_params['ctm'] is not None:  # noqa: E501
            query_params.append(('ctm', local_var_params['ctm']))  # noqa: E501
        if 'server' in local_var_params and local_var_params['server'] is not None:  # noqa: E501
            query_params.append(('server', local_var_params['server']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "list[ResourceObj]",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/run/resources', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_un_ordered_jobs_for_specified_user_daily(self, user_daily, **kwargs):  # noqa: E501
        """Enables you to get all the Jobs that were not ordered for a specified user daily.  # noqa: E501

        Enables you to get all the Jobs that were not ordered for a specified user daily.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_un_ordered_jobs_for_specified_user_daily(user_daily, async_req=True)
        >>> result = thread.get()

        :param user_daily: (required)
        :type user_daily: str
        :param server:
        :type server: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CtmudchkResults
        """
        kwargs['_return_http_data_only'] = True
        return self.get_un_ordered_jobs_for_specified_user_daily_with_http_info(user_daily, **kwargs)  # noqa: E501

    def get_un_ordered_jobs_for_specified_user_daily_with_http_info(self, user_daily, **kwargs):  # noqa: E501
        """Enables you to get all the Jobs that were not ordered for a specified user daily.  # noqa: E501

        Enables you to get all the Jobs that were not ordered for a specified user daily.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_un_ordered_jobs_for_specified_user_daily_with_http_info(user_daily, async_req=True)
        >>> result = thread.get()

        :param user_daily: (required)
        :type user_daily: str
        :param server:
        :type server: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CtmudchkResults, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'user_daily',
            'server'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_un_ordered_jobs_for_specified_user_daily" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'user_daily' is set
        if self.api_client.client_side_validation and ('user_daily' not in local_var_params or  # noqa: E501
                                                        local_var_params['user_daily'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_daily` when calling `get_un_ordered_jobs_for_specified_user_daily`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_daily' in local_var_params:
            path_params['userDaily'] = local_var_params['user_daily']  # noqa: E501

        query_params = []
        if 'server' in local_var_params and local_var_params['server'] is not None:  # noqa: E501
            query_params.append(('server', local_var_params['server']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "CtmudchkResults",
            403: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/run/userDaily/{userDaily}/missing/list', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_variables(self, **kwargs):  # noqa: E501
        """Return variable values based on specified search criteria.  # noqa: E501

        Return variable values based on specified search criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_variables(async_req=True)
        >>> result = thread.get()

        :param pool: The pool name filter
        :type pool: str
        :param variable: The variable name filter
        :type variable: str
        :param server: The server name filter
        :type server: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Variables
        """
        kwargs['_return_http_data_only'] = True
        return self.get_variables_with_http_info(**kwargs)  # noqa: E501

    def get_variables_with_http_info(self, **kwargs):  # noqa: E501
        """Return variable values based on specified search criteria.  # noqa: E501

        Return variable values based on specified search criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_variables_with_http_info(async_req=True)
        >>> result = thread.get()

        :param pool: The pool name filter
        :type pool: str
        :param variable: The variable name filter
        :type variable: str
        :param server: The server name filter
        :type server: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Variables, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'pool',
            'variable',
            'server'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_variables" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'pool' in local_var_params and local_var_params['pool'] is not None:  # noqa: E501
            query_params.append(('pool', local_var_params['pool']))  # noqa: E501
        if 'variable' in local_var_params and local_var_params['variable'] is not None:  # noqa: E501
            query_params.append(('variable', local_var_params['variable']))  # noqa: E501
        if 'server' in local_var_params and local_var_params['server'] is not None:  # noqa: E501
            query_params.append(('server', local_var_params['server']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "Variables",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/run/variables', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_waiting_info(self, job_id, **kwargs):  # noqa: E501
        """get job's waiting information  # noqa: E501

        get the reason why the job is in waiting status  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_waiting_info(job_id, async_req=True)
        >>> result = thread.get()

        :param job_id: The job ID (required)
        :type job_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[str]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_waiting_info_with_http_info(job_id, **kwargs)  # noqa: E501

    def get_waiting_info_with_http_info(self, job_id, **kwargs):  # noqa: E501
        """get job's waiting information  # noqa: E501

        get the reason why the job is in waiting status  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_waiting_info_with_http_info(job_id, async_req=True)
        >>> result = thread.get()

        :param job_id: The job ID (required)
        :type job_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[str], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'job_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_waiting_info" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'job_id' is set
        if self.api_client.client_side_validation and ('job_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['job_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `job_id` when calling `get_waiting_info`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'job_id' in local_var_params:
            path_params['jobId'] = local_var_params['job_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "list[str]",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/run/job/{jobId}/waitingInfo', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_workload_policies(self, **kwargs):  # noqa: E501
        """get workload policies  # noqa: E501

        Get all the workload policies.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_workload_policies(async_req=True)
        >>> result = thread.get()

        :param state: Optionally state filter. Available values Active, Inactive
        :type state: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WorkloadPolicyList
        """
        kwargs['_return_http_data_only'] = True
        return self.get_workload_policies_with_http_info(**kwargs)  # noqa: E501

    def get_workload_policies_with_http_info(self, **kwargs):  # noqa: E501
        """get workload policies  # noqa: E501

        Get all the workload policies.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_workload_policies_with_http_info(async_req=True)
        >>> result = thread.get()

        :param state: Optionally state filter. Available values Active, Inactive
        :type state: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WorkloadPolicyList, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'state'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workload_policies" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'state' in local_var_params and local_var_params['state'] is not None:  # noqa: E501
            query_params.append(('state', local_var_params['state']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "WorkloadPolicyList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/run/workloadpolicies', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def hold_job(self, job_id, **kwargs):  # noqa: E501
        """hold the job so it will not start untill it is freed  # noqa: E501

        hold the job  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.hold_job(job_id, async_req=True)
        >>> result = thread.get()

        :param job_id: The job ID (required)
        :type job_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.hold_job_with_http_info(job_id, **kwargs)  # noqa: E501

    def hold_job_with_http_info(self, job_id, **kwargs):  # noqa: E501
        """hold the job so it will not start untill it is freed  # noqa: E501

        hold the job  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.hold_job_with_http_info(job_id, async_req=True)
        >>> result = thread.get()

        :param job_id: The job ID (required)
        :type job_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'job_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method hold_job" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'job_id' is set
        if self.api_client.client_side_validation and ('job_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['job_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `job_id` when calling `hold_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'job_id' in local_var_params:
            path_params['jobId'] = local_var_params['job_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/run/job/{jobId}/hold', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def kill_job(self, job_id, **kwargs):  # noqa: E501
        """Cancel running job  # noqa: E501

        Abort job execution.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.kill_job(job_id, async_req=True)
        >>> result = thread.get()

        :param job_id: The job ID (required)
        :type job_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.kill_job_with_http_info(job_id, **kwargs)  # noqa: E501

    def kill_job_with_http_info(self, job_id, **kwargs):  # noqa: E501
        """Cancel running job  # noqa: E501

        Abort job execution.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.kill_job_with_http_info(job_id, async_req=True)
        >>> result = thread.get()

        :param job_id: The job ID (required)
        :type job_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'job_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method kill_job" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'job_id' is set
        if self.api_client.client_side_validation and ('job_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['job_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `job_id` when calling `kill_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'job_id' in local_var_params:
            path_params['jobId'] = local_var_params['job_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/run/job/{jobId}/kill', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def modify_job(self, job_id, job_definitions_file, **kwargs):  # noqa: E501
        """Modify active job  # noqa: E501

        Modify active job, specified by order id according to given definitions file (JSON).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.modify_job(job_id, job_definitions_file, async_req=True)
        >>> result = thread.get()

        :param job_id: The job ID (required)
        :type job_id: str
        :param job_definitions_file: File that contains the definitions of the job to modify. It should be a JSON file. (required)
        :type job_definitions_file: file
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.modify_job_with_http_info(job_id, job_definitions_file, **kwargs)  # noqa: E501

    def modify_job_with_http_info(self, job_id, job_definitions_file, **kwargs):  # noqa: E501
        """Modify active job  # noqa: E501

        Modify active job, specified by order id according to given definitions file (JSON).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.modify_job_with_http_info(job_id, job_definitions_file, async_req=True)
        >>> result = thread.get()

        :param job_id: The job ID (required)
        :type job_id: str
        :param job_definitions_file: File that contains the definitions of the job to modify. It should be a JSON file. (required)
        :type job_definitions_file: file
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'job_id',
            'job_definitions_file'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method modify_job" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'job_id' is set
        if self.api_client.client_side_validation and ('job_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['job_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `job_id` when calling `modify_job`")  # noqa: E501
        # verify the required parameter 'job_definitions_file' is set
        if self.api_client.client_side_validation and ('job_definitions_file' not in local_var_params or  # noqa: E501
                                                        local_var_params['job_definitions_file'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `job_definitions_file` when calling `modify_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'job_id' in local_var_params:
            path_params['jobId'] = local_var_params['job_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}
        if 'job_definitions_file' in local_var_params:
            local_var_files['jobDefinitionsFile'] = local_var_params['job_definitions_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['multipart/form-data'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            400: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/run/job/{jobId}/modify', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def order_jobs_in_folder(self, **kwargs):  # noqa: E501
        """Execute requested jobs in certain folder  # noqa: E501

        Run jobs from selected folder according to given filter  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.order_jobs_in_folder(async_req=True)
        >>> result = thread.get()

        :param data: parameters to select the jobs to run
        :type data: OrderFolderParameters
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: RunResult
        """
        kwargs['_return_http_data_only'] = True
        return self.order_jobs_in_folder_with_http_info(**kwargs)  # noqa: E501

    def order_jobs_in_folder_with_http_info(self, **kwargs):  # noqa: E501
        """Execute requested jobs in certain folder  # noqa: E501

        Run jobs from selected folder according to given filter  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.order_jobs_in_folder_with_http_info(async_req=True)
        >>> result = thread.get()

        :param data: parameters to select the jobs to run
        :type data: OrderFolderParameters
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(RunResult, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method order_jobs_in_folder" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "RunResult",
            400: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/run/order', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def poll_forecast_timeline_request(self, poll, **kwargs):  # noqa: E501
        """Returns an array that contains a yearly schedule (according to the filter) when a job will run over the years.  # noqa: E501

        Returns an array that contains a yearly schedule (according to the filter) when a job will run over the years.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.poll_forecast_timeline_request(poll, async_req=True)
        >>> result = thread.get()

        :param poll: A unique ID received from the \"forecast:timeline::get\" API to retrieve the result of the timeline request. (required)
        :type poll: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PollForecastTimelineResults
        """
        kwargs['_return_http_data_only'] = True
        return self.poll_forecast_timeline_request_with_http_info(poll, **kwargs)  # noqa: E501

    def poll_forecast_timeline_request_with_http_info(self, poll, **kwargs):  # noqa: E501
        """Returns an array that contains a yearly schedule (according to the filter) when a job will run over the years.  # noqa: E501

        Returns an array that contains a yearly schedule (according to the filter) when a job will run over the years.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.poll_forecast_timeline_request_with_http_info(poll, async_req=True)
        >>> result = thread.get()

        :param poll: A unique ID received from the \"forecast:timeline::get\" API to retrieve the result of the timeline request. (required)
        :type poll: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PollForecastTimelineResults, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'poll'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method poll_forecast_timeline_request" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'poll' is set
        if self.api_client.client_side_validation and ('poll' not in local_var_params or  # noqa: E501
                                                        local_var_params['poll'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `poll` when calling `poll_forecast_timeline_request`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'poll' in local_var_params:
            path_params['poll'] = local_var_params['poll']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "PollForecastTimelineResults",
            400: "ErrorList",
            401: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/run/forecast/timeline/poll/{poll}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def rerun_job(self, job_id, **kwargs):  # noqa: E501
        """Run job again  # noqa: E501

        Run an already executed job (again).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.rerun_job(job_id, async_req=True)
        >>> result = thread.get()

        :param job_id: The job ID (required)
        :type job_id: str
        :param zos_job_config: The JSON file with the restart configuration and parameters
        :type zos_job_config: RerunParameters
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: JobRunStatus
        """
        kwargs['_return_http_data_only'] = True
        return self.rerun_job_with_http_info(job_id, **kwargs)  # noqa: E501

    def rerun_job_with_http_info(self, job_id, **kwargs):  # noqa: E501
        """Run job again  # noqa: E501

        Run an already executed job (again).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.rerun_job_with_http_info(job_id, async_req=True)
        >>> result = thread.get()

        :param job_id: The job ID (required)
        :type job_id: str
        :param zos_job_config: The JSON file with the restart configuration and parameters
        :type zos_job_config: RerunParameters
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(JobRunStatus, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'job_id',
            'zos_job_config'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method rerun_job" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'job_id' is set
        if self.api_client.client_side_validation and ('job_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['job_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `job_id` when calling `rerun_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'job_id' in local_var_params:
            path_params['jobId'] = local_var_params['job_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'zos_job_config' in local_var_params:
            body_params = local_var_params['zos_job_config']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "JobRunStatus",
            400: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/run/job/{jobId}/rerun', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def run_jobs(self, job_definitions_file, **kwargs):  # noqa: E501
        """Run jobs  # noqa: E501

        Run jobs according to given definitions file (JSON or zip).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.run_jobs(job_definitions_file, async_req=True)
        >>> result = thread.get()

        :param job_definitions_file: File that contains the definitions of the jobs to run. It can be a JSON file, or a zip file that can contain one or more JSON files, as well as account(s) information. (required)
        :type job_definitions_file: file
        :param deploy_descriptor_file: Deploy Descriptor JSON file.
        :type deploy_descriptor_file: file
        :param additional_configuration: additionalConfiguration to enable skip testing for local connection profile
        :type additional_configuration: file
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: RunResult
        """
        kwargs['_return_http_data_only'] = True
        return self.run_jobs_with_http_info(job_definitions_file, **kwargs)  # noqa: E501

    def run_jobs_with_http_info(self, job_definitions_file, **kwargs):  # noqa: E501
        """Run jobs  # noqa: E501

        Run jobs according to given definitions file (JSON or zip).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.run_jobs_with_http_info(job_definitions_file, async_req=True)
        >>> result = thread.get()

        :param job_definitions_file: File that contains the definitions of the jobs to run. It can be a JSON file, or a zip file that can contain one or more JSON files, as well as account(s) information. (required)
        :type job_definitions_file: file
        :param deploy_descriptor_file: Deploy Descriptor JSON file.
        :type deploy_descriptor_file: file
        :param additional_configuration: additionalConfiguration to enable skip testing for local connection profile
        :type additional_configuration: file
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(RunResult, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'job_definitions_file',
            'deploy_descriptor_file',
            'additional_configuration'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method run_jobs" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'job_definitions_file' is set
        if self.api_client.client_side_validation and ('job_definitions_file' not in local_var_params or  # noqa: E501
                                                        local_var_params['job_definitions_file'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `job_definitions_file` when calling `run_jobs`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}
        if 'job_definitions_file' in local_var_params:
            local_var_files['jobDefinitionsFile'] = local_var_params['job_definitions_file']  # noqa: E501
        if 'deploy_descriptor_file' in local_var_params:
            local_var_files['deployDescriptorFile'] = local_var_params['deploy_descriptor_file']  # noqa: E501
        if 'additional_configuration' in local_var_params:
            local_var_files['additionalConfiguration'] = local_var_params['additional_configuration']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['multipart/form-data'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "RunResult",
            400: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/run', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def run_now(self, job_id, **kwargs):  # noqa: E501
        """Bypass scheduling cretirias and start the job  # noqa: E501

        start a job immediately  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.run_now(job_id, async_req=True)
        >>> result = thread.get()

        :param job_id: The job ID (required)
        :type job_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.run_now_with_http_info(job_id, **kwargs)  # noqa: E501

    def run_now_with_http_info(self, job_id, **kwargs):  # noqa: E501
        """Bypass scheduling cretirias and start the job  # noqa: E501

        start a job immediately  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.run_now_with_http_info(job_id, async_req=True)
        >>> result = thread.get()

        :param job_id: The job ID (required)
        :type job_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'job_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method run_now" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'job_id' is set
        if self.api_client.client_side_validation and ('job_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['job_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `job_id` when calling `run_now`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'job_id' in local_var_params:
            path_params['jobId'] = local_var_params['job_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/run/job/{jobId}/runNow', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def run_on_demand(self, definitions_file, **kwargs):  # noqa: E501
        """Run a job on demand  # noqa: E501

        Run a job on demand  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.run_on_demand(definitions_file, async_req=True)
        >>> result = thread.get()

        :param definitions_file: A file that contains jobs definitions to be run on demand (required)
        :type definitions_file: file
        :param deploy_descriptor_file: Deploy Descriptor JSON file.
        :type deploy_descriptor_file: file
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: RunResult
        """
        kwargs['_return_http_data_only'] = True
        return self.run_on_demand_with_http_info(definitions_file, **kwargs)  # noqa: E501

    def run_on_demand_with_http_info(self, definitions_file, **kwargs):  # noqa: E501
        """Run a job on demand  # noqa: E501

        Run a job on demand  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.run_on_demand_with_http_info(definitions_file, async_req=True)
        >>> result = thread.get()

        :param definitions_file: A file that contains jobs definitions to be run on demand (required)
        :type definitions_file: file
        :param deploy_descriptor_file: Deploy Descriptor JSON file.
        :type deploy_descriptor_file: file
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(RunResult, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'definitions_file',
            'deploy_descriptor_file'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method run_on_demand" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'definitions_file' is set
        if self.api_client.client_side_validation and ('definitions_file' not in local_var_params or  # noqa: E501
                                                        local_var_params['definitions_file'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `definitions_file` when calling `run_on_demand`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}
        if 'definitions_file' in local_var_params:
            local_var_files['definitionsFile'] = local_var_params['definitions_file']  # noqa: E501
        if 'deploy_descriptor_file' in local_var_params:
            local_var_files['deployDescriptorFile'] = local_var_params['deploy_descriptor_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['multipart/form-data'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "RunResult",
            400: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/run/ondemand', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def run_un_ordered_jobs_for_specified_user_daily(self, user_daily, **kwargs):  # noqa: E501
        """runs all the jobs that were not ordered for a specified user daily of a specified server.  # noqa: E501

        runs all the jobs that were not ordered for a specified user daily of a specified server.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.run_un_ordered_jobs_for_specified_user_daily(user_daily, async_req=True)
        >>> result = thread.get()

        :param user_daily: (required)
        :type user_daily: str
        :param server:
        :type server: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: RunResult
        """
        kwargs['_return_http_data_only'] = True
        return self.run_un_ordered_jobs_for_specified_user_daily_with_http_info(user_daily, **kwargs)  # noqa: E501

    def run_un_ordered_jobs_for_specified_user_daily_with_http_info(self, user_daily, **kwargs):  # noqa: E501
        """runs all the jobs that were not ordered for a specified user daily of a specified server.  # noqa: E501

        runs all the jobs that were not ordered for a specified user daily of a specified server.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.run_un_ordered_jobs_for_specified_user_daily_with_http_info(user_daily, async_req=True)
        >>> result = thread.get()

        :param user_daily: (required)
        :type user_daily: str
        :param server:
        :type server: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(RunResult, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'user_daily',
            'server'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method run_un_ordered_jobs_for_specified_user_daily" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'user_daily' is set
        if self.api_client.client_side_validation and ('user_daily' not in local_var_params or  # noqa: E501
                                                        local_var_params['user_daily'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_daily` when calling `run_un_ordered_jobs_for_specified_user_daily`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_daily' in local_var_params:
            path_params['userDaily'] = local_var_params['user_daily']  # noqa: E501

        query_params = []
        if 'server' in local_var_params and local_var_params['server'] is not None:  # noqa: E501
            query_params.append(('server', local_var_params['server']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "RunResult",
            403: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/run/userDaily/{userDaily}/missing/run', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def set_to_ok(self, job_id, **kwargs):  # noqa: E501
        """set job end status to OK  # noqa: E501

        set job status to OK, post processing action  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_to_ok(job_id, async_req=True)
        >>> result = thread.get()

        :param job_id: The job ID (required)
        :type job_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.set_to_ok_with_http_info(job_id, **kwargs)  # noqa: E501

    def set_to_ok_with_http_info(self, job_id, **kwargs):  # noqa: E501
        """set job end status to OK  # noqa: E501

        set job status to OK, post processing action  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_to_ok_with_http_info(job_id, async_req=True)
        >>> result = thread.get()

        :param job_id: The job ID (required)
        :type job_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'job_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_to_ok" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'job_id' is set
        if self.api_client.client_side_validation and ('job_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['job_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `job_id` when calling `set_to_ok`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'job_id' in local_var_params:
            path_params['jobId'] = local_var_params['job_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/run/job/{jobId}/setToOk', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def set_variables(self, server, variables_file, **kwargs):  # noqa: E501
        """Set variable values as defined in json input. Use this API to create new variables or update existing variables.  # noqa: E501

        Set variable values as defined in json input. Use this API to create new variables or update existing variables.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_variables(server, variables_file, async_req=True)
        >>> result = thread.get()

        :param server: The server that hosts the variables. (required)
        :type server: str
        :param variables_file: Variables definition file. (required)
        :type variables_file: Variables
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.set_variables_with_http_info(server, variables_file, **kwargs)  # noqa: E501

    def set_variables_with_http_info(self, server, variables_file, **kwargs):  # noqa: E501
        """Set variable values as defined in json input. Use this API to create new variables or update existing variables.  # noqa: E501

        Set variable values as defined in json input. Use this API to create new variables or update existing variables.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_variables_with_http_info(server, variables_file, async_req=True)
        >>> result = thread.get()

        :param server: The server that hosts the variables. (required)
        :type server: str
        :param variables_file: Variables definition file. (required)
        :type variables_file: Variables
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'server',
            'variables_file'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_variables" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in local_var_params or  # noqa: E501
                                                        local_var_params['server'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `server` when calling `set_variables`")  # noqa: E501
        # verify the required parameter 'variables_file' is set
        if self.api_client.client_side_validation and ('variables_file' not in local_var_params or  # noqa: E501
                                                        local_var_params['variables_file'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `variables_file` when calling `set_variables`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in local_var_params:
            path_params['server'] = local_var_params['server']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'variables_file' in local_var_params:
            body_params = local_var_params['variables_file']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            400: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/run/variables/{server}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def undelete_job(self, job_id, **kwargs):  # noqa: E501
        """recover a mark for deletion job  # noqa: E501

        recover a mark for deletion job  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.undelete_job(job_id, async_req=True)
        >>> result = thread.get()

        :param job_id: The job ID (required)
        :type job_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.undelete_job_with_http_info(job_id, **kwargs)  # noqa: E501

    def undelete_job_with_http_info(self, job_id, **kwargs):  # noqa: E501
        """recover a mark for deletion job  # noqa: E501

        recover a mark for deletion job  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.undelete_job_with_http_info(job_id, async_req=True)
        >>> result = thread.get()

        :param job_id: The job ID (required)
        :type job_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'job_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method undelete_job" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'job_id' is set
        if self.api_client.client_side_validation and ('job_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['job_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `job_id` when calling `undelete_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'job_id' in local_var_params:
            path_params['jobId'] = local_var_params['job_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/run/job/{jobId}/undelete', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def update_alert(self, alert_modify_value, **kwargs):  # noqa: E501
        """Update alert.  # noqa: E501

        Update alert.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_alert(alert_modify_value, async_req=True)
        >>> result = thread.get()

        :param alert_modify_value: File that contains the alert property that want to be update. (required)
        :type alert_modify_value: AlertParam
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.update_alert_with_http_info(alert_modify_value, **kwargs)  # noqa: E501

    def update_alert_with_http_info(self, alert_modify_value, **kwargs):  # noqa: E501
        """Update alert.  # noqa: E501

        Update alert.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_alert_with_http_info(alert_modify_value, async_req=True)
        >>> result = thread.get()

        :param alert_modify_value: File that contains the alert property that want to be update. (required)
        :type alert_modify_value: AlertParam
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'alert_modify_value'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_alert" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'alert_modify_value' is set
        if self.api_client.client_side_validation and ('alert_modify_value' not in local_var_params or  # noqa: E501
                                                        local_var_params['alert_modify_value'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `alert_modify_value` when calling `update_alert`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'alert_modify_value' in local_var_params:
            body_params = local_var_params['alert_modify_value']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/run/alerts', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def update_alert_status(self, alert_modify_status_value, **kwargs):  # noqa: E501
        """Update alert status.  # noqa: E501

        Update alert status.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_alert_status(alert_modify_status_value, async_req=True)
        >>> result = thread.get()

        :param alert_modify_status_value: File that contains the alert status property that want to be update. (required)
        :type alert_modify_status_value: AlertStatusParam
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.update_alert_status_with_http_info(alert_modify_status_value, **kwargs)  # noqa: E501

    def update_alert_status_with_http_info(self, alert_modify_status_value, **kwargs):  # noqa: E501
        """Update alert status.  # noqa: E501

        Update alert status.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_alert_status_with_http_info(alert_modify_status_value, async_req=True)
        >>> result = thread.get()

        :param alert_modify_status_value: File that contains the alert status property that want to be update. (required)
        :type alert_modify_status_value: AlertStatusParam
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'alert_modify_status_value'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_alert_status" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'alert_modify_status_value' is set
        if self.api_client.client_side_validation and ('alert_modify_status_value' not in local_var_params or  # noqa: E501
                                                        local_var_params['alert_modify_status_value'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `alert_modify_status_value` when calling `update_alert_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'alert_modify_status_value' in local_var_params:
            body_params = local_var_params['alert_modify_status_value']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/run/alerts/status', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def update_resource(self, server, name, max, **kwargs):  # noqa: E501
        """Update a pool resource.  # noqa: E501

        Update a pool resource.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_resource(server, name, max, async_req=True)
        >>> result = thread.get()

        :param server: The Control-M Server hosting the resource. (required)
        :type server: str
        :param name: Resource name (required)
        :type name: str
        :param max: The defined resource name. (required)
        :type max: ResourceMax
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.update_resource_with_http_info(server, name, max, **kwargs)  # noqa: E501

    def update_resource_with_http_info(self, server, name, max, **kwargs):  # noqa: E501
        """Update a pool resource.  # noqa: E501

        Update a pool resource.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_resource_with_http_info(server, name, max, async_req=True)
        >>> result = thread.get()

        :param server: The Control-M Server hosting the resource. (required)
        :type server: str
        :param name: Resource name (required)
        :type name: str
        :param max: The defined resource name. (required)
        :type max: ResourceMax
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'server',
            'name',
            'max'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_resource" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in local_var_params or  # noqa: E501
                                                        local_var_params['server'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `server` when calling `update_resource`")  # noqa: E501
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in local_var_params or  # noqa: E501
                                                        local_var_params['name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `name` when calling `update_resource`")  # noqa: E501
        # verify the required parameter 'max' is set
        if self.api_client.client_side_validation and ('max' not in local_var_params or  # noqa: E501
                                                        local_var_params['max'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `max` when calling `update_resource`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in local_var_params:
            path_params['server'] = local_var_params['server']  # noqa: E501
        if 'name' in local_var_params:
            path_params['name'] = local_var_params['name']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'max' in local_var_params:
            body_params = local_var_params['max']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/run/resource/{server}/{name}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))
