# coding: utf-8

"""
    Control-M Services

    Provides access to BMC Control-M Services  # noqa: E501

    The version of the OpenAPI document: 9.22.30
    Contact: customer_support@bmc.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from clients.ctm_api_client.configuration import Configuration


class ExternalUserData(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'name': 'str',
        'email': 'str',
        'company': 'str',
        'password': 'str',
        'description': 'str',
        'phone_number': 'str',
        'ssh_key': 'str',
        'as2_key': 'As2KeyData',
        'is_locked': 'bool',
        'lock_reason': 'str',
        'change_password_at_next_login': 'bool',
        'password_never_expires': 'bool',
        'home_folder': 'str',
        'password_update_time': 'str',
        'public_key_update_time': 'str'
    }

    attribute_map = {
        'name': 'name',
        'email': 'email',
        'company': 'company',
        'password': 'password',
        'description': 'description',
        'phone_number': 'phoneNumber',
        'ssh_key': 'sshKey',
        'as2_key': 'as2Key',
        'is_locked': 'isLocked',
        'lock_reason': 'lockReason',
        'change_password_at_next_login': 'changePasswordAtNextLogin',
        'password_never_expires': 'passwordNeverExpires',
        'home_folder': 'homeFolder',
        'password_update_time': 'passwordUpdateTime',
        'public_key_update_time': 'publicKeyUpdateTime'
    }

    def __init__(self, name=None, email=None, company=None, password=None, description=None, phone_number=None, ssh_key=None, as2_key=None, is_locked=None, lock_reason=None, change_password_at_next_login=None, password_never_expires=None, home_folder=None, password_update_time=None, public_key_update_time=None, local_vars_configuration=None):  # noqa: E501
        """ExternalUserData - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._name = None
        self._email = None
        self._company = None
        self._password = None
        self._description = None
        self._phone_number = None
        self._ssh_key = None
        self._as2_key = None
        self._is_locked = None
        self._lock_reason = None
        self._change_password_at_next_login = None
        self._password_never_expires = None
        self._home_folder = None
        self._password_update_time = None
        self._public_key_update_time = None
        self.discriminator = None

        if name is not None:
            self.name = name
        if email is not None:
            self.email = email
        if company is not None:
            self.company = company
        if password is not None:
            self.password = password
        if description is not None:
            self.description = description
        if phone_number is not None:
            self.phone_number = phone_number
        if ssh_key is not None:
            self.ssh_key = ssh_key
        if as2_key is not None:
            self.as2_key = as2_key
        if is_locked is not None:
            self.is_locked = is_locked
        if lock_reason is not None:
            self.lock_reason = lock_reason
        if change_password_at_next_login is not None:
            self.change_password_at_next_login = change_password_at_next_login
        if password_never_expires is not None:
            self.password_never_expires = password_never_expires
        if home_folder is not None:
            self.home_folder = home_folder
        if password_update_time is not None:
            self.password_update_time = password_update_time
        if public_key_update_time is not None:
            self.public_key_update_time = public_key_update_time

    @property
    def name(self):
        """Gets the name of this ExternalUserData.  # noqa: E501

        external user name REQUIRED:addExternalUser,addExternalUserForSite | HIDDEN  # noqa: E501

        :return: The name of this ExternalUserData.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ExternalUserData.

        external user name REQUIRED:addExternalUser,addExternalUserForSite | HIDDEN  # noqa: E501

        :param name: The name of this ExternalUserData.  # noqa: E501
        :type name: str
        """

        self._name = name

    @property
    def email(self):
        """Gets the email of this ExternalUserData.  # noqa: E501

        user email REQUIRED:addExternalUser,addExternalUserForSite | HIDDEN  # noqa: E501

        :return: The email of this ExternalUserData.  # noqa: E501
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """Sets the email of this ExternalUserData.

        user email REQUIRED:addExternalUser,addExternalUserForSite | HIDDEN  # noqa: E501

        :param email: The email of this ExternalUserData.  # noqa: E501
        :type email: str
        """

        self._email = email

    @property
    def company(self):
        """Gets the company of this ExternalUserData.  # noqa: E501

        user's company REQUIRED:addExternalUser,addExternalUserForSite | HIDDEN  # noqa: E501

        :return: The company of this ExternalUserData.  # noqa: E501
        :rtype: str
        """
        return self._company

    @company.setter
    def company(self, company):
        """Sets the company of this ExternalUserData.

        user's company REQUIRED:addExternalUser,addExternalUserForSite | HIDDEN  # noqa: E501

        :param company: The company of this ExternalUserData.  # noqa: E501
        :type company: str
        """

        self._company = company

    @property
    def password(self):
        """Gets the password of this ExternalUserData.  # noqa: E501

        user password HIDDEN:updateExternalUser,updateExternalUserForSite  # noqa: E501

        :return: The password of this ExternalUserData.  # noqa: E501
        :rtype: str
        """
        return self._password

    @password.setter
    def password(self, password):
        """Sets the password of this ExternalUserData.

        user password HIDDEN:updateExternalUser,updateExternalUserForSite  # noqa: E501

        :param password: The password of this ExternalUserData.  # noqa: E501
        :type password: str
        """

        self._password = password

    @property
    def description(self):
        """Gets the description of this ExternalUserData.  # noqa: E501

        user description HIDDEN  # noqa: E501

        :return: The description of this ExternalUserData.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this ExternalUserData.

        user description HIDDEN  # noqa: E501

        :param description: The description of this ExternalUserData.  # noqa: E501
        :type description: str
        """

        self._description = description

    @property
    def phone_number(self):
        """Gets the phone_number of this ExternalUserData.  # noqa: E501

        external user phone number HIDDEN  # noqa: E501

        :return: The phone_number of this ExternalUserData.  # noqa: E501
        :rtype: str
        """
        return self._phone_number

    @phone_number.setter
    def phone_number(self, phone_number):
        """Sets the phone_number of this ExternalUserData.

        external user phone number HIDDEN  # noqa: E501

        :param phone_number: The phone_number of this ExternalUserData.  # noqa: E501
        :type phone_number: str
        """

        self._phone_number = phone_number

    @property
    def ssh_key(self):
        """Gets the ssh_key of this ExternalUserData.  # noqa: E501

        SSH key string HIDDEN  # noqa: E501

        :return: The ssh_key of this ExternalUserData.  # noqa: E501
        :rtype: str
        """
        return self._ssh_key

    @ssh_key.setter
    def ssh_key(self, ssh_key):
        """Sets the ssh_key of this ExternalUserData.

        SSH key string HIDDEN  # noqa: E501

        :param ssh_key: The ssh_key of this ExternalUserData.  # noqa: E501
        :type ssh_key: str
        """

        self._ssh_key = ssh_key

    @property
    def as2_key(self):
        """Gets the as2_key of this ExternalUserData.  # noqa: E501


        :return: The as2_key of this ExternalUserData.  # noqa: E501
        :rtype: As2KeyData
        """
        return self._as2_key

    @as2_key.setter
    def as2_key(self, as2_key):
        """Sets the as2_key of this ExternalUserData.


        :param as2_key: The as2_key of this ExternalUserData.  # noqa: E501
        :type as2_key: As2KeyData
        """

        self._as2_key = as2_key

    @property
    def is_locked(self):
        """Gets the is_locked of this ExternalUserData.  # noqa: E501

        indicates whether the user account is locked HIDDEN  # noqa: E501

        :return: The is_locked of this ExternalUserData.  # noqa: E501
        :rtype: bool
        """
        return self._is_locked

    @is_locked.setter
    def is_locked(self, is_locked):
        """Sets the is_locked of this ExternalUserData.

        indicates whether the user account is locked HIDDEN  # noqa: E501

        :param is_locked: The is_locked of this ExternalUserData.  # noqa: E501
        :type is_locked: bool
        """

        self._is_locked = is_locked

    @property
    def lock_reason(self):
        """Gets the lock_reason of this ExternalUserData.  # noqa: E501

        provides the reason for locking the user account HIDDEN  # noqa: E501

        :return: The lock_reason of this ExternalUserData.  # noqa: E501
        :rtype: str
        """
        return self._lock_reason

    @lock_reason.setter
    def lock_reason(self, lock_reason):
        """Sets the lock_reason of this ExternalUserData.

        provides the reason for locking the user account HIDDEN  # noqa: E501

        :param lock_reason: The lock_reason of this ExternalUserData.  # noqa: E501
        :type lock_reason: str
        """

        self._lock_reason = lock_reason

    @property
    def change_password_at_next_login(self):
        """Gets the change_password_at_next_login of this ExternalUserData.  # noqa: E501

        indicates whether a password change is required at next login HIDDEN  # noqa: E501

        :return: The change_password_at_next_login of this ExternalUserData.  # noqa: E501
        :rtype: bool
        """
        return self._change_password_at_next_login

    @change_password_at_next_login.setter
    def change_password_at_next_login(self, change_password_at_next_login):
        """Sets the change_password_at_next_login of this ExternalUserData.

        indicates whether a password change is required at next login HIDDEN  # noqa: E501

        :param change_password_at_next_login: The change_password_at_next_login of this ExternalUserData.  # noqa: E501
        :type change_password_at_next_login: bool
        """

        self._change_password_at_next_login = change_password_at_next_login

    @property
    def password_never_expires(self):
        """Gets the password_never_expires of this ExternalUserData.  # noqa: E501

        indicates whether the user's password is set to never expire HIDDEN  # noqa: E501

        :return: The password_never_expires of this ExternalUserData.  # noqa: E501
        :rtype: bool
        """
        return self._password_never_expires

    @password_never_expires.setter
    def password_never_expires(self, password_never_expires):
        """Sets the password_never_expires of this ExternalUserData.

        indicates whether the user's password is set to never expire HIDDEN  # noqa: E501

        :param password_never_expires: The password_never_expires of this ExternalUserData.  # noqa: E501
        :type password_never_expires: bool
        """

        self._password_never_expires = password_never_expires

    @property
    def home_folder(self):
        """Gets the home_folder of this ExternalUserData.  # noqa: E501

        default user's home directory HIDDEN  # noqa: E501

        :return: The home_folder of this ExternalUserData.  # noqa: E501
        :rtype: str
        """
        return self._home_folder

    @home_folder.setter
    def home_folder(self, home_folder):
        """Sets the home_folder of this ExternalUserData.

        default user's home directory HIDDEN  # noqa: E501

        :param home_folder: The home_folder of this ExternalUserData.  # noqa: E501
        :type home_folder: str
        """

        self._home_folder = home_folder

    @property
    def password_update_time(self):
        """Gets the password_update_time of this ExternalUserData.  # noqa: E501

        indicate when the user's password changed HIDDEN  # noqa: E501

        :return: The password_update_time of this ExternalUserData.  # noqa: E501
        :rtype: str
        """
        return self._password_update_time

    @password_update_time.setter
    def password_update_time(self, password_update_time):
        """Sets the password_update_time of this ExternalUserData.

        indicate when the user's password changed HIDDEN  # noqa: E501

        :param password_update_time: The password_update_time of this ExternalUserData.  # noqa: E501
        :type password_update_time: str
        """

        self._password_update_time = password_update_time

    @property
    def public_key_update_time(self):
        """Gets the public_key_update_time of this ExternalUserData.  # noqa: E501

        indicate when the user's ssh public key changed HIDDEN  # noqa: E501

        :return: The public_key_update_time of this ExternalUserData.  # noqa: E501
        :rtype: str
        """
        return self._public_key_update_time

    @public_key_update_time.setter
    def public_key_update_time(self, public_key_update_time):
        """Sets the public_key_update_time of this ExternalUserData.

        indicate when the user's ssh public key changed HIDDEN  # noqa: E501

        :param public_key_update_time: The public_key_update_time of this ExternalUserData.  # noqa: E501
        :type public_key_update_time: str
        """

        self._public_key_update_time = public_key_update_time

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ExternalUserData):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ExternalUserData):
            return True

        return self.to_dict() != other.to_dict()
