# coding: utf-8

"""
    Control-M Services

    Provides access to BMC Control-M Services  # noqa: E501

    The version of the OpenAPI document: 9.22.30
    Contact: customer_support@bmc.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from clients.ctm_api_client.configuration import Configuration


class SecretDescriptors(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'provider': 'str',
        'provider_api_label': 'str',
        'provider_web_label': 'str',
        'vault_params': 'list[VaultParam]'
    }

    attribute_map = {
        'provider': 'provider',
        'provider_api_label': 'providerApiLabel',
        'provider_web_label': 'providerWebLabel',
        'vault_params': 'vaultParams'
    }

    def __init__(self, provider=None, provider_api_label=None, provider_web_label=None, vault_params=None, local_vars_configuration=None):  # noqa: E501
        """SecretDescriptors - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._provider = None
        self._provider_api_label = None
        self._provider_web_label = None
        self._vault_params = None
        self.discriminator = None

        if provider is not None:
            self.provider = provider
        if provider_api_label is not None:
            self.provider_api_label = provider_api_label
        if provider_web_label is not None:
            self.provider_web_label = provider_web_label
        if vault_params is not None:
            self.vault_params = vault_params

    @property
    def provider(self):
        """Gets the provider of this SecretDescriptors.  # noqa: E501

        vault provider name  # noqa: E501

        :return: The provider of this SecretDescriptors.  # noqa: E501
        :rtype: str
        """
        return self._provider

    @provider.setter
    def provider(self, provider):
        """Sets the provider of this SecretDescriptors.

        vault provider name  # noqa: E501

        :param provider: The provider of this SecretDescriptors.  # noqa: E501
        :type provider: str
        """

        self._provider = provider

    @property
    def provider_api_label(self):
        """Gets the provider_api_label of this SecretDescriptors.  # noqa: E501

        Vault provider name of the parameter in Automation API  # noqa: E501

        :return: The provider_api_label of this SecretDescriptors.  # noqa: E501
        :rtype: str
        """
        return self._provider_api_label

    @provider_api_label.setter
    def provider_api_label(self, provider_api_label):
        """Sets the provider_api_label of this SecretDescriptors.

        Vault provider name of the parameter in Automation API  # noqa: E501

        :param provider_api_label: The provider_api_label of this SecretDescriptors.  # noqa: E501
        :type provider_api_label: str
        """

        self._provider_api_label = provider_api_label

    @property
    def provider_web_label(self):
        """Gets the provider_web_label of this SecretDescriptors.  # noqa: E501

        Vault provider displayed name of the parameter in Web  # noqa: E501

        :return: The provider_web_label of this SecretDescriptors.  # noqa: E501
        :rtype: str
        """
        return self._provider_web_label

    @provider_web_label.setter
    def provider_web_label(self, provider_web_label):
        """Sets the provider_web_label of this SecretDescriptors.

        Vault provider displayed name of the parameter in Web  # noqa: E501

        :param provider_web_label: The provider_web_label of this SecretDescriptors.  # noqa: E501
        :type provider_web_label: str
        """

        self._provider_web_label = provider_web_label

    @property
    def vault_params(self):
        """Gets the vault_params of this SecretDescriptors.  # noqa: E501


        :return: The vault_params of this SecretDescriptors.  # noqa: E501
        :rtype: list[VaultParam]
        """
        return self._vault_params

    @vault_params.setter
    def vault_params(self, vault_params):
        """Sets the vault_params of this SecretDescriptors.


        :param vault_params: The vault_params of this SecretDescriptors.  # noqa: E501
        :type vault_params: list[VaultParam]
        """

        self._vault_params = vault_params

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SecretDescriptors):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SecretDescriptors):
            return True

        return self.to_dict() != other.to_dict()
