# coding: utf-8

"""
    Control-M Services

    Provides access to BMC Control-M Services  # noqa: E501

    OpenAPI spec version: 9.20.215
    Contact: customer_support@bmc.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from clients.ctm_api_client.api_client import ApiClient


class SessionApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def do_login(self, credentials, **kwargs):  # noqa: E501
        """login user to Control-M  # noqa: E501

        Authenticate the user with the specified password and return a token that can be used later in subsequent requests to access Control-M.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.do_login(credentials, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param LoginCredentials credentials: The credentials to use for login. (required)
        :return: LoginResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.do_login_with_http_info(credentials, **kwargs)  # noqa: E501
        else:
            (data) = self.do_login_with_http_info(credentials, **kwargs)  # noqa: E501
            return data

    def do_login_with_http_info(self, credentials, **kwargs):  # noqa: E501
        """login user to Control-M  # noqa: E501

        Authenticate the user with the specified password and return a token that can be used later in subsequent requests to access Control-M.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.do_login_with_http_info(credentials, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param LoginCredentials credentials: The credentials to use for login. (required)
        :return: LoginResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["credentials"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method do_login" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'credentials' is set
        if self.api_client.client_side_validation and (
            "credentials" not in params or params["credentials"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `credentials` when calling `do_login`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "credentials" in params:
            body_params = params["credentials"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            "/session/login",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="LoginResult",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def do_logout(self, **kwargs):  # noqa: E501
        """logout user from Control-M  # noqa: E501

        Disconnects the user session specified by the request authentication token, and removes it from the server memory.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.do_logout(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.do_logout_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.do_logout_with_http_info(**kwargs)  # noqa: E501
            return data

    def do_logout_with_http_info(self, **kwargs):  # noqa: E501
        """logout user from Control-M  # noqa: E501

        Disconnects the user session specified by the request authentication token, and removes it from the server memory.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.do_logout_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method do_logout" % key
                )
            params[key] = val
        del params["kwargs"]

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Bearer"]  # noqa: E501

        return self.api_client.call_api(
            "/session/logout",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="SuccessData",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def update_my_password(self, passwords_object, **kwargs):  # noqa: E501
        """Change my password  # noqa: E501

        Change my password  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_my_password(passwords_object, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PasswordsObject passwords_object: The new password. (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.update_my_password_with_http_info(
                passwords_object, **kwargs
            )  # noqa: E501
        else:
            (data) = self.update_my_password_with_http_info(
                passwords_object, **kwargs
            )  # noqa: E501
            return data

    def update_my_password_with_http_info(
        self, passwords_object, **kwargs
    ):  # noqa: E501
        """Change my password  # noqa: E501

        Change my password  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_my_password_with_http_info(passwords_object, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PasswordsObject passwords_object: The new password. (required)
        :return: SuccessData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["passwords_object"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_my_password" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'passwords_object' is set
        if self.api_client.client_side_validation and (
            "passwords_object" not in params or params["passwords_object"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `passwords_object` when calling `update_my_password`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "passwords_object" in params:
            body_params = params["passwords_object"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Bearer"]  # noqa: E501

        return self.api_client.call_api(
            "/session/user/password/update",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="SuccessData",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )
