# coding: utf-8

"""
    Control-M Services

    Provides access to BMC Control-M Services  # noqa: E501

    The version of the OpenAPI document: 9.22.30
    Contact: customer_support@bmc.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from clients.ctm_api_client.configuration import Configuration


class ConvertLcpToCcpResults(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'poll_id': 'str',
        'convert_status': 'str',
        'convert_state': 'str',
        'is_dry_run': 'bool',
        'successful_converted_cps': 'int',
        'skipped_converted_cps': 'int',
        'failed_converted_cps': 'int',
        'converted_connection_profiles': 'list[str]',
        'skipped_to_convert_connection_profiles': 'list[str]',
        'failed_to_convert_connection_profiles': 'list[str]',
        'errors': 'list[DeploymentFileError]'
    }

    attribute_map = {
        'poll_id': 'pollId',
        'convert_status': 'convertStatus',
        'convert_state': 'convertState',
        'is_dry_run': 'isDryRun',
        'successful_converted_cps': 'successfulConvertedCps',
        'skipped_converted_cps': 'skippedConvertedCps',
        'failed_converted_cps': 'failedConvertedCps',
        'converted_connection_profiles': 'convertedConnectionProfiles',
        'skipped_to_convert_connection_profiles': 'skippedToConvertConnectionProfiles',
        'failed_to_convert_connection_profiles': 'failedToConvertConnectionProfiles',
        'errors': 'errors'
    }

    def __init__(self, poll_id=None, convert_status=None, convert_state=None, is_dry_run=None, successful_converted_cps=None, skipped_converted_cps=None, failed_converted_cps=None, converted_connection_profiles=None, skipped_to_convert_connection_profiles=None, failed_to_convert_connection_profiles=None, errors=None, local_vars_configuration=None):  # noqa: E501
        """ConvertLcpToCcpResults - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._poll_id = None
        self._convert_status = None
        self._convert_state = None
        self._is_dry_run = None
        self._successful_converted_cps = None
        self._skipped_converted_cps = None
        self._failed_converted_cps = None
        self._converted_connection_profiles = None
        self._skipped_to_convert_connection_profiles = None
        self._failed_to_convert_connection_profiles = None
        self._errors = None
        self.discriminator = None

        if poll_id is not None:
            self.poll_id = poll_id
        if convert_status is not None:
            self.convert_status = convert_status
        if convert_state is not None:
            self.convert_state = convert_state
        if is_dry_run is not None:
            self.is_dry_run = is_dry_run
        if successful_converted_cps is not None:
            self.successful_converted_cps = successful_converted_cps
        if skipped_converted_cps is not None:
            self.skipped_converted_cps = skipped_converted_cps
        if failed_converted_cps is not None:
            self.failed_converted_cps = failed_converted_cps
        if converted_connection_profiles is not None:
            self.converted_connection_profiles = converted_connection_profiles
        if skipped_to_convert_connection_profiles is not None:
            self.skipped_to_convert_connection_profiles = skipped_to_convert_connection_profiles
        if failed_to_convert_connection_profiles is not None:
            self.failed_to_convert_connection_profiles = failed_to_convert_connection_profiles
        if errors is not None:
            self.errors = errors

    @property
    def poll_id(self):
        """Gets the poll_id of this ConvertLcpToCcpResults.  # noqa: E501

        Poll id  # noqa: E501

        :return: The poll_id of this ConvertLcpToCcpResults.  # noqa: E501
        :rtype: str
        """
        return self._poll_id

    @poll_id.setter
    def poll_id(self, poll_id):
        """Sets the poll_id of this ConvertLcpToCcpResults.

        Poll id  # noqa: E501

        :param poll_id: The poll_id of this ConvertLcpToCcpResults.  # noqa: E501
        :type poll_id: str
        """

        self._poll_id = poll_id

    @property
    def convert_status(self):
        """Gets the convert_status of this ConvertLcpToCcpResults.  # noqa: E501

        Currently convert status. ENDED_OK, ENDED_NOT_OK, PARTIAL_RESULTS, UNKNOWN  # noqa: E501

        :return: The convert_status of this ConvertLcpToCcpResults.  # noqa: E501
        :rtype: str
        """
        return self._convert_status

    @convert_status.setter
    def convert_status(self, convert_status):
        """Sets the convert_status of this ConvertLcpToCcpResults.

        Currently convert status. ENDED_OK, ENDED_NOT_OK, PARTIAL_RESULTS, UNKNOWN  # noqa: E501

        :param convert_status: The convert_status of this ConvertLcpToCcpResults.  # noqa: E501
        :type convert_status: str
        """

        self._convert_status = convert_status

    @property
    def convert_state(self):
        """Gets the convert_state of this ConvertLcpToCcpResults.  # noqa: E501

        Current convert local cps state. number of converted connection profiles from total connection profile.  # noqa: E501

        :return: The convert_state of this ConvertLcpToCcpResults.  # noqa: E501
        :rtype: str
        """
        return self._convert_state

    @convert_state.setter
    def convert_state(self, convert_state):
        """Sets the convert_state of this ConvertLcpToCcpResults.

        Current convert local cps state. number of converted connection profiles from total connection profile.  # noqa: E501

        :param convert_state: The convert_state of this ConvertLcpToCcpResults.  # noqa: E501
        :type convert_state: str
        """

        self._convert_state = convert_state

    @property
    def is_dry_run(self):
        """Gets the is_dry_run of this ConvertLcpToCcpResults.  # noqa: E501

        Determines whether this is a simulation of conversion.  # noqa: E501

        :return: The is_dry_run of this ConvertLcpToCcpResults.  # noqa: E501
        :rtype: bool
        """
        return self._is_dry_run

    @is_dry_run.setter
    def is_dry_run(self, is_dry_run):
        """Sets the is_dry_run of this ConvertLcpToCcpResults.

        Determines whether this is a simulation of conversion.  # noqa: E501

        :param is_dry_run: The is_dry_run of this ConvertLcpToCcpResults.  # noqa: E501
        :type is_dry_run: bool
        """

        self._is_dry_run = is_dry_run

    @property
    def successful_converted_cps(self):
        """Gets the successful_converted_cps of this ConvertLcpToCcpResults.  # noqa: E501

        Determines the number of successfully converted connections profiles.  # noqa: E501

        :return: The successful_converted_cps of this ConvertLcpToCcpResults.  # noqa: E501
        :rtype: int
        """
        return self._successful_converted_cps

    @successful_converted_cps.setter
    def successful_converted_cps(self, successful_converted_cps):
        """Sets the successful_converted_cps of this ConvertLcpToCcpResults.

        Determines the number of successfully converted connections profiles.  # noqa: E501

        :param successful_converted_cps: The successful_converted_cps of this ConvertLcpToCcpResults.  # noqa: E501
        :type successful_converted_cps: int
        """

        self._successful_converted_cps = successful_converted_cps

    @property
    def skipped_converted_cps(self):
        """Gets the skipped_converted_cps of this ConvertLcpToCcpResults.  # noqa: E501

        Determines the number of skipped to connections profiles.  # noqa: E501

        :return: The skipped_converted_cps of this ConvertLcpToCcpResults.  # noqa: E501
        :rtype: int
        """
        return self._skipped_converted_cps

    @skipped_converted_cps.setter
    def skipped_converted_cps(self, skipped_converted_cps):
        """Sets the skipped_converted_cps of this ConvertLcpToCcpResults.

        Determines the number of skipped to connections profiles.  # noqa: E501

        :param skipped_converted_cps: The skipped_converted_cps of this ConvertLcpToCcpResults.  # noqa: E501
        :type skipped_converted_cps: int
        """

        self._skipped_converted_cps = skipped_converted_cps

    @property
    def failed_converted_cps(self):
        """Gets the failed_converted_cps of this ConvertLcpToCcpResults.  # noqa: E501

        Determines the number of failed to connections profiles.  # noqa: E501

        :return: The failed_converted_cps of this ConvertLcpToCcpResults.  # noqa: E501
        :rtype: int
        """
        return self._failed_converted_cps

    @failed_converted_cps.setter
    def failed_converted_cps(self, failed_converted_cps):
        """Sets the failed_converted_cps of this ConvertLcpToCcpResults.

        Determines the number of failed to connections profiles.  # noqa: E501

        :param failed_converted_cps: The failed_converted_cps of this ConvertLcpToCcpResults.  # noqa: E501
        :type failed_converted_cps: int
        """

        self._failed_converted_cps = failed_converted_cps

    @property
    def converted_connection_profiles(self):
        """Gets the converted_connection_profiles of this ConvertLcpToCcpResults.  # noqa: E501


        :return: The converted_connection_profiles of this ConvertLcpToCcpResults.  # noqa: E501
        :rtype: list[str]
        """
        return self._converted_connection_profiles

    @converted_connection_profiles.setter
    def converted_connection_profiles(self, converted_connection_profiles):
        """Sets the converted_connection_profiles of this ConvertLcpToCcpResults.


        :param converted_connection_profiles: The converted_connection_profiles of this ConvertLcpToCcpResults.  # noqa: E501
        :type converted_connection_profiles: list[str]
        """

        self._converted_connection_profiles = converted_connection_profiles

    @property
    def skipped_to_convert_connection_profiles(self):
        """Gets the skipped_to_convert_connection_profiles of this ConvertLcpToCcpResults.  # noqa: E501


        :return: The skipped_to_convert_connection_profiles of this ConvertLcpToCcpResults.  # noqa: E501
        :rtype: list[str]
        """
        return self._skipped_to_convert_connection_profiles

    @skipped_to_convert_connection_profiles.setter
    def skipped_to_convert_connection_profiles(self, skipped_to_convert_connection_profiles):
        """Sets the skipped_to_convert_connection_profiles of this ConvertLcpToCcpResults.


        :param skipped_to_convert_connection_profiles: The skipped_to_convert_connection_profiles of this ConvertLcpToCcpResults.  # noqa: E501
        :type skipped_to_convert_connection_profiles: list[str]
        """

        self._skipped_to_convert_connection_profiles = skipped_to_convert_connection_profiles

    @property
    def failed_to_convert_connection_profiles(self):
        """Gets the failed_to_convert_connection_profiles of this ConvertLcpToCcpResults.  # noqa: E501


        :return: The failed_to_convert_connection_profiles of this ConvertLcpToCcpResults.  # noqa: E501
        :rtype: list[str]
        """
        return self._failed_to_convert_connection_profiles

    @failed_to_convert_connection_profiles.setter
    def failed_to_convert_connection_profiles(self, failed_to_convert_connection_profiles):
        """Sets the failed_to_convert_connection_profiles of this ConvertLcpToCcpResults.


        :param failed_to_convert_connection_profiles: The failed_to_convert_connection_profiles of this ConvertLcpToCcpResults.  # noqa: E501
        :type failed_to_convert_connection_profiles: list[str]
        """

        self._failed_to_convert_connection_profiles = failed_to_convert_connection_profiles

    @property
    def errors(self):
        """Gets the errors of this ConvertLcpToCcpResults.  # noqa: E501


        :return: The errors of this ConvertLcpToCcpResults.  # noqa: E501
        :rtype: list[DeploymentFileError]
        """
        return self._errors

    @errors.setter
    def errors(self, errors):
        """Sets the errors of this ConvertLcpToCcpResults.


        :param errors: The errors of this ConvertLcpToCcpResults.  # noqa: E501
        :type errors: list[DeploymentFileError]
        """

        self._errors = errors

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ConvertLcpToCcpResults):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ConvertLcpToCcpResults):
            return True

        return self.to_dict() != other.to_dict()
