# coding: utf-8

"""
    Control-M Services

    Provides access to BMC Control-M Services  # noqa: E501

    The version of the OpenAPI document: 9.22.30
    Contact: customer_support@bmc.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from clients.ctm_api_client.configuration import Configuration


class CtmDetails(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'name': 'str',
        'host': 'str',
        'state': 'str',
        'desired_state': 'str',
        'message': 'str',
        'version': 'str',
        'os_type': 'str',
        'status': 'str'
    }

    attribute_map = {
        'name': 'name',
        'host': 'host',
        'state': 'state',
        'desired_state': 'desiredState',
        'message': 'message',
        'version': 'version',
        'os_type': 'OSType',
        'status': 'status'
    }

    def __init__(self, name=None, host=None, state=None, desired_state=None, message=None, version=None, os_type=None, status=None, local_vars_configuration=None):  # noqa: E501
        """CtmDetails - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._name = None
        self._host = None
        self._state = None
        self._desired_state = None
        self._message = None
        self._version = None
        self._os_type = None
        self._status = None
        self.discriminator = None

        if name is not None:
            self.name = name
        if host is not None:
            self.host = host
        if state is not None:
            self.state = state
        if desired_state is not None:
            self.desired_state = desired_state
        if message is not None:
            self.message = message
        if version is not None:
            self.version = version
        if os_type is not None:
            self.os_type = os_type
        if status is not None:
            self.status = status

    @property
    def name(self):
        """Gets the name of this CtmDetails.  # noqa: E501

        The unique name of the Control-M Server.  # noqa: E501

        :return: The name of this CtmDetails.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this CtmDetails.

        The unique name of the Control-M Server.  # noqa: E501

        :param name: The name of this CtmDetails.  # noqa: E501
        :type name: str
        """

        self._name = name

    @property
    def host(self):
        """Gets the host of this CtmDetails.  # noqa: E501

        The hostname of the Control-M Server is running on.  # noqa: E501

        :return: The host of this CtmDetails.  # noqa: E501
        :rtype: str
        """
        return self._host

    @host.setter
    def host(self, host):
        """Sets the host of this CtmDetails.

        The hostname of the Control-M Server is running on.  # noqa: E501

        :param host: The host of this CtmDetails.  # noqa: E501
        :type host: str
        """

        self._host = host

    @property
    def state(self):
        """Gets the state of this CtmDetails.  # noqa: E501

        Control-M Server state [up|down].  # noqa: E501

        :return: The state of this CtmDetails.  # noqa: E501
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this CtmDetails.

        Control-M Server state [up|down].  # noqa: E501

        :param state: The state of this CtmDetails.  # noqa: E501
        :type state: str
        """

        self._state = state

    @property
    def desired_state(self):
        """Gets the desired_state of this CtmDetails.  # noqa: E501

        Control-M Server state [UP|DOWN|RECYCLE|IGNORE].  # noqa: E501

        :return: The desired_state of this CtmDetails.  # noqa: E501
        :rtype: str
        """
        return self._desired_state

    @desired_state.setter
    def desired_state(self, desired_state):
        """Sets the desired_state of this CtmDetails.

        Control-M Server state [UP|DOWN|RECYCLE|IGNORE].  # noqa: E501

        :param desired_state: The desired_state of this CtmDetails.  # noqa: E501
        :type desired_state: str
        """

        self._desired_state = desired_state

    @property
    def message(self):
        """Gets the message of this CtmDetails.  # noqa: E501

        Control-M Server message describing the communication status.  # noqa: E501

        :return: The message of this CtmDetails.  # noqa: E501
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message):
        """Sets the message of this CtmDetails.

        Control-M Server message describing the communication status.  # noqa: E501

        :param message: The message of this CtmDetails.  # noqa: E501
        :type message: str
        """

        self._message = message

    @property
    def version(self):
        """Gets the version of this CtmDetails.  # noqa: E501

        Control-M Server version.  # noqa: E501

        :return: The version of this CtmDetails.  # noqa: E501
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this CtmDetails.

        Control-M Server version.  # noqa: E501

        :param version: The version of this CtmDetails.  # noqa: E501
        :type version: str
        """

        self._version = version

    @property
    def os_type(self):
        """Gets the os_type of this CtmDetails.  # noqa: E501

        Control-M Server Operating System.  # noqa: E501

        :return: The os_type of this CtmDetails.  # noqa: E501
        :rtype: str
        """
        return self._os_type

    @os_type.setter
    def os_type(self, os_type):
        """Sets the os_type of this CtmDetails.

        Control-M Server Operating System.  # noqa: E501

        :param os_type: The os_type of this CtmDetails.  # noqa: E501
        :type os_type: str
        """

        self._os_type = os_type

    @property
    def status(self):
        """Gets the status of this CtmDetails.  # noqa: E501

        Control-M Server status calculated by the CTM Server.  # noqa: E501

        :return: The status of this CtmDetails.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this CtmDetails.

        Control-M Server status calculated by the CTM Server.  # noqa: E501

        :param status: The status of this CtmDetails.  # noqa: E501
        :type status: str
        """

        self._status = status

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CtmDetails):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, CtmDetails):
            return True

        return self.to_dict() != other.to_dict()
