# Control-M Python Client

Control-M Python Client is a python library to programmatically design, schedule and run your Control-M workflows. The design of the Control-M Python Client is oriented towards data scientists and developers who prefer a more programmatic approach to workflow orchestration.

## Getting Started

The best way to get familiar is to check the [Documentation](https://controlm.github.io/ctm-python-client/). Start with the [Tutorials](https://controlm.github.io/ctm-python-client/tutorials.html) to get familiar with the syntax.

You do not need to have an in-depth knowledge of Control-M, but some familiarity with Control-M will help you understand the different job types and syntax offered by Control-M Python Client.

## Installation

Control-M Python client requires [Python](https://www.python.org/downloads/) version 3.10 or higher.

We recommend to install Control-M Python Client in a [virtual environment](https://docs.python.org/3/library/venv.html).

For Linux:
```
python -m venv venv
source venv/bin/activate
```

For Windows:
```
python -m venv venv
venv\Scripts\activate
```

### Installing via pip
You will need pip and git installed on your system before you run this command.
```
pip install ctm-python-client
```

### Installing from source

```
git clone https://github.com/controlm/ctm-python-client.git
pip install ctm-python-client
```

## Contributing and Support

See [Contributing](https://github.com/controlm/ctm-python-client/blob/main/CONTRIBUTING.md)

## Links

- [Control-M Documentation](https://docs.bmc.com/docs/display/workloadautomation/Control-M+Workload+Automation+Documentation)
- [Helix Control-M Documentation](https://documents.bmc.com/supportu/controlm-saas/en-US/Documentation/home.htm)
- [Automation API Documentation](https://docs.bmc.com/docs/display/public/workloadautomation/Control-M+Automation+API+-+Getting+Started+Guide)
- [Automation API with Helix Control-M Documentation](https://docs.bmc.com/docs/display/ctmSaaSAPI/Control-M+SaaS+Automation+API+Home)
- [Provisioning an agent with Automation API](https://docs.bmc.com/docs/automation-api/monthly/provision-service-1040174602.html#Provisionservice-provisionFresh)
- [Application Integrator](https://documents.bmc.com/supportu/9.0.20/etc/ai/help/en-US/Web_Help/index.htm#69319.htm)

## License

See [License](https://github.com/controlm/ctm-python-client/blob/main/LICENSE)
