# coding: utf-8

"""
    Control-M Services

    Provides access to BMC Control-M Services  # noqa: E501

    The version of the OpenAPI document: 9.22.30
    Contact: customer_support@bmc.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from clients.ctm_api_client.api_client import ApiClient
from clients.ctm_api_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class AuthenticationApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_token(self, token_data_file, **kwargs):  # noqa: E501
        """Creates authentication token  # noqa: E501

        Creates authentication token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_token(token_data_file, async_req=True)
        >>> result = thread.get()

        :param token_data_file: The JSON file with the token data (required)
        :type token_data_file: TokenDataRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TokenDataResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.create_token_with_http_info(token_data_file, **kwargs)  # noqa: E501

    def create_token_with_http_info(self, token_data_file, **kwargs):  # noqa: E501
        """Creates authentication token  # noqa: E501

        Creates authentication token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_token_with_http_info(token_data_file, async_req=True)
        >>> result = thread.get()

        :param token_data_file: The JSON file with the token data (required)
        :type token_data_file: TokenDataRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(TokenDataResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'token_data_file'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_token" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'token_data_file' is set
        if self.api_client.client_side_validation and ('token_data_file' not in local_var_params or  # noqa: E501
                                                        local_var_params['token_data_file'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `token_data_file` when calling `create_token`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'token_data_file' in local_var_params:
            body_params = local_var_params['token_data_file']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "TokenDataResponse",
            400: "ErrorList",
            401: "ErrorList",
            403: "ErrorList",
            405: "ErrorList",
            500: "ErrorList",
            503: "ErrorList",
        }

        return self.api_client.call_api(
            '/authentication/token', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_token(self, token_name, **kwargs):  # noqa: E501
        """Deletes authentication token data  # noqa: E501

        Deletes authentication token data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_token(token_name, async_req=True)
        >>> result = thread.get()

        :param token_name: The token name (required)
        :type token_name: str
        :param for_agent: is this request for agent purposes
        :type for_agent: bool
        :param type: the kind of token to delete, replace forAgent option
        :type type: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_token_with_http_info(token_name, **kwargs)  # noqa: E501

    def delete_token_with_http_info(self, token_name, **kwargs):  # noqa: E501
        """Deletes authentication token data  # noqa: E501

        Deletes authentication token data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_token_with_http_info(token_name, async_req=True)
        >>> result = thread.get()

        :param token_name: The token name (required)
        :type token_name: str
        :param for_agent: is this request for agent purposes
        :type for_agent: bool
        :param type: the kind of token to delete, replace forAgent option
        :type type: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'token_name',
            'for_agent',
            'type'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_token" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'token_name' is set
        if self.api_client.client_side_validation and ('token_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['token_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `token_name` when calling `delete_token`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'token_name' in local_var_params:
            path_params['tokenName'] = local_var_params['token_name']  # noqa: E501

        query_params = []
        if 'for_agent' in local_var_params and local_var_params['for_agent'] is not None:  # noqa: E501
            query_params.append(('forAgent', local_var_params['for_agent']))  # noqa: E501
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            400: "ErrorList",
            401: "ErrorList",
            403: "ErrorList",
            404: "ErrorList",
            405: "ErrorList",
            500: "ErrorList",
            503: "ErrorList",
        }

        return self.api_client.call_api(
            '/authentication/token/{tokenName}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_token_data(self, token_name, **kwargs):  # noqa: E501
        """Returns authentication token data  # noqa: E501

        Returns authentication token data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_token_data(token_name, async_req=True)
        >>> result = thread.get()

        :param token_name: The token name (required)
        :type token_name: str
        :param for_agent: is this request for agent purposes
        :type for_agent: bool
        :param type: the kind of token to get, replace forAgent option
        :type type: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TokenDataResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.get_token_data_with_http_info(token_name, **kwargs)  # noqa: E501

    def get_token_data_with_http_info(self, token_name, **kwargs):  # noqa: E501
        """Returns authentication token data  # noqa: E501

        Returns authentication token data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_token_data_with_http_info(token_name, async_req=True)
        >>> result = thread.get()

        :param token_name: The token name (required)
        :type token_name: str
        :param for_agent: is this request for agent purposes
        :type for_agent: bool
        :param type: the kind of token to get, replace forAgent option
        :type type: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(TokenDataResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'token_name',
            'for_agent',
            'type'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_token_data" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'token_name' is set
        if self.api_client.client_side_validation and ('token_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['token_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `token_name` when calling `get_token_data`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'token_name' in local_var_params:
            path_params['tokenName'] = local_var_params['token_name']  # noqa: E501

        query_params = []
        if 'for_agent' in local_var_params and local_var_params['for_agent'] is not None:  # noqa: E501
            query_params.append(('forAgent', local_var_params['for_agent']))  # noqa: E501
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "TokenDataResponse",
            400: "ErrorList",
            401: "ErrorList",
            403: "ErrorList",
            404: "ErrorList",
            405: "ErrorList",
            500: "ErrorList",
            503: "ErrorList",
        }

        return self.api_client.call_api(
            '/authentication/token/{tokenName}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_token_data_by_value(self, token_value, **kwargs):  # noqa: E501
        """Returns authentication token data  # noqa: E501

        Returns authentication token data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_token_data_by_value(token_value, async_req=True)
        >>> result = thread.get()

        :param token_value: The token value (required)
        :type token_value: TokenByValueRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TokenDataResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.get_token_data_by_value_with_http_info(token_value, **kwargs)  # noqa: E501

    def get_token_data_by_value_with_http_info(self, token_value, **kwargs):  # noqa: E501
        """Returns authentication token data  # noqa: E501

        Returns authentication token data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_token_data_by_value_with_http_info(token_value, async_req=True)
        >>> result = thread.get()

        :param token_value: The token value (required)
        :type token_value: TokenByValueRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(TokenDataResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'token_value'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_token_data_by_value" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'token_value' is set
        if self.api_client.client_side_validation and ('token_value' not in local_var_params or  # noqa: E501
                                                        local_var_params['token_value'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `token_value` when calling `get_token_data_by_value`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'token_value' in local_var_params:
            body_params = local_var_params['token_value']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "TokenDataResponse",
            400: "ErrorList",
            401: "ErrorList",
            403: "ErrorList",
            404: "ErrorList",
            405: "ErrorList",
            500: "ErrorList",
            503: "ErrorList",
        }

        return self.api_client.call_api(
            '/authentication/tokenbyvalue', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_token_list(self, **kwargs):  # noqa: E501
        """Returns list of authentication token data for the authorized user  # noqa: E501

        Returns list of authentication token data for the authorized user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_token_list(async_req=True)
        >>> result = thread.get()

        :param for_agent: is this request for agent purposes
        :type for_agent: bool
        :param type: the kind of tokens to fetch, replace forAgent option
        :type type: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TokenList
        """
        kwargs['_return_http_data_only'] = True
        return self.get_token_list_with_http_info(**kwargs)  # noqa: E501

    def get_token_list_with_http_info(self, **kwargs):  # noqa: E501
        """Returns list of authentication token data for the authorized user  # noqa: E501

        Returns list of authentication token data for the authorized user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_token_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param for_agent: is this request for agent purposes
        :type for_agent: bool
        :param type: the kind of tokens to fetch, replace forAgent option
        :type type: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(TokenList, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'for_agent',
            'type'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_token_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'for_agent' in local_var_params and local_var_params['for_agent'] is not None:  # noqa: E501
            query_params.append(('forAgent', local_var_params['for_agent']))  # noqa: E501
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "TokenList",
            400: "ErrorList",
            401: "ErrorList",
            403: "ErrorList",
            404: "ErrorList",
            405: "ErrorList",
            500: "ErrorList",
            503: "ErrorList",
        }

        return self.api_client.call_api(
            '/authentication/tokens', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def update_token(self, token_data_file, **kwargs):  # noqa: E501
        """Updates authentication token data  # noqa: E501

        Updates authentication token data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_token(token_data_file, async_req=True)
        >>> result = thread.get()

        :param token_data_file: The JSON file with the token data (required)
        :type token_data_file: TokenDataRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TokenDataResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.update_token_with_http_info(token_data_file, **kwargs)  # noqa: E501

    def update_token_with_http_info(self, token_data_file, **kwargs):  # noqa: E501
        """Updates authentication token data  # noqa: E501

        Updates authentication token data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_token_with_http_info(token_data_file, async_req=True)
        >>> result = thread.get()

        :param token_data_file: The JSON file with the token data (required)
        :type token_data_file: TokenDataRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(TokenDataResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'token_data_file'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_token" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'token_data_file' is set
        if self.api_client.client_side_validation and ('token_data_file' not in local_var_params or  # noqa: E501
                                                        local_var_params['token_data_file'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `token_data_file` when calling `update_token`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'token_data_file' in local_var_params:
            body_params = local_var_params['token_data_file']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "TokenDataResponse",
            400: "ErrorList",
            401: "ErrorList",
            403: "ErrorList",
            404: "ErrorList",
            405: "ErrorList",
            406: "ErrorList",
            409: "ErrorList",
            500: "ErrorList",
            503: "ErrorList",
        }

        return self.api_client.call_api(
            '/authentication/token', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))
