# coding: utf-8

"""
    Control-M Services

    Provides access to BMC Control-M Services  # noqa: E501

    The version of the OpenAPI document: 9.22.30
    Contact: customer_support@bmc.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from clients.ctm_api_client.api_client import ApiClient
from clients.ctm_api_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class DeployApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete_calendar(self, calendar_name, **kwargs):  # noqa: E501
        """delete a calendar  # noqa: E501

        Delete a calendar  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_calendar(calendar_name, async_req=True)
        >>> result = thread.get()

        :param calendar_name: The name of the calendar to be deleted. (required)
        :type calendar_name: str
        :param server: The name of the server in which the calendar deploy.
        :type server: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_calendar_with_http_info(calendar_name, **kwargs)  # noqa: E501

    def delete_calendar_with_http_info(self, calendar_name, **kwargs):  # noqa: E501
        """delete a calendar  # noqa: E501

        Delete a calendar  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_calendar_with_http_info(calendar_name, async_req=True)
        >>> result = thread.get()

        :param calendar_name: The name of the calendar to be deleted. (required)
        :type calendar_name: str
        :param server: The name of the server in which the calendar deploy.
        :type server: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'calendar_name',
            'server'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_calendar" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'calendar_name' is set
        if self.api_client.client_side_validation and ('calendar_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['calendar_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `calendar_name` when calling `delete_calendar`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'calendar_name' in local_var_params:
            path_params['calendarName'] = local_var_params['calendar_name']  # noqa: E501

        query_params = []
        if 'server' in local_var_params and local_var_params['server'] is not None:  # noqa: E501
            query_params.append(('server', local_var_params['server']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            400: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/deploy/calendar/{calendarName}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_connection_profile(self, server, agent, type, name, **kwargs):  # noqa: E501
        """Delete Local Connection Profile  # noqa: E501

        Delete Local Connection Profile.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_connection_profile(server, agent, type, name, async_req=True)
        >>> result = thread.get()

        :param server: The name of the Control-M in which the connection profile is deployed. (required)
        :type server: str
        :param agent: The name of the agent the connection profile is deployed on. (required)
        :type agent: str
        :param type: The type of connection profile to delete. (required)
        :type type: str
        :param name: Name of the Connection Profile (required)
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_connection_profile_with_http_info(server, agent, type, name, **kwargs)  # noqa: E501

    def delete_connection_profile_with_http_info(self, server, agent, type, name, **kwargs):  # noqa: E501
        """Delete Local Connection Profile  # noqa: E501

        Delete Local Connection Profile.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_connection_profile_with_http_info(server, agent, type, name, async_req=True)
        >>> result = thread.get()

        :param server: The name of the Control-M in which the connection profile is deployed. (required)
        :type server: str
        :param agent: The name of the agent the connection profile is deployed on. (required)
        :type agent: str
        :param type: The type of connection profile to delete. (required)
        :type type: str
        :param name: Name of the Connection Profile (required)
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'server',
            'agent',
            'type',
            'name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_connection_profile" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in local_var_params or  # noqa: E501
                                                        local_var_params['server'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `server` when calling `delete_connection_profile`")  # noqa: E501
        # verify the required parameter 'agent' is set
        if self.api_client.client_side_validation and ('agent' not in local_var_params or  # noqa: E501
                                                        local_var_params['agent'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `agent` when calling `delete_connection_profile`")  # noqa: E501
        # verify the required parameter 'type' is set
        if self.api_client.client_side_validation and ('type' not in local_var_params or  # noqa: E501
                                                        local_var_params['type'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `type` when calling `delete_connection_profile`")  # noqa: E501
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in local_var_params or  # noqa: E501
                                                        local_var_params['name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `name` when calling `delete_connection_profile`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in local_var_params:
            path_params['server'] = local_var_params['server']  # noqa: E501
        if 'agent' in local_var_params:
            path_params['agent'] = local_var_params['agent']  # noqa: E501
        if 'type' in local_var_params:
            path_params['type'] = local_var_params['type']  # noqa: E501
        if 'name' in local_var_params:
            path_params['name'] = local_var_params['name']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            400: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/deploy/connectionprofile/{server}/{agent}/{type}/{name}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_folder(self, server, folder_name, **kwargs):  # noqa: E501
        """delete a folder  # noqa: E501

        Delete a folder  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_folder(server, folder_name, async_req=True)
        >>> result = thread.get()

        :param server: The name of the Control-M in which the folder(s) are deployed. (required)
        :type server: str
        :param folder_name: The name of the required folder(s). (required)
        :type folder_name: str
        :param library: library be filled only for z/os.
        :type library: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_folder_with_http_info(server, folder_name, **kwargs)  # noqa: E501

    def delete_folder_with_http_info(self, server, folder_name, **kwargs):  # noqa: E501
        """delete a folder  # noqa: E501

        Delete a folder  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_folder_with_http_info(server, folder_name, async_req=True)
        >>> result = thread.get()

        :param server: The name of the Control-M in which the folder(s) are deployed. (required)
        :type server: str
        :param folder_name: The name of the required folder(s). (required)
        :type folder_name: str
        :param library: library be filled only for z/os.
        :type library: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'server',
            'folder_name',
            'library'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_folder" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in local_var_params or  # noqa: E501
                                                        local_var_params['server'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `server` when calling `delete_folder`")  # noqa: E501
        # verify the required parameter 'folder_name' is set
        if self.api_client.client_side_validation and ('folder_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['folder_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `folder_name` when calling `delete_folder`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in local_var_params:
            path_params['server'] = local_var_params['server']  # noqa: E501
        if 'folder_name' in local_var_params:
            path_params['folderName'] = local_var_params['folder_name']  # noqa: E501

        query_params = []
        if 'library' in local_var_params and local_var_params['library'] is not None:  # noqa: E501
            query_params.append(('library', local_var_params['library']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            400: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/deploy/folder/{server}/{folderName}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_job_path(self, job_path, **kwargs):  # noqa: E501
        """delete a job  # noqa: E501

        Delete a job  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_job_path(job_path, async_req=True)
        >>> result = thread.get()

        :param job_path: The name of the required jobPath. (required)
        :type job_path: str
        :param server: The name of the Control-M in which the job are deployed.
        :type server: str
        :param library: library be filled only for z/os.
        :type library: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_job_path_with_http_info(job_path, **kwargs)  # noqa: E501

    def delete_job_path_with_http_info(self, job_path, **kwargs):  # noqa: E501
        """delete a job  # noqa: E501

        Delete a job  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_job_path_with_http_info(job_path, async_req=True)
        >>> result = thread.get()

        :param job_path: The name of the required jobPath. (required)
        :type job_path: str
        :param server: The name of the Control-M in which the job are deployed.
        :type server: str
        :param library: library be filled only for z/os.
        :type library: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'job_path',
            'server',
            'library'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_job_path" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'job_path' is set
        if self.api_client.client_side_validation and ('job_path' not in local_var_params or  # noqa: E501
                                                        local_var_params['job_path'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `job_path` when calling `delete_job_path`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'job_path' in local_var_params:
            path_params['jobPath'] = local_var_params['job_path']  # noqa: E501

        query_params = []
        if 'server' in local_var_params and local_var_params['server'] is not None:  # noqa: E501
            query_params.append(('server', local_var_params['server']))  # noqa: E501
        if 'library' in local_var_params and local_var_params['library'] is not None:  # noqa: E501
            query_params.append(('library', local_var_params['library']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            400: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/deploy/job/{jobPath}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_local_connection_profile(self, server, agent, type, name, **kwargs):  # noqa: E501
        """Delete Local Connection Profile  # noqa: E501

        Delete Local Connection Profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_local_connection_profile(server, agent, type, name, async_req=True)
        >>> result = thread.get()

        :param server: The name of the Control-M in which the connection profile is deployed. (required)
        :type server: str
        :param agent: The name of the agent the connection profile is deployed on. (required)
        :type agent: str
        :param type: The type of connection profile to delete. (required)
        :type type: str
        :param name: Name of the Connection Profile (required)
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_local_connection_profile_with_http_info(server, agent, type, name, **kwargs)  # noqa: E501

    def delete_local_connection_profile_with_http_info(self, server, agent, type, name, **kwargs):  # noqa: E501
        """Delete Local Connection Profile  # noqa: E501

        Delete Local Connection Profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_local_connection_profile_with_http_info(server, agent, type, name, async_req=True)
        >>> result = thread.get()

        :param server: The name of the Control-M in which the connection profile is deployed. (required)
        :type server: str
        :param agent: The name of the agent the connection profile is deployed on. (required)
        :type agent: str
        :param type: The type of connection profile to delete. (required)
        :type type: str
        :param name: Name of the Connection Profile (required)
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'server',
            'agent',
            'type',
            'name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_local_connection_profile" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in local_var_params or  # noqa: E501
                                                        local_var_params['server'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `server` when calling `delete_local_connection_profile`")  # noqa: E501
        # verify the required parameter 'agent' is set
        if self.api_client.client_side_validation and ('agent' not in local_var_params or  # noqa: E501
                                                        local_var_params['agent'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `agent` when calling `delete_local_connection_profile`")  # noqa: E501
        # verify the required parameter 'type' is set
        if self.api_client.client_side_validation and ('type' not in local_var_params or  # noqa: E501
                                                        local_var_params['type'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `type` when calling `delete_local_connection_profile`")  # noqa: E501
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in local_var_params or  # noqa: E501
                                                        local_var_params['name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `name` when calling `delete_local_connection_profile`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'server' in local_var_params:
            path_params['server'] = local_var_params['server']  # noqa: E501
        if 'agent' in local_var_params:
            path_params['agent'] = local_var_params['agent']  # noqa: E501
        if 'type' in local_var_params:
            path_params['type'] = local_var_params['type']  # noqa: E501
        if 'name' in local_var_params:
            path_params['name'] = local_var_params['name']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            400: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/deploy/connectionprofile/local/{server}/{agent}/{type}/{name}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_shared_connection_profile(self, type, name, **kwargs):  # noqa: E501
        """Delete centralized Connection Profile  # noqa: E501

        Delete centralized Connection Profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_shared_connection_profile(type, name, async_req=True)
        >>> result = thread.get()

        :param type: The type of connection profile to delete. (required)
        :type type: str
        :param name: Name of the Connection Profile (required)
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_shared_connection_profile_with_http_info(type, name, **kwargs)  # noqa: E501

    def delete_shared_connection_profile_with_http_info(self, type, name, **kwargs):  # noqa: E501
        """Delete centralized Connection Profile  # noqa: E501

        Delete centralized Connection Profile  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_shared_connection_profile_with_http_info(type, name, async_req=True)
        >>> result = thread.get()

        :param type: The type of connection profile to delete. (required)
        :type type: str
        :param name: Name of the Connection Profile (required)
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'type',
            'name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_shared_connection_profile" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'type' is set
        if self.api_client.client_side_validation and ('type' not in local_var_params or  # noqa: E501
                                                        local_var_params['type'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `type` when calling `delete_shared_connection_profile`")  # noqa: E501
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in local_var_params or  # noqa: E501
                                                        local_var_params['name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `name` when calling `delete_shared_connection_profile`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'type' in local_var_params:
            path_params['type'] = local_var_params['type']  # noqa: E501
        if 'name' in local_var_params:
            path_params['name'] = local_var_params['name']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            400: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/deploy/connectionprofile/centralized/{type}/{name}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_site_standard(self, site_standard_name, **kwargs):  # noqa: E501
        """Delete a Site Standard.  # noqa: E501

        Delete a Site Standard.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_site_standard(site_standard_name, async_req=True)
        >>> result = thread.get()

        :param site_standard_name: The name of the Site Standard to be deleted. (required)
        :type site_standard_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_site_standard_with_http_info(site_standard_name, **kwargs)  # noqa: E501

    def delete_site_standard_with_http_info(self, site_standard_name, **kwargs):  # noqa: E501
        """Delete a Site Standard.  # noqa: E501

        Delete a Site Standard.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_site_standard_with_http_info(site_standard_name, async_req=True)
        >>> result = thread.get()

        :param site_standard_name: The name of the Site Standard to be deleted. (required)
        :type site_standard_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'site_standard_name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_site_standard" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'site_standard_name' is set
        if self.api_client.client_side_validation and ('site_standard_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['site_standard_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `site_standard_name` when calling `delete_site_standard`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'site_standard_name' in local_var_params:
            path_params['siteStandardName'] = local_var_params['site_standard_name']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            403: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/deploy/sitestandard/{siteStandardName}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_site_standard_policy(self, site_standard_policy_name, **kwargs):  # noqa: E501
        """Delete a Site Standard Policy.  # noqa: E501

        Delete a Site Standard Policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_site_standard_policy(site_standard_policy_name, async_req=True)
        >>> result = thread.get()

        :param site_standard_policy_name: The name of the Site Standard Policy to be deleted. (required)
        :type site_standard_policy_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_site_standard_policy_with_http_info(site_standard_policy_name, **kwargs)  # noqa: E501

    def delete_site_standard_policy_with_http_info(self, site_standard_policy_name, **kwargs):  # noqa: E501
        """Delete a Site Standard Policy.  # noqa: E501

        Delete a Site Standard Policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_site_standard_policy_with_http_info(site_standard_policy_name, async_req=True)
        >>> result = thread.get()

        :param site_standard_policy_name: The name of the Site Standard Policy to be deleted. (required)
        :type site_standard_policy_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'site_standard_policy_name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_site_standard_policy" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'site_standard_policy_name' is set
        if self.api_client.client_side_validation and ('site_standard_policy_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['site_standard_policy_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `site_standard_policy_name` when calling `delete_site_standard_policy`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'site_standard_policy_name' in local_var_params:
            path_params['siteStandardPolicyName'] = local_var_params['site_standard_policy_name']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            403: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/deploy/sitestandardpolicy/{siteStandardPolicyName}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_sub_folder(self, sub_folder_path, **kwargs):  # noqa: E501
        """delete a sub folder  # noqa: E501

        Delete a sub folder  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_sub_folder(sub_folder_path, async_req=True)
        >>> result = thread.get()

        :param sub_folder_path: The name of the required subFolderPath. (required)
        :type sub_folder_path: str
        :param server: The name of the Control-M in which the sub folder are deployed.
        :type server: str
        :param library: library be filled only for z/os.
        :type library: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_sub_folder_with_http_info(sub_folder_path, **kwargs)  # noqa: E501

    def delete_sub_folder_with_http_info(self, sub_folder_path, **kwargs):  # noqa: E501
        """delete a sub folder  # noqa: E501

        Delete a sub folder  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_sub_folder_with_http_info(sub_folder_path, async_req=True)
        >>> result = thread.get()

        :param sub_folder_path: The name of the required subFolderPath. (required)
        :type sub_folder_path: str
        :param server: The name of the Control-M in which the sub folder are deployed.
        :type server: str
        :param library: library be filled only for z/os.
        :type library: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'sub_folder_path',
            'server',
            'library'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_sub_folder" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'sub_folder_path' is set
        if self.api_client.client_side_validation and ('sub_folder_path' not in local_var_params or  # noqa: E501
                                                        local_var_params['sub_folder_path'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `sub_folder_path` when calling `delete_sub_folder`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'sub_folder_path' in local_var_params:
            path_params['subFolderPath'] = local_var_params['sub_folder_path']  # noqa: E501

        query_params = []
        if 'server' in local_var_params and local_var_params['server'] is not None:  # noqa: E501
            query_params.append(('server', local_var_params['server']))  # noqa: E501
        if 'library' in local_var_params and local_var_params['library'] is not None:  # noqa: E501
            query_params.append(('library', local_var_params['library']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            400: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/deploy/subfolder/{subFolderPath}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def deploy_ai_jobtype(self, ctm, agent, job_type_id, **kwargs):  # noqa: E501
        """Deploy of Application Integrator job type.  # noqa: E501

        Deploy an existing Application Integrator job type to agent in order to allow it to run  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.deploy_ai_jobtype(ctm, agent, job_type_id, async_req=True)
        >>> result = thread.get()

        :param ctm: (required)
        :type ctm: str
        :param agent: (required)
        :type agent: str
        :param job_type_id: (required)
        :type job_type_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AiDeployResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.deploy_ai_jobtype_with_http_info(ctm, agent, job_type_id, **kwargs)  # noqa: E501

    def deploy_ai_jobtype_with_http_info(self, ctm, agent, job_type_id, **kwargs):  # noqa: E501
        """Deploy of Application Integrator job type.  # noqa: E501

        Deploy an existing Application Integrator job type to agent in order to allow it to run  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.deploy_ai_jobtype_with_http_info(ctm, agent, job_type_id, async_req=True)
        >>> result = thread.get()

        :param ctm: (required)
        :type ctm: str
        :param agent: (required)
        :type agent: str
        :param job_type_id: (required)
        :type job_type_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AiDeployResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'ctm',
            'agent',
            'job_type_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deploy_ai_jobtype" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'ctm' is set
        if self.api_client.client_side_validation and ('ctm' not in local_var_params or  # noqa: E501
                                                        local_var_params['ctm'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `ctm` when calling `deploy_ai_jobtype`")  # noqa: E501
        # verify the required parameter 'agent' is set
        if self.api_client.client_side_validation and ('agent' not in local_var_params or  # noqa: E501
                                                        local_var_params['agent'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `agent` when calling `deploy_ai_jobtype`")  # noqa: E501
        # verify the required parameter 'job_type_id' is set
        if self.api_client.client_side_validation and ('job_type_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['job_type_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `job_type_id` when calling `deploy_ai_jobtype`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ctm' in local_var_params and local_var_params['ctm'] is not None:  # noqa: E501
            query_params.append(('ctm', local_var_params['ctm']))  # noqa: E501
        if 'agent' in local_var_params and local_var_params['agent'] is not None:  # noqa: E501
            query_params.append(('agent', local_var_params['agent']))  # noqa: E501
        if 'job_type_id' in local_var_params and local_var_params['job_type_id'] is not None:  # noqa: E501
            query_params.append(('jobTypeId', local_var_params['job_type_id']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "AiDeployResponse",
            400: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/deploy/ai/jobtype', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def deploy_file(self, definitions_file, **kwargs):  # noqa: E501
        """Deploy definitions file  # noqa: E501

        Deploy the provided definition file (JSON, XML or zip) to Control-M  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.deploy_file(definitions_file, async_req=True)
        >>> result = thread.get()

        :param definitions_file: A file that contains definitions to be deployed to the server. Can be either a JSON definition file, an XML definition file, or a zip file that contains multiple JSON or XML definition files. (required)
        :type definitions_file: file
        :param deploy_descriptor_file: Deploy Descriptor JSON file.
        :type deploy_descriptor_file: file
        :param additional_configuration: additionalConfiguration to enable skip testing for local connection profile
        :type additional_configuration: file
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[DeploymentFileResults]
        """
        kwargs['_return_http_data_only'] = True
        return self.deploy_file_with_http_info(definitions_file, **kwargs)  # noqa: E501

    def deploy_file_with_http_info(self, definitions_file, **kwargs):  # noqa: E501
        """Deploy definitions file  # noqa: E501

        Deploy the provided definition file (JSON, XML or zip) to Control-M  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.deploy_file_with_http_info(definitions_file, async_req=True)
        >>> result = thread.get()

        :param definitions_file: A file that contains definitions to be deployed to the server. Can be either a JSON definition file, an XML definition file, or a zip file that contains multiple JSON or XML definition files. (required)
        :type definitions_file: file
        :param deploy_descriptor_file: Deploy Descriptor JSON file.
        :type deploy_descriptor_file: file
        :param additional_configuration: additionalConfiguration to enable skip testing for local connection profile
        :type additional_configuration: file
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[DeploymentFileResults], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'definitions_file',
            'deploy_descriptor_file',
            'additional_configuration'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deploy_file" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'definitions_file' is set
        if self.api_client.client_side_validation and ('definitions_file' not in local_var_params or  # noqa: E501
                                                        local_var_params['definitions_file'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `definitions_file` when calling `deploy_file`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}
        if 'definitions_file' in local_var_params:
            local_var_files['definitionsFile'] = local_var_params['definitions_file']  # noqa: E501
        if 'deploy_descriptor_file' in local_var_params:
            local_var_files['deployDescriptorFile'] = local_var_params['deploy_descriptor_file']  # noqa: E501
        if 'additional_configuration' in local_var_params:
            local_var_files['additionalConfiguration'] = local_var_params['additional_configuration']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['multipart/form-data'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "list[DeploymentFileResults]",
            400: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/deploy', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def deploy_jobtype_file(self, definitions_file, **kwargs):  # noqa: E501
        """Deploy jobtype  # noqa: E501

        Deploy the provided jobtype to AI server, EM server, and Agent.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.deploy_jobtype_file(definitions_file, async_req=True)
        >>> result = thread.get()

        :param definitions_file: A .ctmai file that contains definitions of jobtype to be deployed to the server. (required)
        :type definitions_file: file
        :param agent:
        :type agent: str
        :param server:
        :type server: str
        :param payload_file: A JSON file that contains specifications of an agent.
        :type payload_file: file
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DeployJobtypeResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.deploy_jobtype_file_with_http_info(definitions_file, **kwargs)  # noqa: E501

    def deploy_jobtype_file_with_http_info(self, definitions_file, **kwargs):  # noqa: E501
        """Deploy jobtype  # noqa: E501

        Deploy the provided jobtype to AI server, EM server, and Agent.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.deploy_jobtype_file_with_http_info(definitions_file, async_req=True)
        >>> result = thread.get()

        :param definitions_file: A .ctmai file that contains definitions of jobtype to be deployed to the server. (required)
        :type definitions_file: file
        :param agent:
        :type agent: str
        :param server:
        :type server: str
        :param payload_file: A JSON file that contains specifications of an agent.
        :type payload_file: file
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DeployJobtypeResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'definitions_file',
            'agent',
            'server',
            'payload_file'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deploy_jobtype_file" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'definitions_file' is set
        if self.api_client.client_side_validation and ('definitions_file' not in local_var_params or  # noqa: E501
                                                        local_var_params['definitions_file'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `definitions_file` when calling `deploy_jobtype_file`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'agent' in local_var_params and local_var_params['agent'] is not None:  # noqa: E501
            query_params.append(('agent', local_var_params['agent']))  # noqa: E501
        if 'server' in local_var_params and local_var_params['server'] is not None:  # noqa: E501
            query_params.append(('server', local_var_params['server']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}
        if 'definitions_file' in local_var_params:
            local_var_files['definitionsFile'] = local_var_params['definitions_file']  # noqa: E501
        if 'payload_file' in local_var_params:
            local_var_files['payloadFile'] = local_var_params['payload_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['multipart/form-data'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "DeployJobtypeResponse",
            400: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/deploy/jobtype', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def deploy_site_standard_policies(self, site_standard_policies_file, **kwargs):  # noqa: E501
        """Deploy Site Standard Policies.  # noqa: E501

        Deploy Site Standard Policies.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.deploy_site_standard_policies(site_standard_policies_file, async_req=True)
        >>> result = thread.get()

        :param site_standard_policies_file: A file that contains definitions of Site Standard Policies (required)
        :type site_standard_policies_file: file
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SiteStandardPoliciesFileResults
        """
        kwargs['_return_http_data_only'] = True
        return self.deploy_site_standard_policies_with_http_info(site_standard_policies_file, **kwargs)  # noqa: E501

    def deploy_site_standard_policies_with_http_info(self, site_standard_policies_file, **kwargs):  # noqa: E501
        """Deploy Site Standard Policies.  # noqa: E501

        Deploy Site Standard Policies.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.deploy_site_standard_policies_with_http_info(site_standard_policies_file, async_req=True)
        >>> result = thread.get()

        :param site_standard_policies_file: A file that contains definitions of Site Standard Policies (required)
        :type site_standard_policies_file: file
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SiteStandardPoliciesFileResults, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'site_standard_policies_file'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deploy_site_standard_policies" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'site_standard_policies_file' is set
        if self.api_client.client_side_validation and ('site_standard_policies_file' not in local_var_params or  # noqa: E501
                                                        local_var_params['site_standard_policies_file'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `site_standard_policies_file` when calling `deploy_site_standard_policies`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}
        if 'site_standard_policies_file' in local_var_params:
            local_var_files['siteStandardPoliciesFile'] = local_var_params['site_standard_policies_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['multipart/form-data'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SiteStandardPoliciesFileResults",
            403: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/deploy/sitestandardpolicies', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_connection_profiles_deployment_status(self, type, name, **kwargs):  # noqa: E501
        """Get deployed connection profiles deployment status  # noqa: E501

        Get currently deployed connection profiles deployment status according to the search query as JSON.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_connection_profiles_deployment_status(type, name, async_req=True)
        >>> result = thread.get()

        :param type: The type of connection profile such as Database, FileTransfer, Hadoop, Informatica, SAP. (required)
        :type type: str
        :param name: Name of the Connection Profile (required)
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ConnectionProfilesDeploymentStatusResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_connection_profiles_deployment_status_with_http_info(type, name, **kwargs)  # noqa: E501

    def get_connection_profiles_deployment_status_with_http_info(self, type, name, **kwargs):  # noqa: E501
        """Get deployed connection profiles deployment status  # noqa: E501

        Get currently deployed connection profiles deployment status according to the search query as JSON.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_connection_profiles_deployment_status_with_http_info(type, name, async_req=True)
        >>> result = thread.get()

        :param type: The type of connection profile such as Database, FileTransfer, Hadoop, Informatica, SAP. (required)
        :type type: str
        :param name: Name of the Connection Profile (required)
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ConnectionProfilesDeploymentStatusResult, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'type',
            'name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_connection_profiles_deployment_status" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'type' is set
        if self.api_client.client_side_validation and ('type' not in local_var_params or  # noqa: E501
                                                        local_var_params['type'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `type` when calling `get_connection_profiles_deployment_status`")  # noqa: E501
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in local_var_params or  # noqa: E501
                                                        local_var_params['name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `name` when calling `get_connection_profiles_deployment_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'type' in local_var_params:
            path_params['type'] = local_var_params['type']  # noqa: E501
        if 'name' in local_var_params:
            path_params['name'] = local_var_params['name']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "ConnectionProfilesDeploymentStatusResult",
            400: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/deploy/connectionprofile/centralized/deploymentstatus/{type}/{name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_ctm_ai_job_type_plugin(self, job_type_name, **kwargs):  # noqa: E501
        """Get AI based job type content  # noqa: E501

        Get AI based job type content. When used with CLI content is saved as a .ctmai file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_ctm_ai_job_type_plugin(job_type_name, async_req=True)
        >>> result = thread.get()

        :param job_type_name: The job type name (required)
        :type job_type_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        return self.get_ctm_ai_job_type_plugin_with_http_info(job_type_name, **kwargs)  # noqa: E501

    def get_ctm_ai_job_type_plugin_with_http_info(self, job_type_name, **kwargs):  # noqa: E501
        """Get AI based job type content  # noqa: E501

        Get AI based job type content. When used with CLI content is saved as a .ctmai file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_ctm_ai_job_type_plugin_with_http_info(job_type_name, async_req=True)
        >>> result = thread.get()

        :param job_type_name: The job type name (required)
        :type job_type_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'job_type_name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ctm_ai_job_type_plugin" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'job_type_name' is set
        if self.api_client.client_side_validation and ('job_type_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['job_type_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `job_type_name` when calling `get_ctm_ai_job_type_plugin`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'job_type_name' in local_var_params and local_var_params['job_type_name'] is not None:  # noqa: E501
            query_params.append(('jobTypeName', local_var_params['job_type_name']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "str",
            400: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/deploy/jobtype', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_deployed_ai_jobtypes(self, **kwargs):  # noqa: E501
        """Get Application Integrator job types  # noqa: E501

        Get deployed Application Integrator job types that match the requested search criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_deployed_ai_jobtypes(async_req=True)
        >>> result = thread.get()

        :param job_type_name: Job type display name ( or partial name ) for query. It accepts * as wildcard.
        :type job_type_name: str
        :param job_type_id: Job type id ( or partial name ) for query. It accepts * as wildcard.
        :type job_type_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AiJobtypeList
        """
        kwargs['_return_http_data_only'] = True
        return self.get_deployed_ai_jobtypes_with_http_info(**kwargs)  # noqa: E501

    def get_deployed_ai_jobtypes_with_http_info(self, **kwargs):  # noqa: E501
        """Get Application Integrator job types  # noqa: E501

        Get deployed Application Integrator job types that match the requested search criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_deployed_ai_jobtypes_with_http_info(async_req=True)
        >>> result = thread.get()

        :param job_type_name: Job type display name ( or partial name ) for query. It accepts * as wildcard.
        :type job_type_name: str
        :param job_type_id: Job type id ( or partial name ) for query. It accepts * as wildcard.
        :type job_type_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AiJobtypeList, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'job_type_name',
            'job_type_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_deployed_ai_jobtypes" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'job_type_name' in local_var_params and local_var_params['job_type_name'] is not None:  # noqa: E501
            query_params.append(('jobTypeName', local_var_params['job_type_name']))  # noqa: E501
        if 'job_type_id' in local_var_params and local_var_params['job_type_id'] is not None:  # noqa: E501
            query_params.append(('jobTypeId', local_var_params['job_type_id']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "AiJobtypeList",
            400: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/deploy/ai/jobtypes', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_deployed_calendars(self, **kwargs):  # noqa: E501
        """Get deployed calendars that match the search criteria.  # noqa: E501

        Get definition of calendars as json code that match the requested search criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_deployed_calendars(async_req=True)
        >>> result = thread.get()

        :param name:
        :type name: str
        :param server:
        :type server: str
        :param type: Calendar type.
        :type type: str
        :param alias: Calendar alias name for z/OS servers.
        :type alias: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        return self.get_deployed_calendars_with_http_info(**kwargs)  # noqa: E501

    def get_deployed_calendars_with_http_info(self, **kwargs):  # noqa: E501
        """Get deployed calendars that match the search criteria.  # noqa: E501

        Get definition of calendars as json code that match the requested search criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_deployed_calendars_with_http_info(async_req=True)
        >>> result = thread.get()

        :param name:
        :type name: str
        :param server:
        :type server: str
        :param type: Calendar type.
        :type type: str
        :param alias: Calendar alias name for z/OS servers.
        :type alias: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'name',
            'server',
            'type',
            'alias'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_deployed_calendars" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'server' in local_var_params and local_var_params['server'] is not None:  # noqa: E501
            query_params.append(('server', local_var_params['server']))  # noqa: E501
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'alias' in local_var_params and local_var_params['alias'] is not None:  # noqa: E501
            query_params.append(('alias', local_var_params['alias']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "str",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/deploy/calendars', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_deployed_connection_profiles(self, agent, type, **kwargs):  # noqa: E501
        """Get local deployed connection profiles  # noqa: E501

        Get currently local deployed connection profiles according to the search query as JSON.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_deployed_connection_profiles(agent, type, async_req=True)
        >>> result = thread.get()

        :param agent: The name of the agent the connection profile is deployed on (required)
        :type agent: str
        :param type: The type of connection profile such as Database, FileTransfer, Hadoop, Informatica, SAP. (required)
        :type type: str
        :param ctm: The name of the Control-M in which the connection profile is deployed on
        :type ctm: str
        :param server: The name of the Control-M in which the connection profile is deployed on
        :type server: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        return self.get_deployed_connection_profiles_with_http_info(agent, type, **kwargs)  # noqa: E501

    def get_deployed_connection_profiles_with_http_info(self, agent, type, **kwargs):  # noqa: E501
        """Get local deployed connection profiles  # noqa: E501

        Get currently local deployed connection profiles according to the search query as JSON.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_deployed_connection_profiles_with_http_info(agent, type, async_req=True)
        >>> result = thread.get()

        :param agent: The name of the agent the connection profile is deployed on (required)
        :type agent: str
        :param type: The type of connection profile such as Database, FileTransfer, Hadoop, Informatica, SAP. (required)
        :type type: str
        :param ctm: The name of the Control-M in which the connection profile is deployed on
        :type ctm: str
        :param server: The name of the Control-M in which the connection profile is deployed on
        :type server: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'agent',
            'type',
            'ctm',
            'server'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_deployed_connection_profiles" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'agent' is set
        if self.api_client.client_side_validation and ('agent' not in local_var_params or  # noqa: E501
                                                        local_var_params['agent'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `agent` when calling `get_deployed_connection_profiles`")  # noqa: E501
        # verify the required parameter 'type' is set
        if self.api_client.client_side_validation and ('type' not in local_var_params or  # noqa: E501
                                                        local_var_params['type'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `type` when calling `get_deployed_connection_profiles`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ctm' in local_var_params and local_var_params['ctm'] is not None:  # noqa: E501
            query_params.append(('ctm', local_var_params['ctm']))  # noqa: E501
        if 'server' in local_var_params and local_var_params['server'] is not None:  # noqa: E501
            query_params.append(('server', local_var_params['server']))  # noqa: E501
        if 'agent' in local_var_params and local_var_params['agent'] is not None:  # noqa: E501
            query_params.append(('agent', local_var_params['agent']))  # noqa: E501
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "str",
            400: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/deploy/connectionprofiles', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_deployed_connection_profiles_status(self, **kwargs):  # noqa: E501
        """Get deployed connection profiles status  # noqa: E501

        Get currently deployed connection profiles status according to the search query as JSON.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_deployed_connection_profiles_status(async_req=True)
        >>> result = thread.get()

        :param limit: number to limit the returned connection profiles. If missed - get all
        :type limit: int
        :param name: conn profile name (support *, ?, and comma, default is * for all).
        :type name: str
        :param type: conn profile type (default is * for accounts from all CMs).
        :type type: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ConnectionProfilesStatusResult
        """
        kwargs['_return_http_data_only'] = True
        return self.get_deployed_connection_profiles_status_with_http_info(**kwargs)  # noqa: E501

    def get_deployed_connection_profiles_status_with_http_info(self, **kwargs):  # noqa: E501
        """Get deployed connection profiles status  # noqa: E501

        Get currently deployed connection profiles status according to the search query as JSON.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_deployed_connection_profiles_status_with_http_info(async_req=True)
        >>> result = thread.get()

        :param limit: number to limit the returned connection profiles. If missed - get all
        :type limit: int
        :param name: conn profile name (support *, ?, and comma, default is * for all).
        :type name: str
        :param type: conn profile type (default is * for accounts from all CMs).
        :type type: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ConnectionProfilesStatusResult, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'limit',
            'name',
            'type'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_deployed_connection_profiles_status" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "ConnectionProfilesStatusResult",
            206: "ConnectionProfilesStatusResult",
            400: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/deploy/connectionprofiles/centralized/status', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_deployed_folders(self, **kwargs):  # noqa: E501
        """Get deployed folders that match the search criteria.  # noqa: E501

        Get definition of folders that match the requested search criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_deployed_folders(async_req=True)
        >>> result = thread.get()

        :param folder:
        :type folder: str
        :param server:
        :type server: str
        :param library: library be filled only for z/os.
        :type library: str
        :param folder_type: filter by simpleFolder
        :type folder_type: str
        :param site_standard: filter by siteStandard
        :type site_standard: str
        :param application: filter by application
        :type application: str
        :param sub_application: filter by subApplication
        :type sub_application: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: object
        """
        kwargs['_return_http_data_only'] = True
        return self.get_deployed_folders_with_http_info(**kwargs)  # noqa: E501

    def get_deployed_folders_with_http_info(self, **kwargs):  # noqa: E501
        """Get deployed folders that match the search criteria.  # noqa: E501

        Get definition of folders that match the requested search criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_deployed_folders_with_http_info(async_req=True)
        >>> result = thread.get()

        :param folder:
        :type folder: str
        :param server:
        :type server: str
        :param library: library be filled only for z/os.
        :type library: str
        :param folder_type: filter by simpleFolder
        :type folder_type: str
        :param site_standard: filter by siteStandard
        :type site_standard: str
        :param application: filter by application
        :type application: str
        :param sub_application: filter by subApplication
        :type sub_application: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(object, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'folder',
            'server',
            'library',
            'folder_type',
            'site_standard',
            'application',
            'sub_application'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_deployed_folders" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'folder' in local_var_params and local_var_params['folder'] is not None:  # noqa: E501
            query_params.append(('folder', local_var_params['folder']))  # noqa: E501
        if 'server' in local_var_params and local_var_params['server'] is not None:  # noqa: E501
            query_params.append(('server', local_var_params['server']))  # noqa: E501
        if 'library' in local_var_params and local_var_params['library'] is not None:  # noqa: E501
            query_params.append(('library', local_var_params['library']))  # noqa: E501
        if 'folder_type' in local_var_params and local_var_params['folder_type'] is not None:  # noqa: E501
            query_params.append(('folderType', local_var_params['folder_type']))  # noqa: E501
        if 'site_standard' in local_var_params and local_var_params['site_standard'] is not None:  # noqa: E501
            query_params.append(('siteStandard', local_var_params['site_standard']))  # noqa: E501
        if 'application' in local_var_params and local_var_params['application'] is not None:  # noqa: E501
            query_params.append(('application', local_var_params['application']))  # noqa: E501
        if 'sub_application' in local_var_params and local_var_params['sub_application'] is not None:  # noqa: E501
            query_params.append(('subApplication', local_var_params['sub_application']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "object",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/deploy/folders', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_deployed_folders_new(self, **kwargs):  # noqa: E501
        """Get deployed jobs that match the search criteria.  # noqa: E501

        Get definition of jobs and folders (in the desired format - JSON or XML) that match the requested search criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_deployed_folders_new(async_req=True)
        >>> result = thread.get()

        :param format: Output format (json or xml)
        :type format: str
        :param folder:
        :type folder: str
        :param job:
        :type job: str
        :param ctm:
        :type ctm: str
        :param server:
        :type server: str
        :param use_array_format: When set to true, the jobs in the json response will always be arranged in arrays
        :type use_array_format: bool
        :param library: library be filled only for z/os.
        :type library: str
        :param flow_data: When set to true, only data cache will be return
        :type flow_data: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: object
        """
        kwargs['_return_http_data_only'] = True
        return self.get_deployed_folders_new_with_http_info(**kwargs)  # noqa: E501

    def get_deployed_folders_new_with_http_info(self, **kwargs):  # noqa: E501
        """Get deployed jobs that match the search criteria.  # noqa: E501

        Get definition of jobs and folders (in the desired format - JSON or XML) that match the requested search criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_deployed_folders_new_with_http_info(async_req=True)
        >>> result = thread.get()

        :param format: Output format (json or xml)
        :type format: str
        :param folder:
        :type folder: str
        :param job:
        :type job: str
        :param ctm:
        :type ctm: str
        :param server:
        :type server: str
        :param use_array_format: When set to true, the jobs in the json response will always be arranged in arrays
        :type use_array_format: bool
        :param library: library be filled only for z/os.
        :type library: str
        :param flow_data: When set to true, only data cache will be return
        :type flow_data: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(object, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'format',
            'folder',
            'job',
            'ctm',
            'server',
            'use_array_format',
            'library',
            'flow_data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_deployed_folders_new" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'format' in local_var_params and local_var_params['format'] is not None:  # noqa: E501
            query_params.append(('format', local_var_params['format']))  # noqa: E501
        if 'folder' in local_var_params and local_var_params['folder'] is not None:  # noqa: E501
            query_params.append(('folder', local_var_params['folder']))  # noqa: E501
        if 'job' in local_var_params and local_var_params['job'] is not None:  # noqa: E501
            query_params.append(('job', local_var_params['job']))  # noqa: E501
        if 'ctm' in local_var_params and local_var_params['ctm'] is not None:  # noqa: E501
            query_params.append(('ctm', local_var_params['ctm']))  # noqa: E501
        if 'server' in local_var_params and local_var_params['server'] is not None:  # noqa: E501
            query_params.append(('server', local_var_params['server']))  # noqa: E501
        if 'use_array_format' in local_var_params and local_var_params['use_array_format'] is not None:  # noqa: E501
            query_params.append(('useArrayFormat', local_var_params['use_array_format']))  # noqa: E501
        if 'library' in local_var_params and local_var_params['library'] is not None:  # noqa: E501
            query_params.append(('library', local_var_params['library']))  # noqa: E501
        if 'flow_data' in local_var_params and local_var_params['flow_data'] is not None:  # noqa: E501
            query_params.append(('flowData', local_var_params['flow_data']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "object",
            400: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/deploy/jobs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_local_connection_profiles(self, agent, type, **kwargs):  # noqa: E501
        """Get local deployed connection profiles  # noqa: E501

        Get currently local deployed connection profiles according to the search query as JSON.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_local_connection_profiles(agent, type, async_req=True)
        >>> result = thread.get()

        :param agent: The name of the agent the connection profile is deployed on (required)
        :type agent: str
        :param type: The type of connection profile such as Database, FileTransfer, Hadoop, Informatica, SAP. (required)
        :type type: str
        :param ctm: The name of the Control-M in which the connection profile is deployed on
        :type ctm: str
        :param server: The name of the Control-M in which the connection profile is deployed on
        :type server: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        return self.get_local_connection_profiles_with_http_info(agent, type, **kwargs)  # noqa: E501

    def get_local_connection_profiles_with_http_info(self, agent, type, **kwargs):  # noqa: E501
        """Get local deployed connection profiles  # noqa: E501

        Get currently local deployed connection profiles according to the search query as JSON.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_local_connection_profiles_with_http_info(agent, type, async_req=True)
        >>> result = thread.get()

        :param agent: The name of the agent the connection profile is deployed on (required)
        :type agent: str
        :param type: The type of connection profile such as Database, FileTransfer, Hadoop, Informatica, SAP. (required)
        :type type: str
        :param ctm: The name of the Control-M in which the connection profile is deployed on
        :type ctm: str
        :param server: The name of the Control-M in which the connection profile is deployed on
        :type server: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'agent',
            'type',
            'ctm',
            'server'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_local_connection_profiles" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'agent' is set
        if self.api_client.client_side_validation and ('agent' not in local_var_params or  # noqa: E501
                                                        local_var_params['agent'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `agent` when calling `get_local_connection_profiles`")  # noqa: E501
        # verify the required parameter 'type' is set
        if self.api_client.client_side_validation and ('type' not in local_var_params or  # noqa: E501
                                                        local_var_params['type'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `type` when calling `get_local_connection_profiles`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ctm' in local_var_params and local_var_params['ctm'] is not None:  # noqa: E501
            query_params.append(('ctm', local_var_params['ctm']))  # noqa: E501
        if 'server' in local_var_params and local_var_params['server'] is not None:  # noqa: E501
            query_params.append(('server', local_var_params['server']))  # noqa: E501
        if 'agent' in local_var_params and local_var_params['agent'] is not None:  # noqa: E501
            query_params.append(('agent', local_var_params['agent']))  # noqa: E501
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "str",
            400: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/deploy/connectionprofiles/local', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_shared_connection_profiles(self, type, **kwargs):  # noqa: E501
        """Get centralized deployed connection profile  # noqa: E501

        Get currently centralized deployed connection profiles according to the search query as JSON.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_shared_connection_profiles(type, async_req=True)
        >>> result = thread.get()

        :param type: The type of connection profile such as Database, FileTransfer, Hadoop, Informatica, SAP. Use * to get all types (required)
        :type type: str
        :param name: The name of centralized connection profile. Supports for *, ?, and comma. By default is *
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        return self.get_shared_connection_profiles_with_http_info(type, **kwargs)  # noqa: E501

    def get_shared_connection_profiles_with_http_info(self, type, **kwargs):  # noqa: E501
        """Get centralized deployed connection profile  # noqa: E501

        Get currently centralized deployed connection profiles according to the search query as JSON.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_shared_connection_profiles_with_http_info(type, async_req=True)
        >>> result = thread.get()

        :param type: The type of connection profile such as Database, FileTransfer, Hadoop, Informatica, SAP. Use * to get all types (required)
        :type type: str
        :param name: The name of centralized connection profile. Supports for *, ?, and comma. By default is *
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'type',
            'name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_shared_connection_profiles" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'type' is set
        if self.api_client.client_side_validation and ('type' not in local_var_params or  # noqa: E501
                                                        local_var_params['type'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `type` when calling `get_shared_connection_profiles`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "str",
            400: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/deploy/connectionprofiles/centralized', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_site_standard_field_restrictions(self, standard_name, field_name, **kwargs):  # noqa: E501
        """Get the allowed values for the specified field in the specified site standard.  # noqa: E501

        Get the allowed values for the specified field in the specified site standard.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_site_standard_field_restrictions(standard_name, field_name, async_req=True)
        >>> result = thread.get()

        :param standard_name: (required)
        :type standard_name: str
        :param field_name: (required)
        :type field_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        return self.get_site_standard_field_restrictions_with_http_info(standard_name, field_name, **kwargs)  # noqa: E501

    def get_site_standard_field_restrictions_with_http_info(self, standard_name, field_name, **kwargs):  # noqa: E501
        """Get the allowed values for the specified field in the specified site standard.  # noqa: E501

        Get the allowed values for the specified field in the specified site standard.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_site_standard_field_restrictions_with_http_info(standard_name, field_name, async_req=True)
        >>> result = thread.get()

        :param standard_name: (required)
        :type standard_name: str
        :param field_name: (required)
        :type field_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'standard_name',
            'field_name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_site_standard_field_restrictions" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'standard_name' is set
        if self.api_client.client_side_validation and ('standard_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['standard_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `standard_name` when calling `get_site_standard_field_restrictions`")  # noqa: E501
        # verify the required parameter 'field_name' is set
        if self.api_client.client_side_validation and ('field_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['field_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `field_name` when calling `get_site_standard_field_restrictions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'standard_name' in local_var_params:
            path_params['standardName'] = local_var_params['standard_name']  # noqa: E501
        if 'field_name' in local_var_params:
            path_params['fieldName'] = local_var_params['field_name']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "str",
            400: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/deploy/sitestandard/{standardName}/fieldRestriction/{fieldName}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_site_standard_policies(self, **kwargs):  # noqa: E501
        """Get definitions of deployed Site Standard Policies that match the search criteria.  # noqa: E501

        Get definitions of deployed Site Standard Policies that match the search criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_site_standard_policies(async_req=True)
        >>> result = thread.get()

        :param name:
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        return self.get_site_standard_policies_with_http_info(**kwargs)  # noqa: E501

    def get_site_standard_policies_with_http_info(self, **kwargs):  # noqa: E501
        """Get definitions of deployed Site Standard Policies that match the search criteria.  # noqa: E501

        Get definitions of deployed Site Standard Policies that match the search criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_site_standard_policies_with_http_info(async_req=True)
        >>> result = thread.get()

        :param name:
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_site_standard_policies" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "str",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/deploy/sitestandardpolicies', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_site_standard_policies_details(self, **kwargs):  # noqa: E501
        """Get details of deployed Site Standard Policies that match the search criteria.  # noqa: E501

        Get details of deployed Site Standard Policies that match the requested search criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_site_standard_policies_details(async_req=True)
        >>> result = thread.get()

        :param name:
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SiteStandardPolicyDetailsList
        """
        kwargs['_return_http_data_only'] = True
        return self.get_site_standard_policies_details_with_http_info(**kwargs)  # noqa: E501

    def get_site_standard_policies_details_with_http_info(self, **kwargs):  # noqa: E501
        """Get details of deployed Site Standard Policies that match the search criteria.  # noqa: E501

        Get details of deployed Site Standard Policies that match the requested search criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_site_standard_policies_details_with_http_info(async_req=True)
        >>> result = thread.get()

        :param name:
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SiteStandardPolicyDetailsList, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_site_standard_policies_details" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SiteStandardPolicyDetailsList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/deploy/sitestandardpolicies/details', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_site_standards(self, **kwargs):  # noqa: E501
        """Get definitions of deployed Site Standards that match the search criteria.  # noqa: E501

        Get definitions of deployed Site Standards that match the search criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_site_standards(async_req=True)
        >>> result = thread.get()

        :param name:
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        return self.get_site_standards_with_http_info(**kwargs)  # noqa: E501

    def get_site_standards_with_http_info(self, **kwargs):  # noqa: E501
        """Get definitions of deployed Site Standards that match the search criteria.  # noqa: E501

        Get definitions of deployed Site Standards that match the search criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_site_standards_with_http_info(async_req=True)
        >>> result = thread.get()

        :param name:
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_site_standards" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "str",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/deploy/sitestandards', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_site_standards_details(self, **kwargs):  # noqa: E501
        """Get details of deployed Site Standards that match the search criteria.  # noqa: E501

        Get details of deployed Site Standards that match the requested search criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_site_standards_details(async_req=True)
        >>> result = thread.get()

        :param name:
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SiteStandardDetailsList
        """
        kwargs['_return_http_data_only'] = True
        return self.get_site_standards_details_with_http_info(**kwargs)  # noqa: E501

    def get_site_standards_details_with_http_info(self, **kwargs):  # noqa: E501
        """Get details of deployed Site Standards that match the search criteria.  # noqa: E501

        Get details of deployed Site Standards that match the requested search criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_site_standards_details_with_http_info(async_req=True)
        >>> result = thread.get()

        :param name:
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SiteStandardDetailsList, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_site_standards_details" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SiteStandardDetailsList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/deploy/sitestandards/details', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def poll_deploy_results(self, poll_id, **kwargs):  # noqa: E501
        """Get the deploy result  # noqa: E501

        Get the deploy result  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.poll_deploy_results(poll_id, async_req=True)
        >>> result = thread.get()

        :param poll_id: deploy request identification (required)
        :type poll_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DeploymentFileResults
        """
        kwargs['_return_http_data_only'] = True
        return self.poll_deploy_results_with_http_info(poll_id, **kwargs)  # noqa: E501

    def poll_deploy_results_with_http_info(self, poll_id, **kwargs):  # noqa: E501
        """Get the deploy result  # noqa: E501

        Get the deploy result  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.poll_deploy_results_with_http_info(poll_id, async_req=True)
        >>> result = thread.get()

        :param poll_id: deploy request identification (required)
        :type poll_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DeploymentFileResults, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'poll_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method poll_deploy_results" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'poll_id' is set
        if self.api_client.client_side_validation and ('poll_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['poll_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `poll_id` when calling `poll_deploy_results`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'poll_id' in local_var_params and local_var_params['poll_id'] is not None:  # noqa: E501
            query_params.append(('pollId', local_var_params['poll_id']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "DeploymentFileResults",
            202: "object",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/deploy/poll', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def rename_site_standard(self, site_standard_name, site_standard_new_name, **kwargs):  # noqa: E501
        """Rename deployed Site Standard.  # noqa: E501

        Rename deployed Site Standard.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.rename_site_standard(site_standard_name, site_standard_new_name, async_req=True)
        >>> result = thread.get()

        :param site_standard_name: (required)
        :type site_standard_name: str
        :param site_standard_new_name: (required)
        :type site_standard_new_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.rename_site_standard_with_http_info(site_standard_name, site_standard_new_name, **kwargs)  # noqa: E501

    def rename_site_standard_with_http_info(self, site_standard_name, site_standard_new_name, **kwargs):  # noqa: E501
        """Rename deployed Site Standard.  # noqa: E501

        Rename deployed Site Standard.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.rename_site_standard_with_http_info(site_standard_name, site_standard_new_name, async_req=True)
        >>> result = thread.get()

        :param site_standard_name: (required)
        :type site_standard_name: str
        :param site_standard_new_name: (required)
        :type site_standard_new_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'site_standard_name',
            'site_standard_new_name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method rename_site_standard" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'site_standard_name' is set
        if self.api_client.client_side_validation and ('site_standard_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['site_standard_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `site_standard_name` when calling `rename_site_standard`")  # noqa: E501
        # verify the required parameter 'site_standard_new_name' is set
        if self.api_client.client_side_validation and ('site_standard_new_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['site_standard_new_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `site_standard_new_name` when calling `rename_site_standard`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'site_standard_name' in local_var_params:
            path_params['siteStandardName'] = local_var_params['site_standard_name']  # noqa: E501

        query_params = []
        if 'site_standard_new_name' in local_var_params and local_var_params['site_standard_new_name'] is not None:  # noqa: E501
            query_params.append(('siteStandardNewName', local_var_params['site_standard_new_name']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            403: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/deploy/sitestandard/{siteStandardName}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def rename_site_standard_policy(self, site_standard_policy_name, site_standard_policy_new_name, **kwargs):  # noqa: E501
        """Rename deployed Site Standard Policy.  # noqa: E501

        Rename deployed Site Standard Policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.rename_site_standard_policy(site_standard_policy_name, site_standard_policy_new_name, async_req=True)
        >>> result = thread.get()

        :param site_standard_policy_name: (required)
        :type site_standard_policy_name: str
        :param site_standard_policy_new_name: (required)
        :type site_standard_policy_new_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.rename_site_standard_policy_with_http_info(site_standard_policy_name, site_standard_policy_new_name, **kwargs)  # noqa: E501

    def rename_site_standard_policy_with_http_info(self, site_standard_policy_name, site_standard_policy_new_name, **kwargs):  # noqa: E501
        """Rename deployed Site Standard Policy.  # noqa: E501

        Rename deployed Site Standard Policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.rename_site_standard_policy_with_http_info(site_standard_policy_name, site_standard_policy_new_name, async_req=True)
        >>> result = thread.get()

        :param site_standard_policy_name: (required)
        :type site_standard_policy_name: str
        :param site_standard_policy_new_name: (required)
        :type site_standard_policy_new_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'site_standard_policy_name',
            'site_standard_policy_new_name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method rename_site_standard_policy" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'site_standard_policy_name' is set
        if self.api_client.client_side_validation and ('site_standard_policy_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['site_standard_policy_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `site_standard_policy_name` when calling `rename_site_standard_policy`")  # noqa: E501
        # verify the required parameter 'site_standard_policy_new_name' is set
        if self.api_client.client_side_validation and ('site_standard_policy_new_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['site_standard_policy_new_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `site_standard_policy_new_name` when calling `rename_site_standard_policy`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'site_standard_policy_name' in local_var_params:
            path_params['siteStandardPolicyName'] = local_var_params['site_standard_policy_name']  # noqa: E501

        query_params = []
        if 'site_standard_policy_new_name' in local_var_params and local_var_params['site_standard_policy_new_name'] is not None:  # noqa: E501
            query_params.append(('siteStandardPolicyNewName', local_var_params['site_standard_policy_new_name']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            403: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/deploy/sitestandardpolicy/{siteStandardPolicyName}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def set_site_standard_field_restrictions(self, standard_name, field_name, values_file, **kwargs):  # noqa: E501
        """Replace the allowed values for the specified field in the specified site standard.  # noqa: E501

        Replace the allowed values for the specified field in the specified site standard.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_site_standard_field_restrictions(standard_name, field_name, values_file, async_req=True)
        >>> result = thread.get()

        :param standard_name: (required)
        :type standard_name: str
        :param field_name: (required)
        :type field_name: str
        :param values_file: The JSON file with the allowed values (required)
        :type values_file: FieldValues
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.set_site_standard_field_restrictions_with_http_info(standard_name, field_name, values_file, **kwargs)  # noqa: E501

    def set_site_standard_field_restrictions_with_http_info(self, standard_name, field_name, values_file, **kwargs):  # noqa: E501
        """Replace the allowed values for the specified field in the specified site standard.  # noqa: E501

        Replace the allowed values for the specified field in the specified site standard.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_site_standard_field_restrictions_with_http_info(standard_name, field_name, values_file, async_req=True)
        >>> result = thread.get()

        :param standard_name: (required)
        :type standard_name: str
        :param field_name: (required)
        :type field_name: str
        :param values_file: The JSON file with the allowed values (required)
        :type values_file: FieldValues
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'standard_name',
            'field_name',
            'values_file'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_site_standard_field_restrictions" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'standard_name' is set
        if self.api_client.client_side_validation and ('standard_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['standard_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `standard_name` when calling `set_site_standard_field_restrictions`")  # noqa: E501
        # verify the required parameter 'field_name' is set
        if self.api_client.client_side_validation and ('field_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['field_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `field_name` when calling `set_site_standard_field_restrictions`")  # noqa: E501
        # verify the required parameter 'values_file' is set
        if self.api_client.client_side_validation and ('values_file' not in local_var_params or  # noqa: E501
                                                        local_var_params['values_file'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `values_file` when calling `set_site_standard_field_restrictions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'standard_name' in local_var_params:
            path_params['standardName'] = local_var_params['standard_name']  # noqa: E501
        if 'field_name' in local_var_params:
            path_params['fieldName'] = local_var_params['field_name']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'values_file' in local_var_params:
            body_params = local_var_params['values_file']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            400: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/deploy/sitestandard/{standardName}/fieldRestriction/{fieldName}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def test_centralized_connection_profile(self, type, name, server, agent, **kwargs):  # noqa: E501
        """Test connection profile centralized on agent  # noqa: E501

        Test connection profile centralized on agent  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.test_centralized_connection_profile(type, name, server, agent, async_req=True)
        >>> result = thread.get()

        :param type: The type of connection profile. (required)
        :type type: str
        :param name: Name of the Connection Profile (required)
        :type name: str
        :param server: The ctm of connection profile. (required)
        :type server: str
        :param agent: (required)
        :type agent: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.test_centralized_connection_profile_with_http_info(type, name, server, agent, **kwargs)  # noqa: E501

    def test_centralized_connection_profile_with_http_info(self, type, name, server, agent, **kwargs):  # noqa: E501
        """Test connection profile centralized on agent  # noqa: E501

        Test connection profile centralized on agent  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.test_centralized_connection_profile_with_http_info(type, name, server, agent, async_req=True)
        >>> result = thread.get()

        :param type: The type of connection profile. (required)
        :type type: str
        :param name: Name of the Connection Profile (required)
        :type name: str
        :param server: The ctm of connection profile. (required)
        :type server: str
        :param agent: (required)
        :type agent: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'type',
            'name',
            'server',
            'agent'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method test_centralized_connection_profile" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'type' is set
        if self.api_client.client_side_validation and ('type' not in local_var_params or  # noqa: E501
                                                        local_var_params['type'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `type` when calling `test_centralized_connection_profile`")  # noqa: E501
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in local_var_params or  # noqa: E501
                                                        local_var_params['name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `name` when calling `test_centralized_connection_profile`")  # noqa: E501
        # verify the required parameter 'server' is set
        if self.api_client.client_side_validation and ('server' not in local_var_params or  # noqa: E501
                                                        local_var_params['server'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `server` when calling `test_centralized_connection_profile`")  # noqa: E501
        # verify the required parameter 'agent' is set
        if self.api_client.client_side_validation and ('agent' not in local_var_params or  # noqa: E501
                                                        local_var_params['agent'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `agent` when calling `test_centralized_connection_profile`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'type' in local_var_params:
            path_params['type'] = local_var_params['type']  # noqa: E501
        if 'name' in local_var_params:
            path_params['name'] = local_var_params['name']  # noqa: E501
        if 'server' in local_var_params:
            path_params['server'] = local_var_params['server']  # noqa: E501
        if 'agent' in local_var_params:
            path_params['agent'] = local_var_params['agent']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            400: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/deploy/connectionprofile/centralized/test/{type}/{name}/{server}/{agent}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def test_connection_profile(self, definitions_file, **kwargs):  # noqa: E501
        """Test connection profile on agent  # noqa: E501

        Test connection profile on agent  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.test_connection_profile(definitions_file, async_req=True)
        >>> result = thread.get()

        :param definitions_file: A file that contains definitions of the connection profile to be tested (required)
        :type definitions_file: file
        :param ctm:
        :type ctm: str
        :param agent:
        :type agent: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.test_connection_profile_with_http_info(definitions_file, **kwargs)  # noqa: E501

    def test_connection_profile_with_http_info(self, definitions_file, **kwargs):  # noqa: E501
        """Test connection profile on agent  # noqa: E501

        Test connection profile on agent  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.test_connection_profile_with_http_info(definitions_file, async_req=True)
        >>> result = thread.get()

        :param definitions_file: A file that contains definitions of the connection profile to be tested (required)
        :type definitions_file: file
        :param ctm:
        :type ctm: str
        :param agent:
        :type agent: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'definitions_file',
            'ctm',
            'agent'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method test_connection_profile" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'definitions_file' is set
        if self.api_client.client_side_validation and ('definitions_file' not in local_var_params or  # noqa: E501
                                                        local_var_params['definitions_file'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `definitions_file` when calling `test_connection_profile`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ctm' in local_var_params and local_var_params['ctm'] is not None:  # noqa: E501
            query_params.append(('ctm', local_var_params['ctm']))  # noqa: E501
        if 'agent' in local_var_params and local_var_params['agent'] is not None:  # noqa: E501
            query_params.append(('agent', local_var_params['agent']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}
        if 'definitions_file' in local_var_params:
            local_var_files['definitionsFile'] = local_var_params['definitions_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['multipart/form-data'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            400: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/deploy/connectionprofile/test', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def transform_file(self, definitions_file, deploy_descriptor_file, **kwargs):  # noqa: E501
        """Transform a definitions file  # noqa: E501

        Transform the provided definitions file (JSON) according to the provided Deploy Descriptor file (JSON).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.transform_file(definitions_file, deploy_descriptor_file, async_req=True)
        >>> result = thread.get()

        :param definitions_file: A JSON file that contains definitions to be deployed to the server (required)
        :type definitions_file: file
        :param deploy_descriptor_file: Deploy Descriptor JSON file. (required)
        :type deploy_descriptor_file: file
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        return self.transform_file_with_http_info(definitions_file, deploy_descriptor_file, **kwargs)  # noqa: E501

    def transform_file_with_http_info(self, definitions_file, deploy_descriptor_file, **kwargs):  # noqa: E501
        """Transform a definitions file  # noqa: E501

        Transform the provided definitions file (JSON) according to the provided Deploy Descriptor file (JSON).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.transform_file_with_http_info(definitions_file, deploy_descriptor_file, async_req=True)
        >>> result = thread.get()

        :param definitions_file: A JSON file that contains definitions to be deployed to the server (required)
        :type definitions_file: file
        :param deploy_descriptor_file: Deploy Descriptor JSON file. (required)
        :type deploy_descriptor_file: file
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'definitions_file',
            'deploy_descriptor_file'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method transform_file" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'definitions_file' is set
        if self.api_client.client_side_validation and ('definitions_file' not in local_var_params or  # noqa: E501
                                                        local_var_params['definitions_file'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `definitions_file` when calling `transform_file`")  # noqa: E501
        # verify the required parameter 'deploy_descriptor_file' is set
        if self.api_client.client_side_validation and ('deploy_descriptor_file' not in local_var_params or  # noqa: E501
                                                        local_var_params['deploy_descriptor_file'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `deploy_descriptor_file` when calling `transform_file`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}
        if 'definitions_file' in local_var_params:
            local_var_files['definitionsFile'] = local_var_params['definitions_file']  # noqa: E501
        if 'deploy_descriptor_file' in local_var_params:
            local_var_files['deployDescriptorFile'] = local_var_params['deploy_descriptor_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['multipart/form-data'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "str",
            400: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/deploy/transform', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))
