# coding: utf-8

"""
    Control-M Services

    Provides access to BMC Control-M Services  # noqa: E501

    The version of the OpenAPI document: 9.22.30
    Contact: customer_support@bmc.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from clients.ctm_api_client.api_client import ApiClient
from clients.ctm_api_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class ProvisionApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_provision_repo(self, repo_name, location, **kwargs):  # noqa: E501
        """Add a configuration of a local repository.  # noqa: E501

        Add a configuration of a local repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_provision_repo(repo_name, location, async_req=True)
        >>> result = thread.get()

        :param repo_name: (required)
        :type repo_name: str
        :param location: (required)
        :type location: str
        :param description:
        :type description: str
        :param helix_repo: True means this is a Helix repository. Otherwise it is an on-prem repo. Default is on prem
        :type helix_repo: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ProvisionRepo
        """
        kwargs['_return_http_data_only'] = True
        return self.add_provision_repo_with_http_info(repo_name, location, **kwargs)  # noqa: E501

    def add_provision_repo_with_http_info(self, repo_name, location, **kwargs):  # noqa: E501
        """Add a configuration of a local repository.  # noqa: E501

        Add a configuration of a local repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_provision_repo_with_http_info(repo_name, location, async_req=True)
        >>> result = thread.get()

        :param repo_name: (required)
        :type repo_name: str
        :param location: (required)
        :type location: str
        :param description:
        :type description: str
        :param helix_repo: True means this is a Helix repository. Otherwise it is an on-prem repo. Default is on prem
        :type helix_repo: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ProvisionRepo, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'repo_name',
            'location',
            'description',
            'helix_repo'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_provision_repo" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'repo_name' is set
        if self.api_client.client_side_validation and ('repo_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['repo_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `repo_name` when calling `add_provision_repo`")  # noqa: E501
        # verify the required parameter 'location' is set
        if self.api_client.client_side_validation and ('location' not in local_var_params or  # noqa: E501
                                                        local_var_params['location'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `location` when calling `add_provision_repo`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'repo_name' in local_var_params and local_var_params['repo_name'] is not None:  # noqa: E501
            query_params.append(('repoName', local_var_params['repo_name']))  # noqa: E501
        if 'location' in local_var_params and local_var_params['location'] is not None:  # noqa: E501
            query_params.append(('location', local_var_params['location']))  # noqa: E501
        if 'description' in local_var_params and local_var_params['description'] is not None:  # noqa: E501
            query_params.append(('description', local_var_params['description']))  # noqa: E501
        if 'helix_repo' in local_var_params and local_var_params['helix_repo'] is not None:  # noqa: E501
            query_params.append(('helixRepo', local_var_params['helix_repo']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "ProvisionRepo",
            400: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/provision/repository', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def cancel_upgrade_activity(self, upgrade_id, **kwargs):  # noqa: E501
        """Cancel upgrade activity  # noqa: E501

        Cancel upgrade activity  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.cancel_upgrade_activity(upgrade_id, async_req=True)
        >>> result = thread.get()

        :param upgrade_id: Id of upgrade to cancel (required)
        :type upgrade_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.cancel_upgrade_activity_with_http_info(upgrade_id, **kwargs)  # noqa: E501

    def cancel_upgrade_activity_with_http_info(self, upgrade_id, **kwargs):  # noqa: E501
        """Cancel upgrade activity  # noqa: E501

        Cancel upgrade activity  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.cancel_upgrade_activity_with_http_info(upgrade_id, async_req=True)
        >>> result = thread.get()

        :param upgrade_id: Id of upgrade to cancel (required)
        :type upgrade_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'upgrade_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cancel_upgrade_activity" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'upgrade_id' is set
        if self.api_client.client_side_validation and ('upgrade_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['upgrade_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `upgrade_id` when calling `cancel_upgrade_activity`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'upgrade_id' in local_var_params:
            path_params['upgradeId'] = local_var_params['upgrade_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            400: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/provision/upgrade/{upgradeId}/cancel', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_provision_repo(self, repo_name, **kwargs):  # noqa: E501
        """Delete configuration of a local repository  # noqa: E501

        Delete configuration of a local repository which is identified with the ID specified.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_provision_repo(repo_name, async_req=True)
        >>> result = thread.get()

        :param repo_name: The name of the local repository configuratioin to be deleted. (required)
        :type repo_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ProvisionReposResults
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_provision_repo_with_http_info(repo_name, **kwargs)  # noqa: E501

    def delete_provision_repo_with_http_info(self, repo_name, **kwargs):  # noqa: E501
        """Delete configuration of a local repository  # noqa: E501

        Delete configuration of a local repository which is identified with the ID specified.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_provision_repo_with_http_info(repo_name, async_req=True)
        >>> result = thread.get()

        :param repo_name: The name of the local repository configuratioin to be deleted. (required)
        :type repo_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ProvisionReposResults, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'repo_name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_provision_repo" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'repo_name' is set
        if self.api_client.client_side_validation and ('repo_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['repo_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `repo_name` when calling `delete_provision_repo`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'repo_name' in local_var_params:
            path_params['repoName'] = local_var_params['repo_name']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "ProvisionReposResults",
            400: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/provision/repository/{repoName}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_upgrade_activity(self, upgrade_id, **kwargs):  # noqa: E501
        """Delete upgrade activity status for specific upgrade id.  # noqa: E501

        Delete upgrade activity status for specific upgrade id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_upgrade_activity(upgrade_id, async_req=True)
        >>> result = thread.get()

        :param upgrade_id: The upgrade id. (required)
        :type upgrade_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_upgrade_activity_with_http_info(upgrade_id, **kwargs)  # noqa: E501

    def delete_upgrade_activity_with_http_info(self, upgrade_id, **kwargs):  # noqa: E501
        """Delete upgrade activity status for specific upgrade id.  # noqa: E501

        Delete upgrade activity status for specific upgrade id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_upgrade_activity_with_http_info(upgrade_id, async_req=True)
        >>> result = thread.get()

        :param upgrade_id: The upgrade id. (required)
        :type upgrade_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'upgrade_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_upgrade_activity" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'upgrade_id' is set
        if self.api_client.client_side_validation and ('upgrade_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['upgrade_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `upgrade_id` when calling `delete_upgrade_activity`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'upgrade_id' in local_var_params:
            path_params['upgradeId'] = local_var_params['upgrade_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/provision/upgrade/{upgradeId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_all_upgrade_activities_status(self, **kwargs):  # noqa: E501
        """Get all upgrade activities status.  # noqa: E501

        Get all upgrade activities status.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_upgrade_activities_status(async_req=True)
        >>> result = thread.get()

        :param ctm: The Control-M server name
        :type ctm: str
        :param server: The Control-M server name
        :type server: str
        :param agent: The Control-M Agent name
        :type agent: str
        :param from_version: Current product version
        :type from_version: str
        :param to_version: Upgrade to version
        :type to_version: str
        :param activity: Activity type (Install, Uninstall)
        :type activity: str
        :param status: Upgrade activity status (Cancel, Running, Completed, TransferCompleted, Failed, Unavailable)
        :type status: str
        :param activity_name: Name of the upgrade activity
        :type activity_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UpgradeRecordList
        """
        kwargs['_return_http_data_only'] = True
        return self.get_all_upgrade_activities_status_with_http_info(**kwargs)  # noqa: E501

    def get_all_upgrade_activities_status_with_http_info(self, **kwargs):  # noqa: E501
        """Get all upgrade activities status.  # noqa: E501

        Get all upgrade activities status.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_upgrade_activities_status_with_http_info(async_req=True)
        >>> result = thread.get()

        :param ctm: The Control-M server name
        :type ctm: str
        :param server: The Control-M server name
        :type server: str
        :param agent: The Control-M Agent name
        :type agent: str
        :param from_version: Current product version
        :type from_version: str
        :param to_version: Upgrade to version
        :type to_version: str
        :param activity: Activity type (Install, Uninstall)
        :type activity: str
        :param status: Upgrade activity status (Cancel, Running, Completed, TransferCompleted, Failed, Unavailable)
        :type status: str
        :param activity_name: Name of the upgrade activity
        :type activity_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(UpgradeRecordList, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'ctm',
            'server',
            'agent',
            'from_version',
            'to_version',
            'activity',
            'status',
            'activity_name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_upgrade_activities_status" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ctm' in local_var_params and local_var_params['ctm'] is not None:  # noqa: E501
            query_params.append(('ctm', local_var_params['ctm']))  # noqa: E501
        if 'server' in local_var_params and local_var_params['server'] is not None:  # noqa: E501
            query_params.append(('server', local_var_params['server']))  # noqa: E501
        if 'agent' in local_var_params and local_var_params['agent'] is not None:  # noqa: E501
            query_params.append(('agent', local_var_params['agent']))  # noqa: E501
        if 'from_version' in local_var_params and local_var_params['from_version'] is not None:  # noqa: E501
            query_params.append(('fromVersion', local_var_params['from_version']))  # noqa: E501
        if 'to_version' in local_var_params and local_var_params['to_version'] is not None:  # noqa: E501
            query_params.append(('toVersion', local_var_params['to_version']))  # noqa: E501
        if 'activity' in local_var_params and local_var_params['activity'] is not None:  # noqa: E501
            query_params.append(('activity', local_var_params['activity']))  # noqa: E501
        if 'status' in local_var_params and local_var_params['status'] is not None:  # noqa: E501
            query_params.append(('status', local_var_params['status']))  # noqa: E501
        if 'activity_name' in local_var_params and local_var_params['activity_name'] is not None:  # noqa: E501
            query_params.append(('activityName', local_var_params['activity_name']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "UpgradeRecordList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/provision/upgrades', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_deploy_versions(self, **kwargs):  # noqa: E501
        """Get available versions for upgrade.  # noqa: E501

        Get available versions for upgrade  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_deploy_versions(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[UpgradeInfo]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_deploy_versions_with_http_info(**kwargs)  # noqa: E501

    def get_deploy_versions_with_http_info(self, **kwargs):  # noqa: E501
        """Get available versions for upgrade.  # noqa: E501

        Get available versions for upgrade  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_deploy_versions_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[UpgradeInfo], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_deploy_versions" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "list[UpgradeInfo]",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/provision/upgrades/versions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_eligible_agents_for_upgrade(self, **kwargs):  # noqa: E501
        """Get eligible agents for upgrade that match the requested search criteria.  # noqa: E501

        Get eligible agents for upgrade that match the requested search criteria from Control-M server.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_eligible_agents_for_upgrade(async_req=True)
        >>> result = thread.get()

        :param type: The type (Agent, MFT, AppPack).
        :type type: str
        :param version: The version.
        :type version: str
        :param show_ineligible_agents: Flag to return agents ineligible for upgrade.
        :type show_ineligible_agents: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[UpgradeAgentInfo]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_eligible_agents_for_upgrade_with_http_info(**kwargs)  # noqa: E501

    def get_eligible_agents_for_upgrade_with_http_info(self, **kwargs):  # noqa: E501
        """Get eligible agents for upgrade that match the requested search criteria.  # noqa: E501

        Get eligible agents for upgrade that match the requested search criteria from Control-M server.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_eligible_agents_for_upgrade_with_http_info(async_req=True)
        >>> result = thread.get()

        :param type: The type (Agent, MFT, AppPack).
        :type type: str
        :param version: The version.
        :type version: str
        :param show_ineligible_agents: Flag to return agents ineligible for upgrade.
        :type show_ineligible_agents: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[UpgradeAgentInfo], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'type',
            'version',
            'show_ineligible_agents'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_eligible_agents_for_upgrade" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'version' in local_var_params and local_var_params['version'] is not None:  # noqa: E501
            query_params.append(('version', local_var_params['version']))  # noqa: E501
        if 'show_ineligible_agents' in local_var_params and local_var_params['show_ineligible_agents'] is not None:  # noqa: E501
            query_params.append(('showIneligibleAgents', local_var_params['show_ineligible_agents']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "list[UpgradeAgentInfo]",
            400: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/provision/upgrades/agents', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_images(self, os, **kwargs):  # noqa: E501
        """get list of available images for the requested OS  # noqa: E501

        Get a list of the images in the system for the requested OS.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_images(os, async_req=True)
        >>> result = thread.get()

        :param os: The OS name of the requested images. (required)
        :type os: str
        :param version: filter according to specific version.
        :type version: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[str]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_images_with_http_info(os, **kwargs)  # noqa: E501

    def get_images_with_http_info(self, os, **kwargs):  # noqa: E501
        """get list of available images for the requested OS  # noqa: E501

        Get a list of the images in the system for the requested OS.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_images_with_http_info(os, async_req=True)
        >>> result = thread.get()

        :param os: The OS name of the requested images. (required)
        :type os: str
        :param version: filter according to specific version.
        :type version: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[str], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'os',
            'version'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_images" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'os' is set
        if self.api_client.client_side_validation and ('os' not in local_var_params or  # noqa: E501
                                                        local_var_params['os'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `os` when calling `get_images`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'os' in local_var_params:
            path_params['os'] = local_var_params['os']  # noqa: E501

        query_params = []
        if 'version' in local_var_params and local_var_params['version'] is not None:  # noqa: E501
            query_params.append(('version', local_var_params['version']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "list[str]",
            400: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/provision/images/{os}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_provision_repo(self, repo_name, **kwargs):  # noqa: E501
        """Get the configuration of the local repo from EM  # noqa: E501

        Get the configuration of the local repo from EM  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_provision_repo(repo_name, async_req=True)
        >>> result = thread.get()

        :param repo_name: Local repo configuration name (required)
        :type repo_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ProvisionRepo
        """
        kwargs['_return_http_data_only'] = True
        return self.get_provision_repo_with_http_info(repo_name, **kwargs)  # noqa: E501

    def get_provision_repo_with_http_info(self, repo_name, **kwargs):  # noqa: E501
        """Get the configuration of the local repo from EM  # noqa: E501

        Get the configuration of the local repo from EM  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_provision_repo_with_http_info(repo_name, async_req=True)
        >>> result = thread.get()

        :param repo_name: Local repo configuration name (required)
        :type repo_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ProvisionRepo, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'repo_name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_provision_repo" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'repo_name' is set
        if self.api_client.client_side_validation and ('repo_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['repo_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `repo_name` when calling `get_provision_repo`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'repo_name' in local_var_params:
            path_params['repoName'] = local_var_params['repo_name']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "ProvisionRepo",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/provision/repository/{repoName}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_upgrade_activity_log(self, upgrade_id, **kwargs):  # noqa: E501
        """Returns log of upgrade activity.  # noqa: E501

        Returns log of upgrade activity  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_upgrade_activity_log(upgrade_id, async_req=True)
        >>> result = thread.get()

        :param upgrade_id: The upgrade id. (required)
        :type upgrade_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        return self.get_upgrade_activity_log_with_http_info(upgrade_id, **kwargs)  # noqa: E501

    def get_upgrade_activity_log_with_http_info(self, upgrade_id, **kwargs):  # noqa: E501
        """Returns log of upgrade activity.  # noqa: E501

        Returns log of upgrade activity  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_upgrade_activity_log_with_http_info(upgrade_id, async_req=True)
        >>> result = thread.get()

        :param upgrade_id: The upgrade id. (required)
        :type upgrade_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'upgrade_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_upgrade_activity_log" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'upgrade_id' is set
        if self.api_client.client_side_validation and ('upgrade_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['upgrade_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `upgrade_id` when calling `get_upgrade_activity_log`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'upgrade_id' in local_var_params:
            path_params['upgradeId'] = local_var_params['upgrade_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "str",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/provision/upgrade/{upgradeId}/output', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_upgrade_activity_status_per_upgrade_id(self, upgrade_id, **kwargs):  # noqa: E501
        """Get upgrade activity status for specific upgrade id.  # noqa: E501

        Get upgrade activity status for specific upgrade id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_upgrade_activity_status_per_upgrade_id(upgrade_id, async_req=True)
        >>> result = thread.get()

        :param upgrade_id: The upgrade id. (required)
        :type upgrade_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UpgradeRecord
        """
        kwargs['_return_http_data_only'] = True
        return self.get_upgrade_activity_status_per_upgrade_id_with_http_info(upgrade_id, **kwargs)  # noqa: E501

    def get_upgrade_activity_status_per_upgrade_id_with_http_info(self, upgrade_id, **kwargs):  # noqa: E501
        """Get upgrade activity status for specific upgrade id.  # noqa: E501

        Get upgrade activity status for specific upgrade id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_upgrade_activity_status_per_upgrade_id_with_http_info(upgrade_id, async_req=True)
        >>> result = thread.get()

        :param upgrade_id: The upgrade id. (required)
        :type upgrade_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(UpgradeRecord, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'upgrade_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_upgrade_activity_status_per_upgrade_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'upgrade_id' is set
        if self.api_client.client_side_validation and ('upgrade_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['upgrade_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `upgrade_id` when calling `get_upgrade_activity_status_per_upgrade_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'upgrade_id' in local_var_params:
            path_params['upgradeId'] = local_var_params['upgrade_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "UpgradeRecord",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/provision/upgrade/{upgradeId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def list_provision_repos(self, **kwargs):  # noqa: E501
        """Get the configuration of all the local repos from EM  # noqa: E501

        Get the configuration of all the local repos from EM  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_provision_repos(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ProvisionReposResults
        """
        kwargs['_return_http_data_only'] = True
        return self.list_provision_repos_with_http_info(**kwargs)  # noqa: E501

    def list_provision_repos_with_http_info(self, **kwargs):  # noqa: E501
        """Get the configuration of all the local repos from EM  # noqa: E501

        Get the configuration of all the local repos from EM  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_provision_repos_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ProvisionReposResults, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_provision_repos" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "ProvisionReposResults",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/provision/repositories', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def retry_upgrade_activity(self, upgrade_id, **kwargs):  # noqa: E501
        """Retry upgrade activity  # noqa: E501

        Retry upgrade activity  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.retry_upgrade_activity(upgrade_id, async_req=True)
        >>> result = thread.get()

        :param upgrade_id: Id of upgrade to retry (required)
        :type upgrade_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SuccessData
        """
        kwargs['_return_http_data_only'] = True
        return self.retry_upgrade_activity_with_http_info(upgrade_id, **kwargs)  # noqa: E501

    def retry_upgrade_activity_with_http_info(self, upgrade_id, **kwargs):  # noqa: E501
        """Retry upgrade activity  # noqa: E501

        Retry upgrade activity  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.retry_upgrade_activity_with_http_info(upgrade_id, async_req=True)
        >>> result = thread.get()

        :param upgrade_id: Id of upgrade to retry (required)
        :type upgrade_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SuccessData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'upgrade_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method retry_upgrade_activity" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'upgrade_id' is set
        if self.api_client.client_side_validation and ('upgrade_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['upgrade_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `upgrade_id` when calling `retry_upgrade_activity`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'upgrade_id' in local_var_params:
            path_params['upgradeId'] = local_var_params['upgrade_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "SuccessData",
            400: "ErrorList",
            404: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/provision/upgrade/{upgradeId}/retry', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def transfer_and_install_product(self, upgrade_request, **kwargs):  # noqa: E501
        """Transfer and install a product on an agent  # noqa: E501

        Transfer and install a product on an agent  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.transfer_and_install_product(upgrade_request, async_req=True)
        >>> result = thread.get()

        :param upgrade_request: Upgrade request details (required)
        :type upgrade_request: UpgradeRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UpgradeResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.transfer_and_install_product_with_http_info(upgrade_request, **kwargs)  # noqa: E501

    def transfer_and_install_product_with_http_info(self, upgrade_request, **kwargs):  # noqa: E501
        """Transfer and install a product on an agent  # noqa: E501

        Transfer and install a product on an agent  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.transfer_and_install_product_with_http_info(upgrade_request, async_req=True)
        >>> result = thread.get()

        :param upgrade_request: Upgrade request details (required)
        :type upgrade_request: UpgradeRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(UpgradeResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'upgrade_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method transfer_and_install_product" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'upgrade_request' is set
        if self.api_client.client_side_validation and ('upgrade_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['upgrade_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `upgrade_request` when calling `transfer_and_install_product`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'upgrade_request' in local_var_params:
            body_params = local_var_params['upgrade_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "UpgradeResponse",
            400: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/provision/upgrade/install', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def uninstall_product(self, rollback_request, **kwargs):  # noqa: E501
        """Uninstall a product from an agent  # noqa: E501

        Uninstall a product from an agent  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.uninstall_product(rollback_request, async_req=True)
        >>> result = thread.get()

        :param rollback_request: Rollback request details (required)
        :type rollback_request: UpgradeRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UpgradeResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.uninstall_product_with_http_info(rollback_request, **kwargs)  # noqa: E501

    def uninstall_product_with_http_info(self, rollback_request, **kwargs):  # noqa: E501
        """Uninstall a product from an agent  # noqa: E501

        Uninstall a product from an agent  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.uninstall_product_with_http_info(rollback_request, async_req=True)
        >>> result = thread.get()

        :param rollback_request: Rollback request details (required)
        :type rollback_request: UpgradeRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(UpgradeResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'rollback_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method uninstall_product" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'rollback_request' is set
        if self.api_client.client_side_validation and ('rollback_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['rollback_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `rollback_request` when calling `uninstall_product`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'rollback_request' in local_var_params:
            body_params = local_var_params['rollback_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'Bearer']  # noqa: E501

        response_types_map = {
            200: "UpgradeResponse",
            400: "ErrorList",
            500: "ErrorList",
        }

        return self.api_client.call_api(
            '/provision/upgrade/uninstall', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))
