# coding: utf-8

"""
    Control-M Services

    Provides access to BMC Control-M Services  # noqa: E501

    The version of the OpenAPI document: 9.22.30
    Contact: customer_support@bmc.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from clients.ctm_api_client.configuration import Configuration


class AddServerParams(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'host': 'str',
        'ctm': 'str',
        'id': 'str',
        'port': 'int'
    }

    attribute_map = {
        'host': 'host',
        'ctm': 'ctm',
        'id': 'id',
        'port': 'port'
    }

    def __init__(self, host=None, ctm=None, id=None, port=None, local_vars_configuration=None):  # noqa: E501
        """AddServerParams - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._host = None
        self._ctm = None
        self._id = None
        self._port = None
        self.discriminator = None

        self.host = host
        self.ctm = ctm
        self.id = id
        if port is not None:
            self.port = port

    @property
    def host(self):
        """Gets the host of this AddServerParams.  # noqa: E501

        The Control-M Server host name.  # noqa: E501

        :return: The host of this AddServerParams.  # noqa: E501
        :rtype: str
        """
        return self._host

    @host.setter
    def host(self, host):
        """Sets the host of this AddServerParams.

        The Control-M Server host name.  # noqa: E501

        :param host: The host of this AddServerParams.  # noqa: E501
        :type host: str
        """
        if self.local_vars_configuration.client_side_validation and host is None:  # noqa: E501
            raise ValueError("Invalid value for `host`, must not be `None`")  # noqa: E501

        self._host = host

    @property
    def ctm(self):
        """Gets the ctm of this AddServerParams.  # noqa: E501

        The Control-M Server name.  # noqa: E501

        :return: The ctm of this AddServerParams.  # noqa: E501
        :rtype: str
        """
        return self._ctm

    @ctm.setter
    def ctm(self, ctm):
        """Sets the ctm of this AddServerParams.

        The Control-M Server name.  # noqa: E501

        :param ctm: The ctm of this AddServerParams.  # noqa: E501
        :type ctm: str
        """
        if self.local_vars_configuration.client_side_validation and ctm is None:  # noqa: E501
            raise ValueError("Invalid value for `ctm`, must not be `None`")  # noqa: E501

        self._ctm = ctm

    @property
    def id(self):
        """Gets the id of this AddServerParams.  # noqa: E501

        The id of the Control-M Server, 3 digits id  # noqa: E501

        :return: The id of this AddServerParams.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this AddServerParams.

        The id of the Control-M Server, 3 digits id  # noqa: E501

        :param id: The id of this AddServerParams.  # noqa: E501
        :type id: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def port(self):
        """Gets the port of this AddServerParams.  # noqa: E501

        The Control-M Server port number.  # noqa: E501

        :return: The port of this AddServerParams.  # noqa: E501
        :rtype: int
        """
        return self._port

    @port.setter
    def port(self, port):
        """Sets the port of this AddServerParams.

        The Control-M Server port number.  # noqa: E501

        :param port: The port of this AddServerParams.  # noqa: E501
        :type port: int
        """

        self._port = port

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AddServerParams):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, AddServerParams):
            return True

        return self.to_dict() != other.to_dict()
