# coding: utf-8

"""
    Control-M Services

    Provides access to BMC Control-M Services  # noqa: E501

    The version of the OpenAPI document: 9.22.30
    Contact: customer_support@bmc.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from clients.ctm_api_client.configuration import Configuration


class AgentDetails(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'nodeid': 'str',
        'status': 'str',
        'hostgroups': 'list[str]',
        'version': 'str',
        'operating_system': 'str',
        'tag': 'str',
        'type': 'str',
        'associated_agents': 'list[str]'
    }

    attribute_map = {
        'nodeid': 'nodeid',
        'status': 'status',
        'hostgroups': 'hostgroups',
        'version': 'version',
        'operating_system': 'operatingSystem',
        'tag': 'tag',
        'type': 'type',
        'associated_agents': 'associatedAgents'
    }

    def __init__(self, nodeid=None, status=None, hostgroups=None, version=None, operating_system=None, tag=None, type=None, associated_agents=None, local_vars_configuration=None):  # noqa: E501
        """AgentDetails - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._nodeid = None
        self._status = None
        self._hostgroups = None
        self._version = None
        self._operating_system = None
        self._tag = None
        self._type = None
        self._associated_agents = None
        self.discriminator = None

        if nodeid is not None:
            self.nodeid = nodeid
        if status is not None:
            self.status = status
        if hostgroups is not None:
            self.hostgroups = hostgroups
        if version is not None:
            self.version = version
        if operating_system is not None:
            self.operating_system = operating_system
        if tag is not None:
            self.tag = tag
        if type is not None:
            self.type = type
        if associated_agents is not None:
            self.associated_agents = associated_agents

    @property
    def nodeid(self):
        """Gets the nodeid of this AgentDetails.  # noqa: E501

        agent machine  # noqa: E501

        :return: The nodeid of this AgentDetails.  # noqa: E501
        :rtype: str
        """
        return self._nodeid

    @nodeid.setter
    def nodeid(self, nodeid):
        """Sets the nodeid of this AgentDetails.

        agent machine  # noqa: E501

        :param nodeid: The nodeid of this AgentDetails.  # noqa: E501
        :type nodeid: str
        """

        self._nodeid = nodeid

    @property
    def status(self):
        """Gets the status of this AgentDetails.  # noqa: E501

        agent status  # noqa: E501

        :return: The status of this AgentDetails.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this AgentDetails.

        agent status  # noqa: E501

        :param status: The status of this AgentDetails.  # noqa: E501
        :type status: str
        """

        self._status = status

    @property
    def hostgroups(self):
        """Gets the hostgroups of this AgentDetails.  # noqa: E501

        list of hostgroups names containing the agent  # noqa: E501

        :return: The hostgroups of this AgentDetails.  # noqa: E501
        :rtype: list[str]
        """
        return self._hostgroups

    @hostgroups.setter
    def hostgroups(self, hostgroups):
        """Sets the hostgroups of this AgentDetails.

        list of hostgroups names containing the agent  # noqa: E501

        :param hostgroups: The hostgroups of this AgentDetails.  # noqa: E501
        :type hostgroups: list[str]
        """

        self._hostgroups = hostgroups

    @property
    def version(self):
        """Gets the version of this AgentDetails.  # noqa: E501

        agent version string i.e. - 9.0.20.080  # noqa: E501

        :return: The version of this AgentDetails.  # noqa: E501
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this AgentDetails.

        agent version string i.e. - 9.0.20.080  # noqa: E501

        :param version: The version of this AgentDetails.  # noqa: E501
        :type version: str
        """

        self._version = version

    @property
    def operating_system(self):
        """Gets the operating_system of this AgentDetails.  # noqa: E501

        agent operating system long name i.e - Microsoft Windows Server 2016  (Build 14393)  # noqa: E501

        :return: The operating_system of this AgentDetails.  # noqa: E501
        :rtype: str
        """
        return self._operating_system

    @operating_system.setter
    def operating_system(self, operating_system):
        """Sets the operating_system of this AgentDetails.

        agent operating system long name i.e - Microsoft Windows Server 2016  (Build 14393)  # noqa: E501

        :param operating_system: The operating_system of this AgentDetails.  # noqa: E501
        :type operating_system: str
        """

        self._operating_system = operating_system

    @property
    def tag(self):
        """Gets the tag of this AgentDetails.  # noqa: E501

        the agent tag  # noqa: E501

        :return: The tag of this AgentDetails.  # noqa: E501
        :rtype: str
        """
        return self._tag

    @tag.setter
    def tag(self, tag):
        """Sets the tag of this AgentDetails.

        the agent tag  # noqa: E501

        :param tag: The tag of this AgentDetails.  # noqa: E501
        :type tag: str
        """

        self._tag = tag

    @property
    def type(self):
        """Gets the type of this AgentDetails.  # noqa: E501

        The type of the host - agent or agentless host  # noqa: E501

        :return: The type of this AgentDetails.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this AgentDetails.

        The type of the host - agent or agentless host  # noqa: E501

        :param type: The type of this AgentDetails.  # noqa: E501
        :type type: str
        """

        self._type = type

    @property
    def associated_agents(self):
        """Gets the associated_agents of this AgentDetails.  # noqa: E501

        The associated agents if type is agentless  # noqa: E501

        :return: The associated_agents of this AgentDetails.  # noqa: E501
        :rtype: list[str]
        """
        return self._associated_agents

    @associated_agents.setter
    def associated_agents(self, associated_agents):
        """Sets the associated_agents of this AgentDetails.

        The associated agents if type is agentless  # noqa: E501

        :param associated_agents: The associated_agents of this AgentDetails.  # noqa: E501
        :type associated_agents: list[str]
        """

        self._associated_agents = associated_agents

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AgentDetails):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, AgentDetails):
            return True

        return self.to_dict() != other.to_dict()
