# coding: utf-8

"""
    Control-M Services

    Provides access to BMC Control-M Services  # noqa: E501

    The version of the OpenAPI document: 9.22.30
    Contact: customer_support@bmc.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from clients.ctm_api_client.configuration import Configuration


class AgentInGroupParams(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'host': 'str',
        'hostgroup_agent_participation': 'HostgroupAgentParticipation',
        'participation_rules': 'list[ParticipationRule]'
    }

    attribute_map = {
        'host': 'host',
        'hostgroup_agent_participation': 'hostgroupAgentParticipation',
        'participation_rules': 'participationRules'
    }

    def __init__(self, host=None, hostgroup_agent_participation=None, participation_rules=None, local_vars_configuration=None):  # noqa: E501
        """AgentInGroupParams - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._host = None
        self._hostgroup_agent_participation = None
        self._participation_rules = None
        self.discriminator = None

        self.host = host
        if hostgroup_agent_participation is not None:
            self.hostgroup_agent_participation = hostgroup_agent_participation
        if participation_rules is not None:
            self.participation_rules = participation_rules

    @property
    def host(self):
        """Gets the host of this AgentInGroupParams.  # noqa: E501

        The hostname of the agent.  # noqa: E501

        :return: The host of this AgentInGroupParams.  # noqa: E501
        :rtype: str
        """
        return self._host

    @host.setter
    def host(self, host):
        """Sets the host of this AgentInGroupParams.

        The hostname of the agent.  # noqa: E501

        :param host: The host of this AgentInGroupParams.  # noqa: E501
        :type host: str
        """
        if self.local_vars_configuration.client_side_validation and host is None:  # noqa: E501
            raise ValueError("Invalid value for `host`, must not be `None`")  # noqa: E501

        self._host = host

    @property
    def hostgroup_agent_participation(self):
        """Gets the hostgroup_agent_participation of this AgentInGroupParams.  # noqa: E501


        :return: The hostgroup_agent_participation of this AgentInGroupParams.  # noqa: E501
        :rtype: HostgroupAgentParticipation
        """
        return self._hostgroup_agent_participation

    @hostgroup_agent_participation.setter
    def hostgroup_agent_participation(self, hostgroup_agent_participation):
        """Sets the hostgroup_agent_participation of this AgentInGroupParams.


        :param hostgroup_agent_participation: The hostgroup_agent_participation of this AgentInGroupParams.  # noqa: E501
        :type hostgroup_agent_participation: HostgroupAgentParticipation
        """

        self._hostgroup_agent_participation = hostgroup_agent_participation

    @property
    def participation_rules(self):
        """Gets the participation_rules of this AgentInGroupParams.  # noqa: E501

        The host condition. HIDDEN.  # noqa: E501

        :return: The participation_rules of this AgentInGroupParams.  # noqa: E501
        :rtype: list[ParticipationRule]
        """
        return self._participation_rules

    @participation_rules.setter
    def participation_rules(self, participation_rules):
        """Sets the participation_rules of this AgentInGroupParams.

        The host condition. HIDDEN.  # noqa: E501

        :param participation_rules: The participation_rules of this AgentInGroupParams.  # noqa: E501
        :type participation_rules: list[ParticipationRule]
        """

        self._participation_rules = participation_rules

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AgentInGroupParams):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, AgentInGroupParams):
            return True

        return self.to_dict() != other.to_dict()
