# coding: utf-8

"""
    Control-M Services

    Provides access to BMC Control-M Services  # noqa: E501

    The version of the OpenAPI document: 9.22.30
    Contact: customer_support@bmc.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from clients.ctm_api_client.configuration import Configuration


class As2KeyData(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'as2_id': 'str',
        'certificate': 'str',
        'destination_folder': 'str'
    }

    attribute_map = {
        'as2_id': 'as2Id',
        'certificate': 'certificate',
        'destination_folder': 'destinationFolder'
    }

    def __init__(self, as2_id=None, certificate=None, destination_folder=None, local_vars_configuration=None):  # noqa: E501
        """As2KeyData - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._as2_id = None
        self._certificate = None
        self._destination_folder = None
        self.discriminator = None

        if as2_id is not None:
            self.as2_id = as2_id
        if certificate is not None:
            self.certificate = certificate
        if destination_folder is not None:
            self.destination_folder = destination_folder

    @property
    def as2_id(self):
        """Gets the as2_id of this As2KeyData.  # noqa: E501

        as2 id HIDDEN  # noqa: E501

        :return: The as2_id of this As2KeyData.  # noqa: E501
        :rtype: str
        """
        return self._as2_id

    @as2_id.setter
    def as2_id(self, as2_id):
        """Sets the as2_id of this As2KeyData.

        as2 id HIDDEN  # noqa: E501

        :param as2_id: The as2_id of this As2KeyData.  # noqa: E501
        :type as2_id: str
        """

        self._as2_id = as2_id

    @property
    def certificate(self):
        """Gets the certificate of this As2KeyData.  # noqa: E501

        partners certificate alias HIDDEN  # noqa: E501

        :return: The certificate of this As2KeyData.  # noqa: E501
        :rtype: str
        """
        return self._certificate

    @certificate.setter
    def certificate(self, certificate):
        """Sets the certificate of this As2KeyData.

        partners certificate alias HIDDEN  # noqa: E501

        :param certificate: The certificate of this As2KeyData.  # noqa: E501
        :type certificate: str
        """

        self._certificate = certificate

    @property
    def destination_folder(self):
        """Gets the destination_folder of this As2KeyData.  # noqa: E501

        AS2 destination folder HIDDEN  # noqa: E501

        :return: The destination_folder of this As2KeyData.  # noqa: E501
        :rtype: str
        """
        return self._destination_folder

    @destination_folder.setter
    def destination_folder(self, destination_folder):
        """Sets the destination_folder of this As2KeyData.

        AS2 destination folder HIDDEN  # noqa: E501

        :param destination_folder: The destination_folder of this As2KeyData.  # noqa: E501
        :type destination_folder: str
        """

        self._destination_folder = destination_folder

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, As2KeyData):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, As2KeyData):
            return True

        return self.to_dict() != other.to_dict()
