# coding: utf-8

"""
    Control-M Services

    Provides access to BMC Control-M Services  # noqa: E501

    The version of the OpenAPI document: 9.22.30
    Contact: customer_support@bmc.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from clients.ctm_api_client.configuration import Configuration


class AuthenticateCredentials(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'username': 'str',
        'msg': 'str',
        'sessiontoken': 'str',
        'groups': 'list[str]',
        'additional_attributes': 'list[AuthenticateCredentialsAdditionalAttributes]'
    }

    attribute_map = {
        'username': 'username',
        'msg': 'msg',
        'sessiontoken': 'sessiontoken',
        'groups': 'groups',
        'additional_attributes': 'additionalAttributes'
    }

    def __init__(self, username=None, msg=None, sessiontoken=None, groups=None, additional_attributes=None, local_vars_configuration=None):  # noqa: E501
        """AuthenticateCredentials - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._username = None
        self._msg = None
        self._sessiontoken = None
        self._groups = None
        self._additional_attributes = None
        self.discriminator = None

        self.username = username
        self.msg = msg
        self.sessiontoken = sessiontoken
        self.groups = groups
        self.additional_attributes = additional_attributes

    @property
    def username(self):
        """Gets the username of this AuthenticateCredentials.  # noqa: E501


        :return: The username of this AuthenticateCredentials.  # noqa: E501
        :rtype: str
        """
        return self._username

    @username.setter
    def username(self, username):
        """Sets the username of this AuthenticateCredentials.


        :param username: The username of this AuthenticateCredentials.  # noqa: E501
        :type username: str
        """

        self._username = username

    @property
    def msg(self):
        """Gets the msg of this AuthenticateCredentials.  # noqa: E501


        :return: The msg of this AuthenticateCredentials.  # noqa: E501
        :rtype: str
        """
        return self._msg

    @msg.setter
    def msg(self, msg):
        """Sets the msg of this AuthenticateCredentials.


        :param msg: The msg of this AuthenticateCredentials.  # noqa: E501
        :type msg: str
        """

        self._msg = msg

    @property
    def sessiontoken(self):
        """Gets the sessiontoken of this AuthenticateCredentials.  # noqa: E501


        :return: The sessiontoken of this AuthenticateCredentials.  # noqa: E501
        :rtype: str
        """
        return self._sessiontoken

    @sessiontoken.setter
    def sessiontoken(self, sessiontoken):
        """Sets the sessiontoken of this AuthenticateCredentials.


        :param sessiontoken: The sessiontoken of this AuthenticateCredentials.  # noqa: E501
        :type sessiontoken: str
        """

        self._sessiontoken = sessiontoken

    @property
    def groups(self):
        """Gets the groups of this AuthenticateCredentials.  # noqa: E501


        :return: The groups of this AuthenticateCredentials.  # noqa: E501
        :rtype: list[str]
        """
        return self._groups

    @groups.setter
    def groups(self, groups):
        """Sets the groups of this AuthenticateCredentials.


        :param groups: The groups of this AuthenticateCredentials.  # noqa: E501
        :type groups: list[str]
        """

        self._groups = groups

    @property
    def additional_attributes(self):
        """Gets the additional_attributes of this AuthenticateCredentials.  # noqa: E501


        :return: The additional_attributes of this AuthenticateCredentials.  # noqa: E501
        :rtype: list[AuthenticateCredentialsAdditionalAttributes]
        """
        return self._additional_attributes

    @additional_attributes.setter
    def additional_attributes(self, additional_attributes):
        """Sets the additional_attributes of this AuthenticateCredentials.


        :param additional_attributes: The additional_attributes of this AuthenticateCredentials.  # noqa: E501
        :type additional_attributes: list[AuthenticateCredentialsAdditionalAttributes]
        """

        self._additional_attributes = additional_attributes

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AuthenticateCredentials):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, AuthenticateCredentials):
            return True

        return self.to_dict() != other.to_dict()
