# coding: utf-8

"""
    Control-M Services

    Provides access to BMC Control-M Services  # noqa: E501

    The version of the OpenAPI document: 9.22.30
    Contact: customer_support@bmc.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from clients.ctm_api_client.configuration import Configuration


class CtmAdvancedDetails(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'name': 'str',
        'host': 'str',
        'state': 'str',
        'message': 'str',
        'version': 'str',
        'ctm_type': 'str',
        'type': 'str',
        'cmc_managed': 'str',
        'current_state': 'str',
        'admin_agent_status': 'str',
        'owned_by': 'str'
    }

    attribute_map = {
        'name': 'name',
        'host': 'host',
        'state': 'state',
        'message': 'message',
        'version': 'version',
        'ctm_type': 'ctmType',
        'type': 'type',
        'cmc_managed': 'cmcManaged',
        'current_state': 'currentState',
        'admin_agent_status': 'adminAgentStatus',
        'owned_by': 'ownedBy'
    }

    def __init__(self, name=None, host=None, state=None, message=None, version=None, ctm_type=None, type=None, cmc_managed=None, current_state=None, admin_agent_status=None, owned_by=None, local_vars_configuration=None):  # noqa: E501
        """CtmAdvancedDetails - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._name = None
        self._host = None
        self._state = None
        self._message = None
        self._version = None
        self._ctm_type = None
        self._type = None
        self._cmc_managed = None
        self._current_state = None
        self._admin_agent_status = None
        self._owned_by = None
        self.discriminator = None

        if name is not None:
            self.name = name
        if host is not None:
            self.host = host
        if state is not None:
            self.state = state
        if message is not None:
            self.message = message
        if version is not None:
            self.version = version
        if ctm_type is not None:
            self.ctm_type = ctm_type
        if type is not None:
            self.type = type
        if cmc_managed is not None:
            self.cmc_managed = cmc_managed
        if current_state is not None:
            self.current_state = current_state
        if admin_agent_status is not None:
            self.admin_agent_status = admin_agent_status
        if owned_by is not None:
            self.owned_by = owned_by

    @property
    def name(self):
        """Gets the name of this CtmAdvancedDetails.  # noqa: E501

        The unique name of the Control-M Server.  # noqa: E501

        :return: The name of this CtmAdvancedDetails.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this CtmAdvancedDetails.

        The unique name of the Control-M Server.  # noqa: E501

        :param name: The name of this CtmAdvancedDetails.  # noqa: E501
        :type name: str
        """

        self._name = name

    @property
    def host(self):
        """Gets the host of this CtmAdvancedDetails.  # noqa: E501

        The hostname of the Control-M Server is running on.  # noqa: E501

        :return: The host of this CtmAdvancedDetails.  # noqa: E501
        :rtype: str
        """
        return self._host

    @host.setter
    def host(self, host):
        """Sets the host of this CtmAdvancedDetails.

        The hostname of the Control-M Server is running on.  # noqa: E501

        :param host: The host of this CtmAdvancedDetails.  # noqa: E501
        :type host: str
        """

        self._host = host

    @property
    def state(self):
        """Gets the state of this CtmAdvancedDetails.  # noqa: E501

        Control-M Server state [up|down].  # noqa: E501

        :return: The state of this CtmAdvancedDetails.  # noqa: E501
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this CtmAdvancedDetails.

        Control-M Server state [up|down].  # noqa: E501

        :param state: The state of this CtmAdvancedDetails.  # noqa: E501
        :type state: str
        """

        self._state = state

    @property
    def message(self):
        """Gets the message of this CtmAdvancedDetails.  # noqa: E501

        Control-M Server message describing the communication status.  # noqa: E501

        :return: The message of this CtmAdvancedDetails.  # noqa: E501
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message):
        """Sets the message of this CtmAdvancedDetails.

        Control-M Server message describing the communication status.  # noqa: E501

        :param message: The message of this CtmAdvancedDetails.  # noqa: E501
        :type message: str
        """

        self._message = message

    @property
    def version(self):
        """Gets the version of this CtmAdvancedDetails.  # noqa: E501

        Control-M Server version.  # noqa: E501

        :return: The version of this CtmAdvancedDetails.  # noqa: E501
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this CtmAdvancedDetails.

        Control-M Server version.  # noqa: E501

        :param version: The version of this CtmAdvancedDetails.  # noqa: E501
        :type version: str
        """

        self._version = version

    @property
    def ctm_type(self):
        """Gets the ctm_type of this CtmAdvancedDetails.  # noqa: E501

        Control-M Server ctm Type. [Distributed|\"z/OS]  # noqa: E501

        :return: The ctm_type of this CtmAdvancedDetails.  # noqa: E501
        :rtype: str
        """
        return self._ctm_type

    @ctm_type.setter
    def ctm_type(self, ctm_type):
        """Sets the ctm_type of this CtmAdvancedDetails.

        Control-M Server ctm Type. [Distributed|\"z/OS]  # noqa: E501

        :param ctm_type: The ctm_type of this CtmAdvancedDetails.  # noqa: E501
        :type ctm_type: str
        """

        self._ctm_type = ctm_type

    @property
    def type(self):
        """Gets the type of this CtmAdvancedDetails.  # noqa: E501

        Control-M Server Type. [CTM_Server]  # noqa: E501

        :return: The type of this CtmAdvancedDetails.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this CtmAdvancedDetails.

        Control-M Server Type. [CTM_Server]  # noqa: E501

        :param type: The type of this CtmAdvancedDetails.  # noqa: E501
        :type type: str
        """

        self._type = type

    @property
    def cmc_managed(self):
        """Gets the cmc_managed of this CtmAdvancedDetails.  # noqa: E501

        Control-M Server Type. [Y|N]  # noqa: E501

        :return: The cmc_managed of this CtmAdvancedDetails.  # noqa: E501
        :rtype: str
        """
        return self._cmc_managed

    @cmc_managed.setter
    def cmc_managed(self, cmc_managed):
        """Sets the cmc_managed of this CtmAdvancedDetails.

        Control-M Server Type. [Y|N]  # noqa: E501

        :param cmc_managed: The cmc_managed of this CtmAdvancedDetails.  # noqa: E501
        :type cmc_managed: str
        """

        self._cmc_managed = cmc_managed

    @property
    def current_state(self):
        """Gets the current_state of this CtmAdvancedDetails.  # noqa: E501

        Control-M Server Type. [UP|Unknown]  # noqa: E501

        :return: The current_state of this CtmAdvancedDetails.  # noqa: E501
        :rtype: str
        """
        return self._current_state

    @current_state.setter
    def current_state(self, current_state):
        """Sets the current_state of this CtmAdvancedDetails.

        Control-M Server Type. [UP|Unknown]  # noqa: E501

        :param current_state: The current_state of this CtmAdvancedDetails.  # noqa: E501
        :type current_state: str
        """

        self._current_state = current_state

    @property
    def admin_agent_status(self):
        """Gets the admin_agent_status of this CtmAdvancedDetails.  # noqa: E501

        Control-M Server Type. [Active|Not Responding]  # noqa: E501

        :return: The admin_agent_status of this CtmAdvancedDetails.  # noqa: E501
        :rtype: str
        """
        return self._admin_agent_status

    @admin_agent_status.setter
    def admin_agent_status(self, admin_agent_status):
        """Sets the admin_agent_status of this CtmAdvancedDetails.

        Control-M Server Type. [Active|Not Responding]  # noqa: E501

        :param admin_agent_status: The admin_agent_status of this CtmAdvancedDetails.  # noqa: E501
        :type admin_agent_status: str
        """

        self._admin_agent_status = admin_agent_status

    @property
    def owned_by(self):
        """Gets the owned_by of this CtmAdvancedDetails.  # noqa: E501

        The Control-M OwnedBy - [Helix, SelfHosted, OnBoarding, OnPrem]. HIDDEN  # noqa: E501

        :return: The owned_by of this CtmAdvancedDetails.  # noqa: E501
        :rtype: str
        """
        return self._owned_by

    @owned_by.setter
    def owned_by(self, owned_by):
        """Sets the owned_by of this CtmAdvancedDetails.

        The Control-M OwnedBy - [Helix, SelfHosted, OnBoarding, OnPrem]. HIDDEN  # noqa: E501

        :param owned_by: The owned_by of this CtmAdvancedDetails.  # noqa: E501
        :type owned_by: str
        """

        self._owned_by = owned_by

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CtmAdvancedDetails):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, CtmAdvancedDetails):
            return True

        return self.to_dict() != other.to_dict()
