# coding: utf-8

"""
    Control-M Services

    Provides access to BMC Control-M Services  # noqa: E501

    The version of the OpenAPI document: 9.22.30
    Contact: customer_support@bmc.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from clients.ctm_api_client.configuration import Configuration


class CtmagentBasicInfoType(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'server_to_agent_port_number': 'int',
        'agent_to_server_port_number': 'int',
        'persistent_connection': 'str',
        'tcpssl_server_mode': 'str',
        'protocol_version': 'str',
        'agent_status': 'str',
        'ip_addresses_list': 'list[str]'
    }

    attribute_map = {
        'server_to_agent_port_number': 'serverToAgentPortNumber',
        'agent_to_server_port_number': 'agentToServerPortNumber',
        'persistent_connection': 'persistentConnection',
        'tcpssl_server_mode': 'tcpsslServerMode',
        'protocol_version': 'protocolVersion',
        'agent_status': 'agentStatus',
        'ip_addresses_list': 'ipAddressesList'
    }

    def __init__(self, server_to_agent_port_number=None, agent_to_server_port_number=None, persistent_connection=None, tcpssl_server_mode=None, protocol_version=None, agent_status=None, ip_addresses_list=None, local_vars_configuration=None):  # noqa: E501
        """CtmagentBasicInfoType - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._server_to_agent_port_number = None
        self._agent_to_server_port_number = None
        self._persistent_connection = None
        self._tcpssl_server_mode = None
        self._protocol_version = None
        self._agent_status = None
        self._ip_addresses_list = None
        self.discriminator = None

        if server_to_agent_port_number is not None:
            self.server_to_agent_port_number = server_to_agent_port_number
        if agent_to_server_port_number is not None:
            self.agent_to_server_port_number = agent_to_server_port_number
        if persistent_connection is not None:
            self.persistent_connection = persistent_connection
        if tcpssl_server_mode is not None:
            self.tcpssl_server_mode = tcpssl_server_mode
        if protocol_version is not None:
            self.protocol_version = protocol_version
        if agent_status is not None:
            self.agent_status = agent_status
        if ip_addresses_list is not None:
            self.ip_addresses_list = ip_addresses_list

    @property
    def server_to_agent_port_number(self):
        """Gets the server_to_agent_port_number of this CtmagentBasicInfoType.  # noqa: E501

        server to agent port number  # noqa: E501

        :return: The server_to_agent_port_number of this CtmagentBasicInfoType.  # noqa: E501
        :rtype: int
        """
        return self._server_to_agent_port_number

    @server_to_agent_port_number.setter
    def server_to_agent_port_number(self, server_to_agent_port_number):
        """Sets the server_to_agent_port_number of this CtmagentBasicInfoType.

        server to agent port number  # noqa: E501

        :param server_to_agent_port_number: The server_to_agent_port_number of this CtmagentBasicInfoType.  # noqa: E501
        :type server_to_agent_port_number: int
        """

        self._server_to_agent_port_number = server_to_agent_port_number

    @property
    def agent_to_server_port_number(self):
        """Gets the agent_to_server_port_number of this CtmagentBasicInfoType.  # noqa: E501

        agent to server port number  # noqa: E501

        :return: The agent_to_server_port_number of this CtmagentBasicInfoType.  # noqa: E501
        :rtype: int
        """
        return self._agent_to_server_port_number

    @agent_to_server_port_number.setter
    def agent_to_server_port_number(self, agent_to_server_port_number):
        """Sets the agent_to_server_port_number of this CtmagentBasicInfoType.

        agent to server port number  # noqa: E501

        :param agent_to_server_port_number: The agent_to_server_port_number of this CtmagentBasicInfoType.  # noqa: E501
        :type agent_to_server_port_number: int
        """

        self._agent_to_server_port_number = agent_to_server_port_number

    @property
    def persistent_connection(self):
        """Gets the persistent_connection of this CtmagentBasicInfoType.  # noqa: E501

        is Server-Agent connection transient or perssistent  # noqa: E501

        :return: The persistent_connection of this CtmagentBasicInfoType.  # noqa: E501
        :rtype: str
        """
        return self._persistent_connection

    @persistent_connection.setter
    def persistent_connection(self, persistent_connection):
        """Sets the persistent_connection of this CtmagentBasicInfoType.

        is Server-Agent connection transient or perssistent  # noqa: E501

        :param persistent_connection: The persistent_connection of this CtmagentBasicInfoType.  # noqa: E501
        :type persistent_connection: str
        """

        self._persistent_connection = persistent_connection

    @property
    def tcpssl_server_mode(self):
        """Gets the tcpssl_server_mode of this CtmagentBasicInfoType.  # noqa: E501

        is connection TCP or SSL  # noqa: E501

        :return: The tcpssl_server_mode of this CtmagentBasicInfoType.  # noqa: E501
        :rtype: str
        """
        return self._tcpssl_server_mode

    @tcpssl_server_mode.setter
    def tcpssl_server_mode(self, tcpssl_server_mode):
        """Sets the tcpssl_server_mode of this CtmagentBasicInfoType.

        is connection TCP or SSL  # noqa: E501

        :param tcpssl_server_mode: The tcpssl_server_mode of this CtmagentBasicInfoType.  # noqa: E501
        :type tcpssl_server_mode: str
        """

        self._tcpssl_server_mode = tcpssl_server_mode

    @property
    def protocol_version(self):
        """Gets the protocol_version of this CtmagentBasicInfoType.  # noqa: E501

        communication protocol version of the Server-Agent  # noqa: E501

        :return: The protocol_version of this CtmagentBasicInfoType.  # noqa: E501
        :rtype: str
        """
        return self._protocol_version

    @protocol_version.setter
    def protocol_version(self, protocol_version):
        """Sets the protocol_version of this CtmagentBasicInfoType.

        communication protocol version of the Server-Agent  # noqa: E501

        :param protocol_version: The protocol_version of this CtmagentBasicInfoType.  # noqa: E501
        :type protocol_version: str
        """

        self._protocol_version = protocol_version

    @property
    def agent_status(self):
        """Gets the agent_status of this CtmagentBasicInfoType.  # noqa: E501

        the Agent's status message  # noqa: E501

        :return: The agent_status of this CtmagentBasicInfoType.  # noqa: E501
        :rtype: str
        """
        return self._agent_status

    @agent_status.setter
    def agent_status(self, agent_status):
        """Sets the agent_status of this CtmagentBasicInfoType.

        the Agent's status message  # noqa: E501

        :param agent_status: The agent_status of this CtmagentBasicInfoType.  # noqa: E501
        :type agent_status: str
        """

        self._agent_status = agent_status

    @property
    def ip_addresses_list(self):
        """Gets the ip_addresses_list of this CtmagentBasicInfoType.  # noqa: E501


        :return: The ip_addresses_list of this CtmagentBasicInfoType.  # noqa: E501
        :rtype: list[str]
        """
        return self._ip_addresses_list

    @ip_addresses_list.setter
    def ip_addresses_list(self, ip_addresses_list):
        """Sets the ip_addresses_list of this CtmagentBasicInfoType.


        :param ip_addresses_list: The ip_addresses_list of this CtmagentBasicInfoType.  # noqa: E501
        :type ip_addresses_list: list[str]
        """

        self._ip_addresses_list = ip_addresses_list

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CtmagentBasicInfoType):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, CtmagentBasicInfoType):
            return True

        return self.to_dict() != other.to_dict()
