# coding: utf-8

"""
    Control-M Services

    Provides access to BMC Control-M Services  # noqa: E501

    The version of the OpenAPI document: 9.22.30
    Contact: customer_support@bmc.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from clients.ctm_api_client.configuration import Configuration


class DiscoverResponse(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'type': 'str',
        'version': 'str',
        'protocol': 'str',
        'release': 'str',
        'ctm_to_em_port': 'int',
        'time_zone': 'str',
        'new_day_time': 'str',
        'week_start_day': 'str',
        'dst_start_date': 'str',
        'dst_end_date': 'str',
        'control_r_installed': 'str',
        'control_b_installed': 'str',
        'control_t_installed': 'str',
        'additional_attributes': 'list[AdditionalAttribute]'
    }

    attribute_map = {
        'type': 'type',
        'version': 'version',
        'protocol': 'protocol',
        'release': 'release',
        'ctm_to_em_port': 'ctmToEMPort',
        'time_zone': 'timeZone',
        'new_day_time': 'newDayTime',
        'week_start_day': 'weekStartDay',
        'dst_start_date': 'dstStartDate',
        'dst_end_date': 'dstEndDate',
        'control_r_installed': 'controlRInstalled',
        'control_b_installed': 'controlBInstalled',
        'control_t_installed': 'controlTInstalled',
        'additional_attributes': 'additionalAttributes'
    }

    def __init__(self, type=None, version=None, protocol=None, release=None, ctm_to_em_port=None, time_zone=None, new_day_time=None, week_start_day=None, dst_start_date=None, dst_end_date=None, control_r_installed=None, control_b_installed=None, control_t_installed=None, additional_attributes=None, local_vars_configuration=None):  # noqa: E501
        """DiscoverResponse - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._type = None
        self._version = None
        self._protocol = None
        self._release = None
        self._ctm_to_em_port = None
        self._time_zone = None
        self._new_day_time = None
        self._week_start_day = None
        self._dst_start_date = None
        self._dst_end_date = None
        self._control_r_installed = None
        self._control_b_installed = None
        self._control_t_installed = None
        self._additional_attributes = None
        self.discriminator = None

        if type is not None:
            self.type = type
        if version is not None:
            self.version = version
        if protocol is not None:
            self.protocol = protocol
        if release is not None:
            self.release = release
        if ctm_to_em_port is not None:
            self.ctm_to_em_port = ctm_to_em_port
        if time_zone is not None:
            self.time_zone = time_zone
        if new_day_time is not None:
            self.new_day_time = new_day_time
        if week_start_day is not None:
            self.week_start_day = week_start_day
        if dst_start_date is not None:
            self.dst_start_date = dst_start_date
        if dst_end_date is not None:
            self.dst_end_date = dst_end_date
        if control_r_installed is not None:
            self.control_r_installed = control_r_installed
        if control_b_installed is not None:
            self.control_b_installed = control_b_installed
        if control_t_installed is not None:
            self.control_t_installed = control_t_installed
        if additional_attributes is not None:
            self.additional_attributes = additional_attributes

    @property
    def type(self):
        """Gets the type of this DiscoverResponse.  # noqa: E501

        Control-M/Server Type [Distributed|zOS]  # noqa: E501

        :return: The type of this DiscoverResponse.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this DiscoverResponse.

        Control-M/Server Type [Distributed|zOS]  # noqa: E501

        :param type: The type of this DiscoverResponse.  # noqa: E501
        :type type: str
        """

        self._type = type

    @property
    def version(self):
        """Gets the version of this DiscoverResponse.  # noqa: E501

        Control-M/Server version  # noqa: E501

        :return: The version of this DiscoverResponse.  # noqa: E501
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this DiscoverResponse.

        Control-M/Server version  # noqa: E501

        :param version: The version of this DiscoverResponse.  # noqa: E501
        :type version: str
        """

        self._version = version

    @property
    def protocol(self):
        """Gets the protocol of this DiscoverResponse.  # noqa: E501

        Protocol the Control-M/Server is using  # noqa: E501

        :return: The protocol of this DiscoverResponse.  # noqa: E501
        :rtype: str
        """
        return self._protocol

    @protocol.setter
    def protocol(self, protocol):
        """Sets the protocol of this DiscoverResponse.

        Protocol the Control-M/Server is using  # noqa: E501

        :param protocol: The protocol of this DiscoverResponse.  # noqa: E501
        :type protocol: str
        """

        self._protocol = protocol

    @property
    def release(self):
        """Gets the release of this DiscoverResponse.  # noqa: E501


        :return: The release of this DiscoverResponse.  # noqa: E501
        :rtype: str
        """
        return self._release

    @release.setter
    def release(self, release):
        """Sets the release of this DiscoverResponse.


        :param release: The release of this DiscoverResponse.  # noqa: E501
        :type release: str
        """

        self._release = release

    @property
    def ctm_to_em_port(self):
        """Gets the ctm_to_em_port of this DiscoverResponse.  # noqa: E501

        Control-M/Server and Control-M/EM communication port goes through  # noqa: E501

        :return: The ctm_to_em_port of this DiscoverResponse.  # noqa: E501
        :rtype: int
        """
        return self._ctm_to_em_port

    @ctm_to_em_port.setter
    def ctm_to_em_port(self, ctm_to_em_port):
        """Sets the ctm_to_em_port of this DiscoverResponse.

        Control-M/Server and Control-M/EM communication port goes through  # noqa: E501

        :param ctm_to_em_port: The ctm_to_em_port of this DiscoverResponse.  # noqa: E501
        :type ctm_to_em_port: int
        """

        self._ctm_to_em_port = ctm_to_em_port

    @property
    def time_zone(self):
        """Gets the time_zone of this DiscoverResponse.  # noqa: E501

        Control-M/Server timezone  # noqa: E501

        :return: The time_zone of this DiscoverResponse.  # noqa: E501
        :rtype: str
        """
        return self._time_zone

    @time_zone.setter
    def time_zone(self, time_zone):
        """Sets the time_zone of this DiscoverResponse.

        Control-M/Server timezone  # noqa: E501

        :param time_zone: The time_zone of this DiscoverResponse.  # noqa: E501
        :type time_zone: str
        """

        self._time_zone = time_zone

    @property
    def new_day_time(self):
        """Gets the new_day_time of this DiscoverResponse.  # noqa: E501

        Control-M/Server \"New Day\" time  # noqa: E501

        :return: The new_day_time of this DiscoverResponse.  # noqa: E501
        :rtype: str
        """
        return self._new_day_time

    @new_day_time.setter
    def new_day_time(self, new_day_time):
        """Sets the new_day_time of this DiscoverResponse.

        Control-M/Server \"New Day\" time  # noqa: E501

        :param new_day_time: The new_day_time of this DiscoverResponse.  # noqa: E501
        :type new_day_time: str
        """

        self._new_day_time = new_day_time

    @property
    def week_start_day(self):
        """Gets the week_start_day of this DiscoverResponse.  # noqa: E501

        Control-M/Server first day of the week  # noqa: E501

        :return: The week_start_day of this DiscoverResponse.  # noqa: E501
        :rtype: str
        """
        return self._week_start_day

    @week_start_day.setter
    def week_start_day(self, week_start_day):
        """Sets the week_start_day of this DiscoverResponse.

        Control-M/Server first day of the week  # noqa: E501

        :param week_start_day: The week_start_day of this DiscoverResponse.  # noqa: E501
        :type week_start_day: str
        """

        self._week_start_day = week_start_day

    @property
    def dst_start_date(self):
        """Gets the dst_start_date of this DiscoverResponse.  # noqa: E501

        Daylight saving time start date  # noqa: E501

        :return: The dst_start_date of this DiscoverResponse.  # noqa: E501
        :rtype: str
        """
        return self._dst_start_date

    @dst_start_date.setter
    def dst_start_date(self, dst_start_date):
        """Sets the dst_start_date of this DiscoverResponse.

        Daylight saving time start date  # noqa: E501

        :param dst_start_date: The dst_start_date of this DiscoverResponse.  # noqa: E501
        :type dst_start_date: str
        """

        self._dst_start_date = dst_start_date

    @property
    def dst_end_date(self):
        """Gets the dst_end_date of this DiscoverResponse.  # noqa: E501

        Daylight saving time end date  # noqa: E501

        :return: The dst_end_date of this DiscoverResponse.  # noqa: E501
        :rtype: str
        """
        return self._dst_end_date

    @dst_end_date.setter
    def dst_end_date(self, dst_end_date):
        """Sets the dst_end_date of this DiscoverResponse.

        Daylight saving time end date  # noqa: E501

        :param dst_end_date: The dst_end_date of this DiscoverResponse.  # noqa: E501
        :type dst_end_date: str
        """

        self._dst_end_date = dst_end_date

    @property
    def control_r_installed(self):
        """Gets the control_r_installed of this DiscoverResponse.  # noqa: E501

        Control-M/Restart  # noqa: E501

        :return: The control_r_installed of this DiscoverResponse.  # noqa: E501
        :rtype: str
        """
        return self._control_r_installed

    @control_r_installed.setter
    def control_r_installed(self, control_r_installed):
        """Sets the control_r_installed of this DiscoverResponse.

        Control-M/Restart  # noqa: E501

        :param control_r_installed: The control_r_installed of this DiscoverResponse.  # noqa: E501
        :type control_r_installed: str
        """

        self._control_r_installed = control_r_installed

    @property
    def control_b_installed(self):
        """Gets the control_b_installed of this DiscoverResponse.  # noqa: E501

        Control-M/Analyzer Installed  # noqa: E501

        :return: The control_b_installed of this DiscoverResponse.  # noqa: E501
        :rtype: str
        """
        return self._control_b_installed

    @control_b_installed.setter
    def control_b_installed(self, control_b_installed):
        """Sets the control_b_installed of this DiscoverResponse.

        Control-M/Analyzer Installed  # noqa: E501

        :param control_b_installed: The control_b_installed of this DiscoverResponse.  # noqa: E501
        :type control_b_installed: str
        """

        self._control_b_installed = control_b_installed

    @property
    def control_t_installed(self):
        """Gets the control_t_installed of this DiscoverResponse.  # noqa: E501

        Control-M/Tape Installed  # noqa: E501

        :return: The control_t_installed of this DiscoverResponse.  # noqa: E501
        :rtype: str
        """
        return self._control_t_installed

    @control_t_installed.setter
    def control_t_installed(self, control_t_installed):
        """Sets the control_t_installed of this DiscoverResponse.

        Control-M/Tape Installed  # noqa: E501

        :param control_t_installed: The control_t_installed of this DiscoverResponse.  # noqa: E501
        :type control_t_installed: str
        """

        self._control_t_installed = control_t_installed

    @property
    def additional_attributes(self):
        """Gets the additional_attributes of this DiscoverResponse.  # noqa: E501

        Additional Attributes  # noqa: E501

        :return: The additional_attributes of this DiscoverResponse.  # noqa: E501
        :rtype: list[AdditionalAttribute]
        """
        return self._additional_attributes

    @additional_attributes.setter
    def additional_attributes(self, additional_attributes):
        """Sets the additional_attributes of this DiscoverResponse.

        Additional Attributes  # noqa: E501

        :param additional_attributes: The additional_attributes of this DiscoverResponse.  # noqa: E501
        :type additional_attributes: list[AdditionalAttribute]
        """

        self._additional_attributes = additional_attributes

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DiscoverResponse):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, DiscoverResponse):
            return True

        return self.to_dict() != other.to_dict()
