# coding: utf-8

"""
    Control-M Services

    Provides access to BMC Control-M Services  # noqa: E501

    The version of the OpenAPI document: 9.22.30
    Contact: customer_support@bmc.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from clients.ctm_api_client.configuration import Configuration


class EMParams(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'desired_state': 'str',
        'additional_parameters': 'str',
        'check_interval': 'int'
    }

    attribute_map = {
        'desired_state': 'desiredState',
        'additional_parameters': 'additionalParameters',
        'check_interval': 'checkInterval'
    }

    def __init__(self, desired_state=None, additional_parameters=None, check_interval=None, local_vars_configuration=None):  # noqa: E501
        """EMParams - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._desired_state = None
        self._additional_parameters = None
        self._check_interval = None
        self.discriminator = None

        if desired_state is not None:
            self.desired_state = desired_state
        if additional_parameters is not None:
            self.additional_parameters = additional_parameters
        if check_interval is not None:
            self.check_interval = check_interval

    @property
    def desired_state(self):
        """Gets the desired_state of this EMParams.  # noqa: E501

        State of the EM component.  # noqa: E501

        :return: The desired_state of this EMParams.  # noqa: E501
        :rtype: str
        """
        return self._desired_state

    @desired_state.setter
    def desired_state(self, desired_state):
        """Sets the desired_state of this EMParams.

        State of the EM component.  # noqa: E501

        :param desired_state: The desired_state of this EMParams.  # noqa: E501
        :type desired_state: str
        """

        self._desired_state = desired_state

    @property
    def additional_parameters(self):
        """Gets the additional_parameters of this EMParams.  # noqa: E501

        Alternative startup parameters for the component.  # noqa: E501

        :return: The additional_parameters of this EMParams.  # noqa: E501
        :rtype: str
        """
        return self._additional_parameters

    @additional_parameters.setter
    def additional_parameters(self, additional_parameters):
        """Sets the additional_parameters of this EMParams.

        Alternative startup parameters for the component.  # noqa: E501

        :param additional_parameters: The additional_parameters of this EMParams.  # noqa: E501
        :type additional_parameters: str
        """

        self._additional_parameters = additional_parameters

    @property
    def check_interval(self):
        """Gets the check_interval of this EMParams.  # noqa: E501

        Interval in seconds to check the component's status.  # noqa: E501

        :return: The check_interval of this EMParams.  # noqa: E501
        :rtype: int
        """
        return self._check_interval

    @check_interval.setter
    def check_interval(self, check_interval):
        """Sets the check_interval of this EMParams.

        Interval in seconds to check the component's status.  # noqa: E501

        :param check_interval: The check_interval of this EMParams.  # noqa: E501
        :type check_interval: int
        """

        self._check_interval = check_interval

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, EMParams):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, EMParams):
            return True

        return self.to_dict() != other.to_dict()
