# coding: utf-8

"""
    Control-M Services

    Provides access to BMC Control-M Services  # noqa: E501

    The version of the OpenAPI document: 9.22.30
    Contact: customer_support@bmc.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from clients.ctm_api_client.configuration import Configuration


class HostProperties(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'host_name': 'str',
        'os_type': 'str',
        'user': 'str',
        'password': 'str',
        'protocol': 'str',
        'port': 'int',
        'ssl': 'bool',
        'ssl_implicit': 'bool',
        'ccc_command': 'bool',
        'cdc_command': 'bool',
        'ssl_level': 'str',
        'passive': 'bool',
        'substitute_ip_address': 'bool',
        'extended_passive_mode': 'bool',
        'ssh_compression': 'bool',
        'logical_key_name': 'str',
        'passphrase': 'str',
        'private_key_content': 'str'
    }

    attribute_map = {
        'host_name': 'hostName',
        'os_type': 'osType',
        'user': 'user',
        'password': 'password',
        'protocol': 'protocol',
        'port': 'port',
        'ssl': 'ssl',
        'ssl_implicit': 'sslImplicit',
        'ccc_command': 'cccCommand',
        'cdc_command': 'cdcCommand',
        'ssl_level': 'sslLevel',
        'passive': 'passive',
        'substitute_ip_address': 'substituteIpAddress',
        'extended_passive_mode': 'extendedPassiveMode',
        'ssh_compression': 'sshCompression',
        'logical_key_name': 'logicalKeyName',
        'passphrase': 'passphrase',
        'private_key_content': 'privateKeyContent'
    }

    def __init__(self, host_name='Local', os_type=None, user=None, password=None, protocol=None, port=0, ssl=False, ssl_implicit=False, ccc_command=False, cdc_command=False, ssl_level=None, passive=False, substitute_ip_address=False, extended_passive_mode=False, ssh_compression=False, logical_key_name='', passphrase='', private_key_content='', local_vars_configuration=None):  # noqa: E501
        """HostProperties - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._host_name = None
        self._os_type = None
        self._user = None
        self._password = None
        self._protocol = None
        self._port = None
        self._ssl = None
        self._ssl_implicit = None
        self._ccc_command = None
        self._cdc_command = None
        self._ssl_level = None
        self._passive = None
        self._substitute_ip_address = None
        self._extended_passive_mode = None
        self._ssh_compression = None
        self._logical_key_name = None
        self._passphrase = None
        self._private_key_content = None
        self.discriminator = None

        if host_name is not None:
            self.host_name = host_name
        if os_type is not None:
            self.os_type = os_type
        if user is not None:
            self.user = user
        if password is not None:
            self.password = password
        if protocol is not None:
            self.protocol = protocol
        if port is not None:
            self.port = port
        if ssl is not None:
            self.ssl = ssl
        if ssl_implicit is not None:
            self.ssl_implicit = ssl_implicit
        if ccc_command is not None:
            self.ccc_command = ccc_command
        if cdc_command is not None:
            self.cdc_command = cdc_command
        if ssl_level is not None:
            self.ssl_level = ssl_level
        if passive is not None:
            self.passive = passive
        if substitute_ip_address is not None:
            self.substitute_ip_address = substitute_ip_address
        if extended_passive_mode is not None:
            self.extended_passive_mode = extended_passive_mode
        if ssh_compression is not None:
            self.ssh_compression = ssh_compression
        if logical_key_name is not None:
            self.logical_key_name = logical_key_name
        if passphrase is not None:
            self.passphrase = passphrase
        if private_key_content is not None:
            self.private_key_content = private_key_content

    @property
    def host_name(self):
        """Gets the host_name of this HostProperties.  # noqa: E501

        Host Name HIDDEN  # noqa: E501

        :return: The host_name of this HostProperties.  # noqa: E501
        :rtype: str
        """
        return self._host_name

    @host_name.setter
    def host_name(self, host_name):
        """Sets the host_name of this HostProperties.

        Host Name HIDDEN  # noqa: E501

        :param host_name: The host_name of this HostProperties.  # noqa: E501
        :type host_name: str
        """

        self._host_name = host_name

    @property
    def os_type(self):
        """Gets the os_type of this HostProperties.  # noqa: E501

        OS Type (Windows/Unix/MVS/OS400/Tandem/OpenVMS/OS2200) HIDDEN  # noqa: E501

        :return: The os_type of this HostProperties.  # noqa: E501
        :rtype: str
        """
        return self._os_type

    @os_type.setter
    def os_type(self, os_type):
        """Sets the os_type of this HostProperties.

        OS Type (Windows/Unix/MVS/OS400/Tandem/OpenVMS/OS2200) HIDDEN  # noqa: E501

        :param os_type: The os_type of this HostProperties.  # noqa: E501
        :type os_type: str
        """

        self._os_type = os_type

    @property
    def user(self):
        """Gets the user of this HostProperties.  # noqa: E501

        User Name HIDDEN  # noqa: E501

        :return: The user of this HostProperties.  # noqa: E501
        :rtype: str
        """
        return self._user

    @user.setter
    def user(self, user):
        """Sets the user of this HostProperties.

        User Name HIDDEN  # noqa: E501

        :param user: The user of this HostProperties.  # noqa: E501
        :type user: str
        """

        self._user = user

    @property
    def password(self):
        """Gets the password of this HostProperties.  # noqa: E501

        Password HIDDEN  # noqa: E501

        :return: The password of this HostProperties.  # noqa: E501
        :rtype: str
        """
        return self._password

    @password.setter
    def password(self, password):
        """Sets the password of this HostProperties.

        Password HIDDEN  # noqa: E501

        :param password: The password of this HostProperties.  # noqa: E501
        :type password: str
        """

        self._password = password

    @property
    def protocol(self):
        """Gets the protocol of this HostProperties.  # noqa: E501

        Protocol Name (Local/FTP/SFTP) HIDDEN  # noqa: E501

        :return: The protocol of this HostProperties.  # noqa: E501
        :rtype: str
        """
        return self._protocol

    @protocol.setter
    def protocol(self, protocol):
        """Sets the protocol of this HostProperties.

        Protocol Name (Local/FTP/SFTP) HIDDEN  # noqa: E501

        :param protocol: The protocol of this HostProperties.  # noqa: E501
        :type protocol: str
        """

        self._protocol = protocol

    @property
    def port(self):
        """Gets the port of this HostProperties.  # noqa: E501

        Port HIDDEN  # noqa: E501

        :return: The port of this HostProperties.  # noqa: E501
        :rtype: int
        """
        return self._port

    @port.setter
    def port(self, port):
        """Sets the port of this HostProperties.

        Port HIDDEN  # noqa: E501

        :param port: The port of this HostProperties.  # noqa: E501
        :type port: int
        """

        self._port = port

    @property
    def ssl(self):
        """Gets the ssl of this HostProperties.  # noqa: E501

        FTP Over SSL/TLS HIDDEN  # noqa: E501

        :return: The ssl of this HostProperties.  # noqa: E501
        :rtype: bool
        """
        return self._ssl

    @ssl.setter
    def ssl(self, ssl):
        """Sets the ssl of this HostProperties.

        FTP Over SSL/TLS HIDDEN  # noqa: E501

        :param ssl: The ssl of this HostProperties.  # noqa: E501
        :type ssl: bool
        """

        self._ssl = ssl

    @property
    def ssl_implicit(self):
        """Gets the ssl_implicit of this HostProperties.  # noqa: E501

        SSL Implicit HIDDEN  # noqa: E501

        :return: The ssl_implicit of this HostProperties.  # noqa: E501
        :rtype: bool
        """
        return self._ssl_implicit

    @ssl_implicit.setter
    def ssl_implicit(self, ssl_implicit):
        """Sets the ssl_implicit of this HostProperties.

        SSL Implicit HIDDEN  # noqa: E501

        :param ssl_implicit: The ssl_implicit of this HostProperties.  # noqa: E501
        :type ssl_implicit: bool
        """

        self._ssl_implicit = ssl_implicit

    @property
    def ccc_command(self):
        """Gets the ccc_command of this HostProperties.  # noqa: E501

        Clear Command Channel (CCC) HIDDEN  # noqa: E501

        :return: The ccc_command of this HostProperties.  # noqa: E501
        :rtype: bool
        """
        return self._ccc_command

    @ccc_command.setter
    def ccc_command(self, ccc_command):
        """Sets the ccc_command of this HostProperties.

        Clear Command Channel (CCC) HIDDEN  # noqa: E501

        :param ccc_command: The ccc_command of this HostProperties.  # noqa: E501
        :type ccc_command: bool
        """

        self._ccc_command = ccc_command

    @property
    def cdc_command(self):
        """Gets the cdc_command of this HostProperties.  # noqa: E501

        Clear Data Channel (CDC) HIDDEN  # noqa: E501

        :return: The cdc_command of this HostProperties.  # noqa: E501
        :rtype: bool
        """
        return self._cdc_command

    @cdc_command.setter
    def cdc_command(self, cdc_command):
        """Sets the cdc_command of this HostProperties.

        Clear Data Channel (CDC) HIDDEN  # noqa: E501

        :param cdc_command: The cdc_command of this HostProperties.  # noqa: E501
        :type cdc_command: bool
        """

        self._cdc_command = cdc_command

    @property
    def ssl_level(self):
        """Gets the ssl_level of this HostProperties.  # noqa: E501

        SSL Security Level (No Authentication/Server Authentication/Client-Server Authentication) HIDDEN  # noqa: E501

        :return: The ssl_level of this HostProperties.  # noqa: E501
        :rtype: str
        """
        return self._ssl_level

    @ssl_level.setter
    def ssl_level(self, ssl_level):
        """Sets the ssl_level of this HostProperties.

        SSL Security Level (No Authentication/Server Authentication/Client-Server Authentication) HIDDEN  # noqa: E501

        :param ssl_level: The ssl_level of this HostProperties.  # noqa: E501
        :type ssl_level: str
        """

        self._ssl_level = ssl_level

    @property
    def passive(self):
        """Gets the passive of this HostProperties.  # noqa: E501

        FTP Passive HIDDEN  # noqa: E501

        :return: The passive of this HostProperties.  # noqa: E501
        :rtype: bool
        """
        return self._passive

    @passive.setter
    def passive(self, passive):
        """Sets the passive of this HostProperties.

        FTP Passive HIDDEN  # noqa: E501

        :param passive: The passive of this HostProperties.  # noqa: E501
        :type passive: bool
        """

        self._passive = passive

    @property
    def substitute_ip_address(self):
        """Gets the substitute_ip_address of this HostProperties.  # noqa: E501

        Substitute IP Address HIDDEN  # noqa: E501

        :return: The substitute_ip_address of this HostProperties.  # noqa: E501
        :rtype: bool
        """
        return self._substitute_ip_address

    @substitute_ip_address.setter
    def substitute_ip_address(self, substitute_ip_address):
        """Sets the substitute_ip_address of this HostProperties.

        Substitute IP Address HIDDEN  # noqa: E501

        :param substitute_ip_address: The substitute_ip_address of this HostProperties.  # noqa: E501
        :type substitute_ip_address: bool
        """

        self._substitute_ip_address = substitute_ip_address

    @property
    def extended_passive_mode(self):
        """Gets the extended_passive_mode of this HostProperties.  # noqa: E501

        Extrernded Passive Mode (EPSV) HIDDEN  # noqa: E501

        :return: The extended_passive_mode of this HostProperties.  # noqa: E501
        :rtype: bool
        """
        return self._extended_passive_mode

    @extended_passive_mode.setter
    def extended_passive_mode(self, extended_passive_mode):
        """Sets the extended_passive_mode of this HostProperties.

        Extrernded Passive Mode (EPSV) HIDDEN  # noqa: E501

        :param extended_passive_mode: The extended_passive_mode of this HostProperties.  # noqa: E501
        :type extended_passive_mode: bool
        """

        self._extended_passive_mode = extended_passive_mode

    @property
    def ssh_compression(self):
        """Gets the ssh_compression of this HostProperties.  # noqa: E501

        SSH Compression HIDDEN  # noqa: E501

        :return: The ssh_compression of this HostProperties.  # noqa: E501
        :rtype: bool
        """
        return self._ssh_compression

    @ssh_compression.setter
    def ssh_compression(self, ssh_compression):
        """Sets the ssh_compression of this HostProperties.

        SSH Compression HIDDEN  # noqa: E501

        :param ssh_compression: The ssh_compression of this HostProperties.  # noqa: E501
        :type ssh_compression: bool
        """

        self._ssh_compression = ssh_compression

    @property
    def logical_key_name(self):
        """Gets the logical_key_name of this HostProperties.  # noqa: E501

        Private Key Name HIDDEN  # noqa: E501

        :return: The logical_key_name of this HostProperties.  # noqa: E501
        :rtype: str
        """
        return self._logical_key_name

    @logical_key_name.setter
    def logical_key_name(self, logical_key_name):
        """Sets the logical_key_name of this HostProperties.

        Private Key Name HIDDEN  # noqa: E501

        :param logical_key_name: The logical_key_name of this HostProperties.  # noqa: E501
        :type logical_key_name: str
        """

        self._logical_key_name = logical_key_name

    @property
    def passphrase(self):
        """Gets the passphrase of this HostProperties.  # noqa: E501

        Key Passphrase HIDDEN  # noqa: E501

        :return: The passphrase of this HostProperties.  # noqa: E501
        :rtype: str
        """
        return self._passphrase

    @passphrase.setter
    def passphrase(self, passphrase):
        """Sets the passphrase of this HostProperties.

        Key Passphrase HIDDEN  # noqa: E501

        :param passphrase: The passphrase of this HostProperties.  # noqa: E501
        :type passphrase: str
        """

        self._passphrase = passphrase

    @property
    def private_key_content(self):
        """Gets the private_key_content of this HostProperties.  # noqa: E501

        Private Key Content HIDDEN  # noqa: E501

        :return: The private_key_content of this HostProperties.  # noqa: E501
        :rtype: str
        """
        return self._private_key_content

    @private_key_content.setter
    def private_key_content(self, private_key_content):
        """Sets the private_key_content of this HostProperties.

        Private Key Content HIDDEN  # noqa: E501

        :param private_key_content: The private_key_content of this HostProperties.  # noqa: E501
        :type private_key_content: str
        """

        self._private_key_content = private_key_content

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, HostProperties):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, HostProperties):
            return True

        return self.to_dict() != other.to_dict()
