# coding: utf-8

"""
    Control-M Services

    Provides access to BMC Control-M Services  # noqa: E501

    The version of the OpenAPI document: 9.22.30
    Contact: customer_support@bmc.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from clients.ctm_api_client.configuration import Configuration


class ItemInfo(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'name': 'str',
        'id': 'int',
        'description': 'str',
        'created_time': 'str',
        'updated_time': 'str',
        'updated_time_utc': 'str',
        'username': 'str',
        'enabled': 'bool',
        'site_standard': 'str',
        'site_standard_id': 'str'
    }

    attribute_map = {
        'name': 'name',
        'id': 'id',
        'description': 'description',
        'created_time': 'createdTime',
        'updated_time': 'updatedTime',
        'updated_time_utc': 'updatedTimeUTC',
        'username': 'username',
        'enabled': 'enabled',
        'site_standard': 'siteStandard',
        'site_standard_id': 'siteStandardId'
    }

    def __init__(self, name=None, id=None, description=None, created_time=None, updated_time=None, updated_time_utc=None, username=None, enabled=None, site_standard=None, site_standard_id=None, local_vars_configuration=None):  # noqa: E501
        """ItemInfo - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._name = None
        self._id = None
        self._description = None
        self._created_time = None
        self._updated_time = None
        self._updated_time_utc = None
        self._username = None
        self._enabled = None
        self._site_standard = None
        self._site_standard_id = None
        self.discriminator = None

        self.name = name
        if id is not None:
            self.id = id
        if description is not None:
            self.description = description
        if created_time is not None:
            self.created_time = created_time
        if updated_time is not None:
            self.updated_time = updated_time
        if updated_time_utc is not None:
            self.updated_time_utc = updated_time_utc
        if username is not None:
            self.username = username
        if enabled is not None:
            self.enabled = enabled
        if site_standard is not None:
            self.site_standard = site_standard
        if site_standard_id is not None:
            self.site_standard_id = site_standard_id

    @property
    def name(self):
        """Gets the name of this ItemInfo.  # noqa: E501


        :return: The name of this ItemInfo.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ItemInfo.


        :param name: The name of this ItemInfo.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def id(self):
        """Gets the id of this ItemInfo.  # noqa: E501


        :return: The id of this ItemInfo.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this ItemInfo.


        :param id: The id of this ItemInfo.  # noqa: E501
        :type id: int
        """

        self._id = id

    @property
    def description(self):
        """Gets the description of this ItemInfo.  # noqa: E501


        :return: The description of this ItemInfo.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this ItemInfo.


        :param description: The description of this ItemInfo.  # noqa: E501
        :type description: str
        """

        self._description = description

    @property
    def created_time(self):
        """Gets the created_time of this ItemInfo.  # noqa: E501

        the time the item was created on (in UTC, in ISO 8601 format)  # noqa: E501

        :return: The created_time of this ItemInfo.  # noqa: E501
        :rtype: str
        """
        return self._created_time

    @created_time.setter
    def created_time(self, created_time):
        """Sets the created_time of this ItemInfo.

        the time the item was created on (in UTC, in ISO 8601 format)  # noqa: E501

        :param created_time: The created_time of this ItemInfo.  # noqa: E501
        :type created_time: str
        """

        self._created_time = created_time

    @property
    def updated_time(self):
        """Gets the updated_time of this ItemInfo.  # noqa: E501

        the time the item was last updated (in UTC, in ISO 8601 format)  # noqa: E501

        :return: The updated_time of this ItemInfo.  # noqa: E501
        :rtype: str
        """
        return self._updated_time

    @updated_time.setter
    def updated_time(self, updated_time):
        """Sets the updated_time of this ItemInfo.

        the time the item was last updated (in UTC, in ISO 8601 format)  # noqa: E501

        :param updated_time: The updated_time of this ItemInfo.  # noqa: E501
        :type updated_time: str
        """

        self._updated_time = updated_time

    @property
    def updated_time_utc(self):
        """Gets the updated_time_utc of this ItemInfo.  # noqa: E501

        the time when the item was last updated as string without date format  # noqa: E501

        :return: The updated_time_utc of this ItemInfo.  # noqa: E501
        :rtype: str
        """
        return self._updated_time_utc

    @updated_time_utc.setter
    def updated_time_utc(self, updated_time_utc):
        """Sets the updated_time_utc of this ItemInfo.

        the time when the item was last updated as string without date format  # noqa: E501

        :param updated_time_utc: The updated_time_utc of this ItemInfo.  # noqa: E501
        :type updated_time_utc: str
        """

        self._updated_time_utc = updated_time_utc

    @property
    def username(self):
        """Gets the username of this ItemInfo.  # noqa: E501

        the username of the last user that updated the item  # noqa: E501

        :return: The username of this ItemInfo.  # noqa: E501
        :rtype: str
        """
        return self._username

    @username.setter
    def username(self, username):
        """Sets the username of this ItemInfo.

        the username of the last user that updated the item  # noqa: E501

        :param username: The username of this ItemInfo.  # noqa: E501
        :type username: str
        """

        self._username = username

    @property
    def enabled(self):
        """Gets the enabled of this ItemInfo.  # noqa: E501

        indicates whether the item is enabled  # noqa: E501

        :return: The enabled of this ItemInfo.  # noqa: E501
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled):
        """Sets the enabled of this ItemInfo.

        indicates whether the item is enabled  # noqa: E501

        :param enabled: The enabled of this ItemInfo.  # noqa: E501
        :type enabled: bool
        """

        self._enabled = enabled

    @property
    def site_standard(self):
        """Gets the site_standard of this ItemInfo.  # noqa: E501

        the Site Standard Name associested with this policy  # noqa: E501

        :return: The site_standard of this ItemInfo.  # noqa: E501
        :rtype: str
        """
        return self._site_standard

    @site_standard.setter
    def site_standard(self, site_standard):
        """Sets the site_standard of this ItemInfo.

        the Site Standard Name associested with this policy  # noqa: E501

        :param site_standard: The site_standard of this ItemInfo.  # noqa: E501
        :type site_standard: str
        """

        self._site_standard = site_standard

    @property
    def site_standard_id(self):
        """Gets the site_standard_id of this ItemInfo.  # noqa: E501

        the Site Standard ID associested with this policy  # noqa: E501

        :return: The site_standard_id of this ItemInfo.  # noqa: E501
        :rtype: str
        """
        return self._site_standard_id

    @site_standard_id.setter
    def site_standard_id(self, site_standard_id):
        """Sets the site_standard_id of this ItemInfo.

        the Site Standard ID associested with this policy  # noqa: E501

        :param site_standard_id: The site_standard_id of this ItemInfo.  # noqa: E501
        :type site_standard_id: str
        """

        self._site_standard_id = site_standard_id

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ItemInfo):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ItemInfo):
            return True

        return self.to_dict() != other.to_dict()
