# coding: utf-8

"""
    Control-M Services

    Provides access to BMC Control-M Services  # noqa: E501

    The version of the OpenAPI document: 9.22.30
    Contact: customer_support@bmc.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from clients.ctm_api_client.configuration import Configuration


class Node(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'name': 'str',
        'id': 'str',
        'role': 'str',
        'host': 'str',
        'availability': 'list[Availability]',
        'performance': 'list[Performance]'
    }

    attribute_map = {
        'name': 'name',
        'id': 'id',
        'role': 'role',
        'host': 'host',
        'availability': 'availability',
        'performance': 'performance'
    }

    def __init__(self, name=None, id=None, role=None, host=None, availability=None, performance=None, local_vars_configuration=None):  # noqa: E501
        """Node - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._name = None
        self._id = None
        self._role = None
        self._host = None
        self._availability = None
        self._performance = None
        self.discriminator = None

        if name is not None:
            self.name = name
        if id is not None:
            self.id = id
        if role is not None:
            self.role = role
        if host is not None:
            self.host = host
        if availability is not None:
            self.availability = availability
        if performance is not None:
            self.performance = performance

    @property
    def name(self):
        """Gets the name of this Node.  # noqa: E501

        Node Name  # noqa: E501

        :return: The name of this Node.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Node.

        Node Name  # noqa: E501

        :param name: The name of this Node.  # noqa: E501
        :type name: str
        """

        self._name = name

    @property
    def id(self):
        """Gets the id of this Node.  # noqa: E501

        A unique id of the node  # noqa: E501

        :return: The id of this Node.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Node.

        A unique id of the node  # noqa: E501

        :param id: The id of this Node.  # noqa: E501
        :type id: str
        """

        self._id = id

    @property
    def role(self):
        """Gets the role of this Node.  # noqa: E501

        The role of the node  # noqa: E501

        :return: The role of this Node.  # noqa: E501
        :rtype: str
        """
        return self._role

    @role.setter
    def role(self, role):
        """Sets the role of this Node.

        The role of the node  # noqa: E501

        :param role: The role of this Node.  # noqa: E501
        :type role: str
        """

        self._role = role

    @property
    def host(self):
        """Gets the host of this Node.  # noqa: E501

        The Host running the node  # noqa: E501

        :return: The host of this Node.  # noqa: E501
        :rtype: str
        """
        return self._host

    @host.setter
    def host(self, host):
        """Sets the host of this Node.

        The Host running the node  # noqa: E501

        :param host: The host of this Node.  # noqa: E501
        :type host: str
        """

        self._host = host

    @property
    def availability(self):
        """Gets the availability of this Node.  # noqa: E501


        :return: The availability of this Node.  # noqa: E501
        :rtype: list[Availability]
        """
        return self._availability

    @availability.setter
    def availability(self, availability):
        """Sets the availability of this Node.


        :param availability: The availability of this Node.  # noqa: E501
        :type availability: list[Availability]
        """

        self._availability = availability

    @property
    def performance(self):
        """Gets the performance of this Node.  # noqa: E501


        :return: The performance of this Node.  # noqa: E501
        :rtype: list[Performance]
        """
        return self._performance

    @performance.setter
    def performance(self, performance):
        """Sets the performance of this Node.


        :param performance: The performance of this Node.  # noqa: E501
        :type performance: list[Performance]
        """

        self._performance = performance

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Node):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Node):
            return True

        return self.to_dict() != other.to_dict()
