# coding: utf-8

"""
    Control-M Services

    Provides access to BMC Control-M Services  # noqa: E501

    The version of the OpenAPI document: 9.22.30
    Contact: customer_support@bmc.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from clients.ctm_api_client.configuration import Configuration


class OutputParams(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'ctm': 'str',
        'order_id': 'str',
        'number_of_runs': 'int',
        'output_table': 'str'
    }

    attribute_map = {
        'ctm': 'ctm',
        'order_id': 'orderId',
        'number_of_runs': 'numberOfRuns',
        'output_table': 'outputTable'
    }

    def __init__(self, ctm=None, order_id=None, number_of_runs=None, output_table=None, local_vars_configuration=None):  # noqa: E501
        """OutputParams - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._ctm = None
        self._order_id = None
        self._number_of_runs = None
        self._output_table = None
        self.discriminator = None

        if ctm is not None:
            self.ctm = ctm
        if order_id is not None:
            self.order_id = order_id
        if number_of_runs is not None:
            self.number_of_runs = number_of_runs
        if output_table is not None:
            self.output_table = output_table

    @property
    def ctm(self):
        """Gets the ctm of this OutputParams.  # noqa: E501

        The name of the Control-M server in which the job was ordered from. HIDDEN.  # noqa: E501

        :return: The ctm of this OutputParams.  # noqa: E501
        :rtype: str
        """
        return self._ctm

    @ctm.setter
    def ctm(self, ctm):
        """Sets the ctm of this OutputParams.

        The name of the Control-M server in which the job was ordered from. HIDDEN.  # noqa: E501

        :param ctm: The ctm of this OutputParams.  # noqa: E501
        :type ctm: str
        """

        self._ctm = ctm

    @property
    def order_id(self):
        """Gets the order_id of this OutputParams.  # noqa: E501

        Job's order id. HIDDEN.  # noqa: E501

        :return: The order_id of this OutputParams.  # noqa: E501
        :rtype: str
        """
        return self._order_id

    @order_id.setter
    def order_id(self, order_id):
        """Sets the order_id of this OutputParams.

        Job's order id. HIDDEN.  # noqa: E501

        :param order_id: The order_id of this OutputParams.  # noqa: E501
        :type order_id: str
        """

        self._order_id = order_id

    @property
    def number_of_runs(self):
        """Gets the number_of_runs of this OutputParams.  # noqa: E501

        Job's rerun number. HIDDEN.  # noqa: E501

        :return: The number_of_runs of this OutputParams.  # noqa: E501
        :rtype: int
        """
        return self._number_of_runs

    @number_of_runs.setter
    def number_of_runs(self, number_of_runs):
        """Sets the number_of_runs of this OutputParams.

        Job's rerun number. HIDDEN.  # noqa: E501

        :param number_of_runs: The number_of_runs of this OutputParams.  # noqa: E501
        :type number_of_runs: int
        """

        self._number_of_runs = number_of_runs

    @property
    def output_table(self):
        """Gets the output_table of this OutputParams.  # noqa: E501

        Job's output table name, accepted as a value in search request. HIDDEN.  # noqa: E501

        :return: The output_table of this OutputParams.  # noqa: E501
        :rtype: str
        """
        return self._output_table

    @output_table.setter
    def output_table(self, output_table):
        """Sets the output_table of this OutputParams.

        Job's output table name, accepted as a value in search request. HIDDEN.  # noqa: E501

        :param output_table: The output_table of this OutputParams.  # noqa: E501
        :type output_table: str
        """

        self._output_table = output_table

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, OutputParams):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, OutputParams):
            return True

        return self.to_dict() != other.to_dict()
