# coding: utf-8

"""
    Control-M Services

    Provides access to BMC Control-M Services  # noqa: E501

    The version of the OpenAPI document: 9.22.30
    Contact: customer_support@bmc.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from clients.ctm_api_client.configuration import Configuration


class ProvisionAdvanceParameters(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'java_home': 'str',
        'connection_initiator': 'str',
        'tag': 'str',
        'server_host_name': 'str',
        'server_port': 'int',
        'secondary_server_host_name': 'str'
    }

    attribute_map = {
        'java_home': 'javaHome',
        'connection_initiator': 'connectionInitiator',
        'tag': 'tag',
        'server_host_name': 'serverHostName',
        'server_port': 'serverPort',
        'secondary_server_host_name': 'secondaryServerHostName'
    }

    def __init__(self, java_home=None, connection_initiator=None, tag=None, server_host_name=None, server_port=None, secondary_server_host_name=None, local_vars_configuration=None):  # noqa: E501
        """ProvisionAdvanceParameters - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._java_home = None
        self._connection_initiator = None
        self._tag = None
        self._server_host_name = None
        self._server_port = None
        self._secondary_server_host_name = None
        self.discriminator = None

        if java_home is not None:
            self.java_home = java_home
        if connection_initiator is not None:
            self.connection_initiator = connection_initiator
        if tag is not None:
            self.tag = tag
        if server_host_name is not None:
            self.server_host_name = server_host_name
        if server_port is not None:
            self.server_port = server_port
        if secondary_server_host_name is not None:
            self.secondary_server_host_name = secondary_server_host_name

    @property
    def java_home(self):
        """Gets the java_home of this ProvisionAdvanceParameters.  # noqa: E501

        The JRE that will be used to install and run the agent  # noqa: E501

        :return: The java_home of this ProvisionAdvanceParameters.  # noqa: E501
        :rtype: str
        """
        return self._java_home

    @java_home.setter
    def java_home(self, java_home):
        """Sets the java_home of this ProvisionAdvanceParameters.

        The JRE that will be used to install and run the agent  # noqa: E501

        :param java_home: The java_home of this ProvisionAdvanceParameters.  # noqa: E501
        :type java_home: str
        """

        self._java_home = java_home

    @property
    def connection_initiator(self):
        """Gets the connection_initiator of this ProvisionAdvanceParameters.  # noqa: E501

        Which component is allowed to initiate the connection [ServerToAgent | AgentToServer | BothAllowed]. Parameters start with capital letter.  HIDDEN.  # noqa: E501

        :return: The connection_initiator of this ProvisionAdvanceParameters.  # noqa: E501
        :rtype: str
        """
        return self._connection_initiator

    @connection_initiator.setter
    def connection_initiator(self, connection_initiator):
        """Sets the connection_initiator of this ProvisionAdvanceParameters.

        Which component is allowed to initiate the connection [ServerToAgent | AgentToServer | BothAllowed]. Parameters start with capital letter.  HIDDEN.  # noqa: E501

        :param connection_initiator: The connection_initiator of this ProvisionAdvanceParameters.  # noqa: E501
        :type connection_initiator: str
        """

        self._connection_initiator = connection_initiator

    @property
    def tag(self):
        """Gets the tag of this ProvisionAdvanceParameters.  # noqa: E501

        Logical name that is used to label specific Control-M/Agents into a group with a specific authorization level.  HIDDEN.  # noqa: E501

        :return: The tag of this ProvisionAdvanceParameters.  # noqa: E501
        :rtype: str
        """
        return self._tag

    @tag.setter
    def tag(self, tag):
        """Sets the tag of this ProvisionAdvanceParameters.

        Logical name that is used to label specific Control-M/Agents into a group with a specific authorization level.  HIDDEN.  # noqa: E501

        :param tag: The tag of this ProvisionAdvanceParameters.  # noqa: E501
        :type tag: str
        """

        self._tag = tag

    @property
    def server_host_name(self):
        """Gets the server_host_name of this ProvisionAdvanceParameters.  # noqa: E501

        Control-M/Server name (in case it has an alias or multiple network interfaces).  HIDDEN.  # noqa: E501

        :return: The server_host_name of this ProvisionAdvanceParameters.  # noqa: E501
        :rtype: str
        """
        return self._server_host_name

    @server_host_name.setter
    def server_host_name(self, server_host_name):
        """Sets the server_host_name of this ProvisionAdvanceParameters.

        Control-M/Server name (in case it has an alias or multiple network interfaces).  HIDDEN.  # noqa: E501

        :param server_host_name: The server_host_name of this ProvisionAdvanceParameters.  # noqa: E501
        :type server_host_name: str
        """

        self._server_host_name = server_host_name

    @property
    def server_port(self):
        """Gets the server_port of this ProvisionAdvanceParameters.  # noqa: E501

        Control-M/Server port to communicate with the agent.  HIDDEN.  # noqa: E501

        :return: The server_port of this ProvisionAdvanceParameters.  # noqa: E501
        :rtype: int
        """
        return self._server_port

    @server_port.setter
    def server_port(self, server_port):
        """Sets the server_port of this ProvisionAdvanceParameters.

        Control-M/Server port to communicate with the agent.  HIDDEN.  # noqa: E501

        :param server_port: The server_port of this ProvisionAdvanceParameters.  # noqa: E501
        :type server_port: int
        """

        self._server_port = server_port

    @property
    def secondary_server_host_name(self):
        """Gets the secondary_server_host_name of this ProvisionAdvanceParameters.  # noqa: E501

        The secondary Control-M/Server host used in High Availability (HA) configurations.  HIDDEN.  # noqa: E501

        :return: The secondary_server_host_name of this ProvisionAdvanceParameters.  # noqa: E501
        :rtype: str
        """
        return self._secondary_server_host_name

    @secondary_server_host_name.setter
    def secondary_server_host_name(self, secondary_server_host_name):
        """Sets the secondary_server_host_name of this ProvisionAdvanceParameters.

        The secondary Control-M/Server host used in High Availability (HA) configurations.  HIDDEN.  # noqa: E501

        :param secondary_server_host_name: The secondary_server_host_name of this ProvisionAdvanceParameters.  # noqa: E501
        :type secondary_server_host_name: str
        """

        self._secondary_server_host_name = secondary_server_host_name

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ProvisionAdvanceParameters):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ProvisionAdvanceParameters):
            return True

        return self.to_dict() != other.to_dict()
