# coding: utf-8

"""
    Control-M Services

    Provides access to BMC Control-M Services  # noqa: E501

    The version of the OpenAPI document: 9.22.30
    Contact: customer_support@bmc.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from clients.ctm_api_client.configuration import Configuration


class ServerEditParams(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'host': 'str',
        'ctm_to_em_port': 'int',
        'configuration_agent_port': 'int',
        'version': 'str',
        'description': 'str',
        'contact': 'str',
        'statistics_alg': 'str',
        'sync_mode': 'str',
        'protocol': 'str',
        'time_zone': 'str',
        'new_day_time': 'str',
        'week_start_day': 'str',
        'day_light_saving_start_date': 'str',
        'day_light_saving_end_date': 'str',
        'is_uppercase_only': 'bool',
        'failover_mode': 'str'
    }

    attribute_map = {
        'host': 'host',
        'ctm_to_em_port': 'ctmToEMPort',
        'configuration_agent_port': 'configurationAgentPort',
        'version': 'version',
        'description': 'description',
        'contact': 'contact',
        'statistics_alg': 'statisticsAlg',
        'sync_mode': 'syncMode',
        'protocol': 'protocol',
        'time_zone': 'timeZone',
        'new_day_time': 'newDayTime',
        'week_start_day': 'weekStartDay',
        'day_light_saving_start_date': 'dayLightSavingStartDate',
        'day_light_saving_end_date': 'dayLightSavingEndDate',
        'is_uppercase_only': 'isUppercaseOnly',
        'failover_mode': 'failoverMode'
    }

    def __init__(self, host=None, ctm_to_em_port=None, configuration_agent_port=None, version=None, description=None, contact=None, statistics_alg=None, sync_mode=None, protocol=None, time_zone=None, new_day_time=None, week_start_day=None, day_light_saving_start_date=None, day_light_saving_end_date=None, is_uppercase_only=None, failover_mode=None, local_vars_configuration=None):  # noqa: E501
        """ServerEditParams - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._host = None
        self._ctm_to_em_port = None
        self._configuration_agent_port = None
        self._version = None
        self._description = None
        self._contact = None
        self._statistics_alg = None
        self._sync_mode = None
        self._protocol = None
        self._time_zone = None
        self._new_day_time = None
        self._week_start_day = None
        self._day_light_saving_start_date = None
        self._day_light_saving_end_date = None
        self._is_uppercase_only = None
        self._failover_mode = None
        self.discriminator = None

        if host is not None:
            self.host = host
        if ctm_to_em_port is not None:
            self.ctm_to_em_port = ctm_to_em_port
        if configuration_agent_port is not None:
            self.configuration_agent_port = configuration_agent_port
        if version is not None:
            self.version = version
        if description is not None:
            self.description = description
        if contact is not None:
            self.contact = contact
        if statistics_alg is not None:
            self.statistics_alg = statistics_alg
        if sync_mode is not None:
            self.sync_mode = sync_mode
        if protocol is not None:
            self.protocol = protocol
        if time_zone is not None:
            self.time_zone = time_zone
        if new_day_time is not None:
            self.new_day_time = new_day_time
        if week_start_day is not None:
            self.week_start_day = week_start_day
        if day_light_saving_start_date is not None:
            self.day_light_saving_start_date = day_light_saving_start_date
        if day_light_saving_end_date is not None:
            self.day_light_saving_end_date = day_light_saving_end_date
        if is_uppercase_only is not None:
            self.is_uppercase_only = is_uppercase_only
        if failover_mode is not None:
            self.failover_mode = failover_mode

    @property
    def host(self):
        """Gets the host of this ServerEditParams.  # noqa: E501

        The Control-M Server host name. HIDDEN  # noqa: E501

        :return: The host of this ServerEditParams.  # noqa: E501
        :rtype: str
        """
        return self._host

    @host.setter
    def host(self, host):
        """Sets the host of this ServerEditParams.

        The Control-M Server host name. HIDDEN  # noqa: E501

        :param host: The host of this ServerEditParams.  # noqa: E501
        :type host: str
        """

        self._host = host

    @property
    def ctm_to_em_port(self):
        """Gets the ctm_to_em_port of this ServerEditParams.  # noqa: E501

        The Control-M/EM port number. HIDDEN  # noqa: E501

        :return: The ctm_to_em_port of this ServerEditParams.  # noqa: E501
        :rtype: int
        """
        return self._ctm_to_em_port

    @ctm_to_em_port.setter
    def ctm_to_em_port(self, ctm_to_em_port):
        """Sets the ctm_to_em_port of this ServerEditParams.

        The Control-M/EM port number. HIDDEN  # noqa: E501

        :param ctm_to_em_port: The ctm_to_em_port of this ServerEditParams.  # noqa: E501
        :type ctm_to_em_port: int
        """

        self._ctm_to_em_port = ctm_to_em_port

    @property
    def configuration_agent_port(self):
        """Gets the configuration_agent_port of this ServerEditParams.  # noqa: E501

        The Configuration Agent Port HIDDEN  # noqa: E501

        :return: The configuration_agent_port of this ServerEditParams.  # noqa: E501
        :rtype: int
        """
        return self._configuration_agent_port

    @configuration_agent_port.setter
    def configuration_agent_port(self, configuration_agent_port):
        """Sets the configuration_agent_port of this ServerEditParams.

        The Configuration Agent Port HIDDEN  # noqa: E501

        :param configuration_agent_port: The configuration_agent_port of this ServerEditParams.  # noqa: E501
        :type configuration_agent_port: int
        """

        self._configuration_agent_port = configuration_agent_port

    @property
    def version(self):
        """Gets the version of this ServerEditParams.  # noqa: E501

        The Control-M Server version. HIDDEN  # noqa: E501

        :return: The version of this ServerEditParams.  # noqa: E501
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this ServerEditParams.

        The Control-M Server version. HIDDEN  # noqa: E501

        :param version: The version of this ServerEditParams.  # noqa: E501
        :type version: str
        """

        self._version = version

    @property
    def description(self):
        """Gets the description of this ServerEditParams.  # noqa: E501

        The Control-M Server description. HIDDEN  # noqa: E501

        :return: The description of this ServerEditParams.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this ServerEditParams.

        The Control-M Server description. HIDDEN  # noqa: E501

        :param description: The description of this ServerEditParams.  # noqa: E501
        :type description: str
        """

        self._description = description

    @property
    def contact(self):
        """Gets the contact of this ServerEditParams.  # noqa: E501

        Contact information of server management. HIDDEN  # noqa: E501

        :return: The contact of this ServerEditParams.  # noqa: E501
        :rtype: str
        """
        return self._contact

    @contact.setter
    def contact(self, contact):
        """Sets the contact of this ServerEditParams.

        Contact information of server management. HIDDEN  # noqa: E501

        :param contact: The contact of this ServerEditParams.  # noqa: E501
        :type contact: str
        """

        self._contact = contact

    @property
    def statistics_alg(self):
        """Gets the statistics_alg of this ServerEditParams.  # noqa: E501

        EM statistics. HIDDEN  # noqa: E501

        :return: The statistics_alg of this ServerEditParams.  # noqa: E501
        :rtype: str
        """
        return self._statistics_alg

    @statistics_alg.setter
    def statistics_alg(self, statistics_alg):
        """Sets the statistics_alg of this ServerEditParams.

        EM statistics. HIDDEN  # noqa: E501

        :param statistics_alg: The statistics_alg of this ServerEditParams.  # noqa: E501
        :type statistics_alg: str
        """

        self._statistics_alg = statistics_alg

    @property
    def sync_mode(self):
        """Gets the sync_mode of this ServerEditParams.  # noqa: E501

        Control-M server and EM server synchronization mode . HIDDEN  # noqa: E501

        :return: The sync_mode of this ServerEditParams.  # noqa: E501
        :rtype: str
        """
        return self._sync_mode

    @sync_mode.setter
    def sync_mode(self, sync_mode):
        """Sets the sync_mode of this ServerEditParams.

        Control-M server and EM server synchronization mode . HIDDEN  # noqa: E501

        :param sync_mode: The sync_mode of this ServerEditParams.  # noqa: E501
        :type sync_mode: str
        """

        self._sync_mode = sync_mode

    @property
    def protocol(self):
        """Gets the protocol of this ServerEditParams.  # noqa: E501

        Protocol the server is using. HIDDEN  # noqa: E501

        :return: The protocol of this ServerEditParams.  # noqa: E501
        :rtype: str
        """
        return self._protocol

    @protocol.setter
    def protocol(self, protocol):
        """Sets the protocol of this ServerEditParams.

        Protocol the server is using. HIDDEN  # noqa: E501

        :param protocol: The protocol of this ServerEditParams.  # noqa: E501
        :type protocol: str
        """

        self._protocol = protocol

    @property
    def time_zone(self):
        """Gets the time_zone of this ServerEditParams.  # noqa: E501

        The Control-M Server time zone. HIDDEN  # noqa: E501

        :return: The time_zone of this ServerEditParams.  # noqa: E501
        :rtype: str
        """
        return self._time_zone

    @time_zone.setter
    def time_zone(self, time_zone):
        """Sets the time_zone of this ServerEditParams.

        The Control-M Server time zone. HIDDEN  # noqa: E501

        :param time_zone: The time_zone of this ServerEditParams.  # noqa: E501
        :type time_zone: str
        """

        self._time_zone = time_zone

    @property
    def new_day_time(self):
        """Gets the new_day_time of this ServerEditParams.  # noqa: E501

        The Control-M Server new day time. HIDDEN  # noqa: E501

        :return: The new_day_time of this ServerEditParams.  # noqa: E501
        :rtype: str
        """
        return self._new_day_time

    @new_day_time.setter
    def new_day_time(self, new_day_time):
        """Sets the new_day_time of this ServerEditParams.

        The Control-M Server new day time. HIDDEN  # noqa: E501

        :param new_day_time: The new_day_time of this ServerEditParams.  # noqa: E501
        :type new_day_time: str
        """

        self._new_day_time = new_day_time

    @property
    def week_start_day(self):
        """Gets the week_start_day of this ServerEditParams.  # noqa: E501

        The Control-M Server week start day. HIDDEN  # noqa: E501

        :return: The week_start_day of this ServerEditParams.  # noqa: E501
        :rtype: str
        """
        return self._week_start_day

    @week_start_day.setter
    def week_start_day(self, week_start_day):
        """Sets the week_start_day of this ServerEditParams.

        The Control-M Server week start day. HIDDEN  # noqa: E501

        :param week_start_day: The week_start_day of this ServerEditParams.  # noqa: E501
        :type week_start_day: str
        """

        self._week_start_day = week_start_day

    @property
    def day_light_saving_start_date(self):
        """Gets the day_light_saving_start_date of this ServerEditParams.  # noqa: E501

        The Control-M Server day light saving start date. HIDDEN  # noqa: E501

        :return: The day_light_saving_start_date of this ServerEditParams.  # noqa: E501
        :rtype: str
        """
        return self._day_light_saving_start_date

    @day_light_saving_start_date.setter
    def day_light_saving_start_date(self, day_light_saving_start_date):
        """Sets the day_light_saving_start_date of this ServerEditParams.

        The Control-M Server day light saving start date. HIDDEN  # noqa: E501

        :param day_light_saving_start_date: The day_light_saving_start_date of this ServerEditParams.  # noqa: E501
        :type day_light_saving_start_date: str
        """

        self._day_light_saving_start_date = day_light_saving_start_date

    @property
    def day_light_saving_end_date(self):
        """Gets the day_light_saving_end_date of this ServerEditParams.  # noqa: E501

        The Control-M Server day light saving end date. HIDDEN  # noqa: E501

        :return: The day_light_saving_end_date of this ServerEditParams.  # noqa: E501
        :rtype: str
        """
        return self._day_light_saving_end_date

    @day_light_saving_end_date.setter
    def day_light_saving_end_date(self, day_light_saving_end_date):
        """Sets the day_light_saving_end_date of this ServerEditParams.

        The Control-M Server day light saving end date. HIDDEN  # noqa: E501

        :param day_light_saving_end_date: The day_light_saving_end_date of this ServerEditParams.  # noqa: E501
        :type day_light_saving_end_date: str
        """

        self._day_light_saving_end_date = day_light_saving_end_date

    @property
    def is_uppercase_only(self):
        """Gets the is_uppercase_only of this ServerEditParams.  # noqa: E501

        The Control-M Server is upper case only. HIDDEN  # noqa: E501

        :return: The is_uppercase_only of this ServerEditParams.  # noqa: E501
        :rtype: bool
        """
        return self._is_uppercase_only

    @is_uppercase_only.setter
    def is_uppercase_only(self, is_uppercase_only):
        """Sets the is_uppercase_only of this ServerEditParams.

        The Control-M Server is upper case only. HIDDEN  # noqa: E501

        :param is_uppercase_only: The is_uppercase_only of this ServerEditParams.  # noqa: E501
        :type is_uppercase_only: bool
        """

        self._is_uppercase_only = is_uppercase_only

    @property
    def failover_mode(self):
        """Gets the failover_mode of this ServerEditParams.  # noqa: E501

        The failover mode used by Control-M Server High Availability. HIDDEN  # noqa: E501

        :return: The failover_mode of this ServerEditParams.  # noqa: E501
        :rtype: str
        """
        return self._failover_mode

    @failover_mode.setter
    def failover_mode(self, failover_mode):
        """Sets the failover_mode of this ServerEditParams.

        The failover mode used by Control-M Server High Availability. HIDDEN  # noqa: E501

        :param failover_mode: The failover_mode of this ServerEditParams.  # noqa: E501
        :type failover_mode: str
        """

        self._failover_mode = failover_mode

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ServerEditParams):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ServerEditParams):
            return True

        return self.to_dict() != other.to_dict()
