# coding: utf-8

"""
    Control-M Services

    Provides access to BMC Control-M Services  # noqa: E501

    The version of the OpenAPI document: 9.22.30
    Contact: customer_support@bmc.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from clients.ctm_api_client.configuration import Configuration


class SiteStandardFieldRule(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'field_name': 'str',
        'job_type': 'str',
        'conditions': 'list[SiteStandardCondition]',
        'attribute_conditions': 'list[SiteStandardCondition]',
        'on_statement': 'str',
        'do_action': 'str',
        'restriction': 'SiteStandardRestriction',
        'sub_fields': 'list[SiteStandardFieldRule]',
        'must_have': 'bool'
    }

    attribute_map = {
        'field_name': 'fieldName',
        'job_type': 'jobType',
        'conditions': 'conditions',
        'attribute_conditions': 'attributeConditions',
        'on_statement': 'onStatement',
        'do_action': 'doAction',
        'restriction': 'restriction',
        'sub_fields': 'subFields',
        'must_have': 'mustHave'
    }

    def __init__(self, field_name=None, job_type=None, conditions=None, attribute_conditions=None, on_statement=None, do_action=None, restriction=None, sub_fields=None, must_have=None, local_vars_configuration=None):  # noqa: E501
        """SiteStandardFieldRule - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._field_name = None
        self._job_type = None
        self._conditions = None
        self._attribute_conditions = None
        self._on_statement = None
        self._do_action = None
        self._restriction = None
        self._sub_fields = None
        self._must_have = None
        self.discriminator = None

        self.field_name = field_name
        if job_type is not None:
            self.job_type = job_type
        if conditions is not None:
            self.conditions = conditions
        if attribute_conditions is not None:
            self.attribute_conditions = attribute_conditions
        if on_statement is not None:
            self.on_statement = on_statement
        if do_action is not None:
            self.do_action = do_action
        if restriction is not None:
            self.restriction = restriction
        if sub_fields is not None:
            self.sub_fields = sub_fields
        if must_have is not None:
            self.must_have = must_have

    @property
    def field_name(self):
        """Gets the field_name of this SiteStandardFieldRule.  # noqa: E501

        The name of the field this rule applies to  # noqa: E501

        :return: The field_name of this SiteStandardFieldRule.  # noqa: E501
        :rtype: str
        """
        return self._field_name

    @field_name.setter
    def field_name(self, field_name):
        """Sets the field_name of this SiteStandardFieldRule.

        The name of the field this rule applies to  # noqa: E501

        :param field_name: The field_name of this SiteStandardFieldRule.  # noqa: E501
        :type field_name: str
        """
        if self.local_vars_configuration.client_side_validation and field_name is None:  # noqa: E501
            raise ValueError("Invalid value for `field_name`, must not be `None`")  # noqa: E501

        self._field_name = field_name

    @property
    def job_type(self):
        """Gets the job_type of this SiteStandardFieldRule.  # noqa: E501

        The job type this rule applies for. Empty job type means it applies to all job types  # noqa: E501

        :return: The job_type of this SiteStandardFieldRule.  # noqa: E501
        :rtype: str
        """
        return self._job_type

    @job_type.setter
    def job_type(self, job_type):
        """Sets the job_type of this SiteStandardFieldRule.

        The job type this rule applies for. Empty job type means it applies to all job types  # noqa: E501

        :param job_type: The job_type of this SiteStandardFieldRule.  # noqa: E501
        :type job_type: str
        """

        self._job_type = job_type

    @property
    def conditions(self):
        """Gets the conditions of this SiteStandardFieldRule.  # noqa: E501

        Job fields conditions to limit when this rule applies  # noqa: E501

        :return: The conditions of this SiteStandardFieldRule.  # noqa: E501
        :rtype: list[SiteStandardCondition]
        """
        return self._conditions

    @conditions.setter
    def conditions(self, conditions):
        """Sets the conditions of this SiteStandardFieldRule.

        Job fields conditions to limit when this rule applies  # noqa: E501

        :param conditions: The conditions of this SiteStandardFieldRule.  # noqa: E501
        :type conditions: list[SiteStandardCondition]
        """

        self._conditions = conditions

    @property
    def attribute_conditions(self):
        """Gets the attribute_conditions of this SiteStandardFieldRule.  # noqa: E501

        Multi-instance fields conditions to limit on what items this multi-instance rule applies. Should not be used in Must Have rules  # noqa: E501

        :return: The attribute_conditions of this SiteStandardFieldRule.  # noqa: E501
        :rtype: list[SiteStandardCondition]
        """
        return self._attribute_conditions

    @attribute_conditions.setter
    def attribute_conditions(self, attribute_conditions):
        """Sets the attribute_conditions of this SiteStandardFieldRule.

        Multi-instance fields conditions to limit on what items this multi-instance rule applies. Should not be used in Must Have rules  # noqa: E501

        :param attribute_conditions: The attribute_conditions of this SiteStandardFieldRule.  # noqa: E501
        :type attribute_conditions: list[SiteStandardCondition]
        """

        self._attribute_conditions = attribute_conditions

    @property
    def on_statement(self):
        """Gets the on_statement of this SiteStandardFieldRule.  # noqa: E501

        For on-do steps, specify the type of on statement this rule applies to. Omit this field for \"any on\"  # noqa: E501

        :return: The on_statement of this SiteStandardFieldRule.  # noqa: E501
        :rtype: str
        """
        return self._on_statement

    @on_statement.setter
    def on_statement(self, on_statement):
        """Sets the on_statement of this SiteStandardFieldRule.

        For on-do steps, specify the type of on statement this rule applies to. Omit this field for \"any on\"  # noqa: E501

        :param on_statement: The on_statement of this SiteStandardFieldRule.  # noqa: E501
        :type on_statement: str
        """
        allowed_values = ["EndedNotOK", "Ended", "EndedOK", "CompletionStatus", "ExecutionsCount", "RerunsCount", "OutputNotFound", "NotSubmitted", "AnyProgramStep", "EveryProgramStep", "SpecificStepName", "SpecificRangeName", "JOBRC", "OutputPattern", "FailuresCount", "SpecificStatement"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and on_statement not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `on_statement` ({0}), must be one of {1}"  # noqa: E501
                .format(on_statement, allowed_values)
            )

        self._on_statement = on_statement

    @property
    def do_action(self):
        """Gets the do_action of this SiteStandardFieldRule.  # noqa: E501

        For on-do steps, specify the type of do action this rule applies to. Omit this field for \"any do\"  # noqa: E501

        :return: The do_action of this SiteStandardFieldRule.  # noqa: E501
        :rtype: str
        """
        return self._do_action

    @do_action.setter
    def do_action(self, do_action):
        """Sets the do_action of this SiteStandardFieldRule.

        For on-do steps, specify the type of do action this rule applies to. Omit this field for \"any do\"  # noqa: E501

        :param do_action: The do_action of this SiteStandardFieldRule.  # noqa: E501
        :type do_action: str
        """
        allowed_values = ["Notify", "Mail", "Remedy", "SetToOK", "SetToNotOK", "RerunJob", "StopCyclicRun", "SetVar", "OrderJob", "SysOut", "Condition", "CtbRule", "Restart"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and do_action not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `do_action` ({0}), must be one of {1}"  # noqa: E501
                .format(do_action, allowed_values)
            )

        self._do_action = do_action

    @property
    def restriction(self):
        """Gets the restriction of this SiteStandardFieldRule.  # noqa: E501


        :return: The restriction of this SiteStandardFieldRule.  # noqa: E501
        :rtype: SiteStandardRestriction
        """
        return self._restriction

    @restriction.setter
    def restriction(self, restriction):
        """Sets the restriction of this SiteStandardFieldRule.


        :param restriction: The restriction of this SiteStandardFieldRule.  # noqa: E501
        :type restriction: SiteStandardRestriction
        """

        self._restriction = restriction

    @property
    def sub_fields(self):
        """Gets the sub_fields of this SiteStandardFieldRule.  # noqa: E501

        Used for list fields to indicate restrictions for items in the list. When mustHave is true, it means the list must contain at least one item with sub-fields that match these restrictions.  # noqa: E501

        :return: The sub_fields of this SiteStandardFieldRule.  # noqa: E501
        :rtype: list[SiteStandardFieldRule]
        """
        return self._sub_fields

    @sub_fields.setter
    def sub_fields(self, sub_fields):
        """Sets the sub_fields of this SiteStandardFieldRule.

        Used for list fields to indicate restrictions for items in the list. When mustHave is true, it means the list must contain at least one item with sub-fields that match these restrictions.  # noqa: E501

        :param sub_fields: The sub_fields of this SiteStandardFieldRule.  # noqa: E501
        :type sub_fields: list[SiteStandardFieldRule]
        """

        self._sub_fields = sub_fields

    @property
    def must_have(self):
        """Gets the must_have of this SiteStandardFieldRule.  # noqa: E501

        Specifies if this is a must-have rule. Relevant only for list fields. true indicates that the field must contain at least one item that matches this rule's restriction false (or missing) indicates that when the field has items, all of them must match the rule's restriction  # noqa: E501

        :return: The must_have of this SiteStandardFieldRule.  # noqa: E501
        :rtype: bool
        """
        return self._must_have

    @must_have.setter
    def must_have(self, must_have):
        """Sets the must_have of this SiteStandardFieldRule.

        Specifies if this is a must-have rule. Relevant only for list fields. true indicates that the field must contain at least one item that matches this rule's restriction false (or missing) indicates that when the field has items, all of them must match the rule's restriction  # noqa: E501

        :param must_have: The must_have of this SiteStandardFieldRule.  # noqa: E501
        :type must_have: bool
        """

        self._must_have = must_have

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SiteStandardFieldRule):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SiteStandardFieldRule):
            return True

        return self.to_dict() != other.to_dict()
