# coding: utf-8

"""
    Control-M Services

    Provides access to BMC Control-M Services  # noqa: E501

    The version of the OpenAPI document: 9.22.30
    Contact: customer_support@bmc.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from clients.ctm_api_client.configuration import Configuration


class SiteStandardRestriction(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'is_required': 'bool',
        'possible_options': 'SiteStandardPossibleOptions',
        'possible_operator_value_options': 'list[SiteStandardOperatorValueOptions]',
        'min_length': 'int',
        'max_length': 'int',
        'numeric_limitation': 'str',
        'numeric_unit': 'str',
        'is_read_only': 'bool',
        'allow_uppercase_letters': 'bool',
        'allow_lowercase_letters': 'bool',
        'allow_digits': 'bool',
        'allowed_characters': 'str',
        'disallowed_characters': 'str',
        'disallowed_options': 'SiteStandardPossibleOptions',
        'disallowed_enum_values': 'list[SiteStandardPossibleValue]',
        'allowed_enum_values': 'list[SiteStandardPossibleValue]',
        'check_for_existence': 'bool',
        'default_value': 'str',
        'validation_error_message': 'str'
    }

    attribute_map = {
        'is_required': 'isRequired',
        'possible_options': 'possibleOptions',
        'possible_operator_value_options': 'possibleOperatorValueOptions',
        'min_length': 'minLength',
        'max_length': 'maxLength',
        'numeric_limitation': 'numericLimitation',
        'numeric_unit': 'numericUnit',
        'is_read_only': 'isReadOnly',
        'allow_uppercase_letters': 'allowUppercaseLetters',
        'allow_lowercase_letters': 'allowLowercaseLetters',
        'allow_digits': 'allowDigits',
        'allowed_characters': 'allowedCharacters',
        'disallowed_characters': 'disallowedCharacters',
        'disallowed_options': 'disallowedOptions',
        'disallowed_enum_values': 'disallowedEnumValues',
        'allowed_enum_values': 'allowedEnumValues',
        'check_for_existence': 'checkForExistence',
        'default_value': 'defaultValue',
        'validation_error_message': 'validationErrorMessage'
    }

    def __init__(self, is_required=None, possible_options=None, possible_operator_value_options=None, min_length=None, max_length=None, numeric_limitation=None, numeric_unit=None, is_read_only=None, allow_uppercase_letters=None, allow_lowercase_letters=None, allow_digits=None, allowed_characters=None, disallowed_characters=None, disallowed_options=None, disallowed_enum_values=None, allowed_enum_values=None, check_for_existence=None, default_value=None, validation_error_message=None, local_vars_configuration=None):  # noqa: E501
        """SiteStandardRestriction - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._is_required = None
        self._possible_options = None
        self._possible_operator_value_options = None
        self._min_length = None
        self._max_length = None
        self._numeric_limitation = None
        self._numeric_unit = None
        self._is_read_only = None
        self._allow_uppercase_letters = None
        self._allow_lowercase_letters = None
        self._allow_digits = None
        self._allowed_characters = None
        self._disallowed_characters = None
        self._disallowed_options = None
        self._disallowed_enum_values = None
        self._allowed_enum_values = None
        self._check_for_existence = None
        self._default_value = None
        self._validation_error_message = None
        self.discriminator = None

        if is_required is not None:
            self.is_required = is_required
        if possible_options is not None:
            self.possible_options = possible_options
        if possible_operator_value_options is not None:
            self.possible_operator_value_options = possible_operator_value_options
        if min_length is not None:
            self.min_length = min_length
        if max_length is not None:
            self.max_length = max_length
        if numeric_limitation is not None:
            self.numeric_limitation = numeric_limitation
        if numeric_unit is not None:
            self.numeric_unit = numeric_unit
        if is_read_only is not None:
            self.is_read_only = is_read_only
        if allow_uppercase_letters is not None:
            self.allow_uppercase_letters = allow_uppercase_letters
        if allow_lowercase_letters is not None:
            self.allow_lowercase_letters = allow_lowercase_letters
        if allow_digits is not None:
            self.allow_digits = allow_digits
        if allowed_characters is not None:
            self.allowed_characters = allowed_characters
        if disallowed_characters is not None:
            self.disallowed_characters = disallowed_characters
        if disallowed_options is not None:
            self.disallowed_options = disallowed_options
        if disallowed_enum_values is not None:
            self.disallowed_enum_values = disallowed_enum_values
        if allowed_enum_values is not None:
            self.allowed_enum_values = allowed_enum_values
        if check_for_existence is not None:
            self.check_for_existence = check_for_existence
        if default_value is not None:
            self.default_value = default_value
        if validation_error_message is not None:
            self.validation_error_message = validation_error_message

    @property
    def is_required(self):
        """Gets the is_required of this SiteStandardRestriction.  # noqa: E501

        Specifies if this field or business parameter must have a value. Relevant only for business parameters and simple fields with no sub-fields  # noqa: E501

        :return: The is_required of this SiteStandardRestriction.  # noqa: E501
        :rtype: bool
        """
        return self._is_required

    @is_required.setter
    def is_required(self, is_required):
        """Sets the is_required of this SiteStandardRestriction.

        Specifies if this field or business parameter must have a value. Relevant only for business parameters and simple fields with no sub-fields  # noqa: E501

        :param is_required: The is_required of this SiteStandardRestriction.  # noqa: E501
        :type is_required: bool
        """

        self._is_required = is_required

    @property
    def possible_options(self):
        """Gets the possible_options of this SiteStandardRestriction.  # noqa: E501


        :return: The possible_options of this SiteStandardRestriction.  # noqa: E501
        :rtype: SiteStandardPossibleOptions
        """
        return self._possible_options

    @possible_options.setter
    def possible_options(self, possible_options):
        """Sets the possible_options of this SiteStandardRestriction.


        :param possible_options: The possible_options of this SiteStandardRestriction.  # noqa: E501
        :type possible_options: SiteStandardPossibleOptions
        """

        self._possible_options = possible_options

    @property
    def possible_operator_value_options(self):
        """Gets the possible_operator_value_options of this SiteStandardRestriction.  # noqa: E501

        List of possible operator-value pars  # noqa: E501

        :return: The possible_operator_value_options of this SiteStandardRestriction.  # noqa: E501
        :rtype: list[SiteStandardOperatorValueOptions]
        """
        return self._possible_operator_value_options

    @possible_operator_value_options.setter
    def possible_operator_value_options(self, possible_operator_value_options):
        """Sets the possible_operator_value_options of this SiteStandardRestriction.

        List of possible operator-value pars  # noqa: E501

        :param possible_operator_value_options: The possible_operator_value_options of this SiteStandardRestriction.  # noqa: E501
        :type possible_operator_value_options: list[SiteStandardOperatorValueOptions]
        """

        self._possible_operator_value_options = possible_operator_value_options

    @property
    def min_length(self):
        """Gets the min_length of this SiteStandardRestriction.  # noqa: E501


        :return: The min_length of this SiteStandardRestriction.  # noqa: E501
        :rtype: int
        """
        return self._min_length

    @min_length.setter
    def min_length(self, min_length):
        """Sets the min_length of this SiteStandardRestriction.


        :param min_length: The min_length of this SiteStandardRestriction.  # noqa: E501
        :type min_length: int
        """

        self._min_length = min_length

    @property
    def max_length(self):
        """Gets the max_length of this SiteStandardRestriction.  # noqa: E501


        :return: The max_length of this SiteStandardRestriction.  # noqa: E501
        :rtype: int
        """
        return self._max_length

    @max_length.setter
    def max_length(self, max_length):
        """Sets the max_length of this SiteStandardRestriction.


        :param max_length: The max_length of this SiteStandardRestriction.  # noqa: E501
        :type max_length: int
        """

        self._max_length = max_length

    @property
    def numeric_limitation(self):
        """Gets the numeric_limitation of this SiteStandardRestriction.  # noqa: E501

        Limitation for numeric fields. Can include various ranges separated by comma, e.g. \"1, 5-8\"  # noqa: E501

        :return: The numeric_limitation of this SiteStandardRestriction.  # noqa: E501
        :rtype: str
        """
        return self._numeric_limitation

    @numeric_limitation.setter
    def numeric_limitation(self, numeric_limitation):
        """Sets the numeric_limitation of this SiteStandardRestriction.

        Limitation for numeric fields. Can include various ranges separated by comma, e.g. \"1, 5-8\"  # noqa: E501

        :param numeric_limitation: The numeric_limitation of this SiteStandardRestriction.  # noqa: E501
        :type numeric_limitation: str
        """

        self._numeric_limitation = numeric_limitation

    @property
    def numeric_unit(self):
        """Gets the numeric_unit of this SiteStandardRestriction.  # noqa: E501

        In case of Rerun Interval field, specifies the unit the numeric limitation is referring to.  # noqa: E501

        :return: The numeric_unit of this SiteStandardRestriction.  # noqa: E501
        :rtype: str
        """
        return self._numeric_unit

    @numeric_unit.setter
    def numeric_unit(self, numeric_unit):
        """Sets the numeric_unit of this SiteStandardRestriction.

        In case of Rerun Interval field, specifies the unit the numeric limitation is referring to.  # noqa: E501

        :param numeric_unit: The numeric_unit of this SiteStandardRestriction.  # noqa: E501
        :type numeric_unit: str
        """
        allowed_values = ["Minutes", "Hours", "Days"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and numeric_unit not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `numeric_unit` ({0}), must be one of {1}"  # noqa: E501
                .format(numeric_unit, allowed_values)
            )

        self._numeric_unit = numeric_unit

    @property
    def is_read_only(self):
        """Gets the is_read_only of this SiteStandardRestriction.  # noqa: E501

        Specifies if this field can be set by the user. Relevant only for boolean fields.  # noqa: E501

        :return: The is_read_only of this SiteStandardRestriction.  # noqa: E501
        :rtype: bool
        """
        return self._is_read_only

    @is_read_only.setter
    def is_read_only(self, is_read_only):
        """Sets the is_read_only of this SiteStandardRestriction.

        Specifies if this field can be set by the user. Relevant only for boolean fields.  # noqa: E501

        :param is_read_only: The is_read_only of this SiteStandardRestriction.  # noqa: E501
        :type is_read_only: bool
        """

        self._is_read_only = is_read_only

    @property
    def allow_uppercase_letters(self):
        """Gets the allow_uppercase_letters of this SiteStandardRestriction.  # noqa: E501

        Determines whether uppercase letters (A-Z) are allowed in the field value  # noqa: E501

        :return: The allow_uppercase_letters of this SiteStandardRestriction.  # noqa: E501
        :rtype: bool
        """
        return self._allow_uppercase_letters

    @allow_uppercase_letters.setter
    def allow_uppercase_letters(self, allow_uppercase_letters):
        """Sets the allow_uppercase_letters of this SiteStandardRestriction.

        Determines whether uppercase letters (A-Z) are allowed in the field value  # noqa: E501

        :param allow_uppercase_letters: The allow_uppercase_letters of this SiteStandardRestriction.  # noqa: E501
        :type allow_uppercase_letters: bool
        """

        self._allow_uppercase_letters = allow_uppercase_letters

    @property
    def allow_lowercase_letters(self):
        """Gets the allow_lowercase_letters of this SiteStandardRestriction.  # noqa: E501

        Determines whether lowercase letters (a-z) are allowed in the field value  # noqa: E501

        :return: The allow_lowercase_letters of this SiteStandardRestriction.  # noqa: E501
        :rtype: bool
        """
        return self._allow_lowercase_letters

    @allow_lowercase_letters.setter
    def allow_lowercase_letters(self, allow_lowercase_letters):
        """Sets the allow_lowercase_letters of this SiteStandardRestriction.

        Determines whether lowercase letters (a-z) are allowed in the field value  # noqa: E501

        :param allow_lowercase_letters: The allow_lowercase_letters of this SiteStandardRestriction.  # noqa: E501
        :type allow_lowercase_letters: bool
        """

        self._allow_lowercase_letters = allow_lowercase_letters

    @property
    def allow_digits(self):
        """Gets the allow_digits of this SiteStandardRestriction.  # noqa: E501

        Determines whether digits (0-9) are allowed in the field value  # noqa: E501

        :return: The allow_digits of this SiteStandardRestriction.  # noqa: E501
        :rtype: bool
        """
        return self._allow_digits

    @allow_digits.setter
    def allow_digits(self, allow_digits):
        """Sets the allow_digits of this SiteStandardRestriction.

        Determines whether digits (0-9) are allowed in the field value  # noqa: E501

        :param allow_digits: The allow_digits of this SiteStandardRestriction.  # noqa: E501
        :type allow_digits: bool
        """

        self._allow_digits = allow_digits

    @property
    def allowed_characters(self):
        """Gets the allowed_characters of this SiteStandardRestriction.  # noqa: E501

        A string contains all characters allowed in the field value (all digits or all letters shouldn't be listed here)  # noqa: E501

        :return: The allowed_characters of this SiteStandardRestriction.  # noqa: E501
        :rtype: str
        """
        return self._allowed_characters

    @allowed_characters.setter
    def allowed_characters(self, allowed_characters):
        """Sets the allowed_characters of this SiteStandardRestriction.

        A string contains all characters allowed in the field value (all digits or all letters shouldn't be listed here)  # noqa: E501

        :param allowed_characters: The allowed_characters of this SiteStandardRestriction.  # noqa: E501
        :type allowed_characters: str
        """

        self._allowed_characters = allowed_characters

    @property
    def disallowed_characters(self):
        """Gets the disallowed_characters of this SiteStandardRestriction.  # noqa: E501

        A string contains all characters not allowed in the field value. This should specified only if the other \"allowed...\" properties are not set  # noqa: E501

        :return: The disallowed_characters of this SiteStandardRestriction.  # noqa: E501
        :rtype: str
        """
        return self._disallowed_characters

    @disallowed_characters.setter
    def disallowed_characters(self, disallowed_characters):
        """Sets the disallowed_characters of this SiteStandardRestriction.

        A string contains all characters not allowed in the field value. This should specified only if the other \"allowed...\" properties are not set  # noqa: E501

        :param disallowed_characters: The disallowed_characters of this SiteStandardRestriction.  # noqa: E501
        :type disallowed_characters: str
        """

        self._disallowed_characters = disallowed_characters

    @property
    def disallowed_options(self):
        """Gets the disallowed_options of this SiteStandardRestriction.  # noqa: E501


        :return: The disallowed_options of this SiteStandardRestriction.  # noqa: E501
        :rtype: SiteStandardPossibleOptions
        """
        return self._disallowed_options

    @disallowed_options.setter
    def disallowed_options(self, disallowed_options):
        """Sets the disallowed_options of this SiteStandardRestriction.


        :param disallowed_options: The disallowed_options of this SiteStandardRestriction.  # noqa: E501
        :type disallowed_options: SiteStandardPossibleOptions
        """

        self._disallowed_options = disallowed_options

    @property
    def disallowed_enum_values(self):
        """Gets the disallowed_enum_values of this SiteStandardRestriction.  # noqa: E501

        List of enum values not allowed for the field  # noqa: E501

        :return: The disallowed_enum_values of this SiteStandardRestriction.  # noqa: E501
        :rtype: list[SiteStandardPossibleValue]
        """
        return self._disallowed_enum_values

    @disallowed_enum_values.setter
    def disallowed_enum_values(self, disallowed_enum_values):
        """Sets the disallowed_enum_values of this SiteStandardRestriction.

        List of enum values not allowed for the field  # noqa: E501

        :param disallowed_enum_values: The disallowed_enum_values of this SiteStandardRestriction.  # noqa: E501
        :type disallowed_enum_values: list[SiteStandardPossibleValue]
        """

        self._disallowed_enum_values = disallowed_enum_values

    @property
    def allowed_enum_values(self):
        """Gets the allowed_enum_values of this SiteStandardRestriction.  # noqa: E501

        List of enum values that are allowed for the field. If this is empty, than any value is allowed if it is not in the disallowedEnumValues list and it matches the other restrictions. If it is not empty, only values listed in the list or values that matches the specified restrictions (if exists) are allowed.  # noqa: E501

        :return: The allowed_enum_values of this SiteStandardRestriction.  # noqa: E501
        :rtype: list[SiteStandardPossibleValue]
        """
        return self._allowed_enum_values

    @allowed_enum_values.setter
    def allowed_enum_values(self, allowed_enum_values):
        """Sets the allowed_enum_values of this SiteStandardRestriction.

        List of enum values that are allowed for the field. If this is empty, than any value is allowed if it is not in the disallowedEnumValues list and it matches the other restrictions. If it is not empty, only values listed in the list or values that matches the specified restrictions (if exists) are allowed.  # noqa: E501

        :param allowed_enum_values: The allowed_enum_values of this SiteStandardRestriction.  # noqa: E501
        :type allowed_enum_values: list[SiteStandardPossibleValue]
        """

        self._allowed_enum_values = allowed_enum_values

    @property
    def check_for_existence(self):
        """Gets the check_for_existence of this SiteStandardRestriction.  # noqa: E501

        Check if the field value need to be checked if it exists in the system. E.g. for node_id field - check that the specified host or host group exists in the system  # noqa: E501

        :return: The check_for_existence of this SiteStandardRestriction.  # noqa: E501
        :rtype: bool
        """
        return self._check_for_existence

    @check_for_existence.setter
    def check_for_existence(self, check_for_existence):
        """Sets the check_for_existence of this SiteStandardRestriction.

        Check if the field value need to be checked if it exists in the system. E.g. for node_id field - check that the specified host or host group exists in the system  # noqa: E501

        :param check_for_existence: The check_for_existence of this SiteStandardRestriction.  # noqa: E501
        :type check_for_existence: bool
        """

        self._check_for_existence = check_for_existence

    @property
    def default_value(self):
        """Gets the default_value of this SiteStandardRestriction.  # noqa: E501


        :return: The default_value of this SiteStandardRestriction.  # noqa: E501
        :rtype: str
        """
        return self._default_value

    @default_value.setter
    def default_value(self, default_value):
        """Sets the default_value of this SiteStandardRestriction.


        :param default_value: The default_value of this SiteStandardRestriction.  # noqa: E501
        :type default_value: str
        """

        self._default_value = default_value

    @property
    def validation_error_message(self):
        """Gets the validation_error_message of this SiteStandardRestriction.  # noqa: E501

        The validation error message to show the user when this rule is not met.<br> If not specified, the default error message will be used.  # noqa: E501

        :return: The validation_error_message of this SiteStandardRestriction.  # noqa: E501
        :rtype: str
        """
        return self._validation_error_message

    @validation_error_message.setter
    def validation_error_message(self, validation_error_message):
        """Sets the validation_error_message of this SiteStandardRestriction.

        The validation error message to show the user when this rule is not met.<br> If not specified, the default error message will be used.  # noqa: E501

        :param validation_error_message: The validation_error_message of this SiteStandardRestriction.  # noqa: E501
        :type validation_error_message: str
        """

        self._validation_error_message = validation_error_message

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SiteStandardRestriction):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SiteStandardRestriction):
            return True

        return self.to_dict() != other.to_dict()
