# coding: utf-8

"""
    Control-M Services

    Provides access to BMC Control-M Services  # noqa: E501

    The version of the OpenAPI document: 9.22.30
    Contact: customer_support@bmc.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from clients.ctm_api_client.configuration import Configuration


class SSHKeyData(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'key_name': 'str',
        'pass_phrase': 'str',
        'format': 'str',
        'type': 'str',
        'bits': 'int',
        '_async': 'bool'
    }

    attribute_map = {
        'key_name': 'keyName',
        'pass_phrase': 'passPhrase',
        'format': 'format',
        'type': 'type',
        'bits': 'bits',
        '_async': 'async'
    }

    def __init__(self, key_name=None, pass_phrase=None, format='OpenSSH', type=None, bits=None, _async=None, local_vars_configuration=None):  # noqa: E501
        """SSHKeyData - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._key_name = None
        self._pass_phrase = None
        self._format = None
        self._type = None
        self._bits = None
        self.__async = None
        self.discriminator = None

        if key_name is not None:
            self.key_name = key_name
        if pass_phrase is not None:
            self.pass_phrase = pass_phrase
        if format is not None:
            self.format = format
        if type is not None:
            self.type = type
        if bits is not None:
            self.bits = bits
        if _async is not None:
            self._async = _async

    @property
    def key_name(self):
        """Gets the key_name of this SSHKeyData.  # noqa: E501

        The name for the key . REQUIRED.  # noqa: E501

        :return: The key_name of this SSHKeyData.  # noqa: E501
        :rtype: str
        """
        return self._key_name

    @key_name.setter
    def key_name(self, key_name):
        """Sets the key_name of this SSHKeyData.

        The name for the key . REQUIRED.  # noqa: E501

        :param key_name: The key_name of this SSHKeyData.  # noqa: E501
        :type key_name: str
        """

        self._key_name = key_name

    @property
    def pass_phrase(self):
        """Gets the pass_phrase of this SSHKeyData.  # noqa: E501

        The password for the key file . REQUIRED.  # noqa: E501

        :return: The pass_phrase of this SSHKeyData.  # noqa: E501
        :rtype: str
        """
        return self._pass_phrase

    @pass_phrase.setter
    def pass_phrase(self, pass_phrase):
        """Sets the pass_phrase of this SSHKeyData.

        The password for the key file . REQUIRED.  # noqa: E501

        :param pass_phrase: The pass_phrase of this SSHKeyData.  # noqa: E501
        :type pass_phrase: str
        """

        self._pass_phrase = pass_phrase

    @property
    def format(self):
        """Gets the format of this SSHKeyData.  # noqa: E501

        the format of the SSH key to generate. [OpenSSH/SSH2]  # noqa: E501

        :return: The format of this SSHKeyData.  # noqa: E501
        :rtype: str
        """
        return self._format

    @format.setter
    def format(self, format):
        """Sets the format of this SSHKeyData.

        the format of the SSH key to generate. [OpenSSH/SSH2]  # noqa: E501

        :param format: The format of this SSHKeyData.  # noqa: E501
        :type format: str
        """

        self._format = format

    @property
    def type(self):
        """Gets the type of this SSHKeyData.  # noqa: E501

        The type of the SSH key to generate.  - For ctm versions under v22: [RSA (Default), DSA] - For ctm versions v22 and above: [RSA, ECDSA (Default)]   # noqa: E501

        :return: The type of this SSHKeyData.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this SSHKeyData.

        The type of the SSH key to generate.  - For ctm versions under v22: [RSA (Default), DSA] - For ctm versions v22 and above: [RSA, ECDSA (Default)]   # noqa: E501

        :param type: The type of this SSHKeyData.  # noqa: E501
        :type type: str
        """

        self._type = type

    @property
    def bits(self):
        """Gets the bits of this SSHKeyData.  # noqa: E501

        Generated keys defined with larger bits provides enhanced security.  For ctm versions under v22:   [512/768/1024 (Default)/2048/3072]  For ctm versions v22 and above:   - For RSA: 3072, 4096 (Default)   - For ECDSA: 256 (Default), 384, 521   # noqa: E501

        :return: The bits of this SSHKeyData.  # noqa: E501
        :rtype: int
        """
        return self._bits

    @bits.setter
    def bits(self, bits):
        """Sets the bits of this SSHKeyData.

        Generated keys defined with larger bits provides enhanced security.  For ctm versions under v22:   [512/768/1024 (Default)/2048/3072]  For ctm versions v22 and above:   - For RSA: 3072, 4096 (Default)   - For ECDSA: 256 (Default), 384, 521   # noqa: E501

        :param bits: The bits of this SSHKeyData.  # noqa: E501
        :type bits: int
        """

        self._bits = bits

    @property
    def _async(self):
        """Gets the _async of this SSHKeyData.  # noqa: E501

        True to add SSH key asynchronously wit0h pollingId. HIDDEN  # noqa: E501

        :return: The _async of this SSHKeyData.  # noqa: E501
        :rtype: bool
        """
        return self.__async

    @_async.setter
    def _async(self, _async):
        """Sets the _async of this SSHKeyData.

        True to add SSH key asynchronously wit0h pollingId. HIDDEN  # noqa: E501

        :param _async: The _async of this SSHKeyData.  # noqa: E501
        :type _async: bool
        """

        self.__async = _async

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SSHKeyData):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SSHKeyData):
            return True

        return self.to_dict() != other.to_dict()
