# coding: utf-8

"""
    Control-M Services

    Provides access to BMC Control-M Services  # noqa: E501

    The version of the OpenAPI document: 9.22.30
    Contact: customer_support@bmc.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from clients.ctm_api_client.configuration import Configuration


class TokenDataRequest(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'token_name': 'str',
        'roles': 'list[str]',
        'expiration_date': 'str',
        'token_type': 'str',
        'server': 'str',
        'server_host': 'str',
        'server_id': 'str',
        'tag': 'str'
    }

    attribute_map = {
        'token_name': 'tokenName',
        'roles': 'roles',
        'expiration_date': 'expirationDate',
        'token_type': 'tokenType',
        'server': 'server',
        'server_host': 'serverHost',
        'server_id': 'serverId',
        'tag': 'tag'
    }

    def __init__(self, token_name=None, roles=None, expiration_date=None, token_type=None, server=None, server_host=None, server_id=None, tag=None, local_vars_configuration=None):  # noqa: E501
        """TokenDataRequest - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._token_name = None
        self._roles = None
        self._expiration_date = None
        self._token_type = None
        self._server = None
        self._server_host = None
        self._server_id = None
        self._tag = None
        self.discriminator = None

        self.token_name = token_name
        if roles is not None:
            self.roles = roles
        if expiration_date is not None:
            self.expiration_date = expiration_date
        if token_type is not None:
            self.token_type = token_type
        if server is not None:
            self.server = server
        if server_host is not None:
            self.server_host = server_host
        if server_id is not None:
            self.server_id = server_id
        if tag is not None:
            self.tag = tag

    @property
    def token_name(self):
        """Gets the token_name of this TokenDataRequest.  # noqa: E501

        required field. HIDDEN.  # noqa: E501

        :return: The token_name of this TokenDataRequest.  # noqa: E501
        :rtype: str
        """
        return self._token_name

    @token_name.setter
    def token_name(self, token_name):
        """Sets the token_name of this TokenDataRequest.

        required field. HIDDEN.  # noqa: E501

        :param token_name: The token_name of this TokenDataRequest.  # noqa: E501
        :type token_name: str
        """
        if self.local_vars_configuration.client_side_validation and token_name is None:  # noqa: E501
            raise ValueError("Invalid value for `token_name`, must not be `None`")  # noqa: E501

        self._token_name = token_name

    @property
    def roles(self):
        """Gets the roles of this TokenDataRequest.  # noqa: E501

        required field when creates token for User. HIDDEN.  # noqa: E501

        :return: The roles of this TokenDataRequest.  # noqa: E501
        :rtype: list[str]
        """
        return self._roles

    @roles.setter
    def roles(self, roles):
        """Sets the roles of this TokenDataRequest.

        required field when creates token for User. HIDDEN.  # noqa: E501

        :param roles: The roles of this TokenDataRequest.  # noqa: E501
        :type roles: list[str]
        """

        self._roles = roles

    @property
    def expiration_date(self):
        """Gets the expiration_date of this TokenDataRequest.  # noqa: E501

        optional field. HIDDEN.  # noqa: E501

        :return: The expiration_date of this TokenDataRequest.  # noqa: E501
        :rtype: str
        """
        return self._expiration_date

    @expiration_date.setter
    def expiration_date(self, expiration_date):
        """Sets the expiration_date of this TokenDataRequest.

        optional field. HIDDEN.  # noqa: E501

        :param expiration_date: The expiration_date of this TokenDataRequest.  # noqa: E501
        :type expiration_date: str
        """

        self._expiration_date = expiration_date

    @property
    def token_type(self):
        """Gets the token_type of this TokenDataRequest.  # noqa: E501

        optional field. HIDDEN.  # noqa: E501

        :return: The token_type of this TokenDataRequest.  # noqa: E501
        :rtype: str
        """
        return self._token_type

    @token_type.setter
    def token_type(self, token_type):
        """Sets the token_type of this TokenDataRequest.

        optional field. HIDDEN.  # noqa: E501

        :param token_type: The token_type of this TokenDataRequest.  # noqa: E501
        :type token_type: str
        """

        self._token_type = token_type

    @property
    def server(self):
        """Gets the server of this TokenDataRequest.  # noqa: E501

        optional field. HIDDEN.  # noqa: E501

        :return: The server of this TokenDataRequest.  # noqa: E501
        :rtype: str
        """
        return self._server

    @server.setter
    def server(self, server):
        """Sets the server of this TokenDataRequest.

        optional field. HIDDEN.  # noqa: E501

        :param server: The server of this TokenDataRequest.  # noqa: E501
        :type server: str
        """

        self._server = server

    @property
    def server_host(self):
        """Gets the server_host of this TokenDataRequest.  # noqa: E501

        optional field used in for CTM token. HIDDEN.  # noqa: E501

        :return: The server_host of this TokenDataRequest.  # noqa: E501
        :rtype: str
        """
        return self._server_host

    @server_host.setter
    def server_host(self, server_host):
        """Sets the server_host of this TokenDataRequest.

        optional field used in for CTM token. HIDDEN.  # noqa: E501

        :param server_host: The server_host of this TokenDataRequest.  # noqa: E501
        :type server_host: str
        """

        self._server_host = server_host

    @property
    def server_id(self):
        """Gets the server_id of this TokenDataRequest.  # noqa: E501

        optional field used in for CTM token. HIDDEN.  # noqa: E501

        :return: The server_id of this TokenDataRequest.  # noqa: E501
        :rtype: str
        """
        return self._server_id

    @server_id.setter
    def server_id(self, server_id):
        """Sets the server_id of this TokenDataRequest.

        optional field used in for CTM token. HIDDEN.  # noqa: E501

        :param server_id: The server_id of this TokenDataRequest.  # noqa: E501
        :type server_id: str
        """

        self._server_id = server_id

    @property
    def tag(self):
        """Gets the tag of this TokenDataRequest.  # noqa: E501

        optional field. HIDDEN.  # noqa: E501

        :return: The tag of this TokenDataRequest.  # noqa: E501
        :rtype: str
        """
        return self._tag

    @tag.setter
    def tag(self, tag):
        """Sets the tag of this TokenDataRequest.

        optional field. HIDDEN.  # noqa: E501

        :param tag: The tag of this TokenDataRequest.  # noqa: E501
        :type tag: str
        """

        self._tag = tag

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TokenDataRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, TokenDataRequest):
            return True

        return self.to_dict() != other.to_dict()
