# coding: utf-8

"""
    Control-M Services

    Provides access to BMC Control-M Services  # noqa: E501

    The version of the OpenAPI document: 9.22.30
    Contact: customer_support@bmc.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from clients.ctm_api_client.configuration import Configuration


class TrialInformation(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'is_trial': 'bool',
        'is_expired': 'bool',
        'trial_start_date': 'str',
        'trial_total_days': 'str'
    }

    attribute_map = {
        'is_trial': 'isTrial',
        'is_expired': 'isExpired',
        'trial_start_date': 'trialStartDate',
        'trial_total_days': 'trialTotalDays'
    }

    def __init__(self, is_trial=None, is_expired=None, trial_start_date=None, trial_total_days=None, local_vars_configuration=None):  # noqa: E501
        """TrialInformation - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._is_trial = None
        self._is_expired = None
        self._trial_start_date = None
        self._trial_total_days = None
        self.discriminator = None

        if is_trial is not None:
            self.is_trial = is_trial
        if is_expired is not None:
            self.is_expired = is_expired
        if trial_start_date is not None:
            self.trial_start_date = trial_start_date
        if trial_total_days is not None:
            self.trial_total_days = trial_total_days

    @property
    def is_trial(self):
        """Gets the is_trial of this TrialInformation.  # noqa: E501

        Indicates whether the user is in a trial period  # noqa: E501

        :return: The is_trial of this TrialInformation.  # noqa: E501
        :rtype: bool
        """
        return self._is_trial

    @is_trial.setter
    def is_trial(self, is_trial):
        """Sets the is_trial of this TrialInformation.

        Indicates whether the user is in a trial period  # noqa: E501

        :param is_trial: The is_trial of this TrialInformation.  # noqa: E501
        :type is_trial: bool
        """

        self._is_trial = is_trial

    @property
    def is_expired(self):
        """Gets the is_expired of this TrialInformation.  # noqa: E501

        Indicates whether the trial period has expired  # noqa: E501

        :return: The is_expired of this TrialInformation.  # noqa: E501
        :rtype: bool
        """
        return self._is_expired

    @is_expired.setter
    def is_expired(self, is_expired):
        """Sets the is_expired of this TrialInformation.

        Indicates whether the trial period has expired  # noqa: E501

        :param is_expired: The is_expired of this TrialInformation.  # noqa: E501
        :type is_expired: bool
        """

        self._is_expired = is_expired

    @property
    def trial_start_date(self):
        """Gets the trial_start_date of this TrialInformation.  # noqa: E501

        Trial start date in ISO 8601 format (YYYY-MM-DD) in UTC time zone  # noqa: E501

        :return: The trial_start_date of this TrialInformation.  # noqa: E501
        :rtype: str
        """
        return self._trial_start_date

    @trial_start_date.setter
    def trial_start_date(self, trial_start_date):
        """Sets the trial_start_date of this TrialInformation.

        Trial start date in ISO 8601 format (YYYY-MM-DD) in UTC time zone  # noqa: E501

        :param trial_start_date: The trial_start_date of this TrialInformation.  # noqa: E501
        :type trial_start_date: str
        """

        self._trial_start_date = trial_start_date

    @property
    def trial_total_days(self):
        """Gets the trial_total_days of this TrialInformation.  # noqa: E501

        Number of remaining days in the trial period  # noqa: E501

        :return: The trial_total_days of this TrialInformation.  # noqa: E501
        :rtype: str
        """
        return self._trial_total_days

    @trial_total_days.setter
    def trial_total_days(self, trial_total_days):
        """Sets the trial_total_days of this TrialInformation.

        Number of remaining days in the trial period  # noqa: E501

        :param trial_total_days: The trial_total_days of this TrialInformation.  # noqa: E501
        :type trial_total_days: str
        """

        self._trial_total_days = trial_total_days

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TrialInformation):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, TrialInformation):
            return True

        return self.to_dict() != other.to_dict()
